;;;                                                                    ;
;;;  REGDUMP.LSP                                                       ;
;;;                                                                    ;
;;;  Copyright 1987, 1988, 1990, 1992, 1994, 1996, 1997, 1998, 1999    ;
;;;  by Autodesk, Inc. All Rights Reserved.                            ;
;;;                                                                    ;
;;;  You are hereby granted permission to use, copy and modify this    ;
;;;  software without charge, provided you do so exclusively for       ;
;;;  your own use or for use by others in your organization in the     ;
;;;  performance of their normal duties, and provided further that     ;
;;;  the above copyright notice appears in all copies and both that    ;
;;;  copyright notice and the limited warranty and restricted rights   ;
;;;  notice below appear in all supporting documentation.              ;
;;;                                                                    ;
;;;  Incorporation of any part of this software into other software,   ;
;;;  except when such incorporation is exclusively for your own use    ;
;;;  or for use by others in your organization in the performance of   ;
;;;  their normal duties, is prohibited without the prior written      ;
;;;  consent of Autodesk, Inc.                                         ;
;;;                                                                    ;
;;;  Copying, modification and distribution of this software or any    ;
;;;  part thereof in any form except as expressly provided herein is   ;
;;;  prohibited without the prior written consent of Autodesk, Inc.    ;
;;;                                                                    ;
;;;  AUTODESK PROVIDES THIS SOFTWARE "AS IS" AND WITH ALL FAULTS.      ;
;;;  AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF           ;
;;;  MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,       ;
;;;  INC. DOES NOT WARRANT THAT THE OPERATION OF THE SOFTWARE          ;
;;;  WILL BE UNINTERRUPTED OR ERROR FREE.                              ;
;;;                                                                    ;
;;;  Restricted Rights for US Government Users.  This software         ;
;;;  and Documentation are provided with RESTRICTED RIGHTS for US      ;
;;;  US Government users.  Use, duplication, or disclosure by the      ;
;;;  Government is subject to restrictions as set forth in FAR         ;
;;;  12.212 (Commercial Computer Software-Restricted Rights) and       ;
;;;  DFAR 227.7202 (Rights in Technical Data and Computer Software),   ;
;;;  as applicable.  Manufacturer is Autodesk, Inc., 111 McInnis       ;
;;;  Parkway, San Rafael, California 94903.                            ;
;;;                                                                    ;

;;;--------------------------------------------------------------------;
;;; General Note:                                                      ;
;;;         Functions defined:                                         ;
;;;	                registry-tree-dump                             ;
;;;	                dump-registered-apps                           ;
;;;                                                                    ;
;;;--------------------------------------------------------------------;
;;;  This file demonstrates several registry-xxxx functions and how    ;
;;;  they can be used to create user defined registry functions.       ;
;;;--------------------------------------------------------------------;

;;; Load the AutoCAD 2000 COM object model functions here
(if (car (atoms-family 1 '("vl-load-com"))) (vl-load-com))

;;;--------------------------------------------------------------------;
;;;       Function:  REGISTRY-TREE-DUMP                                ;
;;;                                                                    ;
;;;    Description:  This function dumps the registry contents for     ;
;;;                  a specific key.                                   ;
;;;                                                                    ;
;;;      Arguments:                                                    ;
;;;             rkey    = Registry Key Name                            ;
;;;             indent  = indent by a string value.                    ;
;;;                       This value can be nil. If nil it             ;
;;;                       defaults to "" other this indent value is    ;
;;;                       incremented internally as required.          ;
;;;                                                                    ;
;;; Returned Value:  A consed list denoting:                           ;
;;;                  (Number-of-registry-decendants                    ;
;;;                     . Number-of-Keys)                              ;
;;;                  Note: This is used internally.                    ;
;;;                                                                    ;
;;;          Usage: (registry-tree-dump                                ;
;;;                     "HKEY_CURRENT_USER\\Software" ""               ;
;;;                     )                                              ;
;;;--------------------------------------------------------------------;
;;;
;;;
(defun registry-tree-dump (rkey indent / vs ks)
  (if (equal "\\" (substr rkey (strlen rkey)))
    (setq rkey (substr rkey 1 (1- (strlen rkey))))
    )
  (or indent (setq indent ""))

  (princ (strcat indent "Key: " rkey "\n"))
  (if (setq vs (vl-registry-descendents rkey t))	; value names
    (progn
      (princ indent)
      (princ "- values:\n")
      (foreach v (vl-sort vs '<)
	(princ indent)
	(princ (strcat
		 "  "
		 (if (equal v "") "@" v)
		 ": " ) )
	(prin1 (vl-registry-read rkey v))
	(terpri)
	) )
    (progn
      (princ indent)
      (princ "- no values\n")
      )
    )
  (if (setq ks (vl-registry-descendents rkey))		; subkey names
    (progn
      (princ indent)
      (princ "- subkeys:\n")
      (setq rkey (strcat rkey "\\")
	    indent (strcat indent "  ") )
      (foreach k (vl-sort ks '<)
	(registry-tree-dump (strcat rkey k) indent)
	) )
    (progn
      (princ indent)
      (princ "- no subkeys\n")
      )
    )
(cons (length ks) (length vs))
 )

;;;--------------------------------------------------------------------;
;;;       Function:  DUMP-REGISTERED-APPS                              ;
;;;                                                                    ;
;;;    Description:  This function dumps the registry database         ;
;;;                  subtree for every application that is registered  ;
;;;                  to the current ACAD .                             ;
;;;                                                                    ;
;;;                 Required Functions:                                ;
;;;                          registry-tree-dump                        ;
;;;                                                                    ;
;;;      Arguments:  none                                              ;
;;;                                                                    ;
;;; Returned Value:  none                                              ;
;;;                                                                    ;
;;;          Usage: (dump-registered-apps)                             ;
;;;--------------------------------------------------------------------;
(defun dump-registered-apps (/ AcadApp AppNames)
  ;; find registry key for current AutoCAD version
  (setq AcadApp "HKEY_LOCAL_MACHINE\\Software\\Autodesk\\AutoCAD"
	AcadApp (strcat AcadApp "\\"
			(vl-registry-read AcadApp "CurVer") )
	AcadApp (strcat AcadApp "\\"
			(vl-registry-read AcadApp "CurVer")
			"\\Applications" ) )
  ;; get list of registered applications
  (setq AppNames (VL-SORT (vl-registry-descendents AcadApp) '<))
  
  ;; dump registry subtree for every application
  (foreach app AppNames
    (princ (strcat "\n=== " app " registry subtree dump\n"))
    (setq app (vl-registry-read (strcat AcadApp "\\" app) "REGPATH"))
    ;; app starts with "\\\\" - Visual LISP does not like this
    (setq app (substr app 3)) ;; So we remove some \\.
    (registry-tree-dump app nil)
    )
  (length AppNames)
  )

;;;--------------------------------------------------------------------;
;;;                                                                    ;
;;; Note:                                                              ;
;;;  To start this function cut and paste the function call below.     ;
;;;     (dump-registered-apps)                                         ;
;;;                                                                    ;
;;;--------------------------------------------------------------------;

;;; EOF

;;;-----BEGIN-SIGNATURE-----
;;; agcAADCCB2YGCSqGSIb3DQEHAqCCB1cwggdTAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIFBjCCBQIwggPqoAMCAQICEGS8scfO5NpYadWPHiL76fQw
;;; DQYJKoZIhvcNAQELBQAwfzELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVj
;;; IENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTAw
;;; LgYDVQQDEydTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBDb2RlIFNpZ25pbmcgQ0Ew
;;; HhcNMTUwOTAzMDAwMDAwWhcNMTYwOTAyMjM1OTU5WjCBiDELMAkGA1UEBhMCVVMx
;;; EzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwxFjAUBgNV
;;; BAoMDUF1dG9kZXNrLCBJbmMxHzAdBgNVBAsMFkRlc2lnbiBTb2x1dGlvbnMgR3Jv
;;; dXAxFjAUBgNVBAMMDUF1dG9kZXNrLCBJbmMwggEiMA0GCSqGSIb3DQEBAQUAA4IB
;;; DwAwggEKAoIBAQDqmfToz8wEanfXT+H6tql3aUyaJRWCfFsYPFnGVXIl95fnZY3s
;;; OEfQvFkf9LVte5SwDWkjkReCGJlk4HaRYOTxkd7PkeAOOtYaUSBvULYRlKvAbe2n
;;; +VWwo4yrWATav8d7pKlbMP9f6pYxlaZQzsq/e+pLZwptP8C9Dfrm5OVgCIL/iPRN
;;; Iuvhl9YUZvnkZYmCnihdP4AS8g4d7rfjdxzT653433nO6tgs3fNgnkQQk6EdROwq
;;; esgQXRlH29yRND5xNfup9KiZ7L7Nm7AiM6laNwNIjBwbG4qMWuQ2Ml7hHzQpLaLF
;;; JRV33oHedeGSZ7OmA6+D5WoQtPpSt4YCcub5AgMBAAGjggFuMIIBajAJBgNVHRME
;;; AjAAMA4GA1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzBmBgNVHSAE
;;; XzBdMFsGC2CGSAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5zeW1j
;;; Yi5jb20vY3BzMCUGCCsGAQUFBwICMBkaF2h0dHBzOi8vZC5zeW1jYi5jb20vcnBh
;;; MB8GA1UdIwQYMBaAFJY7U/B5M5evfYPvLivMyreGHnJmMCsGA1UdHwQkMCIwIKAe
;;; oByGGmh0dHA6Ly9zdi5zeW1jYi5jb20vc3YuY3JsMFcGCCsGAQUFBwEBBEswSTAf
;;; BggrBgEFBQcwAYYTaHR0cDovL3N2LnN5bWNkLmNvbTAmBggrBgEFBQcwAoYaaHR0
;;; cDovL3N2LnN5bWNiLmNvbS9zdi5jcnQwEQYJYIZIAYb4QgEBBAQDAgQQMBYGCisG
;;; AQQBgjcCARsECDAGAQEAAQH/MA0GCSqGSIb3DQEBCwUAA4IBAQAegWHWPJ8y1kt5
;;; 7JP8TOQlnYs0eMMg5/MHxlW3LhKv/PG8jZ2NDg8YrGuwBC7y3um+PA6KxRT9px8N
;;; KjniMX4NsPtQ81s2EITHy4uFfz6dTpgmL2BLE2/6FPmG4koEhY6zeT4tizeTscOR
;;; Mu1gCtr4Vq+BC/+0Ax6LKOGt5Ut1pJT89ivzZYZOIvEtt9AZRgh7GRg2Oz7X6MFn
;;; c3KudMQhCEnBEUkbS3fmC+kll5PuoF/R1XBcbby0ODfQ3xfwSpNd6WIMr2T5HnSC
;;; gOMmAsuP1Y6LjaCoYDP2mhiwMg797o0XVywnKLEeDGw/F9b/c+lpIBuWGWYnFjz7
;;; CTe7cgdcMYICJDCCAiACAQEwgZMwfzELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
;;; bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3
;;; b3JrMTAwLgYDVQQDEydTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBDb2RlIFNpZ25p
;;; bmcgQ0ECEGS8scfO5NpYadWPHiL76fQwDQYJKoZIhvcNAQELBQAwDQYJKoZIhvcN
;;; AQEBBQAEggEAuUBhVLPc8V6Kx9YOXlJpouZsPkyTrHTG4qkaMMgZaopawVLQaJk8
;;; BRTVYDuwrVzvO/BnZhNIJY3z+oYYgBU+qmV0lW0GI4GAIihKg0GsXAPoyVaGCVhl
;;; FvaCGJ4oZjpocthuWmE81UL9LAkOg0MaiQmUkyR0X+sPLHv/A6b/KtAw1NlAGQsk
;;; 2CGiYJ+dti55tAwSJMcIZb1BkDQERguwjm+SEpZy3DCHft6EffYoXjonv/R0KCCm
;;; myQc19DTzEueaGKLjEcHH3dbUCbyif6KohAndj2rBsV85U4kgEQzNuUx0XbmCNFA
;;; 6Sd+AcxmhT2NsQ7Rh/VLDVc2Kx2xJTAXzqFjMGEGA1UdDjFaBFg0ADAAOwAyAC8A
;;; NwAvADIAMAAxADYALwA1AC8AMQAxAC8AMQAwAC8AVABpAG0AZQAgAGYAcgBvAG0A
;;; IAB0AGgAaQBzACAAYwBvAG0AcAB1AHQAZQByAAAA
;;; -----END-SIGNATURE-----