PSCAD 4.2.1

Settings
 {
 Id = "1111705226.1151594509"
 Author = "jayas.plwilson"
 Desc = "IEEE 34 Bus Distribution Test System - Wind Generators included"
 Arch = "windows"
 Options = 32
 Build = 22
 Warn = 1
 Check = 7
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 6
  Step = 5e-005
  Plot = 0.002
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 4479
  Debug = 0
  StartFile = "C:\\Documents and Settings\\plwilson\\Desktop\\IEEE34\\IEEE34WithMeters_units_wind.emt\\steadystate_4sec.snp"
  OFile = "noname.out"
  SFile = "steadystate_4sec.snp"
  SnapTime = 4
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  dfds = 1
  }

 }

Definitions
 {
 Component("unbalanced_shortline")
  {
  Desc = "Unbalanced short line"
  FileDate = 0
  Parameters = 
   {
   Category("Configuration")
    {
    Input("f",6,88,180,12,2)
     {
     Desc = "Frequency"
     Def = "60.0"
     Data = Real
     Unit = "Hz"
     Len = 15
     Min = 0
     }
    Choice("NCap",6,74,180,11,2)
     {
     Style = 0
     Desc = "Nodal Capacitance matrix available?"
     Def = "0"
     Len = 15
     *0 = "No"
     *1 = "Yes"
     }
    Input("length",6,60,180,12,2)
     {
     Desc = "length of the line in any units"
     Def = "1"
     Data = Real
     Len = 15
     Min = 0.001
     }
    Choice("Type",6,16,180,44,2)
     {
     Style = 1
     Desc = "Enter Resistance/Inductance values as"
     Def = "0"
     Len = 15
     *0 = "individual components"
     *1 = "sequence components"
     }
    Choice("View",6,2,180,12,2)
     {
     Style = 0
     Desc = "Graphic Display"
     Def = "0"
     Len = 15
     *0 = "3 phase view"
     *1 = "single line view"
     }
    }
   Category("Individual Components per unit length")
    {
    Cond = "Type==0"
    Input("Mac",6,156,180,12,2)
     {
     Desc = "Mutual Reactance [A-C]"
     Def = "0.009"
     Data = Real
     Unit = "ohm"
     Len = 15
     Min = 0
     }
    Input("Mbc",6,142,180,12,2)
     {
     Desc = "Mutual Reactance [B-C]"
     Def = "0.009"
     Data = Real
     Unit = "ohm"
     Len = 15
     }
    Input("Mab",6,128,180,12,2)
     {
     Desc = "Mutual Reactance [A-B]"
     Def = "0.009"
     Data = Real
     Unit = "ohm"
     Len = 15
     Min = 0
     }
    Input("Rac",6,114,180,12,2)
     {
     Desc = "Mutual Resistance [A-C]"
     Def = "0.0"
     Data = Real
     Unit = "ohm"
     Len = 15
     Min = 0
     }
    Input("Rbc",6,100,180,12,2)
     {
     Desc = "Mutual Resistance [B-C]"
     Def = "0.0"
     Data = Real
     Unit = "ohm"
     Len = 15
     Min = 0
     }
    Input("Rab",6,86,180,12,2)
     {
     Desc = "Mutual Resistance [A-B]"
     Def = "0.0"
     Data = Real
     Unit = "ohm"
     Len = 15
     Min = 0
     }
    Input("Lc",6,72,180,12,2)
     {
     Desc = "Reactance [C]"
     Def = "0.01"
     Data = Real
     Unit = "ohm"
     Len = 15
     Min = 0
     }
    Input("Lb",6,58,180,12,2)
     {
     Desc = "Reactance [B]"
     Def = "0.01"
     Data = Real
     Unit = "ohm"
     Len = 15
     Min = 0
     }
    Input("La",6,44,180,12,2)
     {
     Desc = "Reactance [A]"
     Def = "0.01"
     Data = Real
     Unit = "ohm"
     Len = 15
     Min = 0
     }
    Input("Rc",6,30,180,12,2)
     {
     Desc = "Resistance [C]"
     Def = "0.01"
     Data = Real
     Unit = "ohm"
     Len = 15
     }
    Input("Rb",6,16,180,12,2)
     {
     Desc = "Resistance [B]"
     Def = "0.01"
     Data = Real
     Unit = "ohm"
     Len = 15
     Min = 0
     }
    Input("Ra",6,2,180,12,2)
     {
     Desc = "Resistance [A]"
     Def = "0.01"
     Data = Real
     Unit = "ohm"
     Len = 15
     Min = 0
     }
    }
   Category("Sequence Components per unit length")
    {
    Cond = "Type==1"
    Input("Lz",6,44,180,12,2)
     {
     Desc = "Zero Sequence Reactance"
     Def = "0.028"
     Data = Real
     Unit = "ohm"
     Len = 15
     Min = 0
     }
    Input("Rz",6,30,180,12,2)
     {
     Desc = "Zero Sequence Resistance "
     Def = "0.01"
     Data = Real
     Unit = "ohm"
     Len = 15
     }
    Input("Lp",6,16,180,12,2)
     {
     Desc = "Positive Sequence Reactance"
     Def = "0.001"
     Data = Real
     Unit = "ohm"
     Len = 15
     Min = 0
     }
    Input("Rp",6,2,180,12,2)
     {
     Desc = "Positive Sequence Resistance"
     Def = "0.01"
     Data = Real
     Unit = "ohm"
     Len = 15
     Min = 0
     }
    }
   Category("Nodal Capacitance matrix per unit length")
    {
    Cond = "NCap==1"
    Input("Cod",6,100,180,12,2)
     {
     Desc = "Capacitance - off diagonal"
     Def = "-0.5"
     Data = Real
     Unit = "uF"
     Len = 15
     Max = 0
     Cond = "Type==1"
     }
    Input("Cd",6,86,180,12,2)
     {
     Desc = "Capacitance - diagonal"
     Def = "2.5"
     Data = Real
     Unit = "uF"
     Len = 15
     Min = 0
     Cond = "Type==1"
     }
    Input("Cbc",6,72,180,12,2)
     {
     Desc = "Capacitance [B-C]"
     Def = "-0.5"
     Data = Real
     Unit = "uF"
     Len = 15
     Max = 0
     Cond = "Type==0"
     }
    Input("Cac",6,58,180,12,2)
     {
     Desc = "Capacitance [A-C]"
     Def = "-0.5"
     Data = Real
     Unit = "uF"
     Len = 15
     Max = 0
     Cond = "Type==0"
     }
    Input("Cab",6,44,180,12,2)
     {
     Desc = "Capacitance [A-B]"
     Def = "-0.5"
     Data = Real
     Unit = "uF"
     Len = 15
     Max = 0
     Cond = "Type==0"
     }
    Input("Ccc",6,30,180,12,2)
     {
     Desc = "Capacitance [C-C]"
     Def = "2.5"
     Data = Real
     Unit = "uF"
     Len = 15
     Min = 0
     Cond = "Type==0"
     }
    Input("Cbb",6,16,180,12,2)
     {
     Desc = "Capacitance [B-B]"
     Def = "2.5"
     Data = Real
     Unit = "uF"
     Len = 15
     Min = 0
     Cond = "Type==0"
     }
    Input("Caa",6,2,180,12,2)
     {
     Desc = "Capacitance [A-A]"
     Def = "2.5"
     Data = Real
     Unit = "uF"
     Len = 15
     Min = 0
     Cond = "Type==0"
     }
    }
   }

  Nodes = 
   {
   Electrical("a1",-36,-36)
    {
    Cond = "View==0"
    }
   Electrical("b1",-36,0)
    {
    Cond = "View==0"
    }
   Electrical("c1",-36,36)
    {
    Cond = "View==0"
    }
   Electrical("a2",36,-36)
    {
    Cond = "View==0"
    }
   Electrical("b2",36,0)
    {
    Cond = "View==0"
    }
   Electrical("c2",36,36)
    {
    Cond = "View==0"
    }
   Electrical("N1",-36,0)
    {
    Cond = "View==1"
    Dim  = [3]
    }
   Electrical("N2",36,0)
    {
    Cond = "View==1"
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Pen(,ByNode,ByNode,b2)
   Cond = "View==0"
   Line(-24,0,-36,0)
   Line(-31,-36,-36,-36)
   Line(-31,36,-36,36)
   Pen(,Solid,0.2)
   Line(-31,-36,-24,0)
   Line(-31,36,-24,0)
   Pen(Blue)
   Brush(Solid,Navy)
   Rectangle(-29,-40,-26,-37)
   Pen(Black)
   Brush(,Black)
   Cond = "true"
   Ellipse(-27,-3,-21,3)
   Ellipse(21,-3,27,3)
   Pen(,ByNode,ByNode)
   Cond = "View==0"
   Line(36,0,24,0)
   Line(36,-36,31,-36)
   Line(36,36,31,36)
   Pen(,Solid,0.2)
   Line(24,0,31,-36)
   Line(24,0,31,36)
   Pen(Blue)
   Brush(,Navy)
   Rectangle(26,-40,29,-37)
   Pen(Black,,0.6)
   Cond = "View==1"
   Line(-36,0,-24,0)
   Line(24,0,36,0)
   Pen(,ByNode,ByNode)
   Cond = "View==0"
   Line(-11,0,-23,0)
   Line(23,0,11,0)
   Pen(,Solid,0.2)
   Brush(Hollow)
   Cond = "true"
   Rectangle(-11,-3,11,3)
   Pen(,,0.6)
   Cond = "View==1"
   Line(-23,0,-11,0)
   Line(11,0,23,0)
   }

  Section(EMTDC)
   {
   Transformers = "\
#TRANSFORMERS 1
#WINDINGS 3
!   Three coupled lines:
  3 / Number of windings... 
#IF Type==0
 #IF View==0 
  $a1 $a2    $Ral  $Lal /
  $b1 $b2    $Rabl $Mabl   $Rbl  $Lbl /
  $c1 $c2    $Racl $Macl   $Rbcl $Mbcl   $Rcl $Lcl /
 #ELSE 
  $N1(1) $N2(1)    $Ral  $Lal /
  $N1(2) $N2(2)    $Rabl $Mabl   $Rbl  $Lbl /
  $N1(3) $N2(3)    $Racl $Macl   $Rbcl $Mbcl   $Rcl $Lcl /
 #ENDIF
#ELSE
 #IF View==0 
  $a1 $a2    $R $L /
  $b1 $b2    $Rm $Lm   $R $L /
  $c1 $c2    $Rm $Lm   $Rm $Lm   $R $L /
 #ELSE 
  $N1(1) $N2(1)    $R $L /
  $N1(2) $N2(2)    $Rm $Lm   $R $L /
  $N1(3) $N2(3)    $Rm $Lm   $Rm $Lm   $R $L /
 #ENDIF
#ENDIF
!
"
   Computations = "\
#IF f!=0
 REAL w = 2*pi*f
#ELSE
 REAL w = 1.0
#ENDIF
#IF Type==1
 REAL R = (2*Rp+Rz)*length/3
 REAL L = (2*Lp+Lz)*length/(3*w)
 REAL Rm = (Rz-Rp)*length/3
 REAL Lm = (Lz-Lp)*length/(3*w)
#ELSEIF Type==0
 REAL Ral = Ra*length
 REAL Rbl = Rb*length
 REAL Rcl = Rc*length
 REAL Rabl = Rab*length
 REAL Rbcl = Rbc*length
 REAL Racl = Rac*length
 REAL Lal = La*length/w
 REAL Lbl = Lb*length/w
 REAL Lcl = Lc*length/w
 REAL Mabl = Mab*length/w
 REAL Mbcl = Mbc*length/w
 REAL Macl = Mac*length/w
#ENDIF
#IF NCap==1
 #IF Type==1
  REAL Cdl  = (Cd+2*Cod)*length*0.5/w
  REAL Codl = -Cod*length*0.5/w
 #ELSEIF Type==0
  REAL Cag = (Caa+Cab+Cac)*length*0.5/w
  REAL Cbg = (Cbb+Cab+Cbc)*length*0.5/w
  REAL Ccg = (Ccc+Cac+Cbc)*length*0.5/w
  REAL Cabl = -Cab*length*0.5/w
  REAL Cacl = -Cac*length*0.5/w
  REAL Cbcl = -Cbc*length*0.5/w
 #ENDIF
#ENDIF"
   Branch = "\
#IF NCap==1
 #IF Type==0
  #IF View==0
$a1 0 0.0 0.0 $Cag
$b1 0 0.0 0.0 $Cbg
$c1 0 0.0 0.0 $Ccg
$a1 $b1 0.0 0.0 $Cabl
$b1 $c1 0.0 0.0 $Cbcl
$c1 $a1 0.0 0.0 $Cacl
$a2 0 0.0 0.0 $Cag
$b2 0 0.0 0.0 $Cbg
$c2 0 0.0 0.0 $Ccg
$a2 $b2 0.0 0.0 $Cabl
$b2 $c2 0.0 0.0 $Cbcl
$c2 $a2 0.0 0.0 $Cacl
  #ELSE
$n1(1) 0 0.0 0.0 $Cag
$n1(2) 0 0.0 0.0 $Cbg
$n1(3) 0 0.0 0.0 $Ccg
$n1(1) $n1(2) 0.0 0.0 $Cabl
$n1(2) $n1(3) 0.0 0.0 $Cbcl
$n1(3) $n1(1) 0.0 0.0 $Cacl
$n2(1) 0 0.0 0.0 $Cag
$n2(2) 0 0.0 0.0 $Cbg
$n2(3) 0 0.0 0.0 $Ccg
$n2(1) $n2(2) 0.0 0.0 $Cabl
$n2(2) $n2(3) 0.0 0.0 $Cbcl
$n2(3) $n2(1) 0.0 0.0 $Cacl
  #ENDIF
 #ELSE
  #IF View==0
$a1 0 0.0 0.0 $Cdl
$b1 0 0.0 0.0 $Cdl
$c1 0 0.0 0.0 $Cdl
$a1 $b1 0.0 0.0 $Codl
$b1 $c1 0.0 0.0 $Codl
$c1 $a1 0.0 0.0 $Codl
$a2 0 0.0 0.0 $Cdl
$b2 0 0.0 0.0 $Cdl
$c2 0 0.0 0.0 $Cdl
$a2 $b2 0.0 0.0 $Codl
$b2 $c2 0.0 0.0 $Codl
$c2 $a2 0.0 0.0 $Codl
  #ELSE
$n1(1) 0 0.0 0.0 $Cdl
$n1(2) 0 0.0 0.0 $Cdl
$n1(3) 0 0.0 0.0 $Cdl
$n1(1) $n1(2) 0.0 0.0 $Codl
$n1(2) $n1(3) 0.0 0.0 $Codl
$n1(3) $n1(1) 0.0 0.0 $Codl
$n2(1) 0 0.0 0.0 $Cdl
$n2(2) 0 0.0 0.0 $Cdl
$n2(3) 0 0.0 0.0 $Cdl
$n2(1) $n2(2) 0.0 0.0 $Codl
$n2(2) $n2(3) 0.0 0.0 $Codl
$n2(3) $n2(1) 0.0 0.0 $Codl
  #ENDIF
 #ENDIF 
#ENDIF"
   }
  }
 Component("fload3")
  {
  Desc = "Load"
  FileDate = 0
  Parameters = 
   {
   Category("Parameters")
    {
    Input("PO",6,2,180,12,2)
     {
     Desc = "Rated Real Power per phase"
     Def = "100"
     Data = Real
     Unit = "MW"
     Len = 15
     Min = 0
     }
    Input("QO",6,16,180,12,2)
     {
     Desc = "Rated Reactive Power(+inductive) per phase"
     Def = "25"
     Data = Real
     Unit = "MVAR"
     Len = 15
     Min = 0
     }
    Input("VBO",6,30,180,12,2)
     {
     Desc = "Rated Load Voltage (rms L-G)"
     Def = "230"
     Data = Real
     Unit = "KV"
     Len = 15
     Min = 0
     }
    Input("NP",6,44,180,12,2)
     {
     Desc = "Volt Index for Power (dP/dV)"
     Def = "2"
     Data = Real
     Len = 15
     Min = 0
     }
    Input("NQ",6,58,180,12,2)
     {
     Desc = "Volt Index for Q (dQ/dV)"
     Def = "2"
     Data = Real
     Len = 15
     Min = 0
     }
    Input("KPF",6,72,180,12,2)
     {
     Desc = "Freq Index for Power (dP/dF)"
     Def = "0"
     Data = Real
     Len = 15
     Min = 0
     }
    Input("KQF",6,86,180,12,2)
     {
     Desc = "Freq Index for Q (dQ/dF)"
     Def = "0"
     Data = Real
     Len = 15
     Min = 0
     }
    Input("FR",6,100,180,12,2)
     {
     Desc = "Fundamental Frequency"
     Def = "60"
     Data = Real
     Unit = "Hz"
     Len = 15
     Min = 0
     }
    }
   Category("Internal Outputs")
    {
    Input("R1",6,2,180,12,6)
     {
     Desc = "resistance"
     Data = Real
     Len = 15
     }
    Input("L1",6,16,180,12,6)
     {
     Desc = "inductance"
     Data = Real
     Len = 15
     }
    Input("C1",6,30,180,12,6)
     {
     Desc = "capacitance"
     Data = Real
     Len = 15
     }
    }
   }

  Nodes = 
   {
   Electrical("IA",0,-36)
    {
    Dim  = [0]
    }
   Electrical("G",0,18)
    {
    Type = Ground
    }
   }

  Graphics = 
   {
   Line(-5,1,0,7)
   Line(0,7,5,1)
   Line(-8,29,9,29)
   Line(-5,32,5,32)
   Line(-2,35,2,35)
   Pen(,,ByNode,IA)
   Line(0,-36,0,-25)
   Pen(,,0.2)
   Rectangle(-12,-26,12,10)
   Line(0,-15,0,7)
   Line(0,10,0,29)
   Text(0,-13,"load")
   }

  Section(EMTDC)
   {
   Dsdyn = "\
#IF $#DIM(IA)==1
 #STORAGE STOR:1 REAL:13 LOGICAL:5
      CALL LOAD1P($SS,$IA,
  #IF (PO>0)&&((NP!=2)||(KPF!=0))
   #STORAGE STOR:10 
     +$BP,
  #ELSE
     +0,
  #ENDIF
  #IF (QO>0)&&((NQ!=2)||(KQF!=-1))
   #STORAGE STOR:10 
     +$BQ,
  #ELSEIF (QO<0)&&((NQ!=2)||(KQF!=1))
   #STORAGE STOR:10 
     +$BQ,
  #ELSE
     +0,
  #ENDIF
     +$VBO,$FR,$PO,$QO,$NP,$NQ,$KPF,$KQF)
#ELSEIF $#DIM(IA)==2
 #STORAGE STOR:2 REAL:26 LOGICAL:10
      CALL LOAD1P($SS,$IA(1),
  #IF (PO>0)&&((NP!=2)||(KPF!=0))
   #STORAGE STOR:20 
     +$BP(1),
  #ELSE
     +0,
  #ENDIF
  #IF (QO>0)&&((NQ!=2)||(KQF!=-1))
   #STORAGE STOR:20 
     +$BQ(1),
  #ELSEIF (QO<0)&&((NQ!=2)||(KQF!=1))
   #STORAGE STOR:20 
     +$BQ(1),
  #ELSE
     +0,
  #ENDIF
     +$VBO,$FR,$PO,$QO,$NP,$NQ,$KPF,$KQF)
      CALL LOAD1P($SS,$IA(2),
  #IF (PO>0)&&((NP!=2)||(KPF!=0))
     +$BP(2),
  #ELSE
     +0,
  #ENDIF
  #IF (QO>0)&&((NQ!=2)||(KQF!=-1))
     +$BQ(2),
  #ELSEIF (QO<0)&&((NQ!=2)||(KQF!=1))
     +$BQ(2),
  #ELSE
     +0,
  #ENDIF
     +$VBO,$FR,$PO,$QO,$NP,$NQ,$KPF,$KQF)
#ELSEIF $#DIM(IA)==3
 #STORAGE STOR:3 REAL:29 LOGICAL:9
      CALL LOAD3P($SS,$IA(1),$IA(2),$IA(3),
  #IF (PO>0)&&((NP!=2)||(KPF!=0))
   #STORAGE STOR:30 
     +$BP(1),$BP(2),$BP(3),
  #ELSE
     +0,0,0,
  #ENDIF
  #IF (QO>0)&&((NQ!=2)||(KQF!=-1))
   #STORAGE STOR:30 
     +$BQ(1),$BQ(2),$BQ(3),
  #ELSEIF (QO<0)&&((NQ!=2)||(KQF!=1))
   #STORAGE STOR:30 
     +$BQ(1),$BQ(2),$BQ(3),
  #ELSE
     +0,0,0,
  #ENDIF
     +$VBO,$FR,$PO,$QO,$NP,$NQ,$KPF,$KQF)
#ENDIF
#IF $#DIM(IA)==3
 #OUTPUT REAL R1 {STORF(NSTORF-26)}
 #OUTPUT REAL L1 {STORF(NSTORF-25)}
 #OUTPUT REAL C1 {STORF(NSTORF-24)}
#ELSE
 #OUTPUT REAL R1 {STORF(NSTORF-12)}
 #OUTPUT REAL L1 {STORF(NSTORF-11)}
 #OUTPUT REAL C1 {STORF(NSTORF-10)}
#ENDIF"
   Checks = "ERROR Dimesion exceed - Maximum 3 phase : $#DIM(IA)<4"
   Computations = "\
#IF PO>0
REAL R=VBO*VBO/PO
#ELSE
REAL R=1.0E6
#ENDIF
#IF QO>0
REAL L=VBO*VBO/(QO*2*PI*FR)
REAL C=1.0E-6
#ELSEIF QO<0
REAL C=-QO*1.0E6/(VBO*VBO*2*PI*FR)
REAL L=1.0E6
#ELSE
REAL L=1.0E6
REAL C=1.0E-6
#ENDIF"
   Branch = "\
#IF PO>0
  #IF (NP!=2)||(KPF!=0) 
BP = $IA 0 BREAKER 1.0
 #ELSE 
BP = $IA 0 $R
 #ENDIF
#ENDIF
#IF QO>0
  #IF (NQ!=2)||(KQF!=-1)
BQ = $IA 0 BREAKER 1.0
  #ELSE
BQ = $IA 0 0.0 $L
  #ENDIF
#ENDIF
#IF QO<0
  #IF (NQ!=2)||(KQF!=1)
BQ = $IA 0 BREAKER 1.0
  #ELSE
BQ = $IA 0 0.0 0.0 $C
  #ENDIF
#ENDIF"
   }
  }
 Component("multimeter")
  {
  Desc = "Multimeter"
  FileDate = 0
  Parameters = 
   {
   Category("Configuration")
    {
    Choice("MeasI",6,2,224,12,2)
     {
     Style = 0
     Desc = "Measure Instantaneous Current ?"
     Def = "0"
     Len = 15
     *0 = "No"
     *1 = "Yes"
     }
    Choice("MeasV",6,16,224,12,2)
     {
     Style = 0
     Desc = "Measure Instantaneous Voltage ?"
     Def = "0"
     Len = 15
     *0 = "No"
     *1 = "Yes"
     }
    Choice("MeasP",6,30,224,12,2)
     {
     Style = 0
     Desc = "Measure Active Power flow ?"
     Def = "0"
     Len = 15
     *0 = "No"
     *1 = "Yes"
     }
    Choice("MeasQ",6,44,224,12,2)
     {
     Style = 0
     Desc = "Measure Reactive Power flow ?"
     Def = "0"
     Len = 15
     *0 = "No"
     *1 = "Yes"
     }
    Choice("RMS",6,58,224,12,2)
     {
     Style = 0
     Desc = "Measure RMS voltage ?"
     Def = "0"
     Len = 15
     *0 = "No"
     *1 = "Yes, Analog"
     *2 = "Yes, Digital"
     }
    Input("S",6,72,224,12,2)
     {
     Desc = "Base MVA for per unitizing"
     Def = "1.0"
     Data = Real
     Unit = "MVA"
     Len = 15
     Min = 0
     Max = 500
     Cond = "MeasP||MeasQ"
     }
    Input("BaseV",6,86,224,12,2)
     {
     Desc = "Base voltage for per unitizing"
     Def = "1.0"
     Data = Real
     Unit = "kV"
     Len = 15
     Min = 0
     Max = 500
     Cond = "RMS!=0"
     }
    Input("TS",6,100,224,12,2)
     {
     Desc = "Smoothing Time Constant"
     Def = "0.02"
     Data = Real
     Unit = "s"
     Len = 15
     Min = 0
     Max = 1
     Cond = "MeasP||MeasQ||RMS==1"
     }
    Input("Freq",6,114,224,12,2)
     {
     Desc = "Frequency"
     Def = "60.0"
     Data = Real
     Unit = "Hz"
     Len = 15
     Min = 0
     Cond = "RMS==2"
     }
    Choice("Dis",6,128,224,12,2)
     {
     Style = 0
     Desc = "Animated Display?"
     Def = "0"
     Len = 15
     Cond = "MeasP+MeasQ+RMS>0"
     *0 = "No"
     *1 = "Yes"
     }
    }
   Category("Signal Names")
    {
    Input("CurI",6,2,224,12,2)
     {
     Desc = "Instantaneous Current"
     Data = Real
     Len = 15
     Cond = "MeasI"
     }
    Input("VolI",6,16,224,12,2)
     {
     Desc = "Instantaneous Voltage"
     Data = Real
     Len = 15
     Cond = "MeasV"
     }
    Input("P",6,30,224,12,2)
     {
     Desc = "Active Power"
     Data = Real
     Len = 15
     Cond = "MeasP"
     }
    Input("Q",6,44,224,12,2)
     {
     Desc = "Reactive Power"
     Data = Real
     Len = 15
     Cond = "MeasQ"
     }
    Input("Vrms",6,58,224,12,2)
     {
     Desc = "RMS voltage"
     Data = Real
     Len = 15
     Cond = "RMS!=0"
     }
    }
   Category("Animation")
    {
    Cond = "Dis==2"
    Choice("hide1",6,2,80,48,2)
     {
     Style = 1
     Desc = "power"
     Def = "0"
     Len = 15
     *0 = "hide"
     *1 = "show"
     }
    Choice("hide2",100,2,80,48,2)
     {
     Style = 1
     Desc = "rms voltage"
     Def = "0"
     Len = 15
     *0 = "hide"
     *1 = "show"
     }
    }
   }

  Nodes = 
   {
   Electrical("A",-18,0)
    {
    Cond = "MeasV+MeasP+MeasQ+RMS!=0"
    Dim  = [0]
    }
   Electrical("B",18,0)
    {
    Type = Removable
    Dim  = [0]
    }
   Electrical("A",-18,0)
    {
    Cond = "MeasV+MeasP+MeasQ+RMS==0"
    Type = Removable
    Dim  = [0]
    }
   }

  Graphics = 
   {
   Pen(Navy,,ByNode,A)
   Line(-18,0,-4,0)
   Pen(,,0.4)
   Ellipse(-4,-7,11,8)
   Pen(,,ByNode,B)
   Line(11,0,18,0)
   Pen(,,0.4)
   Ellipse(-4,8,11,23)
   Line(-12,0,-12,16)
   Line(3,23,3,27)
   Line(-2,27,8,27)
   Line(0,29,6,29)
   Line(2,32,4,32)
   Pen(Blue,,0.2)
   Line(12,-12,6,-9)
   Line(6,-15,12,-12)
   Line(-1,-12,12,-12)
   Pen(Navy,,0.4)
   Line(-12,16,-4,16)
   Cond = "MeasP*Dis*hide1>0"
   Text(4,-48,"P = %Pd")
   Cond = "MeasQ*Dis*hide1>0"
   Text(4,-34,"Q = %Qd")
   Cond = "RMS*Dis*hide2>0"
   Text(1,-20,"V = %Vd")
   Cond = "true"
   Text(3,20,"V")
   Text(3,4,"A")
   }

  Section(EMTDC)
   {
   Branch = "BN = $A $B AMMETER"
   DSOUT = "\
#IF MeasI
 #OUTPUT REAL CurI 0 {$CBR:BN}
#ENDIF
!
#IF MeasV
 #FUNCTION REAL EMTDC_VVDC
 #OUTPUT REAL VolI 0 {$VDC:A:0}
#ENDIF
!
#IF (MeasP+MeasQ) || RMS!=0
 #LOCAL REAL RVD1_1
#ENDIF
!
#IF MeasP
 #IF ($#DIM(A)==3 || $#DIM(B)==3)
  #FUNCTION REAL P3PH3
  #STORAGE STOR:3
  #IF SI != 1.0
      RVD1_1 = $SI * P3PH3($SS,$BN(1),$BN(2),$BN(3),$TS,0)
  #ELSE
      RVD1_1 = P3PH3($SS,$BN(1),$BN(2),$BN(3),$TS,0) 
  #ENDIF
  #IF Dis==1
      IF (UPDATE_AG) CALL PSCAD_AGRG($#Component,RVD1_1,\"Pd\")
  #ENDIF
 #ELSEIF ($#DIM(A)==1 && $#DIM(B)==1)
  #STORAGE STOR:9 REAL:2
      CALL PQVI1PH($SS,$A,$BN,$TS)
      RVD1_1 = STORF(NSTORF-2)
  #IF Dis==1
      IF (UPDATE_AG) CALL PSCAD_AGRG($#Component,RVD1_1,\"Pd\")
  #ENDIF
 #ELSE
      RVD1_1 = 0.0
 #ENDIF
 #OUTPUT REAL P {RVD1_1}
#ENDIF
!
#IF MeasQ
 #IF ($#DIM(A)==3 || $#DIM(B)==3)
  #FUNCTION REAL Q3PH3
  #STORAGE STOR:3
  #IF SI != 1.0
      RVD1_1 = $SI * Q3PH3($SS,$BN(1),$BN(2),$BN(3),$TS,0)
  #ELSE
      RVD1_1 = Q3PH3($SS,$BN(1),$BN(2),$BN(3),$TS,0)
  #ENDIF
  #IF Dis==1
      IF (UPDATE_AG) CALL PSCAD_AGRG($#Component,RVD1_1,\"Qd\")
  #ENDIF
 #ELSEIF ($#DIM(A)==1 && $#DIM(B)==1)
  #IF MeasP
      RVD1_1 = STORF(NSTORF-1)
  #ELSE
   #STORAGE STOR:9 REAL:2
      CALL PQVI1PH($SS,$A,$BN,$TS)
      RVD1_1 = STORF(NSTORF-1)
  #ENDIF
  #IF Dis==1
      IF (UPDATE_AG) CALL PSCAD_AGRG($#Component,RVD1_1,\"Qd\")
  #ENDIF
 #ELSE
      RVD1_1 = 0.0
 #ENDIF
 #OUTPUT REAL Q {RVD1_1}
#ENDIF
!
#IF $#DIM(A)==3
 #IF RMS==1
  #STORAGE STOR:2
  #FUNCTION REAL VM3PH2 '3 Phase RMS Voltage Measurement'
  #IF BaseVI != 1.0
      RVD1_1 = $BaseVI * VM3PH2($SS, $A(1), $A(2), $A(3), $TS)
  #ELSE
      RVD1_1 = VM3PH2($SS, $A(1), $A(2), $A(3), $TS) 
  #ENDIF
 #ELSEIF RMS==2
  #SUBROUTINE DGTL_RMS3 '3 Phase Digital RMS Meter'
  #STORAGE REAL:5 INTEGER:2
  #STORAGE REAL:256
      CALL DGTL_RMS3(256,$SS,$A(1),$A(2),$A(3),$FREQ,1.0,0.0,RVD1_1)
  #IF BaseVI != 1.0
      RVD1_1 = $BaseVI*RVD1_1
  #ENDIF
 #ENDIF
 #IF RMS!=0
 #IF Dis==1
      IF (UPDATE_AG) CALL PSCAD_AGRG($#Component,RVD1_1,\"Vd\")
 #ENDIF
 #ENDIF
#ELSEIF $#DIM(A)==1
 #IF RMS==1
  #STORAGE STOR:3
  #FUNCTION REAL RMS3 'Instantaneous RMS Measurement'
      RVD1_1 = RMS3( $VDC:A:0 , $TS )
  #IF BaseVI != 1.0
      RVD1_1 = $BaseVI*RVD1_1
  #ENDIF
 #ELSEIF RMS==2
  #SUBROUTINE DGTL_RMS 'RMS Measurement using Digital Samlping'
  #STORAGE REAL:5 INTEGER:2
  #STORAGE REAL:256
      CALL DGTL_RMS(256,$Freq,$VDC:A:0,$BaseVI,0.0,RVD1_1)
 #ENDIF
 #IF RMS!=0
 #IF Dis==1
      IF (UPDATE_AG) CALL PSCAD_AGRG($#Component,RVD1_1,\"Vd\")
 #ENDIF
 #ENDIF
#ELSE
 #IF RMS!=0
      RVD1_1 = 0.0
 #ENDIF
#ENDIF
#IF RMS!=0
 #OUTPUT REAL Vrms {RVD1_1}
#ENDIF
#IF (MeasQ || MeasP || RMS) && Dis
      IF (FIRSTSTEP) THEN
 #IF ($#DIM(A)==3 || $#DIM(B)==3 || $#DIM(A)==1 || $#DIM(B)==1)
        CALL PSCAD_AGI($#Component,1,\"hide1\")
 #ELSE
        CALL PSCAD_AGI($#Component,0,\"hide1\")
 #ENDIF
 #IF ($#DIM(A)!=3 && $#DIM(A)!=1)
        CALL PSCAD_AGI($#Component,0,\"hide2\")
 #ELSE
        CALL PSCAD_AGI($#Component,1,\"hide2\")
 #ENDIF
      ENDIF
#ENDIF"
   Computations = "\
#IF MeasP||MeasQ
 #IF S!=0.0
  REAL SI=1/S
 #ELSE
  REAL SI=1.0
 #ENDIF
#ENDIF
#IF RMS!=0
 #IF BaseV!=0.0
  REAL BaseVI = 1/BaseV
 #ELSE
  REAL BaseVI = 1.0
 #ENDIF
#ENDIF"
   Checks = "\
#IF $#DIM(A)!=3 && $#DIM(A)!=1
 #IF MeasP||MeasQ
WARNING Power is measured only on 3 phase or single phase lines, Selection ignored. : 0>1
 #ENDIF
 #IF RMS!=0
WARNING RMS voltage is measured only on 3 phase or single phase lines, Selection ignored. : 0>1
 #ENDIF
#ENDIF"
   }
  }
 Component("update_ag")
  {
  Desc = ""
  FileDate = 0
  Parameters = 
   {
   }

  Nodes = 
   {
   Output("a",54,0)
    {
    Type = Logical
    }
   }

  Graphics = 
   {
   Rectangle(-39,-12,39,12)
   Pen(ByNode,ByNode,ByNode,a)
   Line(54,0,39,0)
   Text(-1,4,"Update A.G.")
   }

  Section(EMTDC)
   {
   DSOUT = "\
#FUNCTION LOGICAL G_UPDAT
      $a = G_UPDAT(111)"
   }
  }
 Module("Graph")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-39,-39,39,39)
   Text(0,-13,"Graph")
   }


  Page(A/A4,Portrait,16,[835,483],5)
   {
   -Plot-([36,18],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,288,630]
    Posn = [36,18]
    Icon = [144,324]
    Extents = 0,0,288,630
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,288,142],"y")
     {
     Options = 136
     Units = ""
     Curve(48547104,"Ia",0,,,)
     Curve(48549048,"Ib",0,,,)
     Curve(48551592,"Ic",0,,,)
     }
    Graph([0,142],[0,0,288,142],"y")
     {
     Options = 128
     Units = ""
     Curve(48587336,"Vrmsa",0,,,)
     Curve(48590000,"Vrmsb",0,,,)
     Curve(48592528,"Vrmsc",0,,,)
     }
    Graph([0,284],[0,0,288,142],"y")
     {
     Options = 128
     Units = ""
     Curve(48559280,"Pa",0,,,)
     Curve(48595104,"Pb",0,,,)
     Curve(48597648,"Pc",0,,,)
     }
    Graph([0,426],[0,0,288,141],"y")
     {
     Options = 128
     Units = ""
     Curve(48600192,"Qa",0,,,)
     Curve(48602872,"Qb",0,,,)
     Curve(48561824,"Qc",0,,,)
     }
    }
   -Plot-([324,18],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,288,630]
    Posn = [324,18]
    Icon = [252,324]
    Extents = 0,0,288,630
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,288,142],"y")
     {
     Options = 136
     Units = ""
     Curve(48620936,"Ia",0,,,)
     Curve(48623216,"Ib",0,,,)
     Curve(48625768,"Ic",0,,,)
     Curve(48757768,"In",0,,,)
     }
    Graph([0,142],[0,0,288,142],"y")
     {
     Options = 136
     Units = ""
     Curve(48608040,"Vrmsa",0,,,)
     Curve(48610592,"Vrmsb",0,,,)
     Curve(48613144,"Vrmsc",0,,,)
     }
    Graph([0,284],[0,0,288,142],"y")
     {
     Options = 128
     Units = ""
     Curve(48605416,"Pa",0,,,)
     Curve(48615848,"Pb",0,,,)
     Curve(48618392,"Pc",0,,,)
     }
    Graph([0,426],[0,0,288,141],"y")
     {
     Options = 144
     Units = ""
     Curve(48630992,"Qa",0,,,)
     Curve(48633536,"Qb",0,,,)
     Curve(48628448,"Qc",0,,,)
     }
    }
   -Plot-([612,18],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,288,630]
    Posn = [612,18]
    Icon = [522,324]
    Extents = 0,0,288,630
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,288,142],"y")
     {
     Options = 136
     Units = ""
     Curve(48656768,"Ia",0,,,)
     Curve(48659448,"Ib",0,,,)
     Curve(48661992,"Ic",0,,,)
     }
    Graph([0,142],[0,0,288,142],"y")
     {
     Options = 128
     Units = ""
     Curve(48638736,"Vrmsa",0,,,)
     Curve(48646560,"Vrmsb",0,,,)
     Curve(48649112,"Vrmsc",0,,,)
     }
    Graph([0,284],[0,0,288,142],"y")
     {
     Options = 128
     Units = ""
     Curve(48636208,"Pa",0,,,)
     Curve(48651680,"Pb",0,,,)
     Curve(48654224,"Pc",0,,,)
     }
    Graph([0,426],[0,0,288,141],"y")
     {
     Options = 128
     Units = ""
     Curve(48667080,"Qa",0,,,)
     Curve(48669632,"Qb",0,,,)
     Curve(48664536,"Qc",0,,,)
     }
    }
   -Plot-([36,666],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,288,522]
    Posn = [36,666]
    Icon = [144,522]
    Extents = 0,0,288,522
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,288,153],"y")
     {
     Options = 128
     Units = ""
     Curve(48571872,"Ia",0,,,)
     Curve(48674584,"Ib",0,,,)
     Curve(48677112,"Ic",0,,,)
     Curve(48761392,"IMtfn1",0,,,)
     Curve(48763848,"IMtfn2",0,,,)
     }
    Graph([0,153],[0,0,288,153],"y")
     {
     Options = 128
     Units = ""
     Curve(48679640,"Pa",0,,,)
     Curve(48682304,"Pb",0,,,)
     Curve(48574400,"Pc",0,,,)
     }
    Graph([0,306],[0,0,288,153],"y")
     {
     Options = 144
     Units = ""
     Curve(48684832,"Qa",0,,,)
     Curve(48577064,"Qb",0,,,)
     Curve(48687360,"Qc",0,,,)
     }
    }
   -Plot-([900,666],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,288,630]
    Posn = [900,666]
    Icon = [558,396]
    Extents = 0,0,288,630
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,288,142],"y")
     {
     Options = 128
     Units = ""
     Curve(48739400,"Isrcpos",0,,,)
     Curve(48741304,"Isrcneg",0,,,)
     }
    Graph([0,142],[0,0,288,142],"y")
     {
     Options = 128
     Units = ""
     Curve(48746712,"Ibus1pos",0,,,)
     Curve(48748776,"Ibus1neg",0,,,)
     }
    Graph([0,284],[0,0,288,142],"y")
     {
     Options = 128
     Units = ""
     Curve(48752808,"IMtfpos",0,,,)
     Curve(48754712,"IMtfaneg",0,,,)
     }
    Graph([0,426],[0,0,288,141],"y")
     {
     Options = 128
     Units = ""
     Curve(48733040,"Imotorpos",0,,,)
     Curve(48734968,"Imotorneg",0,,,)
     }
    }
   -Plot-([900,18],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,288,360]
    Posn = [900,18]
    Icon = [792,144]
    Extents = 0,0,288,360
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,288,149],"y")
     {
     Options = 128
     Units = ""
     Curve(48564504,"Ia",0,,,)
     Curve(48566784,"Ib",0,,,)
     Curve(48569328,"Ic",0,,,)
     }
    Graph([0,149],[0,0,288,148],"y")
     {
     Options = 144
     Units = ""
     Curve(48769096,"Iflt",0,,,)
     }
    }
   -Plot-([324,666],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,288,630]
    Posn = [324,666]
    Icon = [288,378]
    Extents = 0,0,288,630
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,288,142],"y")
     {
     Options = 128
     Units = ""
     Curve(48579856,"Ia",0,,,)
     Curve(48703320,"Ib",0,,,)
     Curve(48706896,"Ic",0,,,)
     }
    Graph([0,142],[0,0,288,142],"y")
     {
     Options = 128
     Units = ""
     Curve(48690424,"Vrmsa",0,,,)
     Curve(48692976,"Vrmsb",0,,,)
     Curve(48695664,"Vrmsc",0,,,)
     }
    Graph([0,284],[0,0,288,142],"y")
     {
     Options = 128
     Units = ""
     Curve(48582264,"Pa",0,,,)
     Curve(48698232,"Pb",0,,,)
     Curve(48700776,"Pc",0,,,)
     }
    Graph([0,426],[0,0,288,141],"y")
     {
     Options = 144
     Units = ""
     Curve(48584808,"Qa",0,,,)
     Curve(48709576,"Qb",0,,,)
     Curve(48712120,"Qc",0,,,)
     }
    }
   -Plot-([612,666],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,288,522]
    Posn = [612,666]
    Icon = [360,540]
    Extents = 0,0,288,522
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,288,153],"y")
     {
     Options = 128
     Units = ""
     Curve(48772376,"P",0,,,)
     Curve(48774920,"Q",0,,,)
     }
    Graph([0,153],[0,0,288,153],"y")
     {
     Options = 128
     Units = ""
     Curve(48777464,"Tm",0,,-2,)
     Curve(48780008,"w",0,,-2,)
     Curve(48784472,"Slip_delay",0,,,)
     }
    Graph([0,306],[0,0,288,153],"y")
     {
     Options = 128
     Units = ""
     Curve(48787040,"Ia",0,,-2,)
     Curve(48789056,"Ib",0,,-2,)
     Curve(48796184,"Ic",0,,,)
     }
    }
   }
  }
 Module("Wind_Turbine")
  {
  Desc = ""
  FileDate = 1151590220
  Nodes = 
   {
   Input("W",0,-54)
    {
    Type = Real
    }
   Output("Tm",54,0)
    {
    Type = Real
    }
   Input("P",-18,-54)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-39,-39,39,39)
   Text(0,-13,"Wind Turbine")
   Pen(ByNode,ByNode,ByNode,W)
   Line(0,-54,0,-39)
   Pen(,Solid)
   Line(0,-39,-5,-44)
   Line(0,-39,5,-44)
   Text(10,-42,"W")
   Pen(,ByNode,,Tm)
   Line(54,0,39,0)
   Text(46,-4,"Tm")
   Pen(,,,W)
   Line(-18,-54,-18,-39)
   Pen(,Solid)
   Line(-18,-39,-23,-44)
   Line(-18,-39,-13,-44)
   Text(-8,-42,"P")
   }


  Page(B/A3,Landscape,16,[835,483],5)
   {
   0.import([216,756],0,0,30)
    {
    Name = "W"
    }
   0.export([576,450],0,0,230)
    {
    Name = "Tm"
    }
   -Wire-([234,252],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   0.pgb([234,252],0,47608576,260)
    {
    Name = "w"
    Group = ""
    Display = "1"
    Scale = "1"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "1.0128"
    Max = "1.0132"
    }
   0.pgb([234,288],0,47610616,250)
    {
    Name = "Tm"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-0.82"
    Max = "-0.72"
    }
   0.datalabel([162,252],4,0,-1)
    {
    Name = "w"
    }
   0.pgb([774,648],0,47613160,210)
    {
    Name = "Tturbine"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "0.766"
    Max = "0.78"
    }
   0.pgb([774,684],0,47615144,200)
    {
    Name = "PT"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([612,828],0,0,-1)
    {
    Name = "BETA"
    }
   0.pgb([612,828],0,47617664,190)
    {
    Name = "Beta"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "16.2"
    Max = "16.4"
    }
   0.var([108,648],0,47619648,10)
    {
    Name = "Es"
    Group = ""
    Display = "0"
    Max = "30"
    Min = "0.0"
    Value = "5.0"
    Units = ""
    Collect = "1"
    }
   -Wire-([144,648],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([180,648],0,0,-1)
    {
    Name = "ES"
    }
   0.datalabel([414,648],0,0,-1)
    {
    Name = "Vw"
    }
   0.wind_turbine([612,666],0,0,180)
    {
    Gmva = "0.66"
    Wrat = "1200 [rpm]"
    Rad = "23.5"
    Area = "1735"
    Airden = "1.229 [kg/m^3]"
    Eff = "0.97 [pu]"
    Gratio = "GR"
    Mod = "0"
    }
   0.var([882,864],0,47623880,70)
    {
    Name = "GR"
    Group = ""
    Display = "1"
    Max = "200"
    Min = "0.0"
    Value = "55.0"
    Units = ""
    Collect = "1"
    }
   -Wire-([918,864],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([990,864],0,0,-1)
    {
    Name = "GR"
    }
   -Wire-([522,756],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.compare([396,1026],0,0,120)
    {
    X = "500"
    OL = "0"
    OH = "1"
    INTR = "0"
    }
   0.time-sig([324,1026],0,0,110)
    {
    }
   -Wire-([162,324],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([162,324],0,0,-1)
    {
    Name = "Vw"
    }
   0.pgb([234,324],0,47628800,240)
    {
    Name = "Wind speed"
    Group = ""
    Display = "1"
    Scale = "1"
    Units = "m/s"
    mrun = "0"
    Pol = "0"
    Min = "14.9"
    Max = "15.1"
    }
   0.datalabel([162,288],4,0,-1)
    {
    Name = "Tm"
    }
   0.wind_governor([612,954],0,0,170)
    {
    Pcnt = "0"
    Gen = "0"
    Wrat = "50 [Hz]"
    Tmva = "2 [MW]"
    Gmva = "2 [MVA]"
    Gov = "0"
    Gr = "GR"
    Pref = "1.44 [MW]"
    Wref = "314 [rad/s]"
    Kp = "6.2 [deg/pu]"
    Ki = "6.2 "
    Piul = "100"
    Pill = "-100"
    Ks = "0.05 [deg/pu]"
    Gmul = "30 [deg/pu]"
    Dwm = "0.2 [rad/s]"
    Bo = "20.81"
    K4 = "0.1 [s]"
    Arl = "1"
    Rl = "10.0 [deg/s]"
    Pal = "1"
    Bll = "0 [deg]"
    Bul = "25 [deg]"
    Nf = "0"
    Type = "5"
    Wf = "10.0 [rad/s]"
    Df = "0.3"
    }
   -Wire-([612,900],0,0,-1)
    {
    Vertex="0,0;0,-162"
    }
   0.select([504,972],0,0,160)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.datalabel([468,1008],4,0,-1)
    {
    Name = "CNT"
    }
   0.const([432,972],0,0,100)
    {
    Name = ""
    Value = "1"
    }
   -Wire-([378,936],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Sticky-([252,1080],0)
    {
    Name = ""
    Font = 1
    Bounds = 252,1080,414,1134
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Signal CNT enables the pitch angle dynamics.
(Disabled for this simulation.)"
    }
   -Sticky-([432,828],0)
    {
    Name = ""
    Font = 1
    Bounds = 432,828,558,900
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
A six Pole Machine
Mechanical speed = W(pu)*2*pi*f/(pole paris)
"
    }
   -Wire-([522,684],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([684,648],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([684,684],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([324,648],0,0,-1)
    {
    Vertex="0,0;216,0"
    }
   0.wind_source([252,648],0,0,20)
    {
    EXT = "1"
    BWV = "15"
    Gust = "0"
    Ramp = "0"
    Noise = "0"
    Damp = "0"
    TC = "0.025 [s]"
    MAXG = "1 [m/s]"
    TG = "2 [s]"
    T1G = "3"
    NG = "1"
    MAXR = "1 [m/s]"
    TR = "1 [s]"
    T1R = "6"
    NR = "1"
    N = "50"
    DW = "1 [rad/s]"
    Kn = "0.0192"
    F = "600 [m]"
    ISEED = "8"
    TRM = "0.35 [s]"
    }
   -Sticky-([36,18],0)
    {
    Name = ""
    Font = 1
    Bounds = 36,18,414,90
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case shows a induction generator being driven by a wind turbine. The turbine is 'Satll Controlled'. The 'wind source'  is used to model wind speed fluctuations.

"
    }
   -Sticky-([846,756],0)
    {
    Name = ""
    Font = 1
    Bounds = 846,756,1008,828
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
GR - Gear Ratio
Es - External signal for wind speed
"
    }
   -Wire-([432,1008],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([252,756],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.mult([414,756],0,0,130)
    {
    }
   -Wire-([342,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.div([486,756],0,0,140)
    {
    }
   0.const([450,792],0,0,40)
    {
    Name = "Pole pairs"
    Value = "3"
    }
   -Wire-([774,648],0,0,-1)
    {
    Vertex="0,0;0,-198;-90,-198"
    }
   -Sticky-([396,684],0)
    {
    Name = ""
    Font = 1
    Bounds = 396,684,504,720
    Alignment = 0
    Style = 1
    Arrow = 8
    Color = 0,15792890
    Text = "\
Actual hub speed of machine
"
    }
   -Sticky-([396,0],0)
    {
    Name = ""
    Font = 2
    Bounds = 396,0,1044,36
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "WIND TURBINE"
    }
   0.gain([648,450],4,0,220)
    {
    G = "-1"
    COM = "Gain"
    Dim = "1"
    }
   -Sticky-([504,1026],0)
    {
    Name = ""
    Font = 1
    Bounds = 504,1026,810,1188
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Initial Pitch angle and the Power reference (demand) are inputs to this module.
For this example :
Initial pitch angle = 20.81 deg
Power demand = 0.66 MW

Pitch control is disabled. Turbine is the its Stall control mode.
The turbine aerodynamic characteristics will determine the output torque of the unit."
    }
   -Sticky-([558,504],0)
    {
    Name = ""
    Font = 1
    Bounds = 558,504,756,576
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "The convention for the Induction machine is that input mechanical torque is negative . (ie. motoring mode is positive)"
    }
   -Sticky-([846,936],0)
    {
    Name = ""
    Font = 1
    Bounds = 846,936,1008,1062
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "When in steady state, apply a step change (using the slider) to ES. The pitch angle will regulate the real power to the power order (Demand) requested from the governor."
    }
   -Sticky-([450,108],0)
    {
    Name = ""
    Font = 1
    Bounds = 450,108,738,234
    Alignment = 0
    Style = 1
    Arrow = 64
    Color = 0,15792890
    Text = "\
1.01358 is approximately the pu speed of the machine when delivering 1.44 MW (0.77 pu) of power to the system. This is used as the initial seep to spped up the initialization of the silulation.

If the starting transients are of interest, then the initial speed should be zero and the machine should start in the 'Torque control' mode."
    }
   -Sticky-([126,522],0)
    {
    Name = ""
    Font = 1
    Bounds = 126,522,360,576
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Use this component to study a wind gust or a ramp and see the response of the control systems."
    }
   -Wire-([162,288],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.annotation([216,216],0,0,-1)
    {
    AL1 = "Output Cnahhels for Plotting"
    AL2 = ""
    }
   0.emtconst([288,846],0,0,50)
    {
    Name = ""
    Value = "1"
    }
   0.gain([360,846],0,0,60)
    {
    G = "60.0"
    COM = "freq"
    Dim = "1"
    }
   -Wire-([396,846],0,0,-1)
    {
    Vertex="0,0;18,0;18,-54"
    }
   -ControlPanel-([864,576],0)
    {
    Name = "Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(47619648)
    Slider(47623880)
    }
   0.import([270,936],0,0,80)
    {
    Name = "P"
    }
   0.div([342,936],0,0,150)
    {
    }
   0.const([306,972],0,0,90)
    {
    Name = "Rated Power"
    Value = "0.66"
    }
   -Wire-([432,1026],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Plot-([1044,36],0)
    {
    Title = "Plots"
    Draw = 1
    Area = [0,0,468,1260]
    Posn = [1044,36]
    Icon = [-1,-1]
    Extents = 0,0,468,1260
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,468,150],"Power")
     {
     Options = 0
     Units = ""
     Curve(58603296,"P",0,,,)
     }
    Graph([0,150],[0,0,468,150],"Reactive Power")
     {
     Options = 0
     Units = ""
     Curve(58282008,"Q",0,,,)
     }
    Graph([0,300],[0,0,468,150],"Speed")
     {
     Options = 0
     Units = ""
     Curve(47608576,"w",0,,,)
     }
    Graph([0,450],[0,0,468,150],"Mech. Torque")
     {
     Options = 0
     Units = ""
     Curve(47610616,"Tm",0,,,)
     }
    Graph([0,600],[0,0,468,150],"Elec. Torque")
     {
     Options = 0
     Units = ""
     Curve(58602120,"Te",0,,,)
     }
    Graph([0,750],[0,0,468,149],"Torque")
     {
     Options = 0
     Units = ""
     Curve(47613160,"Tturbine",0,,,)
     }
    Graph([0,899],[0,0,468,149],"Wind Speed")
     {
     Options = 0
     Units = ""
     Curve(47628800,"Wind speed",0,,,)
     }
    Graph([0,1048],[0,0,468,149],"Pitch Angle")
     {
     Options = 0
     Units = ""
     Curve(47617664,"Beta",0,,,)
     }
    }
   }
  }
 Module("MetersG2")
  {
  Desc = "Generator _02"
  FileDate = 1151590220
  Nodes = 
   {
   Electrical("Left",-18,0)
    {
    Dim  = [3]
    }
   Electrical("Right",18,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-10,-12,11,9)
   Pen(ByNode,ByNode,ByNode,Left)
   Line(-18,0,-9,0)
   Pen(,,,Right)
   Line(18,0,12,0)
   Pen(Black,Solid,0.2)
   Arc(-8,-8,9,-2,0,90)
   Arc(-7,-8,10,-2,540,-90)
   Line(0,6,4,-6)
   Text(1,20,"PQ")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([90,234],0,0,-1)
    {
    Name = "Left"
    }
   0.xnode([522,234],0,0,-1)
    {
    Name = "Right"
    }
   0.multimeter([216,126],0,0,10)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "1"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "1"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = "Ang1"
    hide1 = "1"
    hide2 = "1"
    Pd = "0.01916"
    Qd = "-0.07161"
    Vd = "0.07357"
    }
   0.breakout([126,234],0,0,-1)
    {
    Dis = "0"
    }
   0.breakout([468,234],4,0,-1)
    {
    Dis = "0"
    }
   0.multimeter([306,234],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "1"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "1"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.02164"
    Qd = "-0.09687"
    Vd = "0.0921"
    }
   0.multimeter([360,342],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "1"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "1"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.02965"
    Qd = "-0.1953"
    Vd = "0.1246"
    }
   -Wire-([324,234],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([90,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([378,342],0,0,-1)
    {
    Vertex="0,0;54,0;54,-72"
    }
   -Wire-([162,270],0,0,-1)
    {
    Vertex="0,0;0,72;180,72"
    }
   -Wire-([162,234],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([162,198],0,0,-1)
    {
    Vertex="0,0;0,-72;36,-72"
    }
   -Wire-([234,126],0,0,-1)
    {
    Vertex="0,0;198,0;198,72"
    }
   -Wire-([468,234],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([684,144],0,0,-1)
    {
    Name = "Ang1"
    }
   -Wire-([684,144],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([756,144],0,47704808,20)
    {
    Name = "Ang1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -ControlPanel-([720,252],0)
    {
    Name = "$(GROUP) : Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,0,0
    Meter(47704808)
    }
   }
  }
 Module("MetersG1")
  {
  Desc = "Generator _01"
  FileDate = 1151590212
  Nodes = 
   {
   Electrical("Left",-18,0)
    {
    Dim  = [3]
    }
   Electrical("Right",18,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-10,-12,11,9)
   Pen(ByNode,ByNode,ByNode,Left)
   Line(-18,0,-9,0)
   Pen(,,,Right)
   Line(18,0,12,0)
   Pen(Black,Solid,0.2)
   Arc(-8,-8,9,-2,0,90)
   Arc(-7,-8,10,-2,540,-90)
   Line(0,6,4,-6)
   Text(1,20,"PQ")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([90,234],0,0,-1)
    {
    Name = "Left"
    }
   0.xnode([522,234],0,0,-1)
    {
    Name = "Right"
    }
   0.multimeter([216,126],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "1"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "-0.003821"
    Qd = "-0.01378"
    Vd = "0.01578"
    }
   0.breakout([126,234],0,0,-1)
    {
    Dis = "0"
    }
   0.breakout([468,234],4,0,-1)
    {
    Dis = "0"
    }
   0.multimeter([306,234],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "1"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "-0.193"
    Qd = "0.8354"
    Vd = "0.228"
    }
   0.multimeter([360,342],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "1"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.1499"
    Qd = "0.4981"
    Vd = "0.1822"
    }
   -Wire-([324,234],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([90,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([378,342],0,0,-1)
    {
    Vertex="0,0;54,0;54,-72"
    }
   -Wire-([162,270],0,0,-1)
    {
    Vertex="0,0;0,72;180,72"
    }
   -Wire-([162,234],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([162,198],0,0,-1)
    {
    Vertex="0,0;0,-72;36,-72"
    }
   -Wire-([234,126],0,0,-1)
    {
    Vertex="0,0;198,0;198,72"
    }
   -Wire-([468,234],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   }
  }
 Module("Reg2C")
  {
  Desc = ""
  FileDate = 1151590219
  Nodes = 
   {
   Input("V",-54,-18)
    {
    Type = Real
    }
   Input("I",-54,18)
    {
    Type = Real
    }
   Output("TAP",54,0)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-39,-39,39,39)
   Text(0,-13,"Reg2C")
   Pen(ByNode,ByNode,ByNode,V)
   Line(-54,-18,-39,-18)
   Pen(,Solid)
   Line(-39,-18,-44,-23)
   Line(-39,-18,-44,-13)
   Text(-46,-22,"V")
   Pen(,ByNode,,I)
   Line(-54,18,-39,18)
   Pen(,Solid)
   Line(-39,18,-44,13)
   Line(-39,18,-44,23)
   Text(-46,14,"I")
   Pen(,ByNode,,TAP)
   Line(54,0,39,0)
   Text(46,-4,"TAP")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.import([90,90],0,0,10)
    {
    Name = "V"
    }
   0.import([90,126],0,0,20)
    {
    Name = "I"
    }
   0.export([90,162],0,0,730)
    {
    Name = "TAP"
    }
   0.datalabel([342,504],0,0,-1)
    {
    Name = "V"
    }
   0.datalabel([504,396],0,0,-1)
    {
    Name = "I"
    }
   0.annotation([450,450],0,0,-1)
    {
    AL1 = ""
    AL2 = "PT Ratio=120"
    }
   0.annotation([612,342],0,0,-1)
    {
    AL1 = ""
    AL2 = "CT Ratio=500"
    }
   -Wire-([486,504],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.src_ccin_1([720,468],6,0,710)
    {
    Name = "Source 1"
    Cntrl = "1"
    Vm = "132.79 [kA]"
    f = "60.0 [Hz]"
    Ph = "0.0 []"
    Tc = "1.0 [sec]"
    }
   0.source_1([594,504],1,0,690)
    {
    Name = "Source1"
    Type = "6"
    Grnd = "0"
    Spec = "0"
    Cntrl = "1"
    AC = "0"
    Vm = "132.79 [kV]"
    Tc = "0.05 [sec]"
    Ph = "0.0 []"
    f = "60.0 [Hz]"
    P = "0.0 [MW]"
    Q = "0.0 [MVAR]"
    R = "1.0 [ohm]"
    Rs = "1.0 [ohm]"
    Rp = "1.0 [ohm]"
    Lp = "0.1 [H]"
    R' = "1.0 [ohm]"
    L = "0.1 [H]"
    C = "1.0 [uF]"
    L' = "0.1 [H]"
    C' = "1.0 [uF]"
    CUR = ""
    }
   -Wire-([648,396],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([540,504],0,0,-1)
    {
    Name = "Es"
    }
   0.datalabel([702,396],0,0,-1)
    {
    Name = "Is"
    }
   -Wire-([792,468],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([594,558],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([756,468],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.resistor([720,540],4,0,-1)
    {
    R = "12.5 [ohm]"
    }
   0.inductor([756,540],2,0,-1)
    {
    L = "0.0199 [H]"
    }
   -Wire-([756,540],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([594,468],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   0.voltmetergnd([846,468],0,0,170)
    {
    Name = "Emeas"
    }
   0.pgb([360,630],0,45334520,220)
    {
    Name = "Emeas"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([360,630],0,0,-1)
    {
    Name = "Emeas"
    }
   0.ground([594,558],1,0,-1)
    {
    }
   0.pgb([522,504],1,45336352,700)
    {
    Name = "Es"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([702,378],0,45338104,720)
    {
    Name = "Is"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([360,666],0,0,-1)
    {
    Name = "Vdrop"
    }
   0.pgb([360,666],0,45373184,240)
    {
    Name = "Vdrop"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([342,504],3,45374936,150)
    {
    Name = "V"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.rms-inst([504,630],0,0,230)
    {
    Type = "1"
    Ts = "0.05 [sec]"
    Scale = "1"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   0.datalabel([450,630],0,0,-1)
    {
    Name = "Emeas"
    }
   0.sumjct([108,882],0,0,260)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "-1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.abs([252,972],0,0,450)
    {
    Dim = "1"
    }
   -Wire-([216,972],0,0,-1)
    {
    Vertex="0,0;0,-90"
    }
   0.compar([288,972],0,0,460)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   0.mult([540,882],0,0,500)
    {
    }
   -Wire-([216,882],0,0,-1)
    {
    Vertex="0,0;288,0"
    }
   -Wire-([540,972],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.pgb([72,810],0,45381160,250)
    {
    Name = "Vmeas"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([72,882],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([288,882],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.datalabel([288,882],0,0,-1)
    {
    Name = "XX"
    }
   0.pgb([288,846],0,45384120,680)
    {
    Name = "XX"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Sticky-([198,72],0)
    {
    Name = ""
    Font = 1
    Bounds = 198,72,522,252
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
For regulator 1:

PT Ratio:                   120
Primary CT Rating: 100
CT Ratio: 100/0.2= 500
Bandwidth:               2.0v

Compensator Settings: 
R                              2.7v     or 2.7/0.2=13.5ohm
X                              1.6v      or 1.6/0.2= 8ohm or 0.02112H
Voltage Level        122v"
    }
   0.const([126,378],0,0,70)
    {
    Name = ""
    Value = "122"
    }
   0.datalabel([162,288],0,0,-1)
    {
    Name = "Vset"
    }
   0.const([126,396],0,0,80)
    {
    Name = ""
    Value = "2.7"
    }
   0.datalabel([162,306],0,0,-1)
    {
    Name = "Rset"
    }
   0.const([126,414],0,0,90)
    {
    Name = ""
    Value = "1.6"
    }
   0.datalabel([162,324],0,0,-1)
    {
    Name = "Xset"
    }
   0.div([450,504],0,0,410)
    {
    }
   0.div([612,396],0,0,400)
    {
    }
   0.const([414,540],0,0,180)
    {
    Name = ""
    Value = "120"
    }
   0.const([576,432],0,0,120)
    {
    Name = ""
    Value = "500"
    }
   0.voltmeter([792,504],1,0,190)
    {
    Name = "Vdrop"
    }
   -Wire-([756,504],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([720,396],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([684,468],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([450,630],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.const([126,432],0,0,100)
    {
    Name = ""
    Value = "2.0"
    }
   0.datalabel([162,342],0,0,-1)
    {
    Name = "Bw"
    }
   0.datalabel([108,918],0,0,-1)
    {
    Name = "Vset"
    }
   0.datalabel([216,1008],0,0,-1)
    {
    Name = "Bw"
    }
   0.gain([252,1008],0,0,300)
    {
    G = "0.5"
    COM = "Gain"
    Dim = "1"
    }
   0.compar([648,882],0,0,510)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "Vlow"
    OLo = "Vmeas"
    }
   0.const([612,918],0,0,270)
    {
    Name = ""
    Value = "0"
    }
   0.datalabel([198,522],0,0,-1)
    {
    Name = "Vset"
    }
   0.sumjct([198,486],0,0,140)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "-1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.datalabel([234,486],0,0,-1)
    {
    Name = "Vlow"
    }
   0.datalabel([198,612],0,0,-1)
    {
    Name = "Vset"
    }
   0.sumjct([198,576],0,0,210)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.datalabel([234,576],0,0,-1)
    {
    Name = "Vhigh"
    }
   -Wire-([774,882],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.sumjct([810,882],0,0,560)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "-1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.div([954,882],0,0,580)
    {
    }
   0.mult([1296,918],0,0,640)
    {
    }
   0.const([1260,954],0,0,340)
    {
    Name = ""
    Value = "0.00625"
    }
   0.sumjct([1368,918],0,0,650)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.const([1332,954],0,0,350)
    {
    Name = ""
    Value = "1"
    }
   0.datalabel([1404,918],0,0,-1)
    {
    Name = "TAP"
    }
   0.datalabel([756,882],0,0,-1)
    {
    Name = "Vmeas"
    }
   0.unity([1134,918],0,0,620)
    {
    IType = "2"
    OType = "1"
    }
   0.pgb([1404,918],0,45576112,660)
    {
    Name = "TAP"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1242,864],0,45578008,670)
    {
    Name = "Ntap"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([54,882],0,0,-1)
    {
    Name = "Vmeas"
    }
   0.hardlimit([1170,918],0,0,630)
    {
    UL = "16"
    LL = "-16"
    COM = "Hard_Limit"
    }
   0.datalabel([558,630],0,0,-1)
    {
    Name = "Vmeas"
    }
   -Wire-([540,630],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([54,882],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1242,864],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.datalabel([126,90],0,0,-1)
    {
    Name = "V"
    }
   0.datalabel([126,126],0,0,-1)
    {
    Name = "I"
    }
   0.datalabel([144,162],4,0,-1)
    {
    Name = "TAP"
    }
   -ControlPanel-([630,702],0)
    {
    Name = "$(GROUP) : Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 630,702
    Extents = 0,0,144,126
    Meter(45381160)
    Meter(45578008)
    Meter(45576112)
    }
   -Wire-([126,162],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Sticky-([540,72],0)
    {
    Name = ""
    Font = 1
    Bounds = 540,72,864,252
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
For regulator 2:

PT Ratio:                   120
Primary CT Rating: 100
CT Ratio: 100/0.2= 500
Bandwidth:               2.0v

Compensator Settings: 
R                              2.5v     or 2.7/0.2=12.5ohm
X                              1.5v      or 1.6/0.2= 7.5ohm or 0.0199H
Voltage Level        124v"
    }
   -Sticky-([216,288],0)
    {
    Name = ""
    Font = 1
    Bounds = 216,288,324,324
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "Regulator 2 data"
    }
   0.const([126,288],0,0,30)
    {
    Name = ""
    Value = "124"
    }
   0.const([126,306],0,0,40)
    {
    Name = ""
    Value = "2.5"
    }
   0.const([126,324],0,0,50)
    {
    Name = ""
    Value = "1.5"
    }
   0.const([126,342],0,0,60)
    {
    Name = ""
    Value = "2.0"
    }
   -Sticky-([216,378],0)
    {
    Name = ""
    Font = 1
    Bounds = 216,378,324,414
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "Regulator 1 data"
    }
   -Sticky-([630,576],0)
    {
    Name = ""
    Font = 1
    Bounds = 630,576,846,612
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Regulator 1: 13.5ohm, 0.02122H
Regulator 2: 12.5ohm, 0.0199H"
    }
   0.datalabel([90,486],0,0,-1)
    {
    Name = "Bw"
    }
   0.datalabel([90,576],0,0,-1)
    {
    Name = "Bw"
    }
   0.gain([126,486],0,0,130)
    {
    G = "0.5"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([126,576],0,0,200)
    {
    G = "0.5"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([378,504],0,0,160)
    {
    G = "1000"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([540,396],0,0,110)
    {
    G = "1000"
    COM = "Gain"
    Dim = "1"
    }
   -Sticky-([360,396],0)
    {
    Name = ""
    Font = 1
    Bounds = 360,396,432,432
    Alignment = 0
    Style = 1
    Arrow = 10
    Color = 0,15792890
    Text = "kV,kA to V,A"
    }
   0.integral([72,972],0,0,420)
    {
    Extrn = "0"
    Reset = "0"
    Mthd = "0"
    noname5 = ""
    INTR = "0"
    INTCLR = "0"
    T = "1 [s]"
    Yo = "0.0"
    YRst = "0.0"
    YHi = "100.0"
    YLo = "-100.0"
    }
   0.const([36,1008],3,0,290)
    {
    Name = ""
    Value = "1.0"
    }
   0.compar([108,972],0,0,430)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   0.const([108,1044],3,0,310)
    {
    Name = ""
    Value = "1"
    }
   -Sticky-([54,1098],0)
    {
    Name = ""
    Font = 1
    Bounds = 54,1098,162,1152
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
No tap change during first 1s of simulation.
"
    }
   0.mult([180,882],0,0,440)
    {
    }
   -Wire-([180,918],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.integral([432,972],0,0,480)
    {
    Extrn = "0"
    Reset = "1"
    Mthd = "0"
    noname5 = ""
    INTR = "0"
    INTCLR = "0"
    T = "1 [s]"
    Yo = "0.0"
    YRst = "0.0"
    YHi = "100.0"
    YLo = "-100.0"
    }
   0.compar([468,972],0,0,490)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   0.const([468,1044],3,0,360)
    {
    Name = ""
    Value = "0.25"
    }
   -Sticky-([450,1080],0)
    {
    Name = ""
    Font = 1
    Bounds = 450,1080,558,1116
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
0.25s control Time delay.
"
    }
   -Wire-([576,882],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Sticky-([594,1134],0)
    {
    Name = ""
    Font = 1
    Bounds = 594,1134,810,1188
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
out-of-band Low gives Vlow  
out-of-band High gives Vhigh
in-band or during delay gives Vmeas.
"
    }
   -Wire-([360,972],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.sumjct([396,1044],0,0,470)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.const([360,1080],0,0,370)
    {
    Name = ""
    Value = "1.0"
    }
   -Wire-([360,972],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([432,1008],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Sticky-([306,1116],0)
    {
    Name = ""
    Font = 1
    Bounds = 306,1116,432,1170
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "Whenever the voltage goes in-band, the timer is reset."
    }
   -Wire-([702,378],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Sticky-([216,1044],0)
    {
    Name = ""
    Font = 1
    Bounds = 216,1044,306,1080
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
out-of-band?
"
    }
   0.const([612,1008],0,0,330)
    {
    Name = ""
    Value = "0.0"
    }
   0.gain([612,972],0,0,520)
    {
    G = "-1"
    COM = "Gain"
    Dim = "1"
    }
   -Wire-([576,882],0,0,-1)
    {
    Vertex="0,0;0,180"
    }
   0.compar([648,972],0,0,530)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "Vhigh"
    OLo = "Vmeas"
    }
   0.select([774,972],0,0,550)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([720,882],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.compar([648,1062],0,0,540)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   -Wire-([576,1062],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.const([612,1098],0,0,380)
    {
    Name = ""
    Value = "0.0"
    }
   -Wire-([774,1008],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([810,918],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([1206,918],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([720,1062],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([720,936],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([720,972],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.const([918,918],6,0,280)
    {
    Name = ""
    Value = "0.75"
    }
   -Sticky-([1170,990],0)
    {
    Name = ""
    Font = 1
    Bounds = 1170,990,1278,1026
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Tap calculation.
"
    }
   -Plot-([882,342],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,612,468]
    Posn = [882,342]
    Icon = [-1,-1]
    Extents = 0,0,612,468
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,612,102],"y")
     {
     Options = 128
     Units = ""
     Curve(45374936,"V",0,,,)
     }
    Graph([0,102],[0,0,612,101],"y")
     {
     Options = 0
     Units = ""
     Curve(45576112,"TAP",0,,,)
     Curve(45578008,"Ntap",0,,,)
     }
    Graph([0,203],[0,0,612,101],"y")
     {
     Options = 0
     Units = ""
     Curve(45381160,"Vmeas",0,,,)
     }
    Graph([0,304],[0,0,612,101],"y")
     {
     Options = 0
     Units = ""
     Curve(45384120,"XX",0,,,)
     }
    }
   -Plot-([882,54],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,612,288]
    Posn = [882,54]
    Icon = [-1,-1]
    Extents = 0,0,612,288
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,612,113],"y")
     {
     Options = 128
     Units = ""
     Curve(45336352,"Es",0,,-2,)
     Curve(45373184,"Vdrop",0,,,)
     Curve(45334520,"Emeas",0,,-2,)
     }
    Graph([0,113],[0,0,612,112],"y")
     {
     Options = 0
     Units = ""
     Curve(45338104,"Is",0,,,)
     }
    }
   0.select([1062,918],0,0,610)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.logic_mult([1026,954],0,0,590)
    {
    Type = "1"
    Num_in = "2"
    Inv = "0"
    disnum = "0"
    INTR = "0"
    Inv1 = "0"
    Inv2 = "0"
    Inv3 = "0"
    Inv4 = "0"
    Inv5 = "0"
    Inv6 = "0"
    Inv7 = "0"
    Inv8 = "0"
    Inv9 = "0"
    }
   0.const([954,972],0,0,320)
    {
    Name = ""
    Value = "0"
    }
   0.datalabel([1026,918],0,0,-1)
    {
    Name = "TAPini"
    }
   -Wire-([990,882],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([990,882],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([378,972],0,0,-1)
    {
    Name = "clear"
    }
   0.datalabel([918,1062],0,0,-1)
    {
    Name = "clear"
    }
   0.compar([918,1062],0,0,600)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "0"
    OLo = "TAP0"
    }
   0.const([882,1098],0,0,390)
    {
    Name = ""
    Value = "0"
    }
   0.datalabel([1008,1062],0,0,-1)
    {
    Name = "TAPini"
    }
   -Wire-([990,1062],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1242,918],0,0,-1)
    {
    Name = "TAP0"
    }
   -Sticky-([900,1134],0)
    {
    Name = ""
    Font = 1
    Bounds = 900,1134,1008,1170
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Initial Tap setting.
"
    }
   0.pi_ctlr([882,882],0,0,570)
    {
    GP = "1.0"
    TI = "0.01 [s]"
    YHI = "10.0"
    YLO = "-10.0"
    YINIT = "0.0"
    Mthd = "0"
    INTR = "0"
    }
   }
  }
 Module("Reg2B")
  {
  Desc = ""
  FileDate = 1151590219
  Nodes = 
   {
   Input("V",-54,-18)
    {
    Type = Real
    }
   Input("I",-54,18)
    {
    Type = Real
    }
   Output("TAP",54,0)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-39,-39,39,39)
   Text(0,-13,"Reg2B")
   Pen(ByNode,ByNode,ByNode,V)
   Line(-54,-18,-39,-18)
   Pen(,Solid)
   Line(-39,-18,-44,-23)
   Line(-39,-18,-44,-13)
   Text(-46,-22,"V")
   Pen(,ByNode,,I)
   Line(-54,18,-39,18)
   Pen(,Solid)
   Line(-39,18,-44,13)
   Line(-39,18,-44,23)
   Text(-46,14,"I")
   Pen(,ByNode,,TAP)
   Line(54,0,39,0)
   Text(46,-4,"TAP")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.import([108,54],0,0,10)
    {
    Name = "V"
    }
   0.import([108,90],0,0,20)
    {
    Name = "I"
    }
   0.export([108,126],0,0,730)
    {
    Name = "TAP"
    }
   0.datalabel([360,468],0,0,-1)
    {
    Name = "V"
    }
   0.datalabel([522,360],0,0,-1)
    {
    Name = "I"
    }
   0.annotation([468,414],0,0,-1)
    {
    AL1 = ""
    AL2 = "PT Ratio=120"
    }
   0.annotation([630,306],0,0,-1)
    {
    AL1 = ""
    AL2 = "CT Ratio=500"
    }
   -Wire-([504,468],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.src_ccin_1([738,432],6,0,710)
    {
    Name = "Source 1"
    Cntrl = "1"
    Vm = "132.79 [kA]"
    f = "60.0 [Hz]"
    Ph = "0.0 []"
    Tc = "1.0 [sec]"
    }
   0.source_1([612,468],1,0,690)
    {
    Name = "Source1"
    Type = "6"
    Grnd = "0"
    Spec = "0"
    Cntrl = "1"
    AC = "0"
    Vm = "132.79 [kV]"
    Tc = "0.05 [sec]"
    Ph = "0.0 []"
    f = "60.0 [Hz]"
    P = "0.0 [MW]"
    Q = "0.0 [MVAR]"
    R = "1.0 [ohm]"
    Rs = "1.0 [ohm]"
    Rp = "1.0 [ohm]"
    Lp = "0.1 [H]"
    R' = "1.0 [ohm]"
    L = "0.1 [H]"
    C = "1.0 [uF]"
    L' = "0.1 [H]"
    C' = "1.0 [uF]"
    CUR = ""
    }
   -Wire-([666,360],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([558,468],0,0,-1)
    {
    Name = "Es"
    }
   0.datalabel([720,360],0,0,-1)
    {
    Name = "Is"
    }
   -Wire-([810,432],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([612,522],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([774,432],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.resistor([738,504],4,0,-1)
    {
    R = "12.5 [ohm]"
    }
   0.inductor([774,504],2,0,-1)
    {
    L = "0.0199 [H]"
    }
   -Wire-([774,504],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([612,432],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   0.voltmetergnd([864,432],0,0,170)
    {
    Name = "Emeas"
    }
   0.pgb([378,594],0,45719008,220)
    {
    Name = "Emeas"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([378,594],0,0,-1)
    {
    Name = "Emeas"
    }
   0.ground([612,522],1,0,-1)
    {
    }
   0.pgb([540,468],1,45721992,700)
    {
    Name = "Es"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([720,342],0,45723888,720)
    {
    Name = "Is"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([378,630],0,0,-1)
    {
    Name = "Vdrop"
    }
   0.pgb([378,630],0,45726336,240)
    {
    Name = "Vdrop"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([360,468],3,45728232,150)
    {
    Name = "V"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.rms-inst([522,594],0,0,230)
    {
    Type = "1"
    Ts = "0.05 [sec]"
    Scale = "1"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   0.datalabel([468,594],0,0,-1)
    {
    Name = "Emeas"
    }
   0.sumjct([126,846],0,0,260)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "-1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.abs([270,936],0,0,450)
    {
    Dim = "1"
    }
   -Wire-([234,936],0,0,-1)
    {
    Vertex="0,0;0,-90"
    }
   0.compar([306,936],0,0,460)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   0.mult([558,846],0,0,500)
    {
    }
   -Wire-([234,846],0,0,-1)
    {
    Vertex="0,0;288,0"
    }
   -Wire-([558,936],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.pgb([90,774],0,45734832,250)
    {
    Name = "Vmeas"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([90,846],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([306,846],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.datalabel([306,846],0,0,-1)
    {
    Name = "XX"
    }
   0.pgb([306,810],0,45737792,680)
    {
    Name = "XX"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Sticky-([216,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 216,36,540,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
For regulator 1:

PT Ratio:                   120
Primary CT Rating: 100
CT Ratio: 100/0.2= 500
Bandwidth:               2.0v

Compensator Settings: 
R                              2.7v     or 2.7/0.2=13.5ohm
X                              1.6v      or 1.6/0.2= 8ohm or 0.02112H
Voltage Level        122v"
    }
   0.const([144,342],0,0,70)
    {
    Name = ""
    Value = "122"
    }
   0.datalabel([180,252],0,0,-1)
    {
    Name = "Vset"
    }
   0.const([144,360],0,0,80)
    {
    Name = ""
    Value = "2.7"
    }
   0.datalabel([180,270],0,0,-1)
    {
    Name = "Rset"
    }
   0.const([144,378],0,0,90)
    {
    Name = ""
    Value = "1.6"
    }
   0.datalabel([180,288],0,0,-1)
    {
    Name = "Xset"
    }
   0.div([468,468],0,0,410)
    {
    }
   0.div([630,360],0,0,400)
    {
    }
   0.const([432,504],0,0,180)
    {
    Name = ""
    Value = "120"
    }
   0.const([594,396],0,0,120)
    {
    Name = ""
    Value = "500"
    }
   0.voltmeter([810,468],1,0,190)
    {
    Name = "Vdrop"
    }
   -Wire-([774,468],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([738,360],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([702,432],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([468,594],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.const([144,396],0,0,100)
    {
    Name = ""
    Value = "2.0"
    }
   0.datalabel([180,306],0,0,-1)
    {
    Name = "Bw"
    }
   0.datalabel([126,882],0,0,-1)
    {
    Name = "Vset"
    }
   0.datalabel([234,972],0,0,-1)
    {
    Name = "Bw"
    }
   0.gain([270,972],0,0,300)
    {
    G = "0.5"
    COM = "Gain"
    Dim = "1"
    }
   0.compar([666,846],0,0,510)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "Vlow"
    OLo = "Vmeas"
    }
   0.const([630,882],0,0,270)
    {
    Name = ""
    Value = "0"
    }
   0.datalabel([216,486],0,0,-1)
    {
    Name = "Vset"
    }
   0.sumjct([216,450],0,0,140)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "-1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.datalabel([252,450],0,0,-1)
    {
    Name = "Vlow"
    }
   0.datalabel([216,576],0,0,-1)
    {
    Name = "Vset"
    }
   0.sumjct([216,540],0,0,210)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.datalabel([252,540],0,0,-1)
    {
    Name = "Vhigh"
    }
   -Wire-([792,846],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.sumjct([828,846],0,0,560)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "-1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.div([972,846],0,0,580)
    {
    }
   0.mult([1314,882],0,0,640)
    {
    }
   0.const([1278,918],0,0,340)
    {
    Name = ""
    Value = "0.00625"
    }
   0.sumjct([1386,882],0,0,650)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.const([1350,918],0,0,350)
    {
    Name = ""
    Value = "1"
    }
   0.datalabel([1422,882],0,0,-1)
    {
    Name = "TAP"
    }
   0.datalabel([774,846],0,0,-1)
    {
    Name = "Vmeas"
    }
   0.unity([1152,882],0,0,620)
    {
    IType = "2"
    OType = "1"
    }
   0.pgb([1422,882],0,45835368,660)
    {
    Name = "TAP"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1260,828],0,45837000,670)
    {
    Name = "Ntap"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([72,846],0,0,-1)
    {
    Name = "Vmeas"
    }
   0.hardlimit([1188,882],0,0,630)
    {
    UL = "16"
    LL = "-16"
    COM = "Hard_Limit"
    }
   0.datalabel([576,594],0,0,-1)
    {
    Name = "Vmeas"
    }
   -Wire-([558,594],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([72,846],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1260,828],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.datalabel([144,54],0,0,-1)
    {
    Name = "V"
    }
   0.datalabel([144,90],0,0,-1)
    {
    Name = "I"
    }
   0.datalabel([162,126],4,0,-1)
    {
    Name = "TAP"
    }
   -ControlPanel-([648,666],0)
    {
    Name = "$(GROUP) : Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 648,666
    Extents = 0,0,144,126
    Meter(45734832)
    Meter(45837000)
    Meter(45835368)
    }
   -Wire-([144,126],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Sticky-([558,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 558,36,882,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
For regulator 2:

PT Ratio:                   120
Primary CT Rating: 100
CT Ratio: 100/0.2= 500
Bandwidth:               2.0v

Compensator Settings: 
R                              2.5v     or 2.7/0.2=12.5ohm
X                              1.5v      or 1.6/0.2= 7.5ohm or 0.0199H
Voltage Level        124v"
    }
   -Sticky-([234,252],0)
    {
    Name = ""
    Font = 1
    Bounds = 234,252,342,288
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "Regulator 2 data"
    }
   0.const([144,252],0,0,30)
    {
    Name = ""
    Value = "124"
    }
   0.const([144,270],0,0,40)
    {
    Name = ""
    Value = "2.5"
    }
   0.const([144,288],0,0,50)
    {
    Name = ""
    Value = "1.5"
    }
   0.const([144,306],0,0,60)
    {
    Name = ""
    Value = "2.0"
    }
   -Sticky-([234,342],0)
    {
    Name = ""
    Font = 1
    Bounds = 234,342,342,378
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "Regulator 1 data"
    }
   -Sticky-([648,540],0)
    {
    Name = ""
    Font = 1
    Bounds = 648,540,864,576
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Regulator 1: 13.5ohm, 0.02122H
Regulator 2: 12.5ohm, 0.0199H"
    }
   0.datalabel([108,450],0,0,-1)
    {
    Name = "Bw"
    }
   0.datalabel([108,540],0,0,-1)
    {
    Name = "Bw"
    }
   0.gain([144,450],0,0,130)
    {
    G = "0.5"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([144,540],0,0,200)
    {
    G = "0.5"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([396,468],0,0,160)
    {
    G = "1000"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([558,360],0,0,110)
    {
    G = "1000"
    COM = "Gain"
    Dim = "1"
    }
   -Sticky-([378,360],0)
    {
    Name = ""
    Font = 1
    Bounds = 378,360,450,396
    Alignment = 0
    Style = 1
    Arrow = 10
    Color = 0,15792890
    Text = "kV,kA to V,A"
    }
   0.integral([90,936],0,0,420)
    {
    Extrn = "0"
    Reset = "0"
    Mthd = "0"
    noname5 = ""
    INTR = "0"
    INTCLR = "0"
    T = "1 [s]"
    Yo = "0.0"
    YRst = "0.0"
    YHi = "100.0"
    YLo = "-100.0"
    }
   0.const([54,972],3,0,290)
    {
    Name = ""
    Value = "1.0"
    }
   0.compar([126,936],0,0,430)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   0.const([126,1008],3,0,310)
    {
    Name = ""
    Value = "1"
    }
   -Sticky-([72,1062],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,1062,180,1116
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
No tap change during first 1s of simulation.
"
    }
   0.mult([198,846],0,0,440)
    {
    }
   -Wire-([198,882],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.integral([450,936],0,0,480)
    {
    Extrn = "0"
    Reset = "1"
    Mthd = "0"
    noname5 = ""
    INTR = "0"
    INTCLR = "0"
    T = "1 [s]"
    Yo = "0.0"
    YRst = "0.0"
    YHi = "100.0"
    YLo = "-100.0"
    }
   0.compar([486,936],0,0,490)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   0.const([486,1008],3,0,360)
    {
    Name = ""
    Value = "0.25"
    }
   -Sticky-([468,1044],0)
    {
    Name = ""
    Font = 1
    Bounds = 468,1044,576,1080
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
0.25s control Time delay.
"
    }
   -Wire-([594,846],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Sticky-([612,1098],0)
    {
    Name = ""
    Font = 1
    Bounds = 612,1098,828,1152
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
out-of-band Low gives Vlow  
out-of-band High gives Vhigh
in-band or during delay gives Vmeas.
"
    }
   -Wire-([378,936],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.sumjct([414,1008],0,0,470)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.const([378,1044],0,0,370)
    {
    Name = ""
    Value = "1.0"
    }
   -Wire-([378,936],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([450,972],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Sticky-([324,1080],0)
    {
    Name = ""
    Font = 1
    Bounds = 324,1080,450,1134
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "Whenever the voltage goes in-band, the timer is reset."
    }
   -Wire-([720,342],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Sticky-([234,1008],0)
    {
    Name = ""
    Font = 1
    Bounds = 234,1008,324,1044
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
out-of-band?
"
    }
   0.const([630,972],0,0,330)
    {
    Name = ""
    Value = "0.0"
    }
   0.gain([630,936],0,0,520)
    {
    G = "-1"
    COM = "Gain"
    Dim = "1"
    }
   -Wire-([594,846],0,0,-1)
    {
    Vertex="0,0;0,180"
    }
   0.compar([666,936],0,0,530)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "Vhigh"
    OLo = "Vmeas"
    }
   0.select([792,936],0,0,550)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([738,846],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.compar([666,1026],0,0,540)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   -Wire-([594,1026],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.const([630,1062],0,0,380)
    {
    Name = ""
    Value = "0.0"
    }
   -Wire-([792,972],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([828,882],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([1224,882],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([738,1026],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([738,900],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([738,936],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.const([936,882],6,0,280)
    {
    Name = ""
    Value = "0.75"
    }
   -Sticky-([1188,954],0)
    {
    Name = ""
    Font = 1
    Bounds = 1188,954,1296,990
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Tap calculation.
"
    }
   -Plot-([900,306],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,612,468]
    Posn = [900,306]
    Icon = [-1,-1]
    Extents = 0,0,612,468
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,612,102],"y")
     {
     Options = 128
     Units = ""
     Curve(45728232,"V",0,,,)
     }
    Graph([0,102],[0,0,612,101],"y")
     {
     Options = 0
     Units = ""
     Curve(45835368,"TAP",0,,,)
     Curve(45837000,"Ntap",0,,,)
     }
    Graph([0,203],[0,0,612,101],"y")
     {
     Options = 0
     Units = ""
     Curve(45734832,"Vmeas",0,,,)
     }
    Graph([0,304],[0,0,612,101],"y")
     {
     Options = 0
     Units = ""
     Curve(45737792,"XX",0,,,)
     }
    }
   -Plot-([900,18],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,612,288]
    Posn = [900,18]
    Icon = [-1,-1]
    Extents = 0,0,612,288
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,612,113],"y")
     {
     Options = 128
     Units = ""
     Curve(45721992,"Es",0,,-2,)
     Curve(45726336,"Vdrop",0,,,)
     Curve(45719008,"Emeas",0,,-2,)
     }
    Graph([0,113],[0,0,612,112],"y")
     {
     Options = 0
     Units = ""
     Curve(45723888,"Is",0,,,)
     }
    }
   0.select([1080,882],0,0,610)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.logic_mult([1044,918],0,0,590)
    {
    Type = "1"
    Num_in = "2"
    Inv = "0"
    disnum = "0"
    INTR = "0"
    Inv1 = "0"
    Inv2 = "0"
    Inv3 = "0"
    Inv4 = "0"
    Inv5 = "0"
    Inv6 = "0"
    Inv7 = "0"
    Inv8 = "0"
    Inv9 = "0"
    }
   0.const([972,936],0,0,320)
    {
    Name = ""
    Value = "0"
    }
   0.datalabel([1044,882],0,0,-1)
    {
    Name = "TAPini"
    }
   -Wire-([1008,846],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([1008,846],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([396,936],0,0,-1)
    {
    Name = "clear"
    }
   0.datalabel([936,1026],0,0,-1)
    {
    Name = "clear"
    }
   0.compar([936,1026],0,0,600)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "0"
    OLo = "TAP0"
    }
   0.const([900,1062],0,0,390)
    {
    Name = ""
    Value = "0"
    }
   0.datalabel([1026,1026],0,0,-1)
    {
    Name = "TAPini"
    }
   -Wire-([1008,1026],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1260,882],0,0,-1)
    {
    Name = "TAP0"
    }
   -Sticky-([918,1098],0)
    {
    Name = ""
    Font = 1
    Bounds = 918,1098,1026,1134
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Initial Tap setting.
"
    }
   0.pi_ctlr([900,846],0,0,570)
    {
    GP = "1.0"
    TI = "0.01 [s]"
    YHI = "10.0"
    YLO = "-10.0"
    YINIT = "0.0"
    Mthd = "0"
    INTR = "0"
    }
   }
  }
 Module("Reg2A")
  {
  Desc = ""
  FileDate = 1151590219
  Nodes = 
   {
   Input("V",-54,-18)
    {
    Type = Real
    }
   Input("I",-54,18)
    {
    Type = Real
    }
   Output("TAP",54,0)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-39,-39,39,39)
   Text(0,-13,"Reg2A")
   Pen(ByNode,ByNode,ByNode,V)
   Line(-54,-18,-39,-18)
   Pen(,Solid)
   Line(-39,-18,-44,-23)
   Line(-39,-18,-44,-13)
   Text(-46,-22,"V")
   Pen(,ByNode,,I)
   Line(-54,18,-39,18)
   Pen(,Solid)
   Line(-39,18,-44,13)
   Line(-39,18,-44,23)
   Text(-46,14,"I")
   Pen(,ByNode,,TAP)
   Line(54,0,39,0)
   Text(46,-4,"TAP")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.import([108,90],0,0,10)
    {
    Name = "V"
    }
   0.import([108,126],0,0,20)
    {
    Name = "I"
    }
   0.export([108,162],0,0,730)
    {
    Name = "TAP"
    }
   0.datalabel([360,504],0,0,-1)
    {
    Name = "V"
    }
   0.datalabel([522,396],0,0,-1)
    {
    Name = "I"
    }
   0.annotation([468,450],0,0,-1)
    {
    AL1 = ""
    AL2 = "PT Ratio=120"
    }
   0.annotation([630,342],0,0,-1)
    {
    AL1 = ""
    AL2 = "CT Ratio=500"
    }
   -Wire-([504,504],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.src_ccin_1([738,468],6,0,710)
    {
    Name = "Source 1"
    Cntrl = "1"
    Vm = "132.79 [kA]"
    f = "60.0 [Hz]"
    Ph = "0.0 []"
    Tc = "1.0 [sec]"
    }
   0.source_1([612,504],1,0,690)
    {
    Name = "Source1"
    Type = "6"
    Grnd = "0"
    Spec = "0"
    Cntrl = "1"
    AC = "0"
    Vm = "132.79 [kV]"
    Tc = "0.05 [sec]"
    Ph = "0.0 []"
    f = "60.0 [Hz]"
    P = "0.0 [MW]"
    Q = "0.0 [MVAR]"
    R = "1.0 [ohm]"
    Rs = "1.0 [ohm]"
    Rp = "1.0 [ohm]"
    Lp = "0.1 [H]"
    R' = "1.0 [ohm]"
    L = "0.1 [H]"
    C = "1.0 [uF]"
    L' = "0.1 [H]"
    C' = "1.0 [uF]"
    CUR = ""
    }
   -Wire-([666,396],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([558,504],0,0,-1)
    {
    Name = "Es"
    }
   0.datalabel([720,396],0,0,-1)
    {
    Name = "Is"
    }
   -Wire-([810,468],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([612,558],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([774,468],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.resistor([738,540],4,0,-1)
    {
    R = "12.5 [ohm]"
    }
   0.inductor([774,540],2,0,-1)
    {
    L = "0.0199 [H]"
    }
   -Wire-([774,540],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([612,468],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   0.voltmetergnd([864,468],0,0,170)
    {
    Name = "Emeas"
    }
   0.pgb([378,630],0,45829400,220)
    {
    Name = "Emeas"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([378,630],0,0,-1)
    {
    Name = "Emeas"
    }
   0.ground([612,558],1,0,-1)
    {
    }
   0.pgb([540,504],1,45902792,700)
    {
    Name = "Es"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([720,378],0,45904688,720)
    {
    Name = "Is"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([378,666],0,0,-1)
    {
    Name = "Vdrop"
    }
   0.pgb([378,666],0,45907136,240)
    {
    Name = "Vdrop"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([360,504],3,45909032,150)
    {
    Name = "V"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.rms-inst([522,630],0,0,230)
    {
    Type = "1"
    Ts = "0.05 [sec]"
    Scale = "1"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   0.datalabel([468,630],0,0,-1)
    {
    Name = "Emeas"
    }
   0.sumjct([126,882],0,0,260)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "-1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.abs([270,972],0,0,450)
    {
    Dim = "1"
    }
   -Wire-([234,972],0,0,-1)
    {
    Vertex="0,0;0,-90"
    }
   0.compar([306,972],0,0,460)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   0.mult([558,882],0,0,500)
    {
    }
   -Wire-([234,882],0,0,-1)
    {
    Vertex="0,0;288,0"
    }
   -Wire-([558,972],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.pgb([90,810],0,45917680,250)
    {
    Name = "Vmeas"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([90,882],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([306,882],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.datalabel([306,882],0,0,-1)
    {
    Name = "XX"
    }
   0.pgb([306,846],0,45920640,680)
    {
    Name = "XX"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Sticky-([216,72],0)
    {
    Name = ""
    Font = 1
    Bounds = 216,72,540,252
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
For regulator 1:

PT Ratio:                   120
Primary CT Rating: 100
CT Ratio: 100/0.2= 500
Bandwidth:               2.0v

Compensator Settings: 
R                              2.7v     or 2.7/0.2=13.5ohm
X                              1.6v      or 1.6/0.2= 8ohm or 0.02112H
Voltage Level        122v"
    }
   0.const([144,378],0,0,70)
    {
    Name = ""
    Value = "122"
    }
   0.datalabel([180,288],0,0,-1)
    {
    Name = "Vset"
    }
   0.const([144,396],0,0,80)
    {
    Name = ""
    Value = "2.7"
    }
   0.datalabel([180,306],0,0,-1)
    {
    Name = "Rset"
    }
   0.const([144,414],0,0,90)
    {
    Name = ""
    Value = "1.6"
    }
   0.datalabel([180,324],0,0,-1)
    {
    Name = "Xset"
    }
   0.div([468,504],0,0,410)
    {
    }
   0.div([630,396],0,0,400)
    {
    }
   0.const([432,540],0,0,180)
    {
    Name = ""
    Value = "120"
    }
   0.const([594,432],0,0,120)
    {
    Name = ""
    Value = "500"
    }
   0.voltmeter([810,504],1,0,190)
    {
    Name = "Vdrop"
    }
   -Wire-([774,504],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([738,396],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([702,468],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([468,630],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.const([144,432],0,0,100)
    {
    Name = ""
    Value = "2.0"
    }
   0.datalabel([180,342],0,0,-1)
    {
    Name = "Bw"
    }
   0.datalabel([126,918],0,0,-1)
    {
    Name = "Vset"
    }
   0.datalabel([234,1008],0,0,-1)
    {
    Name = "Bw"
    }
   0.gain([270,1008],0,0,300)
    {
    G = "0.5"
    COM = "Gain"
    Dim = "1"
    }
   0.compar([666,882],0,0,510)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "Vlow"
    OLo = "Vmeas"
    }
   0.const([630,918],0,0,270)
    {
    Name = ""
    Value = "0"
    }
   0.datalabel([216,522],0,0,-1)
    {
    Name = "Vset"
    }
   0.sumjct([216,486],0,0,140)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "-1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.datalabel([252,486],0,0,-1)
    {
    Name = "Vlow"
    }
   0.datalabel([216,612],0,0,-1)
    {
    Name = "Vset"
    }
   0.sumjct([216,576],0,0,210)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.datalabel([252,576],0,0,-1)
    {
    Name = "Vhigh"
    }
   -Wire-([792,882],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.sumjct([828,882],0,0,560)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "-1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.div([972,882],0,0,580)
    {
    }
   0.mult([1314,918],0,0,640)
    {
    }
   0.const([1278,954],0,0,340)
    {
    Name = ""
    Value = "0.00625"
    }
   0.sumjct([1386,918],0,0,650)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.const([1350,954],0,0,350)
    {
    Name = ""
    Value = "1"
    }
   0.datalabel([1422,918],0,0,-1)
    {
    Name = "TAP"
    }
   0.datalabel([774,882],0,0,-1)
    {
    Name = "Vmeas"
    }
   0.unity([1152,918],0,0,620)
    {
    IType = "2"
    OType = "1"
    }
   0.pgb([1422,918],0,45986472,660)
    {
    Name = "TAP"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1260,864],0,45988104,670)
    {
    Name = "Ntap"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([72,882],0,0,-1)
    {
    Name = "Vmeas"
    }
   0.hardlimit([1188,918],0,0,630)
    {
    UL = "16"
    LL = "-16"
    COM = "Hard_Limit"
    }
   0.datalabel([576,630],0,0,-1)
    {
    Name = "Vmeas"
    }
   -Wire-([558,630],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([72,882],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1260,864],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.datalabel([144,90],0,0,-1)
    {
    Name = "V"
    }
   0.datalabel([144,126],0,0,-1)
    {
    Name = "I"
    }
   0.datalabel([162,162],4,0,-1)
    {
    Name = "TAP"
    }
   -ControlPanel-([648,702],0)
    {
    Name = "$(GROUP) : Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 648,702
    Extents = 0,0,144,126
    Meter(45917680)
    Meter(45988104)
    Meter(45986472)
    }
   -Wire-([144,162],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Sticky-([558,72],0)
    {
    Name = ""
    Font = 1
    Bounds = 558,72,882,252
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
For regulator 2:

PT Ratio:                   120
Primary CT Rating: 100
CT Ratio: 100/0.2= 500
Bandwidth:               2.0v

Compensator Settings: 
R                              2.5v     or 2.7/0.2=12.5ohm
X                              1.5v      or 1.6/0.2= 7.5ohm or 0.0199H
Voltage Level        124v"
    }
   -Sticky-([234,288],0)
    {
    Name = ""
    Font = 1
    Bounds = 234,288,342,324
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "Regulator 2 data"
    }
   0.const([144,288],0,0,30)
    {
    Name = ""
    Value = "124"
    }
   0.const([144,306],0,0,40)
    {
    Name = ""
    Value = "2.5"
    }
   0.const([144,324],0,0,50)
    {
    Name = ""
    Value = "1.5"
    }
   0.const([144,342],0,0,60)
    {
    Name = ""
    Value = "2.0"
    }
   -Sticky-([234,378],0)
    {
    Name = ""
    Font = 1
    Bounds = 234,378,342,414
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "Regulator 1 data"
    }
   -Sticky-([648,576],0)
    {
    Name = ""
    Font = 1
    Bounds = 648,576,864,612
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Regulator 1: 13.5ohm, 0.02122H
Regulator 2: 12.5ohm, 0.0199H"
    }
   0.datalabel([108,486],0,0,-1)
    {
    Name = "Bw"
    }
   0.datalabel([108,576],0,0,-1)
    {
    Name = "Bw"
    }
   0.gain([144,486],0,0,130)
    {
    G = "0.5"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([144,576],0,0,200)
    {
    G = "0.5"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([396,504],0,0,160)
    {
    G = "1000"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([558,396],0,0,110)
    {
    G = "1000"
    COM = "Gain"
    Dim = "1"
    }
   -Sticky-([378,396],0)
    {
    Name = ""
    Font = 1
    Bounds = 378,396,450,432
    Alignment = 0
    Style = 1
    Arrow = 10
    Color = 0,15792890
    Text = "kV,kA to V,A"
    }
   0.integral([90,972],0,0,420)
    {
    Extrn = "0"
    Reset = "0"
    Mthd = "0"
    noname5 = ""
    INTR = "0"
    INTCLR = "0"
    T = "1 [s]"
    Yo = "0.0"
    YRst = "0.0"
    YHi = "100.0"
    YLo = "-100.0"
    }
   0.const([54,1008],3,0,290)
    {
    Name = ""
    Value = "1.0"
    }
   0.compar([126,972],0,0,430)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   0.const([126,1044],3,0,310)
    {
    Name = ""
    Value = "1"
    }
   -Sticky-([72,1098],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,1098,180,1152
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
No tap change during first 1s of simulation.
"
    }
   0.mult([198,882],0,0,440)
    {
    }
   -Wire-([198,918],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.integral([450,972],0,0,480)
    {
    Extrn = "0"
    Reset = "1"
    Mthd = "0"
    noname5 = ""
    INTR = "0"
    INTCLR = "0"
    T = "1 [s]"
    Yo = "0.0"
    YRst = "0.0"
    YHi = "100.0"
    YLo = "-100.0"
    }
   0.compar([486,972],0,0,490)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   0.const([486,1044],3,0,360)
    {
    Name = ""
    Value = "0.25"
    }
   -Sticky-([468,1080],0)
    {
    Name = ""
    Font = 1
    Bounds = 468,1080,576,1116
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
0.25s control Time delay.
"
    }
   -Wire-([594,882],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Sticky-([612,1134],0)
    {
    Name = ""
    Font = 1
    Bounds = 612,1134,828,1188
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
out-of-band Low gives Vlow  
out-of-band High gives Vhigh
in-band or during delay gives Vmeas.
"
    }
   -Wire-([378,972],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.sumjct([414,1044],0,0,470)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.const([378,1080],0,0,370)
    {
    Name = ""
    Value = "1.0"
    }
   -Wire-([378,972],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([450,1008],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Sticky-([324,1116],0)
    {
    Name = ""
    Font = 1
    Bounds = 324,1116,450,1170
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "Whenever the voltage goes in-band, the timer is reset."
    }
   -Wire-([720,378],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Sticky-([234,1044],0)
    {
    Name = ""
    Font = 1
    Bounds = 234,1044,324,1080
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
out-of-band?
"
    }
   0.const([630,1008],0,0,330)
    {
    Name = ""
    Value = "0.0"
    }
   0.gain([630,972],0,0,520)
    {
    G = "-1"
    COM = "Gain"
    Dim = "1"
    }
   -Wire-([594,882],0,0,-1)
    {
    Vertex="0,0;0,180"
    }
   0.compar([666,972],0,0,530)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "Vhigh"
    OLo = "Vmeas"
    }
   0.select([792,972],0,0,550)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([738,882],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.compar([666,1062],0,0,540)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   -Wire-([594,1062],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.const([630,1098],0,0,380)
    {
    Name = ""
    Value = "0.0"
    }
   -Wire-([792,1008],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([828,918],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([1224,918],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([738,1062],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([738,936],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([738,972],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.const([936,918],6,0,280)
    {
    Name = ""
    Value = "0.75"
    }
   -Sticky-([1188,990],0)
    {
    Name = ""
    Font = 1
    Bounds = 1188,990,1296,1026
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Tap calculation.
"
    }
   -Plot-([900,342],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,612,468]
    Posn = [900,342]
    Icon = [-1,-1]
    Extents = 0,0,612,468
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,612,102],"y")
     {
     Options = 128
     Units = ""
     Curve(45909032,"V",0,,,)
     }
    Graph([0,102],[0,0,612,101],"y")
     {
     Options = 0
     Units = ""
     Curve(45986472,"TAP",0,,,)
     Curve(45988104,"Ntap",0,,,)
     }
    Graph([0,203],[0,0,612,101],"y")
     {
     Options = 0
     Units = ""
     Curve(45917680,"Vmeas",0,,,)
     }
    Graph([0,304],[0,0,612,101],"y")
     {
     Options = 0
     Units = ""
     Curve(45920640,"XX",0,,,)
     }
    }
   -Plot-([900,54],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,612,288]
    Posn = [900,54]
    Icon = [-1,-1]
    Extents = 0,0,612,288
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,612,113],"y")
     {
     Options = 128
     Units = ""
     Curve(45902792,"Es",0,,-2,)
     Curve(45907136,"Vdrop",0,,,)
     Curve(45829400,"Emeas",0,,-2,)
     }
    Graph([0,113],[0,0,612,112],"y")
     {
     Options = 0
     Units = ""
     Curve(45904688,"Is",0,,,)
     }
    }
   0.select([1080,918],0,0,610)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.logic_mult([1044,954],0,0,590)
    {
    Type = "1"
    Num_in = "2"
    Inv = "0"
    disnum = "0"
    INTR = "0"
    Inv1 = "0"
    Inv2 = "0"
    Inv3 = "0"
    Inv4 = "0"
    Inv5 = "0"
    Inv6 = "0"
    Inv7 = "0"
    Inv8 = "0"
    Inv9 = "0"
    }
   0.const([972,972],0,0,320)
    {
    Name = ""
    Value = "0"
    }
   0.datalabel([1044,918],0,0,-1)
    {
    Name = "TAPini"
    }
   -Wire-([1008,882],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([1008,882],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([396,972],0,0,-1)
    {
    Name = "clear"
    }
   0.datalabel([936,1062],0,0,-1)
    {
    Name = "clear"
    }
   0.compar([936,1062],0,0,600)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "0"
    OLo = "TAP0"
    }
   0.const([900,1098],0,0,390)
    {
    Name = ""
    Value = "0"
    }
   0.datalabel([1026,1062],0,0,-1)
    {
    Name = "TAPini"
    }
   -Wire-([1008,1062],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1260,918],0,0,-1)
    {
    Name = "TAP0"
    }
   -Sticky-([918,1134],0)
    {
    Name = ""
    Font = 1
    Bounds = 918,1134,1026,1170
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Initial Tap setting.
"
    }
   0.pi_ctlr([900,882],0,0,570)
    {
    GP = "1.0"
    TI = "0.01 [s]"
    YHI = "10.0"
    YLO = "-10.0"
    YINIT = "0.0"
    Mthd = "0"
    INTR = "0"
    }
   }
  }
 Module("Reg1C")
  {
  Desc = ""
  FileDate = 1151590216
  Nodes = 
   {
   Input("V",-54,-18)
    {
    Type = Real
    }
   Input("I",-54,18)
    {
    Type = Real
    }
   Output("TAP",54,0)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-39,-39,39,39)
   Text(0,-13,"Reg1C")
   Pen(ByNode,ByNode,ByNode,V)
   Line(-54,-18,-39,-18)
   Pen(,Solid)
   Line(-39,-18,-44,-23)
   Line(-39,-18,-44,-13)
   Text(-46,-22,"V")
   Pen(,ByNode,,I)
   Line(-54,18,-39,18)
   Pen(,Solid)
   Line(-39,18,-44,13)
   Line(-39,18,-44,23)
   Text(-46,14,"I")
   Pen(,ByNode,,TAP)
   Line(54,0,39,0)
   Text(46,-4,"TAP")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.import([108,72],0,0,10)
    {
    Name = "V"
    }
   0.import([108,108],0,0,20)
    {
    Name = "I"
    }
   0.export([108,144],0,0,730)
    {
    Name = "TAP"
    }
   0.datalabel([360,486],0,0,-1)
    {
    Name = "V"
    }
   0.datalabel([522,378],0,0,-1)
    {
    Name = "I"
    }
   0.annotation([468,432],0,0,-1)
    {
    AL1 = ""
    AL2 = "PT Ratio=120"
    }
   0.annotation([630,324],0,0,-1)
    {
    AL1 = ""
    AL2 = "CT Ratio=500"
    }
   -Wire-([504,486],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.src_ccin_1([738,450],6,0,710)
    {
    Name = "Source 1"
    Cntrl = "1"
    Vm = "132.79 [kA]"
    f = "60.0 [Hz]"
    Ph = "0.0 []"
    Tc = "1.0 [sec]"
    }
   0.source_1([612,486],1,0,690)
    {
    Name = "Source1"
    Type = "6"
    Grnd = "0"
    Spec = "0"
    Cntrl = "1"
    AC = "0"
    Vm = "132.79 [kV]"
    Tc = "0.05 [sec]"
    Ph = "0.0 []"
    f = "60.0 [Hz]"
    P = "0.0 [MW]"
    Q = "0.0 [MVAR]"
    R = "1.0 [ohm]"
    Rs = "1.0 [ohm]"
    Rp = "1.0 [ohm]"
    Lp = "0.1 [H]"
    R' = "1.0 [ohm]"
    L = "0.1 [H]"
    C = "1.0 [uF]"
    L' = "0.1 [H]"
    C' = "1.0 [uF]"
    CUR = ""
    }
   -Wire-([666,378],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([558,486],0,0,-1)
    {
    Name = "Es"
    }
   0.datalabel([720,378],0,0,-1)
    {
    Name = "Is"
    }
   -Wire-([810,450],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([612,540],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([774,450],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.resistor([738,522],4,0,-1)
    {
    R = "13.5 [ohm]"
    }
   0.inductor([774,522],2,0,-1)
    {
    L = "0.02122 [H]"
    }
   -Wire-([774,522],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([612,450],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   0.voltmetergnd([864,450],0,0,170)
    {
    Name = "Emeas"
    }
   0.pgb([378,612],0,46103448,220)
    {
    Name = "Emeas"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([378,612],0,0,-1)
    {
    Name = "Emeas"
    }
   0.ground([612,540],1,0,-1)
    {
    }
   0.pgb([540,486],1,46106432,700)
    {
    Name = "Es"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([720,360],0,46108328,720)
    {
    Name = "Is"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([378,648],0,0,-1)
    {
    Name = "Vdrop"
    }
   0.pgb([378,648],0,46110776,240)
    {
    Name = "Vdrop"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([360,486],3,46112672,150)
    {
    Name = "V"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.rms-inst([522,612],0,0,230)
    {
    Type = "1"
    Ts = "0.05 [sec]"
    Scale = "1"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   0.datalabel([468,612],0,0,-1)
    {
    Name = "Emeas"
    }
   0.sumjct([126,864],0,0,260)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "-1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.abs([270,954],0,0,450)
    {
    Dim = "1"
    }
   -Wire-([234,954],0,0,-1)
    {
    Vertex="0,0;0,-90"
    }
   0.compar([306,954],0,0,460)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   0.mult([558,864],0,0,500)
    {
    }
   -Wire-([234,864],0,0,-1)
    {
    Vertex="0,0;288,0"
    }
   -Wire-([558,954],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.pgb([90,792],0,46124408,250)
    {
    Name = "Vmeas"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([90,864],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([306,864],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.datalabel([306,864],0,0,-1)
    {
    Name = "XX"
    }
   0.pgb([306,828],0,46127368,680)
    {
    Name = "XX"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Sticky-([216,54],0)
    {
    Name = ""
    Font = 1
    Bounds = 216,54,540,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
For regulator 1:

PT Ratio:                   120
Primary CT Rating: 100
CT Ratio: 100/0.2= 500
Bandwidth:               2.0v

Compensator Settings: 
R                              2.7v     or 2.7/0.2=13.5ohm
X                              1.6v      or 1.6/0.2= 8ohm or 0.02112H
Voltage Level        122v"
    }
   0.const([144,360],0,0,70)
    {
    Name = ""
    Value = "122"
    }
   0.datalabel([180,360],0,0,-1)
    {
    Name = "Vset"
    }
   0.const([144,378],0,0,80)
    {
    Name = ""
    Value = "2.7"
    }
   0.datalabel([180,378],0,0,-1)
    {
    Name = "Rset"
    }
   0.const([144,396],0,0,90)
    {
    Name = ""
    Value = "1.6"
    }
   0.datalabel([180,396],0,0,-1)
    {
    Name = "Xset"
    }
   0.div([468,486],0,0,410)
    {
    }
   0.div([630,378],0,0,400)
    {
    }
   0.const([432,522],0,0,180)
    {
    Name = ""
    Value = "120"
    }
   0.const([594,414],0,0,120)
    {
    Name = ""
    Value = "500"
    }
   0.voltmeter([810,486],1,0,190)
    {
    Name = "Vdrop"
    }
   -Wire-([774,486],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([738,378],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([702,450],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([468,612],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.const([144,414],0,0,100)
    {
    Name = ""
    Value = "2.0"
    }
   0.datalabel([180,414],0,0,-1)
    {
    Name = "Bw"
    }
   0.datalabel([126,900],0,0,-1)
    {
    Name = "Vset"
    }
   0.datalabel([234,990],0,0,-1)
    {
    Name = "Bw"
    }
   0.gain([270,990],0,0,300)
    {
    G = "0.5"
    COM = "Gain"
    Dim = "1"
    }
   0.compar([666,864],0,0,510)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "Vlow"
    OLo = "Vmeas"
    }
   0.const([630,900],0,0,270)
    {
    Name = ""
    Value = "0"
    }
   0.datalabel([216,504],0,0,-1)
    {
    Name = "Vset"
    }
   0.sumjct([216,468],0,0,140)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "-1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.datalabel([252,468],0,0,-1)
    {
    Name = "Vlow"
    }
   0.datalabel([216,594],0,0,-1)
    {
    Name = "Vset"
    }
   0.sumjct([216,558],0,0,210)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.datalabel([252,558],0,0,-1)
    {
    Name = "Vhigh"
    }
   -Wire-([792,864],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.sumjct([828,864],0,0,560)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "-1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.div([972,864],0,0,580)
    {
    }
   0.mult([1314,900],0,0,640)
    {
    }
   0.const([1278,936],0,0,340)
    {
    Name = ""
    Value = "0.00625"
    }
   0.sumjct([1386,900],0,0,650)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.const([1350,936],0,0,350)
    {
    Name = ""
    Value = "1"
    }
   0.datalabel([1422,900],0,0,-1)
    {
    Name = "TAP"
    }
   0.datalabel([774,864],0,0,-1)
    {
    Name = "Vmeas"
    }
   0.unity([1152,900],0,0,620)
    {
    IType = "2"
    OType = "1"
    }
   0.pgb([1422,900],0,46182960,660)
    {
    Name = "TAP"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1260,846],0,46184592,670)
    {
    Name = "Ntap"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([72,864],0,0,-1)
    {
    Name = "Vmeas"
    }
   0.hardlimit([1188,900],0,0,630)
    {
    UL = "16"
    LL = "-16"
    COM = "Hard_Limit"
    }
   0.datalabel([576,612],0,0,-1)
    {
    Name = "Vmeas"
    }
   -Wire-([558,612],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([72,864],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1260,846],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.datalabel([144,72],0,0,-1)
    {
    Name = "V"
    }
   0.datalabel([144,108],0,0,-1)
    {
    Name = "I"
    }
   0.datalabel([162,144],4,0,-1)
    {
    Name = "TAP"
    }
   -ControlPanel-([648,684],0)
    {
    Name = "$(GROUP) : Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 648,684
    Extents = 0,0,144,126
    Meter(46124408)
    Meter(46184592)
    Meter(46182960)
    }
   -Wire-([144,144],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Sticky-([558,54],0)
    {
    Name = ""
    Font = 1
    Bounds = 558,54,882,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
For regulator 2:

PT Ratio:                   120
Primary CT Rating: 100
CT Ratio: 100/0.2= 500
Bandwidth:               2.0v

Compensator Settings: 
R                              2.5v     or 2.7/0.2=12.5ohm
X                              1.5v      or 1.6/0.2= 7.5ohm or 0.0199H
Voltage Level        124v"
    }
   -Sticky-([234,270],0)
    {
    Name = ""
    Font = 1
    Bounds = 234,270,342,306
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "Regulator 2 data"
    }
   0.const([144,270],0,0,30)
    {
    Name = ""
    Value = "124"
    }
   0.const([144,288],0,0,40)
    {
    Name = ""
    Value = "2.5"
    }
   0.const([144,306],0,0,50)
    {
    Name = ""
    Value = "1.5"
    }
   0.const([144,324],0,0,60)
    {
    Name = ""
    Value = "2.0"
    }
   -Sticky-([234,360],0)
    {
    Name = ""
    Font = 1
    Bounds = 234,360,342,396
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "Regulator 1 data"
    }
   -Sticky-([648,558],0)
    {
    Name = ""
    Font = 1
    Bounds = 648,558,864,594
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Regulator 1: 13.5ohm, 0.02122H
Regulator 2: 12.5ohm, 0.0199H"
    }
   0.datalabel([108,468],0,0,-1)
    {
    Name = "Bw"
    }
   0.datalabel([108,558],0,0,-1)
    {
    Name = "Bw"
    }
   0.gain([144,468],0,0,130)
    {
    G = "0.5"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([144,558],0,0,200)
    {
    G = "0.5"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([396,486],0,0,160)
    {
    G = "1000"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([558,378],0,0,110)
    {
    G = "1000"
    COM = "Gain"
    Dim = "1"
    }
   -Sticky-([378,378],0)
    {
    Name = ""
    Font = 1
    Bounds = 378,378,450,414
    Alignment = 0
    Style = 1
    Arrow = 10
    Color = 0,15792890
    Text = "kV,kA to V,A"
    }
   0.integral([90,954],0,0,420)
    {
    Extrn = "0"
    Reset = "0"
    Mthd = "0"
    noname5 = ""
    INTR = "0"
    INTCLR = "0"
    T = "1 [s]"
    Yo = "0.0"
    YRst = "0.0"
    YHi = "100.0"
    YLo = "-100.0"
    }
   0.const([54,990],3,0,290)
    {
    Name = ""
    Value = "1.0"
    }
   0.compar([126,954],0,0,430)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   0.const([126,1026],3,0,310)
    {
    Name = ""
    Value = "1"
    }
   -Sticky-([72,1080],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,1080,180,1134
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
No tap change during first 1s of simulation.
"
    }
   0.mult([198,864],0,0,440)
    {
    }
   -Wire-([198,900],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.integral([450,954],0,0,480)
    {
    Extrn = "0"
    Reset = "1"
    Mthd = "0"
    noname5 = ""
    INTR = "0"
    INTCLR = "0"
    T = "1 [s]"
    Yo = "0.0"
    YRst = "0.0"
    YHi = "100.0"
    YLo = "-100.0"
    }
   0.compar([486,954],0,0,490)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   0.const([486,1026],3,0,360)
    {
    Name = ""
    Value = "0.25"
    }
   -Sticky-([468,1062],0)
    {
    Name = ""
    Font = 1
    Bounds = 468,1062,576,1098
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
0.25s control Time delay.
"
    }
   -Wire-([594,864],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Sticky-([612,1116],0)
    {
    Name = ""
    Font = 1
    Bounds = 612,1116,828,1170
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
out-of-band Low gives Vlow  
out-of-band High gives Vhigh
in-band or during delay gives Vmeas.
"
    }
   -Wire-([378,954],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.sumjct([414,1026],0,0,470)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.const([378,1062],0,0,370)
    {
    Name = ""
    Value = "1.0"
    }
   -Wire-([378,954],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([450,990],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Sticky-([324,1098],0)
    {
    Name = ""
    Font = 1
    Bounds = 324,1098,450,1152
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "Whenever the voltage goes in-band, the timer is reset."
    }
   -Wire-([720,360],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Sticky-([234,1026],0)
    {
    Name = ""
    Font = 1
    Bounds = 234,1026,324,1062
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
out-of-band?
"
    }
   0.const([630,990],0,0,330)
    {
    Name = ""
    Value = "0.0"
    }
   0.gain([630,954],0,0,520)
    {
    G = "-1"
    COM = "Gain"
    Dim = "1"
    }
   -Wire-([594,864],0,0,-1)
    {
    Vertex="0,0;0,180"
    }
   0.compar([666,954],0,0,530)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "Vhigh"
    OLo = "Vmeas"
    }
   0.select([792,954],0,0,550)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([738,864],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.compar([666,1044],0,0,540)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   -Wire-([594,1044],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.const([630,1080],0,0,380)
    {
    Name = ""
    Value = "0.0"
    }
   -Wire-([792,990],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([828,900],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([1224,900],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([738,1044],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([738,918],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([738,954],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.const([936,900],6,0,280)
    {
    Name = ""
    Value = "0.75"
    }
   -Sticky-([1188,972],0)
    {
    Name = ""
    Font = 1
    Bounds = 1188,972,1296,1008
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Tap calculation.
"
    }
   -Plot-([900,324],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,612,468]
    Posn = [900,324]
    Icon = [-1,-1]
    Extents = 0,0,612,468
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,612,102],"y")
     {
     Options = 128
     Units = ""
     Curve(46112672,"V",0,,,)
     }
    Graph([0,102],[0,0,612,101],"y")
     {
     Options = 0
     Units = ""
     Curve(46182960,"TAP",0,,,)
     Curve(46184592,"Ntap",0,,,)
     }
    Graph([0,203],[0,0,612,101],"y")
     {
     Options = 0
     Units = ""
     Curve(46124408,"Vmeas",0,,,)
     }
    Graph([0,304],[0,0,612,101],"y")
     {
     Options = 0
     Units = ""
     Curve(46127368,"XX",0,,,)
     }
    }
   -Plot-([900,36],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,612,288]
    Posn = [900,36]
    Icon = [-1,-1]
    Extents = 0,0,612,288
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,612,113],"y")
     {
     Options = 128
     Units = ""
     Curve(46106432,"Es",0,,-2,)
     Curve(46110776,"Vdrop",0,,,)
     Curve(46103448,"Emeas",0,,-2,)
     }
    Graph([0,113],[0,0,612,112],"y")
     {
     Options = 0
     Units = ""
     Curve(46108328,"Is",0,,,)
     }
    }
   0.select([1080,900],0,0,610)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.logic_mult([1044,936],0,0,590)
    {
    Type = "1"
    Num_in = "2"
    Inv = "0"
    disnum = "0"
    INTR = "0"
    Inv1 = "0"
    Inv2 = "0"
    Inv3 = "0"
    Inv4 = "0"
    Inv5 = "0"
    Inv6 = "0"
    Inv7 = "0"
    Inv8 = "0"
    Inv9 = "0"
    }
   0.const([972,954],0,0,320)
    {
    Name = ""
    Value = "0"
    }
   0.datalabel([1044,900],0,0,-1)
    {
    Name = "TAPini"
    }
   -Wire-([1008,864],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([1008,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([396,954],0,0,-1)
    {
    Name = "clear"
    }
   0.datalabel([936,1044],0,0,-1)
    {
    Name = "clear"
    }
   0.compar([936,1044],0,0,600)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "0"
    OLo = "TAP0"
    }
   0.const([900,1080],0,0,390)
    {
    Name = ""
    Value = "0"
    }
   0.datalabel([1026,1044],0,0,-1)
    {
    Name = "TAPini"
    }
   -Wire-([1008,1044],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1260,900],0,0,-1)
    {
    Name = "TAP0"
    }
   -Sticky-([918,1116],0)
    {
    Name = ""
    Font = 1
    Bounds = 918,1116,1026,1152
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Initial Tap setting.
"
    }
   0.pi_ctlr([900,864],0,0,570)
    {
    GP = "1.0"
    TI = "0.01 [s]"
    YHI = "10.0"
    YLO = "-10.0"
    YINIT = "0.0"
    Mthd = "0"
    INTR = "0"
    }
   }
  }
 Module("Reg1B")
  {
  Desc = ""
  FileDate = 1151590216
  Nodes = 
   {
   Input("V",-54,-18)
    {
    Type = Real
    }
   Input("I",-54,18)
    {
    Type = Real
    }
   Output("TAP",54,0)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-39,-39,39,39)
   Text(0,-13,"Reg1B")
   Pen(ByNode,ByNode,ByNode,V)
   Line(-54,-18,-39,-18)
   Pen(,Solid)
   Line(-39,-18,-44,-23)
   Line(-39,-18,-44,-13)
   Text(-46,-22,"V")
   Pen(,ByNode,,I)
   Line(-54,18,-39,18)
   Pen(,Solid)
   Line(-39,18,-44,13)
   Line(-39,18,-44,23)
   Text(-46,14,"I")
   Pen(,ByNode,,TAP)
   Line(54,0,39,0)
   Text(46,-4,"TAP")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.import([108,72],0,0,10)
    {
    Name = "V"
    }
   0.import([108,108],0,0,20)
    {
    Name = "I"
    }
   0.export([108,144],0,0,730)
    {
    Name = "TAP"
    }
   0.datalabel([360,486],0,0,-1)
    {
    Name = "V"
    }
   0.datalabel([522,378],0,0,-1)
    {
    Name = "I"
    }
   0.annotation([468,432],0,0,-1)
    {
    AL1 = ""
    AL2 = "PT Ratio=120"
    }
   0.annotation([630,324],0,0,-1)
    {
    AL1 = ""
    AL2 = "CT Ratio=500"
    }
   -Wire-([504,486],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.src_ccin_1([738,450],6,0,710)
    {
    Name = "Source 1"
    Cntrl = "1"
    Vm = "132.79 [kA]"
    f = "60.0 [Hz]"
    Ph = "0.0 []"
    Tc = "1.0 [sec]"
    }
   0.source_1([612,486],1,0,690)
    {
    Name = "Source1"
    Type = "6"
    Grnd = "0"
    Spec = "0"
    Cntrl = "1"
    AC = "0"
    Vm = "132.79 [kV]"
    Tc = "0.05 [sec]"
    Ph = "0.0 []"
    f = "60.0 [Hz]"
    P = "0.0 [MW]"
    Q = "0.0 [MVAR]"
    R = "1.0 [ohm]"
    Rs = "1.0 [ohm]"
    Rp = "1.0 [ohm]"
    Lp = "0.1 [H]"
    R' = "1.0 [ohm]"
    L = "0.1 [H]"
    C = "1.0 [uF]"
    L' = "0.1 [H]"
    C' = "1.0 [uF]"
    CUR = ""
    }
   -Wire-([666,378],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([558,486],0,0,-1)
    {
    Name = "Es"
    }
   0.datalabel([720,378],0,0,-1)
    {
    Name = "Is"
    }
   -Wire-([810,450],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([612,540],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([774,450],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.resistor([738,522],4,0,-1)
    {
    R = "13.5 [ohm]"
    }
   0.inductor([774,522],2,0,-1)
    {
    L = "0.02122 [H]"
    }
   -Wire-([774,522],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([612,450],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   0.voltmetergnd([864,450],0,0,170)
    {
    Name = "Emeas"
    }
   0.pgb([378,612],0,46366736,220)
    {
    Name = "Emeas"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([378,612],0,0,-1)
    {
    Name = "Emeas"
    }
   0.ground([612,540],1,0,-1)
    {
    }
   0.pgb([540,486],1,46369720,700)
    {
    Name = "Es"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([720,360],0,46371616,720)
    {
    Name = "Is"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([378,648],0,0,-1)
    {
    Name = "Vdrop"
    }
   0.pgb([378,648],0,46374064,240)
    {
    Name = "Vdrop"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([360,486],3,46375960,150)
    {
    Name = "V"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.rms-inst([522,612],0,0,230)
    {
    Type = "1"
    Ts = "0.05 [sec]"
    Scale = "1"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   0.datalabel([468,612],0,0,-1)
    {
    Name = "Emeas"
    }
   0.sumjct([126,864],0,0,260)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "-1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.abs([270,954],0,0,450)
    {
    Dim = "1"
    }
   -Wire-([234,954],0,0,-1)
    {
    Vertex="0,0;0,-90"
    }
   0.compar([306,954],0,0,460)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   0.mult([558,864],0,0,500)
    {
    }
   -Wire-([234,864],0,0,-1)
    {
    Vertex="0,0;288,0"
    }
   -Wire-([558,954],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.pgb([90,792],0,46382560,250)
    {
    Name = "Vmeas"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([90,864],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([306,864],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.datalabel([306,864],0,0,-1)
    {
    Name = "XX"
    }
   0.pgb([306,828],0,46385520,680)
    {
    Name = "XX"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Sticky-([216,54],0)
    {
    Name = ""
    Font = 1
    Bounds = 216,54,540,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
For regulator 1:

PT Ratio:                   120
Primary CT Rating: 100
CT Ratio: 100/0.2= 500
Bandwidth:               2.0v

Compensator Settings: 
R                              2.7v     or 2.7/0.2=13.5ohm
X                              1.6v      or 1.6/0.2= 8ohm or 0.02112H
Voltage Level        122v"
    }
   0.const([144,360],0,0,70)
    {
    Name = ""
    Value = "122"
    }
   0.datalabel([180,360],0,0,-1)
    {
    Name = "Vset"
    }
   0.const([144,378],0,0,80)
    {
    Name = ""
    Value = "2.7"
    }
   0.datalabel([180,378],0,0,-1)
    {
    Name = "Rset"
    }
   0.const([144,396],0,0,90)
    {
    Name = ""
    Value = "1.6"
    }
   0.datalabel([180,396],0,0,-1)
    {
    Name = "Xset"
    }
   0.div([468,486],0,0,410)
    {
    }
   0.div([630,378],0,0,400)
    {
    }
   0.const([432,522],0,0,180)
    {
    Name = ""
    Value = "120"
    }
   0.const([594,414],0,0,120)
    {
    Name = ""
    Value = "500"
    }
   0.voltmeter([810,486],1,0,190)
    {
    Name = "Vdrop"
    }
   -Wire-([774,486],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([738,378],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([702,450],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([468,612],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.const([144,414],0,0,100)
    {
    Name = ""
    Value = "2.0"
    }
   0.datalabel([180,414],0,0,-1)
    {
    Name = "Bw"
    }
   0.datalabel([126,900],0,0,-1)
    {
    Name = "Vset"
    }
   0.datalabel([234,990],0,0,-1)
    {
    Name = "Bw"
    }
   0.gain([270,990],0,0,300)
    {
    G = "0.5"
    COM = "Gain"
    Dim = "1"
    }
   0.compar([666,864],0,0,510)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "Vlow"
    OLo = "Vmeas"
    }
   0.const([630,900],0,0,270)
    {
    Name = ""
    Value = "0"
    }
   0.datalabel([216,504],0,0,-1)
    {
    Name = "Vset"
    }
   0.sumjct([216,468],0,0,140)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "-1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.datalabel([252,468],0,0,-1)
    {
    Name = "Vlow"
    }
   0.datalabel([216,594],0,0,-1)
    {
    Name = "Vset"
    }
   0.sumjct([216,558],0,0,210)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.datalabel([252,558],0,0,-1)
    {
    Name = "Vhigh"
    }
   -Wire-([792,864],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.sumjct([828,864],0,0,560)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "-1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.div([972,864],0,0,580)
    {
    }
   0.mult([1314,900],0,0,640)
    {
    }
   0.const([1278,936],0,0,340)
    {
    Name = ""
    Value = "0.00625"
    }
   0.sumjct([1386,900],0,0,650)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.const([1350,936],0,0,350)
    {
    Name = ""
    Value = "1"
    }
   0.datalabel([1422,900],0,0,-1)
    {
    Name = "TAP"
    }
   0.datalabel([774,864],0,0,-1)
    {
    Name = "Vmeas"
    }
   0.unity([1152,900],0,0,620)
    {
    IType = "2"
    OType = "1"
    }
   0.pgb([1422,900],0,46413608,660)
    {
    Name = "TAP"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1260,846],0,46415240,670)
    {
    Name = "Ntap"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([72,864],0,0,-1)
    {
    Name = "Vmeas"
    }
   0.hardlimit([1188,900],0,0,630)
    {
    UL = "16"
    LL = "-16"
    COM = "Hard_Limit"
    }
   0.datalabel([576,612],0,0,-1)
    {
    Name = "Vmeas"
    }
   -Wire-([558,612],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([72,864],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1260,846],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.datalabel([144,72],0,0,-1)
    {
    Name = "V"
    }
   0.datalabel([144,108],0,0,-1)
    {
    Name = "I"
    }
   0.datalabel([162,144],4,0,-1)
    {
    Name = "TAP"
    }
   -ControlPanel-([648,684],0)
    {
    Name = "$(GROUP) : Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 648,684
    Extents = 0,0,144,126
    Meter(46382560)
    Meter(46415240)
    Meter(46413608)
    }
   -Wire-([144,144],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Sticky-([558,54],0)
    {
    Name = ""
    Font = 1
    Bounds = 558,54,882,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
For regulator 2:

PT Ratio:                   120
Primary CT Rating: 100
CT Ratio: 100/0.2= 500
Bandwidth:               2.0v

Compensator Settings: 
R                              2.5v     or 2.7/0.2=12.5ohm
X                              1.5v      or 1.6/0.2= 7.5ohm or 0.0199H
Voltage Level        124v"
    }
   -Sticky-([234,270],0)
    {
    Name = ""
    Font = 1
    Bounds = 234,270,342,306
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "Regulator 2 data"
    }
   0.const([144,270],0,0,30)
    {
    Name = ""
    Value = "124"
    }
   0.const([144,288],0,0,40)
    {
    Name = ""
    Value = "2.5"
    }
   0.const([144,306],0,0,50)
    {
    Name = ""
    Value = "1.5"
    }
   0.const([144,324],0,0,60)
    {
    Name = ""
    Value = "2.0"
    }
   -Sticky-([234,360],0)
    {
    Name = ""
    Font = 1
    Bounds = 234,360,342,396
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "Regulator 1 data"
    }
   -Sticky-([648,558],0)
    {
    Name = ""
    Font = 1
    Bounds = 648,558,864,594
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Regulator 1: 13.5ohm, 0.02122H
Regulator 2: 12.5ohm, 0.0199H"
    }
   0.datalabel([108,468],0,0,-1)
    {
    Name = "Bw"
    }
   0.datalabel([108,558],0,0,-1)
    {
    Name = "Bw"
    }
   0.gain([144,468],0,0,130)
    {
    G = "0.5"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([144,558],0,0,200)
    {
    G = "0.5"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([396,486],0,0,160)
    {
    G = "1000"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([558,378],0,0,110)
    {
    G = "1000"
    COM = "Gain"
    Dim = "1"
    }
   -Sticky-([378,378],0)
    {
    Name = ""
    Font = 1
    Bounds = 378,378,450,414
    Alignment = 0
    Style = 1
    Arrow = 10
    Color = 0,15792890
    Text = "kV,kA to V,A"
    }
   0.integral([90,954],0,0,420)
    {
    Extrn = "0"
    Reset = "0"
    Mthd = "0"
    noname5 = ""
    INTR = "0"
    INTCLR = "0"
    T = "1 [s]"
    Yo = "0.0"
    YRst = "0.0"
    YHi = "100.0"
    YLo = "-100.0"
    }
   0.const([54,990],3,0,290)
    {
    Name = ""
    Value = "1.0"
    }
   0.compar([126,954],0,0,430)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   0.const([126,1026],3,0,310)
    {
    Name = ""
    Value = "1"
    }
   -Sticky-([72,1080],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,1080,180,1134
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
No tap change during first 1s of simulation.
"
    }
   0.mult([198,864],0,0,440)
    {
    }
   -Wire-([198,900],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.integral([450,954],0,0,480)
    {
    Extrn = "0"
    Reset = "1"
    Mthd = "0"
    noname5 = ""
    INTR = "0"
    INTCLR = "0"
    T = "1 [s]"
    Yo = "0.0"
    YRst = "0.0"
    YHi = "100.0"
    YLo = "-100.0"
    }
   0.compar([486,954],0,0,490)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   0.const([486,1026],3,0,360)
    {
    Name = ""
    Value = "0.25"
    }
   -Sticky-([468,1062],0)
    {
    Name = ""
    Font = 1
    Bounds = 468,1062,576,1098
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
0.25s control Time delay.
"
    }
   -Wire-([594,864],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Sticky-([612,1116],0)
    {
    Name = ""
    Font = 1
    Bounds = 612,1116,828,1170
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
out-of-band Low gives Vlow  
out-of-band High gives Vhigh
in-band or during delay gives Vmeas.
"
    }
   -Wire-([378,954],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.sumjct([414,1026],0,0,470)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.const([378,1062],0,0,370)
    {
    Name = ""
    Value = "1.0"
    }
   -Wire-([378,954],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([450,990],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Sticky-([324,1098],0)
    {
    Name = ""
    Font = 1
    Bounds = 324,1098,450,1152
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "Whenever the voltage goes in-band, the timer is reset."
    }
   -Wire-([720,360],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Sticky-([234,1026],0)
    {
    Name = ""
    Font = 1
    Bounds = 234,1026,324,1062
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
out-of-band?
"
    }
   0.const([630,990],0,0,330)
    {
    Name = ""
    Value = "0.0"
    }
   0.gain([630,954],0,0,520)
    {
    G = "-1"
    COM = "Gain"
    Dim = "1"
    }
   -Wire-([594,864],0,0,-1)
    {
    Vertex="0,0;0,180"
    }
   0.compar([666,954],0,0,530)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "Vhigh"
    OLo = "Vmeas"
    }
   0.select([792,954],0,0,550)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([738,864],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.compar([666,1044],0,0,540)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   -Wire-([594,1044],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.const([630,1080],0,0,380)
    {
    Name = ""
    Value = "0.0"
    }
   -Wire-([792,990],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([828,900],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([1224,900],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([738,1044],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([738,918],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([738,954],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.const([936,900],6,0,280)
    {
    Name = ""
    Value = "0.75"
    }
   -Sticky-([1188,972],0)
    {
    Name = ""
    Font = 1
    Bounds = 1188,972,1296,1008
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Tap calculation.
"
    }
   -Plot-([900,324],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,612,468]
    Posn = [900,324]
    Icon = [-1,-1]
    Extents = 0,0,612,468
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,612,102],"y")
     {
     Options = 128
     Units = ""
     Curve(46375960,"V",0,,,)
     }
    Graph([0,102],[0,0,612,101],"y")
     {
     Options = 0
     Units = ""
     Curve(46413608,"TAP",0,,,)
     Curve(46415240,"Ntap",0,,,)
     }
    Graph([0,203],[0,0,612,101],"y")
     {
     Options = 0
     Units = ""
     Curve(46382560,"Vmeas",0,,,)
     }
    Graph([0,304],[0,0,612,101],"y")
     {
     Options = 0
     Units = ""
     Curve(46385520,"XX",0,,,)
     }
    }
   -Plot-([900,36],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,612,288]
    Posn = [900,36]
    Icon = [-1,-1]
    Extents = 0,0,612,288
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,612,113],"y")
     {
     Options = 128
     Units = ""
     Curve(46369720,"Es",0,,-2,)
     Curve(46374064,"Vdrop",0,,,)
     Curve(46366736,"Emeas",0,,-2,)
     }
    Graph([0,113],[0,0,612,112],"y")
     {
     Options = 0
     Units = ""
     Curve(46371616,"Is",0,,,)
     }
    }
   0.select([1080,900],0,0,610)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.logic_mult([1044,936],0,0,590)
    {
    Type = "1"
    Num_in = "2"
    Inv = "0"
    disnum = "0"
    INTR = "0"
    Inv1 = "0"
    Inv2 = "0"
    Inv3 = "0"
    Inv4 = "0"
    Inv5 = "0"
    Inv6 = "0"
    Inv7 = "0"
    Inv8 = "0"
    Inv9 = "0"
    }
   0.const([972,954],0,0,320)
    {
    Name = ""
    Value = "0"
    }
   0.datalabel([1044,900],0,0,-1)
    {
    Name = "TAPini"
    }
   -Wire-([1008,864],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([1008,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([396,954],0,0,-1)
    {
    Name = "clear"
    }
   0.datalabel([936,1044],0,0,-1)
    {
    Name = "clear"
    }
   0.compar([936,1044],0,0,600)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "0"
    OLo = "TAP0"
    }
   0.const([900,1080],0,0,390)
    {
    Name = ""
    Value = "0"
    }
   0.datalabel([1026,1044],0,0,-1)
    {
    Name = "TAPini"
    }
   -Wire-([1008,1044],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1260,900],0,0,-1)
    {
    Name = "TAP0"
    }
   -Sticky-([918,1116],0)
    {
    Name = ""
    Font = 1
    Bounds = 918,1116,1026,1152
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Initial Tap setting.
"
    }
   0.pi_ctlr([900,864],0,0,570)
    {
    GP = "1.0"
    TI = "0.01 [s]"
    YHI = "10.0"
    YLO = "-10.0"
    YINIT = "0.0"
    Mthd = "0"
    INTR = "0"
    }
   }
  }
 Module("Reg1A")
  {
  Desc = ""
  FileDate = 1151590216
  Nodes = 
   {
   Input("V",-54,-18)
    {
    Type = Real
    }
   Input("I",-54,18)
    {
    Type = Real
    }
   Output("TAP",54,0)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-39,-39,39,39)
   Text(0,-13,"Reg1A")
   Pen(ByNode,ByNode,ByNode,V)
   Line(-54,-18,-39,-18)
   Pen(,Solid)
   Line(-39,-18,-44,-23)
   Line(-39,-18,-44,-13)
   Text(-46,-22,"V")
   Pen(,ByNode,,I)
   Line(-54,18,-39,18)
   Pen(,Solid)
   Line(-39,18,-44,13)
   Line(-39,18,-44,23)
   Text(-46,14,"I")
   Pen(,ByNode,,TAP)
   Line(54,0,39,0)
   Text(46,-4,"TAP")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.import([90,72],0,0,10)
    {
    Name = "V"
    }
   0.import([90,108],0,0,20)
    {
    Name = "I"
    }
   0.export([90,144],0,0,740)
    {
    Name = "TAP"
    }
   0.datalabel([342,486],0,0,-1)
    {
    Name = "V"
    }
   0.datalabel([504,378],0,0,-1)
    {
    Name = "I"
    }
   0.annotation([450,432],0,0,-1)
    {
    AL1 = ""
    AL2 = "PT Ratio=120"
    }
   0.annotation([612,324],0,0,-1)
    {
    AL1 = ""
    AL2 = "CT Ratio=500"
    }
   -Wire-([486,486],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.src_ccin_1([720,450],6,0,720)
    {
    Name = "Source 1"
    Cntrl = "1"
    Vm = "132.79 [kA]"
    f = "60.0 [Hz]"
    Ph = "0.0 []"
    Tc = "1.0 [sec]"
    }
   0.source_1([594,486],1,0,700)
    {
    Name = "Source1"
    Type = "6"
    Grnd = "0"
    Spec = "0"
    Cntrl = "1"
    AC = "0"
    Vm = "132.79 [kV]"
    Tc = "0.05 [sec]"
    Ph = "0.0 []"
    f = "60.0 [Hz]"
    P = "0.0 [MW]"
    Q = "0.0 [MVAR]"
    R = "1.0 [ohm]"
    Rs = "1.0 [ohm]"
    Rp = "1.0 [ohm]"
    Lp = "0.1 [H]"
    R' = "1.0 [ohm]"
    L = "0.1 [H]"
    C = "1.0 [uF]"
    L' = "0.1 [H]"
    C' = "1.0 [uF]"
    CUR = ""
    }
   -Wire-([648,378],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([540,486],0,0,-1)
    {
    Name = "Es"
    }
   0.datalabel([702,378],0,0,-1)
    {
    Name = "Is"
    }
   -Wire-([792,450],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([594,540],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([756,450],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.resistor([720,522],4,0,-1)
    {
    R = "13.5 [ohm]"
    }
   0.inductor([756,522],2,0,-1)
    {
    L = "0.02122 [H]"
    }
   -Wire-([756,522],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([594,450],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   0.voltmetergnd([846,450],0,0,170)
    {
    Name = "Emeas"
    }
   0.pgb([360,612],0,46613552,220)
    {
    Name = "Emeas"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "3.0"
    }
   0.datalabel([360,612],0,0,-1)
    {
    Name = "Emeas"
    }
   0.ground([594,540],1,0,-1)
    {
    }
   0.pgb([522,486],1,46620680,710)
    {
    Name = "Es"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "3.0"
    }
   0.pgb([702,360],0,46622528,730)
    {
    Name = "Is"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.2"
    Max = "0.2"
    }
   0.datalabel([360,648],0,0,-1)
    {
    Name = "Vdrop"
    }
   0.pgb([360,648],0,46624976,240)
    {
    Name = "Vdrop"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "3.0"
    }
   0.pgb([342,486],3,46626872,150)
    {
    Name = "V"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-25.0"
    Max = "25.0"
    }
   0.rms-inst([504,612],0,0,230)
    {
    Type = "1"
    Ts = "0.05 [sec]"
    Scale = "1"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   0.datalabel([450,612],0,0,-1)
    {
    Name = "Emeas"
    }
   0.sumjct([108,864],0,0,260)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "-1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.abs([252,954],0,0,450)
    {
    Dim = "1"
    }
   -Wire-([216,954],0,0,-1)
    {
    Vertex="0,0;0,-90"
    }
   0.compar([288,954],0,0,460)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   0.mult([540,864],0,0,500)
    {
    }
   -Wire-([216,864],0,0,-1)
    {
    Vertex="0,0;288,0"
    }
   -Wire-([540,954],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.pgb([72,792],0,46633472,250)
    {
    Name = "Vmeas"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "140.0"
    }
   -Wire-([72,864],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([288,864],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.datalabel([288,864],0,0,-1)
    {
    Name = "XX"
    }
   0.pgb([288,828],0,46636432,690)
    {
    Name = "XX"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "8.0"
    }
   -Sticky-([198,54],0)
    {
    Name = ""
    Font = 1
    Bounds = 198,54,522,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
For regulator 1:

PT Ratio:                   120
Primary CT Rating: 100
CT Ratio: 100/0.2= 500
Bandwidth:               2.0v

Compensator Settings: 
R                              2.7v     or 2.7/0.2=13.5ohm
X                              1.6v      or 1.6/0.2= 8ohm or 0.02112H
Voltage Level        122v"
    }
   0.const([126,360],0,0,70)
    {
    Name = ""
    Value = "122"
    }
   0.datalabel([162,360],0,0,-1)
    {
    Name = "Vset"
    }
   0.const([126,378],0,0,80)
    {
    Name = ""
    Value = "2.7"
    }
   0.datalabel([162,378],0,0,-1)
    {
    Name = "Rset"
    }
   0.const([126,396],0,0,90)
    {
    Name = ""
    Value = "1.6"
    }
   0.datalabel([162,396],0,0,-1)
    {
    Name = "Xset"
    }
   0.div([450,486],0,0,410)
    {
    }
   0.div([612,378],0,0,400)
    {
    }
   0.const([414,522],0,0,180)
    {
    Name = ""
    Value = "120"
    }
   0.const([576,414],0,0,120)
    {
    Name = ""
    Value = "500"
    }
   0.voltmeter([792,486],1,0,190)
    {
    Name = "Vdrop"
    }
   -Wire-([756,486],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([720,378],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([684,450],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([450,612],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.const([126,414],0,0,100)
    {
    Name = ""
    Value = "2.0"
    }
   0.datalabel([162,414],0,0,-1)
    {
    Name = "Bw"
    }
   0.datalabel([108,900],0,0,-1)
    {
    Name = "Vset"
    }
   0.datalabel([216,990],0,0,-1)
    {
    Name = "Bw"
    }
   0.gain([252,990],0,0,300)
    {
    G = "0.5"
    COM = "Gain"
    Dim = "1"
    }
   0.compar([648,864],0,0,510)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "Vlow"
    OLo = "Vmeas"
    }
   0.const([612,900],0,0,270)
    {
    Name = ""
    Value = "0"
    }
   0.datalabel([198,504],0,0,-1)
    {
    Name = "Vset"
    }
   0.sumjct([198,468],0,0,140)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "-1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.datalabel([234,468],0,0,-1)
    {
    Name = "Vlow"
    }
   0.datalabel([198,594],0,0,-1)
    {
    Name = "Vset"
    }
   0.sumjct([198,558],0,0,210)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.datalabel([234,558],0,0,-1)
    {
    Name = "Vhigh"
    }
   -Wire-([774,864],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.sumjct([810,864],0,0,560)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "-1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.div([954,864],0,0,580)
    {
    }
   0.mult([1296,900],0,0,640)
    {
    }
   0.const([1260,936],0,0,340)
    {
    Name = ""
    Value = "0.00625"
    }
   0.sumjct([1368,900],0,0,650)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.const([1332,936],0,0,350)
    {
    Name = ""
    Value = "1"
    }
   0.datalabel([1404,900],0,0,-1)
    {
    Name = "TAP"
    }
   0.datalabel([756,864],0,0,-1)
    {
    Name = "Vmeas"
    }
   0.unity([1134,900],0,0,620)
    {
    IType = "2"
    OType = "1"
    }
   0.pgb([1404,900],0,46701256,660)
    {
    Name = "TAP"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "14.0"
    }
   0.pgb([1242,846],0,46702888,680)
    {
    Name = "Ntap"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "14.0"
    }
   0.datalabel([54,864],0,0,-1)
    {
    Name = "Vmeas"
    }
   0.hardlimit([1170,900],0,0,630)
    {
    UL = "16"
    LL = "-16"
    COM = "Hard_Limit"
    }
   0.datalabel([558,612],0,0,-1)
    {
    Name = "Vmeas"
    }
   -Wire-([540,612],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([54,864],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1242,846],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.datalabel([126,72],0,0,-1)
    {
    Name = "V"
    }
   0.datalabel([126,108],0,0,-1)
    {
    Name = "I"
    }
   0.datalabel([144,144],4,0,-1)
    {
    Name = "TAP"
    }
   -Wire-([126,144],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Sticky-([540,54],0)
    {
    Name = ""
    Font = 1
    Bounds = 540,54,864,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
For regulator 2:

PT Ratio:                   120
Primary CT Rating: 100
CT Ratio: 100/0.2= 500
Bandwidth:               2.0v

Compensator Settings: 
R                              2.5v     or 2.7/0.2=12.5ohm
X                              1.5v      or 1.6/0.2= 7.5ohm or 0.0199H
Voltage Level        124v"
    }
   -Sticky-([216,270],0)
    {
    Name = ""
    Font = 1
    Bounds = 216,270,324,306
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "Regulator 2 data"
    }
   0.const([126,270],0,0,30)
    {
    Name = ""
    Value = "124"
    }
   0.const([126,288],0,0,40)
    {
    Name = ""
    Value = "2.5"
    }
   0.const([126,306],0,0,50)
    {
    Name = ""
    Value = "1.5"
    }
   0.const([126,324],0,0,60)
    {
    Name = ""
    Value = "2.0"
    }
   -Sticky-([216,360],0)
    {
    Name = ""
    Font = 1
    Bounds = 216,360,324,396
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "Regulator 1 data"
    }
   -Sticky-([630,558],0)
    {
    Name = ""
    Font = 1
    Bounds = 630,558,846,594
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Regulator 1: 13.5ohm, 0.02122H
Regulator 2: 12.5ohm, 0.0199H"
    }
   0.datalabel([90,468],0,0,-1)
    {
    Name = "Bw"
    }
   0.datalabel([90,558],0,0,-1)
    {
    Name = "Bw"
    }
   0.gain([126,468],0,0,130)
    {
    G = "0.5"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([126,558],0,0,200)
    {
    G = "0.5"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([378,486],0,0,160)
    {
    G = "1000"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([540,378],0,0,110)
    {
    G = "1000"
    COM = "Gain"
    Dim = "1"
    }
   -Sticky-([360,378],0)
    {
    Name = ""
    Font = 1
    Bounds = 360,378,432,414
    Alignment = 0
    Style = 1
    Arrow = 10
    Color = 0,15792890
    Text = "kV,kA to V,A"
    }
   0.integral([72,954],0,0,420)
    {
    Extrn = "0"
    Reset = "0"
    Mthd = "0"
    noname5 = ""
    INTR = "0"
    INTCLR = "0"
    T = "1 [s]"
    Yo = "0.0"
    YRst = "0.0"
    YHi = "100.0"
    YLo = "-100.0"
    }
   0.const([36,990],3,0,290)
    {
    Name = ""
    Value = "1.0"
    }
   0.compar([108,954],0,0,430)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   0.const([108,1026],3,0,310)
    {
    Name = ""
    Value = "1"
    }
   -Sticky-([54,1080],0)
    {
    Name = ""
    Font = 1
    Bounds = 54,1080,162,1134
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
No tap change during first 1s of simulation.
"
    }
   0.mult([180,864],0,0,440)
    {
    }
   -Wire-([180,900],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.integral([432,954],0,0,480)
    {
    Extrn = "0"
    Reset = "1"
    Mthd = "0"
    noname5 = ""
    INTR = "0"
    INTCLR = "0"
    T = "1 [s]"
    Yo = "0.0"
    YRst = "0.0"
    YHi = "100.0"
    YLo = "-100.0"
    }
   0.compar([468,954],0,0,490)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   0.const([468,1026],3,0,360)
    {
    Name = ""
    Value = "0.25"
    }
   -Sticky-([450,1062],0)
    {
    Name = ""
    Font = 1
    Bounds = 450,1062,558,1098
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
0.25s control Time delay.
"
    }
   -Wire-([576,864],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Sticky-([594,1116],0)
    {
    Name = ""
    Font = 1
    Bounds = 594,1116,810,1170
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
out-of-band Low gives Vlow  
out-of-band High gives Vhigh
in-band or during delay gives Vmeas.
"
    }
   -Wire-([360,954],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.sumjct([396,1026],0,0,470)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.const([360,1062],0,0,370)
    {
    Name = ""
    Value = "1.0"
    }
   -Wire-([360,954],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([432,990],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Sticky-([306,1098],0)
    {
    Name = ""
    Font = 1
    Bounds = 306,1098,432,1152
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "Whenever the voltage goes in-band, the timer is reset."
    }
   -Wire-([702,360],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Sticky-([216,1026],0)
    {
    Name = ""
    Font = 1
    Bounds = 216,1026,306,1062
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
out-of-band?
"
    }
   0.const([612,990],0,0,330)
    {
    Name = ""
    Value = "0.0"
    }
   0.gain([612,954],0,0,520)
    {
    G = "-1"
    COM = "Gain"
    Dim = "1"
    }
   -Wire-([576,864],0,0,-1)
    {
    Vertex="0,0;0,180"
    }
   0.compar([648,954],0,0,530)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "Vhigh"
    OLo = "Vmeas"
    }
   0.select([774,954],0,0,550)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([720,864],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.compar([648,1044],0,0,540)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   -Wire-([576,1044],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.const([612,1080],0,0,380)
    {
    Name = ""
    Value = "0.0"
    }
   -Wire-([774,990],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([810,900],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([1206,900],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([720,1044],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([720,918],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([720,954],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.const([918,900],6,0,280)
    {
    Name = ""
    Value = "0.75"
    }
   -Sticky-([1170,972],0)
    {
    Name = ""
    Font = 1
    Bounds = 1170,972,1278,1008
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Tap calculation.
"
    }
   -Plot-([882,324],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,612,468]
    Posn = [882,324]
    Icon = [-1,-1]
    Extents = 0,0,612,468
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,612,102],"y")
     {
     Options = 128
     Units = ""
     Curve(46626872,"V",0,,,)
     }
    Graph([0,102],[0,0,612,101],"y")
     {
     Options = 0
     Units = ""
     Curve(46701256,"TAP",0,,,)
     Curve(46702888,"Ntap",0,,,)
     }
    Graph([0,203],[0,0,612,101],"y")
     {
     Options = 0
     Units = ""
     Curve(46633472,"Vmeas",0,,,)
     }
    Graph([0,304],[0,0,612,101],"y")
     {
     Options = 0
     Units = ""
     Curve(46636432,"XX",0,,,)
     }
    }
   0.select([1062,900],0,0,610)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.logic_mult([1026,936],0,0,590)
    {
    Type = "1"
    Num_in = "2"
    Inv = "0"
    disnum = "0"
    INTR = "0"
    Inv1 = "0"
    Inv2 = "0"
    Inv3 = "0"
    Inv4 = "0"
    Inv5 = "0"
    Inv6 = "0"
    Inv7 = "0"
    Inv8 = "0"
    Inv9 = "0"
    }
   0.const([954,954],0,0,320)
    {
    Name = ""
    Value = "0"
    }
   0.datalabel([1026,900],0,0,-1)
    {
    Name = "TAPini"
    }
   -Wire-([990,864],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([990,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([378,954],0,0,-1)
    {
    Name = "clear"
    }
   0.datalabel([918,1044],0,0,-1)
    {
    Name = "clear"
    }
   0.compar([918,1044],0,0,600)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "0"
    OLo = "TAP0"
    }
   0.const([882,1080],0,0,390)
    {
    Name = ""
    Value = "0"
    }
   0.datalabel([1008,1044],0,0,-1)
    {
    Name = "TAPini"
    }
   -Wire-([990,1044],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1242,900],0,0,-1)
    {
    Name = "TAP0"
    }
   -Sticky-([900,1116],0)
    {
    Name = ""
    Font = 1
    Bounds = 900,1116,1008,1152
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Initial Tap setting.
"
    }
   0.pgb([468,954],3,46782680,670)
    {
    Name = "<Untitled>"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -ControlPanel-([774,684],0)
    {
    Name = "$(GROUP) : Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 774,684
    Extents = 0,0,144,126
    Meter(46633472)
    Meter(46702888)
    Meter(46701256)
    }
   -Plot-([144,666],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,0,0]
    Posn = [144,666]
    Icon = [-1,-1]
    Extents = 0,0,576,288
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,576,225],"y")
     {
     Options = 128
     Units = ""
     Curve(46782680,"<Untitled>",0,,,)
     }
    }
   0.pi_ctlr([882,864],0,0,570)
    {
    GP = "1.0"
    TI = "0.01 [s]"
    YHI = "10.0"
    YLO = "-10.0"
    YINIT = "0.0"
    Mthd = "0"
    INTR = "0"
    }
   -Plot-([882,36],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,612,288]
    Posn = [882,36]
    Icon = [-1,-1]
    Extents = 0,0,612,288
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,612,113],"y")
     {
     Options = 128
     Units = ""
     Curve(46620680,"Es",0,,-2,)
     Curve(46624976,"Vdrop",0,,,)
     Curve(46613552,"Emeas",0,,-2,)
     }
    Graph([0,113],[0,0,612,112],"y")
     {
     Options = 0
     Units = ""
     Curve(46622528,"Is",0,,,)
     }
    }
   }
  }
 Module("IloadBC840")
  {
  Desc = ""
  FileDate = 1151590218
  Nodes = 
   {
   Electrical("B",-36,0)
    {
    }
   Electrical("C",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zbc840")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([252,252],2,0,-1)
    {
    Name = "B"
    }
   -Wire-([252,486],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.datalabel([216,108],0,0,-1)
    {
    Name = "Vbc840"
    }
   0.varrlc([306,360],3,0,200)
    {
    RLC = "0"
    R = "Rbc840"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([216,360],3,0,210)
    {
    RLC = "1"
    R = "R"
    L = "Lbc840"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([540,108],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   0.div([576,108],0,0,190)
    {
    }
   0.const([684,144],4,0,30)
    {
    Name = "P in MW"
    Value = "0.007333"
    }
   0.div([576,252],0,0,170)
    {
    }
   0.emtconst([810,288],4,0,60)
    {
    Name = ""
    Value = "1"
    }
   0.mult([738,288],4,0,150)
    {
    }
   0.const([774,324],4,0,80)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.const([684,324],4,0,70)
    {
    Name = "Q in MVAR"
    Value = "0.0036667"
    }
   0.datalabel([612,108],0,0,-1)
    {
    Name = "Rbc840"
    }
   0.datalabel([684,252],0,0,-1)
    {
    Name = "Lbc840"
    }
   -Wire-([306,324],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([216,414],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([252,324],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([252,486],0,0,-1)
    {
    Name = "C"
    }
   0.voltmeter([360,252],0,0,50)
    {
    Name = "Vbc840"
    }
   -Wire-([252,252],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([252,486],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([360,288],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   -Wire-([306,360],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.div([612,144],4,0,140)
    {
    }
   0.const([648,180],4,0,40)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.div([612,324],4,0,160)
    {
    }
   0.const([648,360],4,0,90)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.div([648,252],0,0,180)
    {
    }
   -Wire-([576,288],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([648,288],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([216,414],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.hardlimit([324,108],0,0,110)
    {
    UL = "1.2"
    LL = "0.8"
    COM = "Hard_Limit"
    }
   0.mult([468,108],0,0,130)
    {
    }
   0.const([504,144],4,0,20)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.const([360,144],0,0,10)
    {
    Name = ""
    Value = "0.000001"
    }
   0.sumjct([396,108],0,0,120)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([504,108],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.rms-inst([252,108],0,0,100)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "24.9"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   }
  }
 Module("IloadAB840")
  {
  Desc = ""
  FileDate = 1151590218
  Nodes = 
   {
   Electrical("A",-36,0)
    {
    }
   Electrical("B",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zab840")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([144,216],2,0,-1)
    {
    Name = "A"
    }
   -Wire-([144,450],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.datalabel([108,72],0,0,-1)
    {
    Name = "Vab840"
    }
   0.varrlc([198,324],3,0,200)
    {
    RLC = "0"
    R = "Rab840"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([108,324],3,0,210)
    {
    RLC = "1"
    R = "R"
    L = "Lab840"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([432,72],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   0.div([468,72],0,0,190)
    {
    }
   0.const([576,108],4,0,30)
    {
    Name = "P in MW"
    Value = "0.006"
    }
   0.div([468,216],0,0,170)
    {
    }
   0.emtconst([702,252],4,0,60)
    {
    Name = ""
    Value = "1"
    }
   0.mult([630,252],4,0,150)
    {
    }
   0.const([666,288],4,0,80)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.const([576,288],4,0,70)
    {
    Name = "Q in MVAR"
    Value = "0.003"
    }
   0.datalabel([504,72],0,0,-1)
    {
    Name = "Rab840"
    }
   0.datalabel([576,216],0,0,-1)
    {
    Name = "Lab840"
    }
   -Wire-([198,288],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([108,378],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([144,288],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([144,450],0,0,-1)
    {
    Name = "B"
    }
   0.voltmeter([252,216],0,0,50)
    {
    Name = "Vab840"
    }
   -Wire-([144,216],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([144,450],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([252,252],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   -Wire-([198,324],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([108,324],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.div([504,108],4,0,140)
    {
    }
   0.const([540,144],4,0,40)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.div([504,288],4,0,160)
    {
    }
   0.const([540,324],4,0,90)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.div([540,216],0,0,180)
    {
    }
   -Wire-([468,252],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([540,252],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.hardlimit([216,72],0,0,110)
    {
    UL = "1.2"
    LL = "0.8"
    COM = "Hard_Limit"
    }
   0.mult([360,72],0,0,130)
    {
    }
   0.const([396,108],4,0,20)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.const([252,108],0,0,10)
    {
    Name = ""
    Value = "0.000001"
    }
   0.sumjct([288,72],0,0,120)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([396,72],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.rms-inst([144,72],0,0,100)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "24.9"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   }
  }
 Module("IloadBC836")
  {
  Desc = ""
  FileDate = 1151590218
  Nodes = 
   {
   Electrical("B",-36,0)
    {
    }
   Electrical("C",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zbc836")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([252,252],2,0,-1)
    {
    Name = "B"
    }
   -Wire-([252,486],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.datalabel([216,108],0,0,-1)
    {
    Name = "Vbc836"
    }
   0.varrlc([306,360],3,0,200)
    {
    RLC = "0"
    R = "Rbc836_1"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([216,360],3,0,210)
    {
    RLC = "1"
    R = "R"
    L = "Lbc836_1"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([540,108],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   0.div([576,108],0,0,190)
    {
    }
   0.const([684,144],4,0,30)
    {
    Name = "P in MW"
    Value = "0.0146667"
    }
   0.div([576,252],0,0,170)
    {
    }
   0.emtconst([810,288],4,0,60)
    {
    Name = ""
    Value = "1"
    }
   0.mult([738,288],4,0,150)
    {
    }
   0.const([774,324],4,0,80)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.const([684,324],4,0,70)
    {
    Name = "Q in MVAR"
    Value = "0.0073333"
    }
   0.datalabel([612,108],0,0,-1)
    {
    Name = "Rbc836_1"
    }
   0.datalabel([684,252],0,0,-1)
    {
    Name = "Lbc836_1"
    }
   -Wire-([306,324],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([216,414],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([252,324],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([252,486],0,0,-1)
    {
    Name = "C"
    }
   0.voltmeter([360,252],0,0,50)
    {
    Name = "Vbc836"
    }
   -Wire-([252,252],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([252,486],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([360,288],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   -Wire-([306,360],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.div([612,144],4,0,140)
    {
    }
   0.const([648,180],4,0,40)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.div([612,324],4,0,160)
    {
    }
   0.const([648,360],4,0,90)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.div([648,252],0,0,180)
    {
    }
   -Wire-([576,288],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([648,288],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([216,414],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.hardlimit([324,108],0,0,110)
    {
    UL = "1.2"
    LL = "0.8"
    COM = "Hard_Limit"
    }
   0.mult([468,108],0,0,130)
    {
    }
   0.const([504,144],4,0,20)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.const([360,144],0,0,10)
    {
    Name = ""
    Value = "0.000001"
    }
   0.sumjct([396,108],0,0,120)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([504,108],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.rms-inst([252,108],0,0,100)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "24.9"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   }
  }
 Module("IloadAB836")
  {
  Desc = ""
  FileDate = 1151590218
  Nodes = 
   {
   Electrical("A",-36,0)
    {
    }
   Electrical("B",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zab836")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([252,378],2,0,-1)
    {
    Name = "A"
    }
   -Wire-([252,612],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.datalabel([216,234],0,0,-1)
    {
    Name = "Vab836"
    }
   0.varrlc([306,486],3,0,200)
    {
    RLC = "0"
    R = "Rab836_1"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([216,486],3,0,210)
    {
    RLC = "1"
    R = "R"
    L = "Lab836_1"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([540,234],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   0.div([576,234],0,0,190)
    {
    }
   0.const([684,270],4,0,30)
    {
    Name = "P in MW"
    Value = "0.012"
    }
   0.div([576,378],0,0,170)
    {
    }
   0.emtconst([810,414],4,0,60)
    {
    Name = ""
    Value = "1"
    }
   0.mult([738,414],4,0,150)
    {
    }
   0.const([774,450],4,0,80)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.const([684,450],4,0,70)
    {
    Name = "Q in MVAR"
    Value = "0.006"
    }
   0.datalabel([612,234],0,0,-1)
    {
    Name = "Rab836_1"
    }
   0.datalabel([684,378],0,0,-1)
    {
    Name = "Lab836_1"
    }
   -Wire-([306,450],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([216,540],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([252,450],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([252,612],0,0,-1)
    {
    Name = "B"
    }
   0.voltmeter([360,378],0,0,50)
    {
    Name = "Vab836"
    }
   -Wire-([252,378],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([252,612],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([360,414],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   -Wire-([306,486],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([216,486],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.div([612,270],4,0,140)
    {
    }
   0.const([648,306],4,0,40)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.div([612,450],4,0,160)
    {
    }
   0.const([648,486],4,0,90)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.div([648,378],0,0,180)
    {
    }
   -Wire-([576,414],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([648,414],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.hardlimit([324,234],0,0,110)
    {
    UL = "1.2"
    LL = "0.8"
    COM = "Hard_Limit"
    }
   0.mult([468,234],0,0,130)
    {
    }
   0.const([504,270],4,0,20)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.const([360,270],0,0,10)
    {
    Name = ""
    Value = "0.000001"
    }
   0.sumjct([396,234],0,0,120)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([504,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.rms-inst([252,234],0,0,100)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "24.9"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   }
  }
 Module("loadAB836")
  {
  Desc = ""
  FileDate = 1151590218
  Nodes = 
   {
   Electrical("A",-36,0)
    {
    }
   Electrical("B",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zab836")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([270,288],2,0,-1)
    {
    Name = "A"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;0,-126"
    }
   0.datalabel([36,72],0,0,-1)
    {
    Name = "Vab836"
    }
   0.varrlc([324,396],3,0,170)
    {
    RLC = "0"
    R = "Rab836"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([234,396],3,0,180)
    {
    RLC = "1"
    R = "R"
    L = "Lab836"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([432,72],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   0.square([396,72],0,0,120)
    {
    Dim = "1"
    }
   0.mult([504,216],4,0,150)
    {
    }
   0.div([468,72],0,0,130)
    {
    }
   0.const([504,108],4,0,30)
    {
    Name = "P in MW"
    Value = "0.01"
    }
   0.div([468,180],0,0,160)
    {
    }
   0.emtconst([540,252],4,0,50)
    {
    Name = ""
    Value = "1"
    }
   0.mult([576,216],4,0,140)
    {
    }
   0.const([612,252],4,0,60)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.const([648,216],4,0,40)
    {
    Name = "Q in MVAR"
    Value = "0.005"
    }
   0.datalabel([504,72],0,0,-1)
    {
    Name = "Rab836"
    }
   0.datalabel([504,180],0,0,-1)
    {
    Name = "Lab836"
    }
   -Wire-([324,360],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([234,396],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([270,360],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([270,522],0,0,-1)
    {
    Name = "B"
    }
   0.voltmeter([378,288],0,0,70)
    {
    Name = "Vab836"
    }
   -Wire-([270,288],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([378,324],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   0.hardlimit([144,72],0,0,90)
    {
    UL = "1.2"
    LL = "0.8"
    COM = "Hard_Limit"
    }
   0.mult([288,72],0,0,110)
    {
    }
   0.const([324,108],4,0,20)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.const([180,108],0,0,10)
    {
    Name = ""
    Value = "0.000001"
    }
   0.sumjct([216,72],0,0,100)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([324,72],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.rms-inst([72,72],0,0,80)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "24.9"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   }
  }
 Module("loadBC836")
  {
  Desc = ""
  FileDate = 1151590218
  Nodes = 
   {
   Electrical("B",-36,0)
    {
    }
   Electrical("C",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zbc836")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([270,288],2,0,-1)
    {
    Name = "B"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;0,-126"
    }
   0.datalabel([36,72],0,0,-1)
    {
    Name = "Vbc836"
    }
   0.varrlc([324,396],3,0,170)
    {
    RLC = "0"
    R = "Rbc836"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([234,396],3,0,180)
    {
    RLC = "1"
    R = "R"
    L = "Lbc836"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([432,72],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   0.square([396,72],0,0,120)
    {
    Dim = "1"
    }
   0.mult([504,216],4,0,150)
    {
    }
   0.div([468,72],0,0,130)
    {
    }
   0.const([504,108],4,0,30)
    {
    Name = "P in MW"
    Value = "0.003333"
    }
   0.div([468,180],0,0,160)
    {
    }
   0.emtconst([540,252],4,0,50)
    {
    Name = ""
    Value = "1"
    }
   0.mult([576,216],4,0,140)
    {
    }
   0.const([612,252],4,0,60)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.const([648,216],4,0,40)
    {
    Name = "Q in MVAR"
    Value = "0.002"
    }
   0.datalabel([504,72],0,0,-1)
    {
    Name = "Rbc836"
    }
   0.datalabel([504,180],0,0,-1)
    {
    Name = "Lbc836"
    }
   -Wire-([324,360],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([234,396],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([270,360],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([270,522],0,0,-1)
    {
    Name = "C"
    }
   0.voltmeter([378,288],0,0,70)
    {
    Name = "Vbc836"
    }
   -Wire-([270,288],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([378,324],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   0.hardlimit([144,72],0,0,90)
    {
    UL = "1.2"
    LL = "0.8"
    COM = "Hard_Limit"
    }
   0.mult([288,72],0,0,110)
    {
    }
   0.const([324,108],4,0,20)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.const([180,108],0,0,10)
    {
    Name = ""
    Value = "0.000001"
    }
   0.sumjct([216,72],0,0,100)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([324,72],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.rms-inst([72,72],0,0,80)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "24.9"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   }
  }
 Module("loadCA836")
  {
  Desc = ""
  FileDate = 1151590218
  Nodes = 
   {
   Electrical("C",-36,0)
    {
    }
   Electrical("A",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zca836")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([270,288],2,0,-1)
    {
    Name = "C"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;0,-126"
    }
   0.datalabel([36,72],0,0,-1)
    {
    Name = "Vca836"
    }
   0.varrlc([324,396],3,0,170)
    {
    RLC = "0"
    R = "Rca836"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([234,396],3,0,180)
    {
    RLC = "1"
    R = "R"
    L = "Lca836"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([432,72],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   0.square([396,72],0,0,120)
    {
    Dim = "1"
    }
   0.mult([504,216],4,0,150)
    {
    }
   0.div([468,72],0,0,130)
    {
    }
   0.const([504,108],4,0,30)
    {
    Name = "P in MW"
    Value = "0.014"
    }
   0.div([468,180],0,0,160)
    {
    }
   0.emtconst([540,252],4,0,50)
    {
    Name = ""
    Value = "1"
    }
   0.mult([576,216],4,0,140)
    {
    }
   0.const([612,252],4,0,60)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.const([648,216],4,0,40)
    {
    Name = "Q in MVAR"
    Value = "0.007333"
    }
   0.datalabel([504,72],0,0,-1)
    {
    Name = "Rca836"
    }
   0.datalabel([504,180],0,0,-1)
    {
    Name = "Lca836"
    }
   -Wire-([324,360],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([234,396],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([270,360],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([270,522],0,0,-1)
    {
    Name = "A"
    }
   0.voltmeter([378,288],0,0,70)
    {
    Name = "Vca836"
    }
   -Wire-([270,288],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([378,324],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   0.hardlimit([144,72],0,0,90)
    {
    UL = "1.2"
    LL = "0.8"
    COM = "Hard_Limit"
    }
   0.mult([288,72],0,0,110)
    {
    }
   0.const([324,108],4,0,20)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.const([180,108],0,0,10)
    {
    Name = ""
    Value = "0.000001"
    }
   0.sumjct([216,72],0,0,100)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([324,72],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.rms-inst([72,72],0,0,80)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "24.9"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   }
  }
 Module("loadAB860")
  {
  Desc = ""
  FileDate = 1151590217
  Nodes = 
   {
   Electrical("A",-36,0)
    {
    }
   Electrical("B",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zab860")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([270,288],2,0,-1)
    {
    Name = "A"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;0,-126"
    }
   0.datalabel([36,72],0,0,-1)
    {
    Name = "Vab860"
    }
   0.varrlc([324,396],3,0,210)
    {
    RLC = "0"
    R = "Rab860"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([234,396],3,0,220)
    {
    RLC = "1"
    R = "R"
    L = "Lab860"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([432,72],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   0.square([396,72],0,0,140)
    {
    Dim = "1"
    }
   0.mult([504,216],4,0,180)
    {
    }
   0.div([468,72],0,0,150)
    {
    }
   0.const([504,108],4,0,30)
    {
    Name = "P in MW"
    Value = "0.02"
    }
   0.div([468,180],0,0,190)
    {
    }
   0.emtconst([540,252],4,0,70)
    {
    Name = ""
    Value = "1"
    }
   0.mult([576,216],4,0,170)
    {
    }
   0.const([612,252],4,0,80)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.const([648,216],4,0,50)
    {
    Name = "Q in MVAR"
    Value = "0.01"
    }
   0.datalabel([702,72],0,0,-1)
    {
    Name = "Rab860"
    }
   0.datalabel([810,180],0,0,-1)
    {
    Name = "Lab860"
    }
   -Wire-([324,360],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([234,396],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([270,360],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([270,522],0,0,-1)
    {
    Name = "B"
    }
   0.voltmeter([378,288],0,0,90)
    {
    Name = "Vab860"
    }
   -Wire-([270,288],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([378,324],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   0.maxmin([666,72],0,0,160)
    {
    DPath = "1"
    Type = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "1"
    F = "0"
    G = "0"
    }
   0.maxmin([774,180],0,0,200)
    {
    DPath = "1"
    Type = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "1"
    F = "0"
    G = "0"
    }
   -Wire-([504,72],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([504,180],0,0,-1)
    {
    Vertex="0,0;234,0"
    }
   0.const([594,108],0,0,40)
    {
    Name = ""
    Value = ".001"
    }
   0.const([702,216],0,0,60)
    {
    Name = ""
    Value = ".00001"
    }
   0.hardlimit([144,72],0,0,110)
    {
    UL = "1.2"
    LL = "0.8"
    COM = "Hard_Limit"
    }
   0.mult([288,72],0,0,130)
    {
    }
   0.const([324,108],4,0,20)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.const([180,108],0,0,10)
    {
    Name = ""
    Value = "0.000001"
    }
   0.sumjct([216,72],0,0,120)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([324,72],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.rms-inst([72,72],0,0,100)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "24.9"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   }
  }
 Module("loadBC860")
  {
  Desc = ""
  FileDate = 1151590217
  Nodes = 
   {
   Electrical("B",-36,0)
    {
    }
   Electrical("C",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zbc860")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([270,288],2,0,-1)
    {
    Name = "B"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;0,-126"
    }
   0.datalabel([36,72],0,0,-1)
    {
    Name = "Vbc860"
    }
   0.varrlc([324,396],3,0,170)
    {
    RLC = "0"
    R = "Rbc860"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([234,396],3,0,180)
    {
    RLC = "1"
    R = "R"
    L = "Lbc860"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([432,72],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   0.square([396,72],0,0,120)
    {
    Dim = "1"
    }
   0.mult([504,216],4,0,150)
    {
    }
   0.div([468,72],0,0,130)
    {
    }
   0.const([504,108],4,0,30)
    {
    Name = "P in MW"
    Value = "0.006667"
    }
   0.div([468,180],0,0,160)
    {
    }
   0.emtconst([540,252],4,0,50)
    {
    Name = ""
    Value = "1"
    }
   0.mult([576,216],4,0,140)
    {
    }
   0.const([612,252],4,0,60)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.const([648,216],4,0,40)
    {
    Name = "Q in MVAR"
    Value = "0.004"
    }
   0.datalabel([504,72],0,0,-1)
    {
    Name = "Rbc860"
    }
   0.datalabel([504,180],0,0,-1)
    {
    Name = "Lbc860"
    }
   -Wire-([324,360],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([234,396],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([270,360],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([270,522],0,0,-1)
    {
    Name = "C"
    }
   0.voltmeter([378,288],0,0,70)
    {
    Name = "Vbc860"
    }
   -Wire-([270,288],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([378,324],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   0.hardlimit([144,72],0,0,90)
    {
    UL = "1.2"
    LL = "0.8"
    COM = "Hard_Limit"
    }
   0.mult([288,72],0,0,110)
    {
    }
   0.const([324,108],4,0,20)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.const([180,108],0,0,10)
    {
    Name = ""
    Value = "0.000001"
    }
   0.sumjct([216,72],0,0,100)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([324,72],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.rms-inst([72,72],0,0,80)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "24.9"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   }
  }
 Module("loadCA860")
  {
  Desc = ""
  FileDate = 1151590218
  Nodes = 
   {
   Electrical("C",-36,0)
    {
    }
   Electrical("A",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zca860")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([270,288],2,0,-1)
    {
    Name = "C"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;0,-126"
    }
   0.datalabel([36,72],0,0,-1)
    {
    Name = "Vca860"
    }
   0.varrlc([324,396],3,0,170)
    {
    RLC = "0"
    R = "Rca860"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([234,396],3,0,180)
    {
    RLC = "1"
    R = "R"
    L = "Lca860"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([432,72],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   0.square([396,72],0,0,120)
    {
    Dim = "1"
    }
   0.mult([504,216],4,0,150)
    {
    }
   0.div([468,72],0,0,130)
    {
    }
   0.const([504,108],4,0,30)
    {
    Name = "P in MW"
    Value = "0.028"
    }
   0.div([468,180],0,0,160)
    {
    }
   0.emtconst([540,252],4,0,50)
    {
    Name = ""
    Value = "1"
    }
   0.mult([576,216],4,0,140)
    {
    }
   0.const([612,252],4,0,60)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.const([648,216],4,0,40)
    {
    Name = "Q in MVAR"
    Value = "0.0146667"
    }
   0.datalabel([504,72],0,0,-1)
    {
    Name = "Rca860"
    }
   0.datalabel([504,180],0,0,-1)
    {
    Name = "Lca860"
    }
   -Wire-([324,360],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([234,396],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([270,360],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([270,522],0,0,-1)
    {
    Name = "A"
    }
   0.voltmeter([378,288],0,0,70)
    {
    Name = "Vca860"
    }
   -Wire-([270,288],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([378,324],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   0.hardlimit([144,72],0,0,90)
    {
    UL = "1.2"
    LL = "0.8"
    COM = "Hard_Limit"
    }
   0.mult([288,72],0,0,110)
    {
    }
   0.const([324,108],4,0,20)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.const([180,108],0,0,10)
    {
    Name = ""
    Value = "0.000001"
    }
   0.sumjct([216,72],0,0,100)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([324,72],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.rms-inst([72,72],0,0,80)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "24.9"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   }
  }
 Module("loadAB834")
  {
  Desc = ""
  FileDate = 1151590217
  Nodes = 
   {
   Electrical("A",-36,0)
    {
    }
   Electrical("B",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zab834")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([270,288],2,0,-1)
    {
    Name = "A"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;0,-126"
    }
   0.datalabel([36,72],0,0,-1)
    {
    Name = "Vab834"
    }
   0.varrlc([324,396],3,0,170)
    {
    RLC = "0"
    R = "Rab834"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([234,396],3,0,180)
    {
    RLC = "1"
    R = "R"
    L = "Lab834"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([432,72],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   0.square([396,72],0,0,120)
    {
    Dim = "1"
    }
   0.mult([504,216],4,0,150)
    {
    }
   0.div([468,72],0,0,130)
    {
    }
   0.const([504,108],4,0,30)
    {
    Name = "P in MW"
    Value = "0.0013333"
    }
   0.div([468,180],0,0,160)
    {
    }
   0.emtconst([540,252],4,0,50)
    {
    Name = ""
    Value = "1"
    }
   0.mult([576,216],4,0,140)
    {
    }
   0.const([612,252],4,0,60)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.const([648,216],4,0,40)
    {
    Name = "Q in MVAR"
    Value = "0.0006667"
    }
   0.datalabel([504,72],0,0,-1)
    {
    Name = "Rab834"
    }
   0.datalabel([504,180],0,0,-1)
    {
    Name = "Lab834"
    }
   -Wire-([324,360],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([234,396],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([270,360],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([270,522],0,0,-1)
    {
    Name = "B"
    }
   0.voltmeter([378,288],0,0,70)
    {
    Name = "Vab834"
    }
   -Wire-([270,288],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([378,324],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   0.hardlimit([144,72],0,0,90)
    {
    UL = "1.2"
    LL = "0.8"
    COM = "Hard_Limit"
    }
   0.mult([288,72],0,0,110)
    {
    }
   0.const([324,108],4,0,20)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.const([180,108],0,0,10)
    {
    Name = ""
    Value = "0.000001"
    }
   0.sumjct([216,72],0,0,100)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([324,72],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.rms-inst([72,72],0,0,80)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "24.9"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   }
  }
 Module("loadBC834")
  {
  Desc = ""
  FileDate = 1151590217
  Nodes = 
   {
   Electrical("B",-36,0)
    {
    }
   Electrical("C",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zbc834")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([270,288],2,0,-1)
    {
    Name = "B"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;0,-126"
    }
   0.datalabel([36,72],0,0,-1)
    {
    Name = "Vbc834"
    }
   0.varrlc([324,396],3,0,170)
    {
    RLC = "0"
    R = "Rbc834"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([234,396],3,0,180)
    {
    RLC = "1"
    R = "R"
    L = "Lbc834"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([432,72],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   0.square([396,72],0,0,120)
    {
    Dim = "1"
    }
   0.mult([504,216],4,0,150)
    {
    }
   0.div([468,72],0,0,130)
    {
    }
   0.const([504,108],4,0,30)
    {
    Name = "P in MW"
    Value = "0.005"
    }
   0.div([468,180],0,0,160)
    {
    }
   0.emtconst([540,252],4,0,50)
    {
    Name = ""
    Value = "1"
    }
   0.mult([576,216],4,0,140)
    {
    }
   0.const([612,252],4,0,60)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.const([648,216],4,0,40)
    {
    Name = "Q in MVAR"
    Value = "0.0026667"
    }
   0.datalabel([504,72],0,0,-1)
    {
    Name = "Rbc834"
    }
   0.datalabel([504,180],0,0,-1)
    {
    Name = "Lbc834"
    }
   -Wire-([324,360],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([234,396],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([270,360],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([270,522],0,0,-1)
    {
    Name = "C"
    }
   0.voltmeter([378,288],0,0,70)
    {
    Name = "Vbc834"
    }
   -Wire-([270,288],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([378,324],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   0.hardlimit([144,72],0,0,90)
    {
    UL = "1.2"
    LL = "0.8"
    COM = "Hard_Limit"
    }
   0.mult([288,72],0,0,110)
    {
    }
   0.const([324,108],4,0,20)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.const([180,108],0,0,10)
    {
    Name = ""
    Value = "0.000001"
    }
   0.sumjct([216,72],0,0,100)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([324,72],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.rms-inst([72,72],0,0,80)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "24.9"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   }
  }
 Module("loadCA834")
  {
  Desc = ""
  FileDate = 1151590217
  Nodes = 
   {
   Electrical("C",-36,0)
    {
    }
   Electrical("A",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zca834")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([270,288],2,0,-1)
    {
    Name = "C"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;0,-126"
    }
   0.datalabel([36,72],0,0,-1)
    {
    Name = "Vca834"
    }
   0.varrlc([324,396],3,0,170)
    {
    RLC = "0"
    R = "Rca834"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([234,396],3,0,180)
    {
    RLC = "1"
    R = "R"
    L = "Lca834"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([432,72],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   0.square([396,72],0,0,120)
    {
    Dim = "1"
    }
   0.mult([504,216],4,0,150)
    {
    }
   0.div([468,72],0,0,130)
    {
    }
   0.const([504,108],4,0,30)
    {
    Name = "P in MW"
    Value = "0.0043333"
    }
   0.div([468,180],0,0,160)
    {
    }
   0.emtconst([540,252],4,0,50)
    {
    Name = ""
    Value = "1"
    }
   0.mult([576,216],4,0,140)
    {
    }
   0.const([612,252],4,0,60)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.const([648,216],4,0,40)
    {
    Name = "Q in MVAR"
    Value = "0.0023333"
    }
   0.datalabel([504,72],0,0,-1)
    {
    Name = "Rca834"
    }
   0.datalabel([504,180],0,0,-1)
    {
    Name = "Lca834"
    }
   -Wire-([324,360],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([234,396],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([270,360],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([270,522],0,0,-1)
    {
    Name = "A"
    }
   0.voltmeter([378,288],0,0,70)
    {
    Name = "Vca834"
    }
   -Wire-([270,288],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([378,324],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   0.hardlimit([144,72],0,0,90)
    {
    UL = "1.2"
    LL = "0.8"
    COM = "Hard_Limit"
    }
   0.mult([288,72],0,0,110)
    {
    }
   0.const([324,108],4,0,20)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.const([180,108],0,0,10)
    {
    Name = ""
    Value = "0.000001"
    }
   0.sumjct([216,72],0,0,100)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([324,72],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.rms-inst([72,72],0,0,80)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "24.9"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   }
  }
 Module("loadAB858")
  {
  Desc = ""
  FileDate = 1151590217
  Nodes = 
   {
   Electrical("A",-36,0)
    {
    }
   Electrical("B",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zab858")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([270,288],2,0,-1)
    {
    Name = "A"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;0,-126"
    }
   0.datalabel([36,72],0,0,-1)
    {
    Name = "Vab858"
    }
   0.varrlc([324,396],3,0,170)
    {
    RLC = "0"
    R = "Rab858"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([234,396],3,0,180)
    {
    RLC = "1"
    R = "R"
    L = "Lab858"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([432,72],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   0.square([396,72],0,0,120)
    {
    Dim = "1"
    }
   0.mult([504,216],4,0,150)
    {
    }
   0.div([468,72],0,0,130)
    {
    }
   0.const([504,108],4,0,30)
    {
    Name = "P in MW"
    Value = "0.0026667"
    }
   0.div([468,180],0,0,160)
    {
    }
   0.emtconst([540,252],4,0,50)
    {
    Name = ""
    Value = "1"
    }
   0.mult([576,216],4,0,140)
    {
    }
   0.const([612,252],4,0,60)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.const([648,216],4,0,40)
    {
    Name = "Q in MVAR"
    Value = "0.0013333"
    }
   0.datalabel([504,72],0,0,-1)
    {
    Name = "Rab858"
    }
   0.datalabel([504,180],0,0,-1)
    {
    Name = "Lab858"
    }
   -Wire-([324,360],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([234,396],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([270,360],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([270,522],0,0,-1)
    {
    Name = "B"
    }
   0.voltmeter([378,288],0,0,70)
    {
    Name = "Vab858"
    }
   -Wire-([270,288],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([378,324],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   0.hardlimit([144,72],0,0,90)
    {
    UL = "1.2"
    LL = "0.8"
    COM = "Hard_Limit"
    }
   0.mult([288,72],0,0,110)
    {
    }
   0.const([324,108],4,0,20)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.const([180,108],0,0,10)
    {
    Name = ""
    Value = "0.000001"
    }
   0.sumjct([216,72],0,0,100)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([324,72],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.rms-inst([72,72],0,0,80)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "24.9"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   }
  }
 Module("loadBC858")
  {
  Desc = ""
  FileDate = 1151590217
  Nodes = 
   {
   Electrical("B",-36,0)
    {
    }
   Electrical("C",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zbc858")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([270,288],2,0,-1)
    {
    Name = "B"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;0,-126"
    }
   0.datalabel([36,72],0,0,-1)
    {
    Name = "Vbc858"
    }
   0.varrlc([324,396],3,0,170)
    {
    RLC = "0"
    R = "Rbc858"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([234,396],3,0,180)
    {
    RLC = "1"
    R = "R"
    L = "Lbc858"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([432,72],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   0.square([396,72],0,0,120)
    {
    Dim = "1"
    }
   0.mult([504,216],4,0,150)
    {
    }
   0.div([468,72],0,0,130)
    {
    }
   0.const([504,108],4,0,30)
    {
    Name = "P in MW"
    Value = "0.01"
    }
   0.div([468,180],0,0,160)
    {
    }
   0.emtconst([540,252],4,0,50)
    {
    Name = ""
    Value = "1"
    }
   0.mult([576,216],4,0,140)
    {
    }
   0.const([612,252],4,0,60)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.const([648,216],4,0,40)
    {
    Name = "Q in MVAR"
    Value = "0.0053333"
    }
   0.datalabel([504,72],0,0,-1)
    {
    Name = "Rbc858"
    }
   0.datalabel([504,180],0,0,-1)
    {
    Name = "Lbc858"
    }
   -Wire-([324,360],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([234,396],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([270,360],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([270,522],0,0,-1)
    {
    Name = "C"
    }
   0.voltmeter([378,288],0,0,70)
    {
    Name = "Vbc858"
    }
   -Wire-([270,288],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([378,324],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   0.hardlimit([144,72],0,0,90)
    {
    UL = "1.2"
    LL = "0.8"
    COM = "Hard_Limit"
    }
   0.mult([288,72],0,0,110)
    {
    }
   0.const([324,108],4,0,20)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.const([180,108],0,0,10)
    {
    Name = ""
    Value = "0.000001"
    }
   0.sumjct([216,72],0,0,100)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([324,72],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.rms-inst([72,72],0,0,80)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "24.9"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   }
  }
 Module("loadCA858")
  {
  Desc = ""
  FileDate = 1151590217
  Nodes = 
   {
   Electrical("C",-36,0)
    {
    }
   Electrical("A",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zca858")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([270,288],2,0,-1)
    {
    Name = "C"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;0,-126"
    }
   0.datalabel([36,72],0,0,-1)
    {
    Name = "Vca858"
    }
   0.varrlc([324,396],3,0,170)
    {
    RLC = "0"
    R = "Rca858"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([234,396],3,0,180)
    {
    RLC = "1"
    R = "R"
    L = "Lca858"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([432,72],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   0.square([396,72],0,0,120)
    {
    Dim = "1"
    }
   0.mult([504,216],4,0,150)
    {
    }
   0.div([468,72],0,0,130)
    {
    }
   0.const([504,108],4,0,30)
    {
    Name = "P in MW"
    Value = "0.0086667"
    }
   0.div([468,180],0,0,160)
    {
    }
   0.emtconst([540,252],4,0,50)
    {
    Name = ""
    Value = "1"
    }
   0.mult([576,216],4,0,140)
    {
    }
   0.const([612,252],4,0,60)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.const([648,216],4,0,40)
    {
    Name = "Q in MVAR"
    Value = "0.0046667"
    }
   0.datalabel([504,72],0,0,-1)
    {
    Name = "Rca858"
    }
   0.datalabel([504,180],0,0,-1)
    {
    Name = "Lca858"
    }
   -Wire-([324,360],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([234,396],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([270,360],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([270,522],0,0,-1)
    {
    Name = "A"
    }
   0.voltmeter([378,288],0,0,70)
    {
    Name = "Vca858"
    }
   -Wire-([270,288],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([378,324],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   0.hardlimit([144,72],0,0,90)
    {
    UL = "1.2"
    LL = "0.8"
    COM = "Hard_Limit"
    }
   0.mult([288,72],0,0,110)
    {
    }
   0.const([324,108],4,0,20)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.const([180,108],0,0,10)
    {
    Name = ""
    Value = "0.000001"
    }
   0.sumjct([216,72],0,0,100)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([324,72],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.rms-inst([72,72],0,0,80)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "24.9"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   }
  }
 Module("loadAB830")
  {
  Desc = ""
  FileDate = 1151590220
  Nodes = 
   {
   Electrical("B",36,0)
    {
    }
   Electrical("A",-36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zab830")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([144,162],2,0,-1)
    {
    Name = "A"
    }
   -Wire-([144,396],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([198,234],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([108,324],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([144,234],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([144,396],0,0,-1)
    {
    Name = "B"
    }
   -Wire-([198,270],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([108,324],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.resistor([198,270],3,0,-1)
    {
    R = "62001 [ohm]"
    }
   0.inductor([108,270],3,0,-1)
    {
    L = "329 [H]"
    }
   }
  }
 Module("loadBC830")
  {
  Desc = ""
  FileDate = 1151590220
  Nodes = 
   {
   Electrical("C",36,0)
    {
    }
   Electrical("B",-36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zbc830")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([144,144],2,0,-1)
    {
    Name = "B"
    }
   -Wire-([144,378],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([144,378],0,0,-1)
    {
    Name = "C"
    }
   -Wire-([198,216],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([108,306],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([144,216],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([198,252],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([108,306],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.resistor([198,252],3,0,-1)
    {
    R = "62001 [ohm]"
    }
   0.inductor([108,252],3,0,-1)
    {
    L = "329 [H]"
    }
   }
  }
 Module("loadCA830")
  {
  Desc = ""
  FileDate = 1151590220
  Nodes = 
   {
   Electrical("C",-36,0)
    {
    }
   Electrical("A",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zca830")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([162,252],2,0,-1)
    {
    Name = "C"
    }
   -Wire-([162,486],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([162,486],0,0,-1)
    {
    Name = "A"
    }
   -Wire-([216,324],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([126,414],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([162,324],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([216,360],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([126,414],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.resistor([216,360],3,0,-1)
    {
    R = "24800 [ohm]"
    }
   0.inductor([126,360],3,0,-1)
    {
    L = "164.5 [H]"
    }
   }
  }
 Module("loadCA890")
  {
  Desc = ""
  FileDate = 1151590220
  Nodes = 
   {
   Electrical("C",-36,0)
    {
    }
   Electrical("A",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zca890")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([378,360],2,0,-1)
    {
    Name = "C"
    }
   -Wire-([378,594],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.datalabel([306,216],0,0,-1)
    {
    Name = "Vca890"
    }
   0.varrlc([432,468],3,0,200)
    {
    RLC = "0"
    R = "Rca890"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([342,468],3,0,210)
    {
    RLC = "1"
    R = "R"
    L = "Lca890"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([666,216],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   0.div([702,216],0,0,190)
    {
    }
   0.const([810,252],4,0,30)
    {
    Name = "P in MW"
    Value = "0.15"
    }
   0.div([702,360],0,0,170)
    {
    }
   0.emtconst([936,396],4,0,60)
    {
    Name = ""
    Value = "1"
    }
   0.mult([864,396],4,0,150)
    {
    }
   0.const([900,432],4,0,80)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.const([810,432],4,0,70)
    {
    Name = "Q in MVAR"
    Value = "0.075"
    }
   0.datalabel([738,216],0,0,-1)
    {
    Name = "Rca890"
    }
   0.datalabel([810,360],0,0,-1)
    {
    Name = "Lca890"
    }
   -Wire-([432,432],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([342,522],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([378,432],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([378,594],0,0,-1)
    {
    Name = "A"
    }
   0.voltmeter([486,360],0,0,50)
    {
    Name = "Vca890"
    }
   -Wire-([378,360],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([378,594],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([486,396],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   -Wire-([432,468],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.div([738,252],4,0,140)
    {
    }
   0.const([774,288],4,0,40)
    {
    Name = "V in kV"
    Value = "4.16"
    }
   0.div([738,432],4,0,160)
    {
    }
   0.const([774,468],4,0,90)
    {
    Name = "V in kV"
    Value = "4.16"
    }
   0.div([774,360],0,0,180)
    {
    }
   -Wire-([702,396],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([774,396],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([342,522],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   -Wire-([594,216],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.rms-inst([342,216],0,0,100)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "4.16"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   0.hardlimit([414,216],0,0,110)
    {
    UL = "1.2"
    LL = "0.8"
    COM = "Hard_Limit"
    }
   0.mult([558,216],0,0,130)
    {
    }
   0.const([594,252],4,0,20)
    {
    Name = "V in kV"
    Value = "4.16"
    }
   0.const([450,252],0,0,10)
    {
    Name = ""
    Value = "0.000001"
    }
   0.sumjct([486,216],0,0,120)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   }
  }
 Module("loadBC890")
  {
  Desc = ""
  FileDate = 1151590220
  Nodes = 
   {
   Electrical("B",-36,0)
    {
    }
   Electrical("C",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zbc890")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([252,252],2,0,-1)
    {
    Name = "B"
    }
   -Wire-([252,486],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.datalabel([180,108],0,0,-1)
    {
    Name = "Vbc890"
    }
   0.varrlc([306,360],3,0,200)
    {
    RLC = "0"
    R = "Rbc890"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([216,360],3,0,210)
    {
    RLC = "1"
    R = "R"
    L = "Lbc890"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([540,108],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   0.div([576,108],0,0,190)
    {
    }
   0.const([684,144],4,0,30)
    {
    Name = "P in MW"
    Value = "0.15"
    }
   0.div([576,252],0,0,170)
    {
    }
   0.emtconst([810,288],4,0,60)
    {
    Name = ""
    Value = "1"
    }
   0.mult([738,288],4,0,150)
    {
    }
   0.const([774,324],4,0,80)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.const([684,324],4,0,70)
    {
    Name = "Q in MVAR"
    Value = "0.075"
    }
   0.datalabel([612,108],0,0,-1)
    {
    Name = "Rbc890"
    }
   0.datalabel([684,252],0,0,-1)
    {
    Name = "Lbc890"
    }
   -Wire-([306,324],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([216,414],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([252,324],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([252,486],0,0,-1)
    {
    Name = "C"
    }
   0.voltmeter([360,252],0,0,50)
    {
    Name = "Vbc890"
    }
   -Wire-([252,252],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([252,486],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([360,288],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   -Wire-([306,360],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.div([612,144],4,0,140)
    {
    }
   0.const([648,180],4,0,40)
    {
    Name = "V in kV"
    Value = "4.16"
    }
   0.div([612,324],4,0,160)
    {
    }
   0.const([648,360],4,0,90)
    {
    Name = "V in kV"
    Value = "4.16"
    }
   0.div([648,252],0,0,180)
    {
    }
   -Wire-([576,288],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([648,288],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([216,414],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   -Wire-([468,108],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.rms-inst([216,108],0,0,100)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "4.16"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   0.hardlimit([288,108],0,0,110)
    {
    UL = "1.2"
    LL = "0.8"
    COM = "Hard_Limit"
    }
   0.mult([432,108],0,0,130)
    {
    }
   0.const([468,144],4,0,20)
    {
    Name = "V in kV"
    Value = "4.16"
    }
   0.const([324,144],0,0,10)
    {
    Name = ""
    Value = "0.000001"
    }
   0.sumjct([360,108],0,0,120)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   }
  }
 Module("loadAB890")
  {
  Desc = ""
  FileDate = 1151590219
  Nodes = 
   {
   Electrical("A",-36,0)
    {
    }
   Electrical("B",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zab890")
   }


  Page(A/A4,Landscape,144,[835,483],5)
   {
   0.xnode([162,468],2,0,-1)
    {
    Name = "A"
    }
   -Wire-([162,702],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.varrlc([216,576],3,0,200)
    {
    RLC = "0"
    R = "Rab890"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([126,576],3,0,210)
    {
    RLC = "1"
    R = "R"
    L = "Lab890"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([216,540],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([126,630],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([162,540],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([162,702],0,0,-1)
    {
    Name = "B"
    }
   0.voltmeter([270,468],0,0,10)
    {
    Name = "Vab890"
    }
   -Wire-([162,468],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([162,702],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([270,504],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   -Wire-([216,576],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([126,576],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.rms-inst([468,468],0,0,20)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "4.16"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   0.datalabel([396,468],0,0,-1)
    {
    Name = "Vab890"
    }
   -Wire-([396,468],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.hardlimit([540,468],0,0,30)
    {
    UL = "1.2"
    LL = "0.8"
    COM = "Hard_Limit"
    }
   -Wire-([756,468],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   0.div([792,468],0,0,170)
    {
    }
   0.const([900,504],4,0,60)
    {
    Name = "P in MW"
    Value = "0.15"
    }
   0.div([792,612],0,0,160)
    {
    }
   0.emtconst([1026,648],4,0,80)
    {
    Name = ""
    Value = "1"
    }
   0.mult([954,648],4,0,180)
    {
    }
   0.const([990,684],4,0,100)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.const([900,684],4,0,90)
    {
    Name = "Q in MVAR"
    Value = "0.075"
    }
   0.datalabel([828,468],0,0,-1)
    {
    Name = "Rab890"
    }
   0.datalabel([900,612],0,0,-1)
    {
    Name = "Lab890"
    }
   0.div([828,504],4,0,140)
    {
    }
   0.const([864,540],4,0,70)
    {
    Name = "V in kV"
    Value = "4.16"
    }
   0.div([828,684],4,0,150)
    {
    }
   0.const([864,720],4,0,110)
    {
    Name = "V in kV"
    Value = "4.16"
    }
   0.div([864,612],0,0,190)
    {
    }
   -Wire-([792,648],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([864,648],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([720,468],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.mult([684,468],0,0,130)
    {
    }
   0.const([720,504],4,0,50)
    {
    Name = "V in kV"
    Value = "4.16"
    }
   0.const([576,504],0,0,40)
    {
    Name = ""
    Value = "0.000001"
    }
   0.sumjct([612,468],0,0,120)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   }
  }
 Module("loadCA848")
  {
  Desc = ""
  FileDate = 1151590213
  Nodes = 
   {
   Electrical("C",-36,0)
    {
    }
   Electrical("A",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zca848")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([270,288],2,0,-1)
    {
    Name = "C"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;0,-126"
    }
   0.datalabel([36,72],0,0,-1)
    {
    Name = "Vca848"
    }
   0.varrlc([324,396],3,0,170)
    {
    RLC = "0"
    R = "Rca848"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([234,396],3,0,180)
    {
    RLC = "1"
    R = "R"
    L = "Lca848"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([432,72],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   0.square([396,72],0,0,120)
    {
    Dim = "1"
    }
   0.mult([504,216],4,0,150)
    {
    }
   0.div([468,72],0,0,130)
    {
    }
   0.const([504,108],4,0,30)
    {
    Name = "P in MW"
    Value = "0.02"
    }
   0.div([468,180],0,0,160)
    {
    }
   0.emtconst([540,252],4,0,50)
    {
    Name = ""
    Value = "1"
    }
   0.mult([576,216],4,0,140)
    {
    }
   0.const([612,252],4,0,60)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.const([648,216],4,0,40)
    {
    Name = "Q in MVAR"
    Value = "0.016"
    }
   0.datalabel([504,72],0,0,-1)
    {
    Name = "Rca848"
    }
   0.datalabel([504,180],0,0,-1)
    {
    Name = "Lca848"
    }
   -Wire-([324,360],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([234,396],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([270,360],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([270,522],0,0,-1)
    {
    Name = "A"
    }
   0.voltmeter([378,288],0,0,70)
    {
    Name = "Vca848"
    }
   -Wire-([270,288],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([378,324],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   0.hardlimit([144,72],0,0,90)
    {
    UL = "1.2"
    LL = "0.8"
    COM = "Hard_Limit"
    }
   0.mult([288,72],0,0,110)
    {
    }
   0.const([324,108],4,0,20)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.const([180,108],0,0,10)
    {
    Name = ""
    Value = "0.000001"
    }
   0.sumjct([216,72],0,0,100)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([324,72],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.rms-inst([72,72],0,0,80)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "24.9"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   }
  }
 Module("loadBC848")
  {
  Desc = ""
  FileDate = 1151590213
  Nodes = 
   {
   Electrical("B",-36,0)
    {
    }
   Electrical("C",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zbc848")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([270,288],2,0,-1)
    {
    Name = "B"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;0,-126"
    }
   0.datalabel([36,72],0,0,-1)
    {
    Name = "Vbc848"
    }
   0.varrlc([324,396],3,0,170)
    {
    RLC = "0"
    R = "Rbc848"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([234,396],3,0,180)
    {
    RLC = "1"
    R = "R"
    L = "Lbc848"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([432,72],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   0.square([396,72],0,0,120)
    {
    Dim = "1"
    }
   0.mult([504,216],4,0,150)
    {
    }
   0.div([468,72],0,0,130)
    {
    }
   0.const([504,108],4,0,30)
    {
    Name = "P in MW"
    Value = "0.02"
    }
   0.div([468,180],0,0,160)
    {
    }
   0.emtconst([540,252],4,0,50)
    {
    Name = ""
    Value = "1"
    }
   0.mult([576,216],4,0,140)
    {
    }
   0.const([612,252],4,0,60)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.const([648,216],4,0,40)
    {
    Name = "Q in MVAR"
    Value = "0.016"
    }
   0.datalabel([504,72],0,0,-1)
    {
    Name = "Rbc848"
    }
   0.datalabel([504,180],0,0,-1)
    {
    Name = "Lbc848"
    }
   -Wire-([324,360],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([234,396],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([270,360],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([270,522],0,0,-1)
    {
    Name = "C"
    }
   0.voltmeter([378,288],0,0,70)
    {
    Name = "Vbc848"
    }
   -Wire-([270,288],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([378,324],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   0.hardlimit([144,72],0,0,90)
    {
    UL = "1.2"
    LL = "0.8"
    COM = "Hard_Limit"
    }
   0.mult([288,72],0,0,110)
    {
    }
   0.const([324,108],4,0,20)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.const([180,108],0,0,10)
    {
    Name = ""
    Value = "0.000001"
    }
   0.sumjct([216,72],0,0,100)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([324,72],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.rms-inst([72,72],0,0,80)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "24.9"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   }
  }
 Module("loadAB848")
  {
  Desc = ""
  FileDate = 1151590212
  Nodes = 
   {
   Electrical("A",-36,0)
    {
    }
   Electrical("B",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zab848")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([270,288],2,0,-1)
    {
    Name = "A"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;0,-126"
    }
   0.datalabel([36,72],0,0,-1)
    {
    Name = "Vab848"
    }
   0.varrlc([324,396],3,0,170)
    {
    RLC = "0"
    R = "Rab848"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([234,396],3,0,180)
    {
    RLC = "1"
    R = "R"
    L = "Lab848"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([432,72],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   0.square([396,72],0,0,120)
    {
    Dim = "1"
    }
   0.mult([504,216],4,0,150)
    {
    }
   0.div([468,72],0,0,130)
    {
    }
   0.const([504,108],4,0,30)
    {
    Name = "P in MW"
    Value = "0.02"
    }
   0.div([468,180],0,0,160)
    {
    }
   0.emtconst([540,252],4,0,50)
    {
    Name = ""
    Value = "1"
    }
   0.mult([576,216],4,0,140)
    {
    }
   0.const([612,252],4,0,60)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.const([648,216],4,0,40)
    {
    Name = "Q in MVAR"
    Value = "0.016"
    }
   0.datalabel([504,72],0,0,-1)
    {
    Name = "Rab848"
    }
   0.datalabel([504,180],0,0,-1)
    {
    Name = "Lab848"
    }
   -Wire-([324,360],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([234,396],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([270,360],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([270,522],0,0,-1)
    {
    Name = "B"
    }
   0.voltmeter([378,288],0,0,70)
    {
    Name = "Vab848"
    }
   -Wire-([270,288],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([378,324],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   0.hardlimit([144,72],0,0,90)
    {
    UL = "1.2"
    LL = "0.8"
    COM = "Hard_Limit"
    }
   0.mult([288,72],0,0,110)
    {
    }
   0.const([324,108],4,0,20)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.const([180,108],0,0,10)
    {
    Name = ""
    Value = "0.000001"
    }
   0.sumjct([216,72],0,0,100)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([324,72],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.rms-inst([72,72],0,0,80)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "24.9"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   }
  }
 Module("WG1_1")
  {
  Desc = ""
  FileDate = 1151593211
  Nodes = 
   {
   Electrical("e1",-54,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Ellipse(-34,-34,36,34)
   Text(0,4,"WG2")
   Pen(ByNode,ByNode,ByNode,e1)
   Line(-54,0,-34,0)
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([810,414],0,0,-1)
    {
    Name = "e1"
    }
   -Wire-([738,414],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.xfmr-3p2w([594,414],4,0,-1)
    {
    Name = "T32"
    Tmva = "0.75 [MVA]"
    f = "60.0 [Hz]"
    YD1 = "0"
    YD2 = "0"
    Lead = "2"
    Xl = "0.05 [p.u.]"
    Ideal = "0"
    NLL = "0.0 [pu]"
    CuL = "0.01 [pu]"
    Tap = "0"
    View = "1"
    Dtls = "0"
    V1 = "4.16 [kV]"
    V2 = "0.48 [kV]"
    Enab = "0"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [sec]"
    Xknee = "1.25 [pu]"
    Txk = "0.1 [sec]"
    Im1 = "0.4 [%]"
    ILA1 = ""
    ILB1 = ""
    ILC1 = ""
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = ""
    ILB2 = ""
    ILC2 = ""
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   0.ground([612,450],7,0,-1)
    {
    }
   0.ground([594,450],7,0,-1)
    {
    }
   0.compare([198,414],0,0,50)
    {
    X = "0.2"
    OL = "1"
    OH = "0"
    INTR = "0"
    }
   0.time-sig([126,414],0,0,40)
    {
    }
   -Wire-([234,450],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.const([198,360],0,0,20)
    {
    Name = ""
    Value = "1.0"
    }
   -Wire-([234,360],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.multimeter([378,414],0,0,60)
    {
    MeasI = "0"
    MeasV = "0"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = "PG2"
    Q = ""
    Vrms = "VG2rms"
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.06955"
    Qd = "-0.2891"
    Vd = "0.1705"
    }
   0.wound_rotor([288,414],0,0,190)
    {
    Name = "G2"
    Pbase = "660 [kVA]"
    Vbase = "480 [V]"
    OMEG = "376.99 [rad/s]"
    TRN = "1"
    J = "5 [s]"
    D = "0.001 [pu]"
    View = "1"
    ERC = "1"
    MM = "0"
    SNP = "1"
    Cage = "0"
    NCW = "1"
    Msat = "0"
    Lsat = "0"
    R1 = "0.0053 [pu]"
    R2 = "0.007 [pu]"
    R3 = "0.298 [pu]"
    R4 = "0.018 [pu]"
    R5 = "0.018 [pu]"
    Xmd = "4 [pu]"
    Xa = "0.106 [pu]"
    Xkd1 = "0.12 [pu]"
    Xkd2 = "0.05 [pu]"
    Xkd3 = "0.05 [pu]"
    Xkd4 = "0.05 [pu]"
    Xkd12 = "0.02 [pu]"
    Xkd13 = "0.02 [pu]"
    Xkd14 = "0.02 [pu]"
    Xkd23 = "0.02 [pu]"
    Xkd24 = "0.02 [pu]"
    Xkd34 = "0.02 [pu]"
    I1M = "0.0 [pu]"
    V1M = "0.0 [pu]"
    I2M = "0.5 [pu]"
    V2M = "0.5 [pu]"
    I3M = "0.8 [pu]"
    V3M = "0.79 [pu]"
    I4M = "1.0 [pu]"
    V4M = "0.947 [pu]"
    I5M = "1.2 [pu]"
    V5M = "1.076 [pu]"
    I6M = "1.5 [pu]"
    V6M = "1.2 [pu]"
    I7M = "1.8 [pu]"
    V7M = "1.26 [pu]"
    I8M = "2.2 [pu]"
    V8M = "1.32 [pu]"
    I9M = "3.2 [pu]"
    V9M = "1.42 [pu]"
    I10M = "4.2 [pu]"
    V10M = "1.5 [pu]"
    I1 = "0.0 [pu]"
    V1 = "0.0 [pu]"
    I2 = "1.196 [pu]"
    V2 = "0.286 [pu]"
    I3 = "1.82 [pu]"
    V3 = "0.4 [pu]"
    I4 = "2.861 [pu]"
    V4 = "0.564 [pu]"
    I5 = "5.882 [pu]"
    V5 = "0.981 [pu]"
    I6 = "-1.0 [pu]"
    V6 = "-1.0 [pu]"
    I7 = "-1.0 [pu]"
    V7 = "-1.0 [pu]"
    I8 = "-1.0 [pu]"
    V8 = "-1.0 [pu]"
    I9 = "-1.0 [pu]"
    V9 = "-1.0 [pu]"
    I10 = "-1.0 [pu]"
    V10 = "-1.0 [pu]"
    MSF = ""
    LSF = ""
    Spd = "w2"
    Tel = "Te2"
    TmOp = ""
    ThetaR = ""
    }
   0.short([288,324],3,0,-1)
    {
    }
   0.breaker3([702,414],4,0,90)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "0"
    NAME = "BRK"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = ""
    IBRB = ""
    IBRC = ""
    IBR0 = ""
    SBRA = ""
    SBRB = ""
    SBRC = ""
    BP = ""
    BQ = ""
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "0 [MW]"
    Q = "0 [MVAR]"
    }
   0.tbreakn([684,342],4,0,30)
    {
    NUMS = "1"
    INIT = "1"
    TO1 = "0.2"
    TO2 = "1.05 [s]"
    }
   -Wire-([756,342],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.datalabel([756,342],4,0,-1)
    {
    Name = "BRK"
    }
   -Wire-([648,414],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.ammeter([504,414],0,0,80)
    {
    Name = "IG2"
    }
   -Wire-([432,414],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.ammeter([288,324],1,0,10)
    {
    Name = "IG2r"
    }
   .MetersG2([450,414],0,0,70)
    {
    }
   0.datalabel([126,504],6,0,-1)
    {
    Name = "w2"
    }
   0.datalabel([108,504],6,0,-1)
    {
    Name = "PG2"
    }
   -Wire-([342,414],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([468,414],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([540,414],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([198,630],0,0,-1)
    {
    Name = "w2"
    }
   -Wire-([198,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([234,630],0,48766608,290)
    {
    Name = "w2"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "1.0"
    Max = "1.03"
    }
   -Wire-([234,468],0,0,-1)
    {
    Vertex="0,0;0,90;-54,90"
    }
   0.pgb([234,558],0,48187240,320)
    {
    Name = "Tm2"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([198,594],0,0,-1)
    {
    Name = "Te2"
    }
   -Wire-([198,594],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([234,594],0,48189920,310)
    {
    Name = "Te2"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([198,666],0,0,-1)
    {
    Name = "VG2rms"
    }
   -Wire-([198,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([234,666],0,79488848,110)
    {
    Name = "VG2rms"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "1.0"
    Max = "1.03"
    }
   .Wind_Turbine([126,558],0,0,180)
    {
    }
   0.fft([1062,684],0,0,250)
    {
    Type = "4"
    Size = "0"
    F = "60.0 [Hz]"
    AMod = "0"
    PMod = "0"
    PModCS = "0"
    Filt = "1"
    Track = "0"
    Enab = "1"
    Fout = ""
    }
   0.datatap([990,648],0,0,120)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([990,684],0,0,130)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([990,720],0,0,140)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([972,522],0,0,-1)
    {
    Vertex="0,0;0,180"
    }
   0.datalabel([972,522],6,0,-1)
    {
    Name = "IG2"
    }
   0.datatap([1044,594],3,0,270)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1080,594],3,0,260)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.pgb([1080,558],0,48796704,280)
    {
    Name = "IG22"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "0.4"
    }
   0.pgb([1044,522],0,48798600,300)
    {
    Name = "IG21"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   -Wire-([1080,594],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([1044,594],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.pgb([972,558],0,48854456,100)
    {
    Name = "IG2"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.fft([1062,954],0,0,200)
    {
    Type = "4"
    Size = "0"
    F = "60.0 [Hz]"
    AMod = "0"
    PMod = "0"
    PModCS = "0"
    Filt = "1"
    Track = "0"
    Enab = "1"
    Fout = ""
    }
   0.datatap([990,918],0,0,150)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([990,954],0,0,160)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([990,990],0,0,170)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([972,828],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   0.datalabel([972,828],6,0,-1)
    {
    Name = "IG2r"
    }
   0.datatap([1044,864],3,0,220)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1080,864],3,0,210)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.pgb([1080,828],0,48843072,230)
    {
    Name = "IG2r2"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "0.4"
    }
   0.pgb([1044,792],0,48844968,240)
    {
    Name = "IG2r1"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   -Wire-([1080,864],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([1044,864],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Plot-([306,522],0)
    {
    Title = "Generator at Bus 890"
    Draw = 1
    Area = [0,0,486,576]
    Posn = [306,522]
    Icon = [3096,1908]
    Extents = 0,0,486,576
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,486,103],"Torque (pu)")
     {
     Options = 0
     Units = ""
     Curve(48187240,"Tm2",0,,,)
     Curve(48189920,"Te2",0,,,)
     }
    Graph([0,103],[0,0,486,103],"Torque (PU)")
     {
     Options = 0
     Units = ""
     Curve(48187240,"Tm2",0,,,)
     }
    Graph([0,206],[0,0,486,103],"Speed (PU)")
     {
     Options = 0
     Units = ""
     Curve(48766608,"w2",0,,,)
     }
    Graph([0,309],[0,0,486,102],"y")
     {
     Options = 128
     Units = ""
     Curve(79488848,"VG2rms",0,,,)
     }
    Graph([0,411],[0,0,486,102],"Current (kA)")
     {
     Options = 0
     Units = ""
     Curve(48854456,"IG2",0,,-7,)
     }
    }
   }
  }
 Module("WG1")
  {
  Desc = ""
  FileDate = 1151593211
  Nodes = 
   {
   Electrical("e1",-54,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Ellipse(-34,-34,36,34)
   Text(0,4,"WG1")
   Pen(ByNode,ByNode,ByNode,e1)
   Line(-54,0,-34,0)
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([727,377],0,0,-1)
    {
    Name = "e1"
    }
   0.const([115,431],0,0,80)
    {
    Name = ""
    Value = "-1"
    }
   0.compare([115,377],6,0,40)
    {
    X = "0.1"
    OL = "1"
    OH = "0"
    INTR = "0"
    }
   0.time-sig([43,377],0,0,30)
    {
    }
   -Wire-([151,341],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.const([115,323],0,0,20)
    {
    Name = ""
    Value = "1.0"
    }
   -Wire-([151,431],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.wound_rotor([205,377],0,0,190)
    {
    Name = "G1"
    Pbase = "660 [kVA]"
    Vbase = "480 [V]"
    OMEG = "376.99 [rad/s]"
    TRN = "1"
    J = "2 [s]"
    D = "0.001 [pu]"
    View = "1"
    ERC = "1"
    MM = "0"
    SNP = "1"
    Cage = "0"
    NCW = "1"
    Msat = "0"
    Lsat = "0"
    R1 = "0.0053 [pu]"
    R2 = "0.007 [pu]"
    R3 = "0.298 [pu]"
    R4 = "0.018 [pu]"
    R5 = "0.018 [pu]"
    Xmd = "4 [pu]"
    Xa = "0.106 [pu]"
    Xkd1 = "0.12 [pu]"
    Xkd2 = "0.05 [pu]"
    Xkd3 = "0.05 [pu]"
    Xkd4 = "0.05 [pu]"
    Xkd12 = "0.02 [pu]"
    Xkd13 = "0.02 [pu]"
    Xkd14 = "0.02 [pu]"
    Xkd23 = "0.02 [pu]"
    Xkd24 = "0.02 [pu]"
    Xkd34 = "0.02 [pu]"
    I1M = "0.0 [pu]"
    V1M = "0.0 [pu]"
    I2M = "0.5 [pu]"
    V2M = "0.5 [pu]"
    I3M = "0.8 [pu]"
    V3M = "0.79 [pu]"
    I4M = "1.0 [pu]"
    V4M = "0.947 [pu]"
    I5M = "1.2 [pu]"
    V5M = "1.076 [pu]"
    I6M = "1.5 [pu]"
    V6M = "1.2 [pu]"
    I7M = "1.8 [pu]"
    V7M = "1.26 [pu]"
    I8M = "2.2 [pu]"
    V8M = "1.32 [pu]"
    I9M = "3.2 [pu]"
    V9M = "1.42 [pu]"
    I10M = "4.2 [pu]"
    V10M = "1.5 [pu]"
    I1 = "0.0 [pu]"
    V1 = "0.0 [pu]"
    I2 = "1.196 [pu]"
    V2 = "0.286 [pu]"
    I3 = "1.82 [pu]"
    V3 = "0.4 [pu]"
    I4 = "2.861 [pu]"
    V4 = "0.564 [pu]"
    I5 = "5.882 [pu]"
    V5 = "0.981 [pu]"
    I6 = "-1.0 [pu]"
    V6 = "-1.0 [pu]"
    I7 = "-1.0 [pu]"
    V7 = "-1.0 [pu]"
    I8 = "-1.0 [pu]"
    V8 = "-1.0 [pu]"
    I9 = "-1.0 [pu]"
    V9 = "-1.0 [pu]"
    I10 = "-1.0 [pu]"
    V10 = "-1.0 [pu]"
    MSF = ""
    LSF = ""
    Spd = "w1"
    Tel = ""
    TmOp = ""
    ThetaR = ""
    }
   0.short([205,287],3,0,-1)
    {
    }
   0.ammeter([259,377],0,0,50)
    {
    Name = "IG1"
    }
   0.ammeter([205,287],1,0,10)
    {
    Name = "IG1r"
    }
   0.multimeter([331,377],0,0,60)
    {
    MeasI = "0"
    MeasV = "0"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = "PG1"
    Q = "QG1"
    Vrms = "VG1rms"
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.05434"
    Qd = "-0.6452"
    Vd = "0.2639"
    }
   -Wire-([295,377],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([97,485],0,0,-1)
    {
    Name = "w1"
    }
   -Wire-([97,485],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([133,485],0,79490504,300)
    {
    Name = "w1"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "1.0"
    Max = "1.03"
    }
   0.datalabel([97,521],0,0,-1)
    {
    Name = "VG1rms"
    }
   -Wire-([97,521],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([133,521],0,50454536,90)
    {
    Name = "VG1rms"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "1.0"
    Max = "1.03"
    }
   0.datalabel([97,557],0,0,-1)
    {
    Name = "PG1"
    }
   -Wire-([97,557],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([133,557],0,72164232,100)
    {
    Name = "PG1"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "1.0"
    Max = "1.03"
    }
   0.datalabel([97,593],0,0,-1)
    {
    Name = "QG1"
    }
   -Wire-([97,593],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([133,593],0,84478568,110)
    {
    Name = "QG1"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "1.0"
    Max = "1.03"
    }
   -Plot-([25,683],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,576,522]
    Posn = [72,576]
    Icon = [4266,126]
    Extents = 0,0,576,522
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,576,115],"y")
     {
     Options = 128
     Units = ""
     Curve(50454536,"VG1rms",0,,,)
     }
    Graph([0,115],[0,0,576,115],"y")
     {
     Options = 128
     Units = ""
     Curve(48852728,"IG1",0,,,)
     }
    Graph([0,230],[0,0,576,115],"y")
     {
     Options = 128
     Units = ""
     Curve(72164232,"PG1",0,,,)
     }
    Graph([0,345],[0,0,576,114],"y")
     {
     Options = 128
     Units = ""
     Curve(84478568,"QG1",0,,,)
     }
    }
   0.fft([997,791],0,0,250)
    {
    Type = "4"
    Size = "0"
    F = "60.0 [Hz]"
    AMod = "0"
    PMod = "0"
    PModCS = "0"
    Filt = "1"
    Track = "0"
    Enab = "1"
    Fout = ""
    }
   0.datatap([925,755],0,0,130)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([925,791],0,0,140)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([925,827],0,0,150)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([907,629],0,0,-1)
    {
    Vertex="0,0;0,180"
    }
   0.datalabel([907,629],6,0,-1)
    {
    Name = "IG1"
    }
   0.datatap([979,701],3,0,270)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1015,701],3,0,260)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.pgb([1015,665],0,48787624,280)
    {
    Name = "IG12"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "0.4"
    }
   0.pgb([979,629],0,48789520,290)
    {
    Name = "IG11"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   -Wire-([1015,701],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([979,701],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([907,665],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.pgb([925,665],0,48852728,120)
    {
    Name = "IG1"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([349,377],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.fft([997,1097],0,0,200)
    {
    Type = "4"
    Size = "0"
    F = "60.0 [Hz]"
    AMod = "0"
    PMod = "0"
    PModCS = "0"
    Filt = "1"
    Track = "0"
    Enab = "1"
    Fout = ""
    }
   0.datatap([925,1061],0,0,160)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([925,1097],0,0,170)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([925,1133],0,0,180)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([907,917],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   0.datalabel([907,917],6,0,-1)
    {
    Name = "IG1r"
    }
   0.datatap([979,1007],3,0,220)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1015,1007],3,0,210)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.pgb([1015,971],0,48833904,230)
    {
    Name = "IG1r2"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "0.4"
    }
   0.pgb([979,935],0,48835888,240)
    {
    Name = "IG1r1"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   -Wire-([1015,1007],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([979,1007],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xfmr-3p2w([547,377],4,0,-1)
    {
    Name = "T32"
    Tmva = "0.75 [MVA]"
    f = "60.0 [Hz]"
    YD1 = "0"
    YD2 = "0"
    Lead = "2"
    Xl = "0.05 [p.u.]"
    Ideal = "0"
    NLL = "0.0 [pu]"
    CuL = "0.01 [pu]"
    Tap = "0"
    View = "1"
    Dtls = "0"
    V1 = "24.9 [kV]"
    V2 = "0.48 [kV]"
    Enab = "0"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [sec]"
    Xknee = "1.25 [pu]"
    Txk = "0.1 [sec]"
    Im1 = "0.4 [%]"
    ILA1 = ""
    ILB1 = ""
    ILC1 = ""
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = ""
    ILB2 = ""
    ILC2 = ""
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   0.ground([565,413],7,0,-1)
    {
    }
   0.ground([547,413],7,0,-1)
    {
    }
   -Wire-([511,377],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   .MetersG1([475,377],4,0,70)
    {
    }
   -Wire-([601,377],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Plot-([1098,828],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,450,342]
    Posn = [1098,828]
    Icon = [666,540]
    Extents = 0,0,450,342
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,450,140],"y")
     {
     Options = 128
     Units = ""
     Curve(48835888,"IG1r1",0,,,)
     }
    Graph([0,140],[0,0,450,139],"y")
     {
     Options = 128
     Units = ""
     Curve(48833904,"IG1r2",0,,,)
     }
    }
   }
  }
 Module("Meters836_862")
  {
  Desc = "Branch 836 to 862"
  FileDate = 1151590219
  Nodes = 
   {
   Electrical("Left",-18,0)
    {
    Dim  = [3]
    }
   Electrical("Right",18,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-10,-12,11,9)
   Pen(ByNode,ByNode,ByNode,Left)
   Line(-18,0,-9,0)
   Pen(,,,Right)
   Line(18,0,12,0)
   Pen(Black,Solid,0.2)
   Arc(-8,-8,9,-2,0,90)
   Arc(-7,-8,10,-2,540,-90)
   Line(0,6,4,-6)
   Text(1,20,"PQ")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([90,234],0,0,-1)
    {
    Name = "Left"
    }
   0.xnode([522,234],0,0,-1)
    {
    Name = "Right"
    }
   0.multimeter([216,126],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0"
    Qd = "0"
    Vd = "0.0004682"
    }
   0.breakout([126,234],0,0,-1)
    {
    Dis = "0"
    }
   0.breakout([468,234],4,0,-1)
    {
    Dis = "0"
    }
   0.multimeter([306,234],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "-0.04585"
    Qd = "-0.02199"
    Vd = "1.026"
    }
   0.multimeter([360,342],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0"
    Qd = "0"
    Vd = "0.8264"
    }
   -Wire-([324,234],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([90,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([378,342],0,0,-1)
    {
    Vertex="0,0;54,0;54,-72"
    }
   -Wire-([162,270],0,0,-1)
    {
    Vertex="0,0;0,72;180,72"
    }
   -Wire-([162,234],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([162,198],0,0,-1)
    {
    Vertex="0,0;0,-72;36,-72"
    }
   -Wire-([234,126],0,0,-1)
    {
    Vertex="0,0;198,0;198,72"
    }
   -Wire-([468,234],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   }
  }
 Module("Meters888_890")
  {
  Desc = "Branch 888 to 890"
  FileDate = 1151590219
  Nodes = 
   {
   Electrical("Left",-18,0)
    {
    Dim  = [3]
    }
   Electrical("Right",18,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-10,-12,11,9)
   Pen(ByNode,ByNode,ByNode,Left)
   Line(-18,0,-9,0)
   Pen(,,,Right)
   Line(18,0,12,0)
   Pen(Black,Solid,0.2)
   Arc(-8,-8,9,-2,0,90)
   Arc(-7,-8,10,-2,540,-90)
   Line(0,6,4,-6)
   Text(1,20,"PQ")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([90,234],0,0,-1)
    {
    Name = "Left"
    }
   0.xnode([522,234],0,0,-1)
    {
    Name = "Right"
    }
   0.multimeter([216,126],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.004723"
    Qd = "0.09731"
    Vd = "0.05278"
    }
   0.breakout([126,234],0,0,-1)
    {
    Dis = "0"
    }
   0.breakout([468,234],4,0,-1)
    {
    Dis = "0"
    }
   0.multimeter([306,234],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.01214"
    Qd = "0.1293"
    Vd = "0.06481"
    }
   0.multimeter([360,342],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.03498"
    Qd = "0.2618"
    Vd = "0.0888"
    }
   -Wire-([324,234],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([90,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([378,342],0,0,-1)
    {
    Vertex="0,0;54,0;54,-72"
    }
   -Wire-([162,270],0,0,-1)
    {
    Vertex="0,0;0,72;180,72"
    }
   -Wire-([162,234],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([162,198],0,0,-1)
    {
    Vertex="0,0;0,-72;36,-72"
    }
   -Wire-([234,126],0,0,-1)
    {
    Vertex="0,0;198,0;198,72"
    }
   -Wire-([468,234],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   }
  }
 Module("Meters834_842")
  {
  Desc = "Branch 834 to 842"
  FileDate = 1151590216
  Nodes = 
   {
   Electrical("Left",-18,0)
    {
    Dim  = [3]
    }
   Electrical("Right",18,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-10,-12,11,9)
   Pen(ByNode,ByNode,ByNode,Left)
   Line(-18,0,-9,0)
   Pen(,,,Right)
   Line(18,0,12,0)
   Pen(Black,Solid,0.2)
   Arc(-8,-8,9,-2,0,90)
   Arc(-7,-8,10,-2,540,-90)
   Line(0,6,4,-6)
   Text(1,20,"PQ")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([90,234],0,0,-1)
    {
    Name = "Left"
    }
   0.xnode([522,234],0,0,-1)
    {
    Name = "Right"
    }
   0.multimeter([216,126],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "-2.303e-006"
    Qd = "8.67e-006"
    Vd = "1.483e-006"
    }
   0.breakout([126,234],0,0,-1)
    {
    Dis = "0"
    }
   0.breakout([468,234],4,0,-1)
    {
    Dis = "0"
    }
   0.multimeter([306,234],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.1102"
    Qd = "0.956"
    Vd = "1.027"
    }
   0.multimeter([360,342],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.3023"
    Qd = "0.5635"
    Vd = "0.8268"
    }
   -Wire-([324,234],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([90,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([378,342],0,0,-1)
    {
    Vertex="0,0;54,0;54,-72"
    }
   -Wire-([162,270],0,0,-1)
    {
    Vertex="0,0;0,72;180,72"
    }
   -Wire-([162,234],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([162,198],0,0,-1)
    {
    Vertex="0,0;0,-72;36,-72"
    }
   -Wire-([234,126],0,0,-1)
    {
    Vertex="0,0;198,0;198,72"
    }
   -Wire-([468,234],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   }
  }
 Module("Meters834_860")
  {
  Desc = "Branch 834 to 860"
  FileDate = 1151590216
  Nodes = 
   {
   Electrical("Left",-18,0)
    {
    Dim  = [3]
    }
   Electrical("Right",18,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-10,-12,11,9)
   Pen(ByNode,ByNode,ByNode,Left)
   Line(-18,0,-9,0)
   Pen(,,,Right)
   Line(18,0,12,0)
   Pen(Black,Solid,0.2)
   Arc(-8,-8,9,-2,0,90)
   Arc(-7,-8,10,-2,540,-90)
   Line(0,6,4,-6)
   Text(1,20,"PQ")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([90,234],0,0,-1)
    {
    Name = "Left"
    }
   0.xnode([522,234],0,0,-1)
    {
    Name = "Right"
    }
   0.multimeter([216,126],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "9.724e-006"
    Qd = "8.189e-006"
    Vd = "1.483e-006"
    }
   0.breakout([126,234],0,0,-1)
    {
    Dis = "0"
    }
   0.breakout([468,234],4,0,-1)
    {
    Dis = "0"
    }
   0.multimeter([306,234],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.1541"
    Qd = "0.06975"
    Vd = "1.027"
    }
   0.multimeter([360,342],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.07991"
    Qd = "0.06972"
    Vd = "0.8268"
    }
   -Wire-([324,234],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([90,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([378,342],0,0,-1)
    {
    Vertex="0,0;54,0;54,-72"
    }
   -Wire-([162,270],0,0,-1)
    {
    Vertex="0,0;0,72;180,72"
    }
   -Wire-([162,234],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([162,198],0,0,-1)
    {
    Vertex="0,0;0,-72;36,-72"
    }
   -Wire-([234,126],0,0,-1)
    {
    Vertex="0,0;198,0;198,72"
    }
   -Wire-([468,234],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   }
  }
 Module("Meters858_834")
  {
  Desc = "Branch 858 to 834"
  FileDate = 1151590216
  Nodes = 
   {
   Electrical("Left",-18,0)
    {
    Dim  = [3]
    }
   Electrical("Right",18,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-10,-12,11,9)
   Pen(ByNode,ByNode,ByNode,Left)
   Line(-18,0,-9,0)
   Pen(,,,Right)
   Line(18,0,12,0)
   Pen(Black,Solid,0.2)
   Arc(-8,-8,9,-2,0,90)
   Arc(-7,-8,10,-2,540,-90)
   Line(0,6,4,-6)
   Text(1,20,"PQ")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([90,234],0,0,-1)
    {
    Name = "Left"
    }
   0.xnode([522,234],0,0,-1)
    {
    Name = "Right"
    }
   0.multimeter([216,126],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.07964"
    Qd = "0.05063"
    Vd = "0.03261"
    }
   0.breakout([126,234],0,0,-1)
    {
    Dis = "0"
    }
   0.breakout([468,234],4,0,-1)
    {
    Dis = "0"
    }
   0.multimeter([306,234],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.2841"
    Qd = "1.026"
    Vd = "1.029"
    }
   0.multimeter([360,342],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.402"
    Qd = "0.6442"
    Vd = "0.8337"
    }
   -Wire-([324,234],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([90,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([378,342],0,0,-1)
    {
    Vertex="0,0;54,0;54,-72"
    }
   -Wire-([162,270],0,0,-1)
    {
    Vertex="0,0;0,72;180,72"
    }
   -Wire-([162,234],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([162,198],0,0,-1)
    {
    Vertex="0,0;0,-72;36,-72"
    }
   -Wire-([234,126],0,0,-1)
    {
    Vertex="0,0;198,0;198,72"
    }
   -Wire-([468,234],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   }
  }
 Module("Meters832_858")
  {
  Desc = "Branch 832 to 858"
  FileDate = 1151590218
  Nodes = 
   {
   Electrical("Left",-18,0)
    {
    Dim  = [3]
    }
   Electrical("Right",18,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-10,-12,11,9)
   Pen(ByNode,ByNode,ByNode,Left)
   Line(-18,0,-9,0)
   Pen(,,,Right)
   Line(18,0,12,0)
   Pen(Black,Solid,0.2)
   Arc(-8,-8,9,-2,0,90)
   Arc(-7,-8,10,-2,540,-90)
   Line(0,6,4,-6)
   Text(1,20,"PQ")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([90,234],0,0,-1)
    {
    Name = "Left"
    }
   0.xnode([522,234],0,0,-1)
    {
    Name = "Right"
    }
   0.multimeter([216,126],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.1468"
    Qd = "0.09318"
    Vd = "0.06006"
    }
   0.breakout([126,234],0,0,-1)
    {
    Dis = "0"
    }
   0.breakout([468,234],4,0,-1)
    {
    Dis = "0"
    }
   0.multimeter([306,234],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.2921"
    Qd = "1.026"
    Vd = "1.03"
    }
   0.multimeter([360,342],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.4133"
    Qd = "0.6464"
    Vd = "0.8397"
    }
   -Wire-([324,234],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([90,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([378,342],0,0,-1)
    {
    Vertex="0,0;54,0;54,-72"
    }
   -Wire-([162,270],0,0,-1)
    {
    Vertex="0,0;0,72;180,72"
    }
   -Wire-([162,234],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([162,198],0,0,-1)
    {
    Vertex="0,0;0,-72;36,-72"
    }
   -Wire-([234,126],0,0,-1)
    {
    Vertex="0,0;198,0;198,72"
    }
   -Wire-([468,234],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   }
  }
 Module("Meters832_888")
  {
  Desc = "Branch 832 to 888"
  FileDate = 1151590219
  Nodes = 
   {
   Electrical("Left",-18,0)
    {
    Dim  = [3]
    }
   Electrical("Right",18,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-10,-12,11,9)
   Pen(ByNode,ByNode,ByNode,Left)
   Line(-18,0,-9,0)
   Pen(,,,Right)
   Line(18,0,12,0)
   Pen(Black,Solid,0.2)
   Arc(-8,-8,9,-2,0,90)
   Arc(-7,-8,10,-2,540,-90)
   Line(0,6,4,-6)
   Text(1,20,"PQ")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([90,234],0,0,-1)
    {
    Name = "Left"
    }
   0.xnode([522,234],0,0,-1)
    {
    Name = "Right"
    }
   0.multimeter([216,126],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.009162"
    Qd = "0.01121"
    Vd = "0.06006"
    }
   0.breakout([126,234],0,0,-1)
    {
    Dis = "0"
    }
   0.breakout([468,234],4,0,-1)
    {
    Dis = "0"
    }
   0.multimeter([306,234],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.2917"
    Qd = "0.3617"
    Vd = "1.03"
    }
   0.multimeter([360,342],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "-0.02246"
    Qd = "0.3648"
    Vd = "0.8397"
    }
   -Wire-([324,234],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([90,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([378,342],0,0,-1)
    {
    Vertex="0,0;54,0;54,-72"
    }
   -Wire-([162,270],0,0,-1)
    {
    Vertex="0,0;0,72;180,72"
    }
   -Wire-([162,234],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([162,198],0,0,-1)
    {
    Vertex="0,0;0,-72;36,-72"
    }
   -Wire-([234,126],0,0,-1)
    {
    Vertex="0,0;198,0;198,72"
    }
   -Wire-([468,234],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   }
  }
 Module("Meters852_832")
  {
  Desc = "Branch 852 to 832"
  FileDate = 1151590220
  Nodes = 
   {
   Electrical("Left",-18,0)
    {
    Dim  = [3]
    }
   Electrical("Right",18,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-10,-12,11,9)
   Pen(ByNode,ByNode,ByNode,Left)
   Line(-18,0,-9,0)
   Pen(,,,Right)
   Line(18,0,12,0)
   Pen(Black,Solid,0.2)
   Arc(-8,-8,9,-2,0,90)
   Arc(-7,-8,10,-2,540,-90)
   Line(0,6,4,-6)
   Text(1,20,"PQ")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([90,234],0,0,-1)
    {
    Name = "Left"
    }
   0.xnode([522,234],0,0,-1)
    {
    Name = "Right"
    }
   0.multimeter([216,126],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.1562"
    Qd = "0.1045"
    Vd = "0.05561"
    }
   0.breakout([126,234],0,0,-1)
    {
    Dis = "0"
    }
   0.breakout([468,234],4,0,-1)
    {
    Dis = "0"
    }
   0.multimeter([306,234],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.5837"
    Qd = "1.39"
    Vd = "0.9525"
    }
   0.multimeter([360,342],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.3909"
    Qd = "1.012"
    Vd = "0.7766"
    }
   -Wire-([324,234],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([90,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([378,342],0,0,-1)
    {
    Vertex="0,0;54,0;54,-72"
    }
   -Wire-([162,270],0,0,-1)
    {
    Vertex="0,0;0,72;180,72"
    }
   -Wire-([162,234],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([162,198],0,0,-1)
    {
    Vertex="0,0;0,-72;36,-72"
    }
   -Wire-([234,126],0,0,-1)
    {
    Vertex="0,0;198,0;198,72"
    }
   -Wire-([468,234],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   }
  }
 Module("Meters828_830")
  {
  Desc = "Branch 828 to 830"
  FileDate = 1151590220
  Nodes = 
   {
   Electrical("Left",-18,0)
    {
    Dim  = [3]
    }
   Electrical("Right",18,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-10,-12,11,9)
   Pen(ByNode,ByNode,ByNode,Left)
   Line(-18,0,-9,0)
   Pen(,,,Right)
   Line(18,0,12,0)
   Pen(Black,Solid,0.2)
   Arc(-8,-8,9,-2,0,90)
   Arc(-7,-8,10,-2,540,-90)
   Line(0,6,4,-6)
   Text(1,20,"PQ")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([90,234],0,0,-1)
    {
    Name = "Left"
    }
   0.xnode([522,234],0,0,-1)
    {
    Name = "Right"
    }
   0.multimeter([216,126],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "1.238"
    Qd = "0.7768"
    Vd = "0.4311"
    }
   0.breakout([126,234],0,0,-1)
    {
    Dis = "0"
    }
   0.breakout([468,234],4,0,-1)
    {
    Dis = "0"
    }
   0.multimeter([306,234],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.7367"
    Qd = "1.423"
    Vd = "1.015"
    }
   0.multimeter([360,342],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.6458"
    Qd = "1.059"
    Vd = "0.8865"
    }
   -Wire-([324,234],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([90,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([378,342],0,0,-1)
    {
    Vertex="0,0;54,0;54,-72"
    }
   -Wire-([162,270],0,0,-1)
    {
    Vertex="0,0;0,72;180,72"
    }
   -Wire-([162,234],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([162,198],0,0,-1)
    {
    Vertex="0,0;0,-72;36,-72"
    }
   -Wire-([234,126],0,0,-1)
    {
    Vertex="0,0;198,0;198,72"
    }
   -Wire-([468,234],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   }
  }
 Module("Meters824_828")
  {
  Desc = "Branch 824 to 828"
  FileDate = 1151590216
  Nodes = 
   {
   Electrical("Left",-18,0)
    {
    Dim  = [3]
    }
   Electrical("Right",18,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-10,-12,11,9)
   Pen(ByNode,ByNode,ByNode,Left)
   Line(-18,0,-9,0)
   Pen(,,,Right)
   Line(18,0,12,0)
   Pen(Black,Solid,0.2)
   Arc(-8,-8,9,-2,0,90)
   Arc(-7,-8,10,-2,540,-90)
   Line(0,6,4,-6)
   Text(1,20,"PQ")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([90,234],0,0,-1)
    {
    Name = "Left"
    }
   0.xnode([522,234],0,0,-1)
    {
    Name = "Right"
    }
   0.multimeter([216,126],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "1.254"
    Qd = "0.7867"
    Vd = "0.4366"
    }
   0.breakout([126,234],0,0,-1)
    {
    Dis = "0"
    }
   0.breakout([468,234],4,0,-1)
    {
    Dis = "0"
    }
   0.multimeter([306,234],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.7387"
    Qd = "1.424"
    Vd = "1.016"
    }
   0.multimeter([360,342],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.6544"
    Qd = "1.061"
    Vd = "0.8883"
    }
   -Wire-([324,234],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([90,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([378,342],0,0,-1)
    {
    Vertex="0,0;54,0;54,-72"
    }
   -Wire-([162,270],0,0,-1)
    {
    Vertex="0,0;0,72;180,72"
    }
   -Wire-([162,234],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([162,198],0,0,-1)
    {
    Vertex="0,0;0,-72;36,-72"
    }
   -Wire-([234,126],0,0,-1)
    {
    Vertex="0,0;198,0;198,72"
    }
   -Wire-([468,234],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   }
  }
 Module("Meters824")
  {
  Desc = "Branch 824 -"
  FileDate = 1151590216
  Nodes = 
   {
   Electrical("Left",-18,0)
    {
    Dim  = [3]
    }
   Electrical("Right",18,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-10,-12,11,9)
   Pen(ByNode,ByNode,ByNode,Left)
   Line(-18,0,-9,0)
   Pen(,,,Right)
   Line(18,0,12,0)
   Pen(Black,Solid,0.2)
   Arc(-8,-8,9,-2,0,90)
   Arc(-7,-8,10,-2,540,-90)
   Line(0,6,4,-6)
   Text(1,20,"PQ")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([90,234],0,0,-1)
    {
    Name = "Left"
    }
   0.xnode([522,234],0,0,-1)
    {
    Name = "Right"
    }
   0.multimeter([216,126],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "4.731e-017"
    Qd = "-1.595e-015"
    Vd = "0.4366"
    }
   0.breakout([126,234],0,0,-1)
    {
    Dis = "0"
    }
   0.breakout([468,234],4,0,-1)
    {
    Dis = "0"
    }
   0.multimeter([306,234],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.05126"
    Qd = "0.0253"
    Vd = "1.016"
    }
   0.multimeter([360,342],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "1.009e-016"
    Qd = "-4.209e-015"
    Vd = "0.8883"
    }
   -Wire-([324,234],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([90,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([378,342],0,0,-1)
    {
    Vertex="0,0;54,0;54,-72"
    }
   -Wire-([162,270],0,0,-1)
    {
    Vertex="0,0;0,72;180,72"
    }
   -Wire-([162,234],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([162,198],0,0,-1)
    {
    Vertex="0,0;0,-72;36,-72"
    }
   -Wire-([234,126],0,0,-1)
    {
    Vertex="0,0;198,0;198,72"
    }
   -Wire-([468,234],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   }
  }
 Module("Meters816")
  {
  Desc = "Branch 816 to 824"
  FileDate = 1151590216
  Nodes = 
   {
   Electrical("Left",-18,0)
    {
    Dim  = [3]
    }
   Electrical("Right",18,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-10,-12,11,9)
   Pen(ByNode,ByNode,ByNode,Left)
   Line(-18,0,-9,0)
   Pen(,,,Right)
   Line(18,0,12,0)
   Pen(Black,Solid,0.2)
   Arc(-8,-8,9,-2,0,90)
   Arc(-7,-8,10,-2,540,-90)
   Line(0,6,4,-6)
   Text(1,20,"PQ")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([90,234],0,0,-1)
    {
    Name = "Left"
    }
   0.xnode([522,234],0,0,-1)
    {
    Name = "Right"
    }
   0.multimeter([216,126],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "1.446"
    Qd = "0.9065"
    Vd = "0.5032"
    }
   0.breakout([126,234],0,0,-1)
    {
    Dis = "0"
    }
   0.breakout([468,234],4,0,-1)
    {
    Dis = "0"
    }
   0.multimeter([306,234],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.8189"
    Qd = "1.455"
    Vd = "1.029"
    }
   0.multimeter([360,342],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.6992"
    Qd = "1.07"
    Vd = "0.91"
    }
   -Wire-([324,234],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([90,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([378,342],0,0,-1)
    {
    Vertex="0,0;54,0;54,-72"
    }
   -Wire-([162,270],0,0,-1)
    {
    Vertex="0,0;0,72;180,72"
    }
   -Wire-([162,234],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([162,198],0,0,-1)
    {
    Vertex="0,0;0,-72;36,-72"
    }
   -Wire-([234,126],0,0,-1)
    {
    Vertex="0,0;198,0;198,72"
    }
   -Wire-([468,234],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   }
  }
 Module("Meters814")
  {
  Desc = "Branch 814 to 850"
  FileDate = 1151590216
  Nodes = 
   {
   Electrical("Left",-18,0)
    {
    Dim  = [3]
    }
   Electrical("Right",18,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-10,-12,11,9)
   Pen(ByNode,ByNode,ByNode,Left)
   Line(-18,0,-9,0)
   Pen(,,,Right)
   Line(18,0,12,0)
   Pen(Black,Solid,0.2)
   Arc(-8,-8,9,-2,0,90)
   Arc(-7,-8,10,-2,540,-90)
   Line(0,6,4,-6)
   Text(1,20,"PQ")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([90,234],0,0,-1)
    {
    Name = "Left"
    }
   0.xnode([522,234],0,0,-1)
    {
    Name = "Right"
    }
   0.multimeter([216,126],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "1.513"
    Qd = "0.936"
    Vd = "0.4674"
    }
   0.breakout([126,234],0,0,-1)
    {
    Dis = "0"
    }
   0.breakout([468,234],4,0,-1)
    {
    Dis = "0"
    }
   0.multimeter([306,234],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.8197"
    Qd = "1.455"
    Vd = "0.9517"
    }
   0.multimeter([360,342],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.7005"
    Qd = "1.071"
    Vd = "0.8423"
    }
   -Wire-([324,234],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([90,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([378,342],0,0,-1)
    {
    Vertex="0,0;54,0;54,-72"
    }
   -Wire-([162,270],0,0,-1)
    {
    Vertex="0,0;0,72;180,72"
    }
   -Wire-([162,234],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([162,198],0,0,-1)
    {
    Vertex="0,0;0,-72;36,-72"
    }
   -Wire-([234,126],0,0,-1)
    {
    Vertex="0,0;198,0;198,72"
    }
   -Wire-([468,234],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   }
  }
 Module("Meters808")
  {
  Desc = "Branch 808 to 812"
  FileDate = 1151590215
  Nodes = 
   {
   Electrical("Left",-18,0)
    {
    Dim  = [3]
    }
   Electrical("Right",18,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-10,-12,11,9)
   Pen(ByNode,ByNode,ByNode,Left)
   Line(-18,0,-9,0)
   Pen(,,,Right)
   Line(18,0,12,0)
   Pen(Black,Solid,0.2)
   Arc(-8,-8,9,-2,0,90)
   Arc(-7,-8,10,-2,540,-90)
   Line(0,6,4,-6)
   Text(1,20,"PQ")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([90,234],0,0,-1)
    {
    Name = "Left"
    }
   0.xnode([522,234],0,0,-1)
    {
    Name = "Right"
    }
   0.multimeter([216,126],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "2.595"
    Qd = "1.883"
    Vd = "0.8444"
    }
   0.breakout([126,234],0,0,-1)
    {
    Dis = "0"
    }
   0.breakout([468,234],4,0,-1)
    {
    Dis = "0"
    }
   0.multimeter([306,234],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.9121"
    Qd = "1.513"
    Vd = "1.014"
    }
   0.multimeter([360,342],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.947"
    Qd = "1.126"
    Vd = "0.9744"
    }
   -Wire-([324,234],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([90,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([378,342],0,0,-1)
    {
    Vertex="0,0;54,0;54,-72"
    }
   -Wire-([162,270],0,0,-1)
    {
    Vertex="0,0;0,72;180,72"
    }
   -Wire-([162,234],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([162,198],0,0,-1)
    {
    Vertex="0,0;0,-72;36,-72"
    }
   -Wire-([234,126],0,0,-1)
    {
    Vertex="0,0;198,0;198,72"
    }
   -Wire-([468,234],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   }
  }
 Module("Meters806")
  {
  Desc = "Branch 806 to 808"
  FileDate = 1151590213
  Nodes = 
   {
   Electrical("Left",-18,0)
    {
    Dim  = [3]
    }
   Electrical("Right",18,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-10,-12,11,9)
   Pen(ByNode,ByNode,ByNode,Left)
   Line(-18,0,-9,0)
   Pen(,,,Right)
   Line(18,0,12,0)
   Pen(Black,Solid,0.2)
   Arc(-8,-8,9,-2,0,90)
   Arc(-7,-8,10,-2,540,-90)
   Line(0,6,4,-6)
   Text(1,20,"PQ")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([90,234],0,0,-1)
    {
    Name = "Left"
    }
   0.xnode([522,234],0,0,-1)
    {
    Name = "Right"
    }
   0.multimeter([216,126],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "3.113"
    Qd = "2.323"
    Vd = "1.026"
    }
   0.breakout([126,234],0,0,-1)
    {
    Dis = "0"
    }
   0.breakout([468,234],4,0,-1)
    {
    Dis = "0"
    }
   0.multimeter([306,234],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "0.9774"
    Qd = "1.547"
    Vd = "1.045"
    }
   0.multimeter([360,342],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "1.064"
    Qd = "1.15"
    Vd = "1.041"
    }
   -Wire-([324,234],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([90,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([378,342],0,0,-1)
    {
    Vertex="0,0;54,0;54,-72"
    }
   -Wire-([162,270],0,0,-1)
    {
    Vertex="0,0;0,72;180,72"
    }
   -Wire-([162,234],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([162,198],0,0,-1)
    {
    Vertex="0,0;0,-72;36,-72"
    }
   -Wire-([234,126],0,0,-1)
    {
    Vertex="0,0;198,0;198,72"
    }
   -Wire-([468,234],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   }
  }
 Module("Meters800")
  {
  Desc = "Branch 800 to 802"
  FileDate = 1151590213
  Nodes = 
   {
   Electrical("Left",-18,0)
    {
    Dim  = [3]
    }
   Electrical("Right",18,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-10,-12,11,9)
   Pen(ByNode,ByNode,ByNode,Left)
   Line(-18,0,-9,0)
   Pen(,,,Right)
   Line(18,0,12,0)
   Pen(Black,Solid,0.2)
   Arc(-8,-8,9,-2,0,90)
   Arc(-7,-8,10,-2,540,-90)
   Line(0,6,4,-6)
   Text(1,20,"PQ")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([90,234],0,0,-1)
    {
    Name = "Left"
    }
   0.xnode([522,234],0,0,-1)
    {
    Name = "Right"
    }
   0.multimeter([216,126],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "3.183"
    Qd = "2.397"
    Vd = "1.05"
    }
   0.breakout([126,234],0,0,-1)
    {
    Dis = "0"
    }
   0.breakout([468,234],4,0,-1)
    {
    Dis = "0"
    }
   0.multimeter([306,234],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "1.035"
    Qd = "1.579"
    Vd = "1.05"
    }
   0.multimeter([360,342],0,0,-1)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "1.122"
    Qd = "1.176"
    Vd = "1.05"
    }
   -Wire-([324,234],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([90,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([378,342],0,0,-1)
    {
    Vertex="0,0;54,0;54,-72"
    }
   -Wire-([162,270],0,0,-1)
    {
    Vertex="0,0;0,72;180,72"
    }
   -Wire-([162,234],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([162,198],0,0,-1)
    {
    Vertex="0,0;0,-72;36,-72"
    }
   -Wire-([234,126],0,0,-1)
    {
    Vertex="0,0;198,0;198,72"
    }
   -Wire-([468,234],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   }
  }
 Module("regulator2")
  {
  Desc = ""
  FileDate = 1151590219
  Nodes = 
   {
   Electrical("in",-36,0)
    {
    Dim  = [3]
    }
   Electrical("out",36,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Pen(ByNode,ByNode,ByNode,in)
   Line(-36,0,-17,0)
   Pen(,,,out)
   Line(36,0,18,0)
   Text(4,30,"Regulator 2")
   Pen(Black,Solid,0.6)
   Ellipse(-17,-19,19,17)
   Pen(,,0.2)
   Line(-17,13,20,-16)
   Line(16,-15,19,-16)
   Line(18,-11,20,-16)
   Text(-27,-12,"852")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([180,360],0,0,-1)
    {
    Name = "in"
    }
   0.xfmr-2w([396,486],0,0,230)
    {
    Tmva = "0.5 [MVA]"
    f = "60.0 [Hz]"
    Xl = "0.000001 [pu]"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Ideal = "1"
    Tap = "2"
    View = "2"
    V1 = "14.376 [kV]"
    V2 = "14.376 [kV]"
    Enab = "0"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0.1 [s]"
    Im1 = "1 [%]"
    IL1 = ""
    IL2 = ""
    IMAG = ""
    FLUX = ""
    }
   0.breakout([180,360],0,0,-1)
    {
    Dis = "0"
    }
   -Wire-([216,360],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   -Wire-([216,324],0,0,-1)
    {
    Vertex="0,0;0,-90;144,-90"
    }
   -Wire-([216,396],0,0,-1)
    {
    Vertex="0,0;0,90;144,90"
    }
   -Wire-([360,270],0,0,-1)
    {
    Vertex="0,0;-36,0;-36,288"
    }
   -Wire-([360,396],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([360,522],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.ground([324,558],1,0,-1)
    {
    }
   0.xnode([612,360],4,0,-1)
    {
    Name = "out"
    }
   0.breakout([612,360],4,0,-1)
    {
    Dis = "0"
    }
   -Wire-([540,360],0,0,-1)
    {
    Vertex="0,0;-108,0"
    }
   -Wire-([576,324],0,0,-1)
    {
    Vertex="0,0;0,-90;-108,-90"
    }
   -Wire-([432,270],0,0,-1)
    {
    Vertex="0,0;36,0;36,288"
    }
   -Wire-([432,396],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([432,522],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.ground([468,558],7,0,-1)
    {
    }
   0.xfmr-2w([396,234],0,0,270)
    {
    Tmva = "0.5 [MVA]"
    f = "60.0 [Hz]"
    Xl = "0.000001 [pu]"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Ideal = "1"
    Tap = "2"
    View = "2"
    V1 = "14.376 [kV]"
    V2 = "14.376 [kV]"
    Enab = "0"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0.1 [s]"
    Im1 = "1 [%]"
    IL1 = ""
    IL2 = ""
    IMAG = ""
    FLUX = ""
    }
   0.xfmr-2w([396,360],0,0,250)
    {
    Tmva = "0.5 [MVA]"
    f = "60.0 [Hz]"
    Xl = "0.00001 [pu]"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Ideal = "1"
    Tap = "2"
    View = "2"
    V1 = "14.376 [kV]"
    V2 = "14.376 [kV]"
    Enab = "0"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0.1 [s]"
    Im1 = "1 [%]"
    IL1 = ""
    IL2 = ""
    IMAG = ""
    FLUX = ""
    }
   .Reg2A([774,216],0,0,30)
    {
    }
   .Reg2B([774,342],0,0,80)
    {
    }
   .Reg2C([774,450],0,0,190)
    {
    }
   0.datalabel([720,198],0,0,-1)
    {
    Name = "Ea2"
    }
   0.datalabel([720,234],0,0,-1)
    {
    Name = "Ia2"
    }
   0.datalabel([720,324],0,0,-1)
    {
    Name = "Eb2"
    }
   0.datalabel([720,360],0,0,-1)
    {
    Name = "Ib2"
    }
   0.datalabel([720,432],0,0,-1)
    {
    Name = "Ec2"
    }
   0.datalabel([720,468],0,0,-1)
    {
    Name = "Ic2"
    }
   0.datalabel([846,216],0,0,-1)
    {
    Name = "TAPa2"
    }
   0.datalabel([846,342],0,0,-1)
    {
    Name = "TAPb2"
    }
   0.datalabel([846,450],0,0,-1)
    {
    Name = "TAPc2"
    }
   -Wire-([828,216],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,342],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([828,450],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.ammeter([432,234],0,0,10)
    {
    Name = "Ia2"
    }
   0.voltmetergnd([504,234],0,0,20)
    {
    Name = "Ea2"
    }
   -Wire-([576,396],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   -Wire-([540,486],0,0,-1)
    {
    Vertex="0,0;-108,0"
    }
   0.ammeter([540,360],0,0,70)
    {
    Name = "Ib2"
    }
   0.ammeter([540,486],0,0,120)
    {
    Name = "Ic2"
    }
   0.voltmetergnd([522,360],0,0,60)
    {
    Name = "Eb2"
    }
   0.voltmetergnd([522,486],0,0,110)
    {
    Name = "Ec2"
    }
   0.datalabel([360,198],6,0,-1)
    {
    Name = "TAPa2"
    }
   0.datalabel([360,324],6,0,-1)
    {
    Name = "TAPb2"
    }
   0.datalabel([360,450],6,0,-1)
    {
    Name = "TAPc2"
    }
   -Wire-([846,216],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.pgb([1008,216],0,48074472,260)
    {
    Name = "TAPa2"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-16"
    Max = "16"
    }
   0.pgb([1008,342],0,48076424,240)
    {
    Name = "TAPb2"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-16"
    Max = "16"
    }
   0.pgb([1008,450],0,48078320,220)
    {
    Name = "TAPc2"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-16"
    Max = "16"
    }
   0.sumjct([900,216],0,0,150)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.const([864,252],0,0,40)
    {
    Name = ""
    Value = "1.0"
    }
   0.div([972,216],0,0,160)
    {
    }
   0.const([936,252],0,0,50)
    {
    Name = ""
    Value = "0.00625"
    }
   0.sumjct([900,342],0,0,170)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.div([972,342],0,0,180)
    {
    }
   0.div([972,450],0,0,210)
    {
    }
   0.const([864,378],0,0,90)
    {
    Name = ""
    Value = "1.0"
    }
   0.const([936,378],0,0,100)
    {
    Name = ""
    Value = "0.00625"
    }
   0.const([864,486],0,0,130)
    {
    Name = ""
    Value = "1.0"
    }
   0.const([936,486],0,0,140)
    {
    Name = ""
    Value = "0.00625"
    }
   0.sumjct([900,450],0,0,200)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -ControlPanel-([162,594],0)
    {
    Name = "$(GROUP) : Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 162,594
    Extents = 0,0,0,0
    Meter(48074472)
    Meter(48076424)
    Meter(48078320)
    }
   -Wire-([846,450],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   }
  }
 Module("regulator1")
  {
  Desc = ""
  FileDate = 1151590216
  Nodes = 
   {
   Electrical("in",-36,0)
    {
    Dim  = [3]
    }
   Electrical("out",36,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Pen(ByNode,ByNode,ByNode,in)
   Line(-36,0,-18,0)
   Pen(,,,out)
   Line(36,0,18,0)
   Text(3,31,"Regulator 1")
   Pen(Black,Solid,0.6)
   Ellipse(-18,-18,18,18)
   Pen(,,0.2)
   Line(-18,14,19,-15)
   Line(15,-14,18,-15)
   Line(17,-10,19,-15)
   Text(-28,-12,"814")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([180,360],0,0,-1)
    {
    Name = "in"
    }
   0.xfmr-2w([396,234],0,0,290)
    {
    Tmva = "0.5 [MVA]"
    f = "60.0 [Hz]"
    Xl = "0.000001 [pu]"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Ideal = "1"
    Tap = "2"
    View = "2"
    V1 = "14.376 [kV]"
    V2 = "14.376 [kV]"
    Enab = "0"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0.1 [s]"
    Im1 = "1 [%]"
    IL1 = ""
    IL2 = ""
    IMAG = ""
    FLUX = ""
    }
   0.breakout([180,360],0,0,-1)
    {
    Dis = "0"
    }
   -Wire-([216,360],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   -Wire-([216,324],0,0,-1)
    {
    Vertex="0,0;0,-90;144,-90"
    }
   -Wire-([360,270],0,0,-1)
    {
    Vertex="0,0;-36,0;-36,288"
    }
   -Wire-([360,396],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([360,522],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.ground([324,558],1,0,-1)
    {
    }
   0.xnode([612,360],4,0,-1)
    {
    Name = "out"
    }
   0.breakout([612,360],4,0,-1)
    {
    Dis = "0"
    }
   -Wire-([540,360],0,0,-1)
    {
    Vertex="0,0;-108,0"
    }
   -Wire-([576,324],0,0,-1)
    {
    Vertex="0,0;0,-90;-108,-90"
    }
   -Wire-([432,270],0,0,-1)
    {
    Vertex="0,0;36,0;36,288"
    }
   -Wire-([432,396],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([432,522],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.ground([468,558],7,0,-1)
    {
    }
   0.xfmr-2w([396,360],0,0,270)
    {
    Tmva = "0.5 [MVA]"
    f = "60.0 [Hz]"
    Xl = "0.000001 [pu]"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Ideal = "1"
    Tap = "2"
    View = "2"
    V1 = "14.376 [kV]"
    V2 = "14.376 [kV]"
    Enab = "0"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0.1 [s]"
    Im1 = "1 [%]"
    IL1 = ""
    IL2 = ""
    IMAG = ""
    FLUX = ""
    }
   0.xfmr-2w([396,486],0,0,250)
    {
    Tmva = "0.5 [MVA]"
    f = "60.0 [Hz]"
    Xl = "0.000001 [pu]"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Ideal = "1"
    Tap = "2"
    View = "2"
    V1 = "14.376 [kV]"
    V2 = "14.376 [kV]"
    Enab = "0"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0.1 [s]"
    Im1 = "1 [%]"
    IL1 = ""
    IL2 = ""
    IMAG = ""
    FLUX = ""
    }
   -Wire-([216,396],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   -Wire-([216,486],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   -Wire-([576,396],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   -Wire-([540,486],0,0,-1)
    {
    Vertex="0,0;-108,0"
    }
   0.voltmetergnd([486,234],0,0,20)
    {
    Name = "Ea1"
    }
   0.ammeter([432,234],0,0,10)
    {
    Name = "Ia1"
    }
   0.datalabel([720,216],0,0,-1)
    {
    Name = "Ea1"
    }
   0.datalabel([720,252],0,0,-1)
    {
    Name = "Ia1"
    }
   0.datalabel([846,234],0,0,-1)
    {
    Name = "TAPa1"
    }
   0.datalabel([360,198],6,0,-1)
    {
    Name = "TAPa1"
    }
   -Wire-([828,234],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   .Reg1A([774,234],0,0,30)
    {
    }
   0.ammeter([540,360],0,0,70)
    {
    Name = "Ib1"
    }
   0.ammeter([540,486],0,0,120)
    {
    Name = "Ic1"
    }
   0.voltmetergnd([522,360],0,0,60)
    {
    Name = "Eb1"
    }
   0.voltmetergnd([522,486],0,0,110)
    {
    Name = "Ec1"
    }
   .Reg1B([774,342],0,0,80)
    {
    }
   .Reg1C([774,468],0,0,130)
    {
    }
   0.datalabel([720,324],0,0,-1)
    {
    Name = "Eb1"
    }
   0.datalabel([720,360],0,0,-1)
    {
    Name = "Ib1"
    }
   0.datalabel([720,450],0,0,-1)
    {
    Name = "Ec1"
    }
   0.datalabel([720,486],0,0,-1)
    {
    Name = "Ic1"
    }
   0.datalabel([846,342],0,0,-1)
    {
    Name = "TAPb1"
    }
   0.datalabel([846,468],0,0,-1)
    {
    Name = "TAPc1"
    }
   -Wire-([828,342],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([828,468],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([360,324],6,0,-1)
    {
    Name = "TAPb1"
    }
   0.datalabel([360,450],6,0,-1)
    {
    Name = "TAPc1"
    }
   0.pgb([1026,234],0,48131104,280)
    {
    Name = "TAPa1"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-16"
    Max = "16"
    }
   0.pgb([1026,342],0,48133224,260)
    {
    Name = "TAPb1"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-16"
    Max = "16"
    }
   0.pgb([1026,468],0,48135120,240)
    {
    Name = "TAPc1"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-16"
    Max = "16"
    }
   -ControlPanel-([594,558],0)
    {
    Name = "$(GROUP) : Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 594,558
    Extents = 0,0,0,0
    Meter(48131104)
    Meter(48133224)
    Meter(48135120)
    }
   0.sumjct([918,234],0,0,180)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.const([882,270],0,0,40)
    {
    Name = ""
    Value = "1.0"
    }
   0.div([990,234],0,0,190)
    {
    }
   0.const([954,270],0,0,50)
    {
    Name = ""
    Value = "0.00625"
    }
   0.sumjct([918,342],0,0,200)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.div([990,342],0,0,210)
    {
    }
   0.sumjct([918,468],0,0,220)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.div([990,468],0,0,230)
    {
    }
   0.const([882,378],0,0,90)
    {
    Name = ""
    Value = "1.0"
    }
   0.const([954,378],0,0,100)
    {
    Name = ""
    Value = "0.00625"
    }
   0.const([882,504],0,0,140)
    {
    Name = ""
    Value = "1.0"
    }
   0.const([954,504],0,0,150)
    {
    Name = ""
    Value = "0.00625"
    }
   0.rms-inst([792,126],0,0,170)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "1.0"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   0.pgb([828,126],0,48157752,300)
    {
    Name = "Ia1rms"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.rms-inst([792,90],0,0,160)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "1.0"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   0.pgb([828,90],0,48160904,310)
    {
    Name = "Ea1rms"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([720,90],0,0,-1)
    {
    Name = "Ea1"
    }
   -Wire-([720,90],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([720,126],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([720,126],0,0,-1)
    {
    Name = "Ia1"
    }
   -Plot-([882,558],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,0,0]
    Posn = [882,558]
    Icon = [-1,-1]
    Extents = 0,0,576,288
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,576,113],"y")
     {
     Options = 128
     Units = ""
     Curve(48160904,"Ea1rms",0,,,)
     }
    Graph([0,113],[0,0,576,112],"y")
     {
     Options = 128
     Units = ""
     Curve(48157752,"Ia1rms",0,,,)
     }
    }
   }
  }
 Module("DIload840")
  {
  Desc = ""
  FileDate = 1151590218
  Nodes = 
   {
   Electrical("in",-54,0)
    {
    Type = Switched
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-39,-7,37,10)
   Pen(ByNode,ByNode,ByNode,in)
   Line(-54,0,-39,0)
   Text(-1,4,"DIload840")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([342,360],0,0,-1)
    {
    Name = "in"
    }
   0.breakout([378,360],0,0,-1)
    {
    Dis = "0"
    }
   -Wire-([594,324],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([594,360],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([594,396],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([432,324],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   -Wire-([504,360],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([576,396],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([576,432],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([576,486],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([468,486],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([342,360],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   .IloadAB840([468,432],0,0,10)
    {
    }
   .IloadBC840([540,432],0,0,20)
    {
    }
   }
  }
 Module("DIload836")
  {
  Desc = ""
  FileDate = 1151590218
  Nodes = 
   {
   Electrical("in",-54,0)
    {
    Type = Switched
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-39,-7,37,10)
   Pen(ByNode,ByNode,ByNode,in)
   Line(-54,0,-39,0)
   Text(-1,4,"DIload836")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([126,306],0,0,-1)
    {
    Name = "in"
    }
   0.breakout([162,306],0,0,-1)
    {
    Dis = "0"
    }
   -Wire-([378,270],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([378,306],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([378,342],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([216,270],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   -Wire-([288,306],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([360,342],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([360,378],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([360,432],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([252,432],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([126,306],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   .IloadAB836([252,378],0,0,10)
    {
    }
   .IloadBC836([324,378],0,0,20)
    {
    }
   }
  }
 Module("DZload860")
  {
  Desc = ""
  FileDate = 1151590217
  Nodes = 
   {
   Electrical("in",-54,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-39,-7,37,10)
   Pen(ByNode,ByNode,ByNode,in)
   Line(-54,0,-39,0)
   Text(-1,4,"DZload860")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([72,216],0,0,-1)
    {
    Name = "in"
    }
   0.breakout([108,216],0,0,-1)
    {
    Dis = "0"
    }
   -Wire-([72,216],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([324,180],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([324,216],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([324,252],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([162,180],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   -Wire-([234,216],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   -Wire-([306,252],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([306,288],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([306,342],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([198,342],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([288,270],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([234,270],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([288,306],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([234,306],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([216,270],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([162,270],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([216,306],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([162,306],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([270,342],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([252,342],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([198,342],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([252,378],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([198,378],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([198,342],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.resistor([180,270],0,0,-1)
    {
    R = "116251 [ohm]"
    }
   0.inductor([180,306],0,0,-1)
    {
    L = "616.72 [H]"
    }
   0.resistor([252,270],0,0,-1)
    {
    R = "93001 [ohm]"
    }
   0.inductor([252,306],0,0,-1)
    {
    L = "493.38 [H]"
    }
   0.resistor([216,342],0,0,-1)
    {
    R = "16909 [ohm]"
    }
   0.inductor([216,378],0,0,-1)
    {
    L = "89.7 [H]"
    }
   0.pin([234,270],0,0,-1)
    {
    }
   }
  }
 Module("DZload834")
  {
  Desc = ""
  FileDate = 1151590217
  Nodes = 
   {
   Electrical("in",-54,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-39,-9,37,8)
   Pen(ByNode,ByNode,ByNode,in)
   Line(-54,0,-39,0)
   Text(-1,3,"DZload834")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([72,216],0,0,-1)
    {
    Name = "in"
    }
   0.breakout([108,216],0,0,-1)
    {
    Dis = "0"
    }
   -Wire-([72,216],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([324,180],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([324,216],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([324,252],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([162,180],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   -Wire-([234,216],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   -Wire-([306,252],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([306,288],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([306,342],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([198,342],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([288,270],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([234,270],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([288,306],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([234,306],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([216,270],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([162,270],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([216,306],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([162,306],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([270,342],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([252,342],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([198,342],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([252,378],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([198,378],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([198,342],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.resistor([180,270],0,0,-1)
    {
    R = "58125.9 [ohm]"
    }
   0.inductor([180,306],0,0,-1)
    {
    L = "308.36 [H]"
    }
   0.resistor([252,270],0,0,-1)
    {
    R = "46500.7 [ohm]"
    }
   0.inductor([252,306],0,0,-1)
    {
    L = "246.69 [H]"
    }
   0.resistor([216,342],0,0,-1)
    {
    R = "8454.68 [ohm]"
    }
   0.inductor([216,378],0,0,-1)
    {
    L = "44.85 [H]"
    }
   0.pin([234,270],0,0,-1)
    {
    }
   }
  }
 Module("DPQload836")
  {
  Desc = ""
  FileDate = 1151590218
  Nodes = 
   {
   Electrical("in",-54,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-39,-7,37,10)
   Pen(ByNode,ByNode,ByNode,in)
   Line(-54,0,-39,0)
   Text(-1,4,"DPQload836")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([270,324],0,0,-1)
    {
    Name = "in"
    }
   0.breakout([270,324],0,0,-1)
    {
    Dis = "0"
    }
   -Wire-([486,288],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([486,324],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([486,360],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([324,288],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   -Wire-([396,324],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([468,360],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([468,396],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([468,450],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([360,450],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   .loadCA836([396,450],0,0,30)
    {
    }
   .loadBC836([432,396],0,0,20)
    {
    }
   .loadAB836([360,396],0,0,10)
    {
    }
   }
  }
 Module("DPQload860")
  {
  Desc = ""
  FileDate = 1151590217
  Nodes = 
   {
   Electrical("in",-54,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-39,-7,37,10)
   Pen(ByNode,ByNode,ByNode,in)
   Line(-54,0,-39,0)
   Text(-1,4,"DPQload860")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([306,234],0,0,-1)
    {
    Name = "in"
    }
   0.breakout([306,234],0,0,-1)
    {
    Dis = "0"
    }
   -Wire-([522,198],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([522,234],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([522,270],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([360,198],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   -Wire-([432,234],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([504,270],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([504,306],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([504,360],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([396,360],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   .loadCA860([432,360],0,0,30)
    {
    }
   .loadBC860([468,306],0,0,20)
    {
    }
   .loadAB860([396,306],0,0,10)
    {
    }
   }
  }
 Module("DPQload834")
  {
  Desc = ""
  FileDate = 1151590217
  Nodes = 
   {
   Electrical("in",-54,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-39,-7,37,10)
   Pen(ByNode,ByNode,ByNode,in)
   Line(-54,0,-39,0)
   Text(-1,4,"DPQload834")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([270,288],0,0,-1)
    {
    Name = "in"
    }
   0.breakout([270,288],0,0,-1)
    {
    Dis = "0"
    }
   -Wire-([486,252],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([486,288],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([486,324],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([324,252],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   -Wire-([396,288],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([468,324],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([468,360],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([468,414],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([360,414],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   .loadCA834([396,414],0,0,30)
    {
    }
   .loadBC834([432,360],0,0,20)
    {
    }
   .loadAB834([360,360],0,0,10)
    {
    }
   }
  }
 Module("DPQload858")
  {
  Desc = ""
  FileDate = 1151590216
  Nodes = 
   {
   Electrical("in",-54,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-39,-7,37,10)
   Pen(ByNode,ByNode,ByNode,in)
   Line(-54,0,-39,0)
   Text(-1,4,"DPQload858")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([252,324],0,0,-1)
    {
    Name = "in"
    }
   0.breakout([252,324],0,0,-1)
    {
    Dis = "0"
    }
   -Wire-([468,288],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([468,324],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([468,360],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([306,288],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   -Wire-([378,324],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([450,360],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([450,396],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([450,450],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([342,450],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   .loadCA858([378,450],0,0,30)
    {
    }
   .loadBC858([414,396],0,0,20)
    {
    }
   .loadAB858([342,396],0,0,10)
    {
    }
   }
  }
 Module("DZload858")
  {
  Desc = ""
  FileDate = 1151590216
  Nodes = 
   {
   Electrical("in",-54,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-39,-7,37,10)
   Pen(ByNode,ByNode,ByNode,in)
   Line(-54,0,-39,0)
   Text(-1,4,"DZload858")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([72,216],0,0,-1)
    {
    Name = "in"
    }
   0.breakout([108,216],0,0,-1)
    {
    Dis = "0"
    }
   -Wire-([72,216],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([324,180],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([324,216],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([324,252],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([162,180],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   -Wire-([234,216],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   -Wire-([306,252],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([306,288],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([306,342],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([198,342],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([288,270],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([234,270],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([288,306],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([234,306],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([216,270],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([162,270],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([216,306],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([162,306],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([270,342],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([252,342],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([198,342],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([252,378],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([198,378],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([198,342],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.resistor([180,270],0,0,-1)
    {
    R = "265718 [ohm]"
    }
   0.inductor([180,306],0,0,-1)
    {
    L = "1644.59 [H]"
    }
   0.resistor([252,270],0,0,-1)
    {
    R = "930015 [ohm]"
    }
   0.inductor([252,306],0,0,-1)
    {
    L = "4933.77 [H]"
    }
   0.resistor([216,342],0,0,-1)
    {
    R = "310005 [ohm]"
    }
   0.inductor([216,378],0,0,-1)
    {
    L = "1644.59 [H]"
    }
   0.pin([234,270],0,0,-1)
    {
    }
   }
  }
 Module("DZload832")
  {
  Desc = ""
  FileDate = 1151590217
  Nodes = 
   {
   Electrical("in",-54,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-39,-7,37,10)
   Pen(ByNode,ByNode,ByNode,in)
   Line(-54,0,-39,0)
   Text(-1,4,"DZload832")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([108,252],0,0,-1)
    {
    Name = "in"
    }
   0.breakout([144,252],0,0,-1)
    {
    Dis = "0"
    }
   -Wire-([360,216],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([360,252],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([360,288],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([198,216],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   -Wire-([270,252],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   -Wire-([342,288],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([342,324],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([342,378],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([234,378],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([108,252],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([324,306],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([270,306],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([324,342],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([270,342],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([252,306],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([198,306],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([252,342],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([198,342],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([306,378],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([288,378],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([234,378],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([288,414],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([234,414],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([234,378],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.resistor([216,306],0,0,-1)
    {
    R = "132859 [ohm]"
    }
   0.inductor([216,342],0,0,-1)
    {
    L = "822.29 [H]"
    }
   0.resistor([288,306],0,0,-1)
    {
    R = "465007 [ohm]"
    }
   0.inductor([288,342],0,0,-1)
    {
    L = "2466.88 [H]"
    }
   0.resistor([252,378],0,0,-1)
    {
    R = "155002 [ohm]"
    }
   0.inductor([252,414],0,0,-1)
    {
    L = "822.29 [H]"
    }
   0.pin([270,306],0,0,-1)
    {
    }
   0.pin([270,342],0,0,-1)
    {
    }
   }
  }
 Module("loadBC824")
  {
  Desc = ""
  FileDate = 1151590213
  Nodes = 
   {
   Electrical("B",-36,0)
    {
    }
   Electrical("C",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zbc824")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([216,288],2,0,-1)
    {
    Name = "B"
    }
   -Wire-([216,522],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.datalabel([180,144],0,0,-1)
    {
    Name = "Vbc824"
    }
   0.varrlc([270,396],3,0,200)
    {
    RLC = "0"
    R = "Rbc824"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([180,396],3,0,210)
    {
    RLC = "1"
    R = "R"
    L = "Lbc824"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([504,144],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   0.div([540,144],0,0,190)
    {
    }
   0.const([648,180],4,0,30)
    {
    Name = "P in MW"
    Value = "0.0016667"
    }
   0.div([540,288],0,0,170)
    {
    }
   0.emtconst([774,324],4,0,60)
    {
    Name = ""
    Value = "1"
    }
   0.mult([702,324],4,0,150)
    {
    }
   0.const([738,360],4,0,80)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.const([648,360],4,0,70)
    {
    Name = "Q in MVAR"
    Value = "0.0006667"
    }
   0.datalabel([576,144],0,0,-1)
    {
    Name = "Rbc824"
    }
   0.datalabel([648,288],0,0,-1)
    {
    Name = "Lbc824"
    }
   -Wire-([270,360],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([180,450],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([216,360],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([216,522],0,0,-1)
    {
    Name = "C"
    }
   0.voltmeter([324,288],0,0,50)
    {
    Name = "Vbc824"
    }
   -Wire-([216,288],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([216,522],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([324,324],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   -Wire-([270,396],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.div([576,180],4,0,140)
    {
    }
   0.const([612,216],4,0,40)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.div([576,360],4,0,160)
    {
    }
   0.const([612,396],4,0,90)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.div([612,288],0,0,180)
    {
    }
   -Wire-([540,324],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([612,324],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([180,450],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.hardlimit([288,144],0,0,110)
    {
    UL = "1.2"
    LL = "0.8"
    COM = "Hard_Limit"
    }
   0.mult([432,144],0,0,130)
    {
    }
   0.const([468,180],4,0,20)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.const([324,180],0,0,10)
    {
    Name = ""
    Value = "0.000001"
    }
   0.sumjct([360,144],0,0,120)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([468,144],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.rms-inst([216,144],0,0,100)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "24.9"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   }
  }
 Module("loadBC816")
  {
  Desc = ""
  FileDate = 1151590216
  Nodes = 
   {
   Electrical("B",-36,0)
    {
    }
   Electrical("C",36,0)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-30,-7,28,6)
   Pen(ByNode,ByNode,ByNode)
   Line(-36,0,-30,0)
   Line(35,0,27,0)
   Text(-2,4,"Zbc816")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([252,252],2,0,-1)
    {
    Name = "B"
    }
   -Wire-([252,486],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.datalabel([216,108],0,0,-1)
    {
    Name = "Vbc816"
    }
   0.varrlc([306,360],3,0,200)
    {
    RLC = "0"
    R = "Rbc816"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([216,360],3,0,210)
    {
    RLC = "1"
    R = "R"
    L = "Lbc816"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([540,108],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   0.div([576,108],0,0,190)
    {
    }
   0.const([684,144],4,0,30)
    {
    Name = "P in MW"
    Value = "0.00333"
    }
   0.div([576,252],0,0,170)
    {
    }
   0.emtconst([810,288],4,0,60)
    {
    Name = ""
    Value = "1"
    }
   0.mult([738,288],4,0,150)
    {
    }
   0.const([774,324],4,0,80)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.const([684,324],4,0,70)
    {
    Name = "Q in MVAR"
    Value = "0.001333"
    }
   0.datalabel([612,108],0,0,-1)
    {
    Name = "Rbc816"
    }
   0.datalabel([684,252],0,0,-1)
    {
    Name = "Lbc816"
    }
   -Wire-([306,324],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([216,414],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([252,324],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.xnode([252,486],0,0,-1)
    {
    Name = "C"
    }
   0.voltmeter([360,252],0,0,50)
    {
    Name = "Vbc816"
    }
   -Wire-([252,252],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([252,486],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([360,288],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   -Wire-([306,360],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.div([612,144],4,0,140)
    {
    }
   0.const([648,180],4,0,40)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.div([612,324],4,0,160)
    {
    }
   0.const([648,360],4,0,90)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.div([648,252],0,0,180)
    {
    }
   -Wire-([576,288],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([648,288],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([216,414],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.rms-inst([252,108],0,0,100)
    {
    Type = "1"
    Ts = "0.02 [s]"
    Scale = "24.9"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   0.hardlimit([324,108],0,0,110)
    {
    UL = "1.2"
    LL = "0.8"
    COM = "Hard_Limit"
    }
   0.mult([468,108],0,0,130)
    {
    }
   0.const([504,144],4,0,20)
    {
    Name = "V in kV"
    Value = "24.9"
    }
   0.const([360,144],0,0,10)
    {
    Name = ""
    Value = "0.000001"
    }
   0.sumjct([396,108],0,0,120)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([504,108],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   }
  }
 Module("DZload830")
  {
  Desc = ""
  FileDate = 1151590220
  Nodes = 
   {
   Electrical("in",-54,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-39,-7,37,10)
   Pen(ByNode,ByNode,ByNode,in)
   Line(-54,0,-39,0)
   Text(-1,4,"DZload830")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([270,234],0,0,-1)
    {
    Name = "in"
    }
   0.breakout([306,234],0,0,-1)
    {
    Dis = "0"
    }
   -Wire-([522,198],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([522,234],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([522,270],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([360,198],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   -Wire-([432,234],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([504,270],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([504,306],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([504,360],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([396,360],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([270,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   .loadCA830([432,360],0,0,30)
    {
    }
   .loadBC830([468,306],0,0,20)
    {
    }
   .loadAB830([396,306],0,0,10)
    {
    }
   }
  }
 Module("DIload890")
  {
  Desc = ""
  FileDate = 1151590219
  Nodes = 
   {
   Electrical("in",-54,0)
    {
    Type = Switched
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-39,-7,37,10)
   Pen(ByNode,ByNode,ByNode,in)
   Line(-54,0,-39,0)
   Text(-1,4,"DIload890")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([144,234],0,0,-1)
    {
    Name = "in"
    }
   0.breakout([180,234],0,0,-1)
    {
    Dis = "0"
    }
   -Wire-([396,198],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([396,234],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([396,270],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([234,198],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   -Wire-([306,234],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([378,270],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([378,306],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([378,360],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([270,360],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   .loadAB890([270,306],0,0,10)
    {
    }
   -Wire-([144,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pin([234,306],0,0,-1)
    {
    }
   .loadBC890([342,306],0,0,20)
    {
    }
   .loadCA890([306,360],0,0,30)
    {
    }
   }
  }
 Module("DPQload848")
  {
  Desc = ""
  FileDate = 1151590212
  Nodes = 
   {
   Electrical("in",-54,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Rectangle(-39,-7,37,10)
   Pen(ByNode,ByNode,ByNode,in)
   Line(-54,0,-39,0)
   Text(-1,4,"DPQload848")
   }


  Page(A/A4,Landscape,16,[835,483],5)
   {
   0.xnode([180,234],0,0,-1)
    {
    Name = "in"
    }
   0.breakout([216,234],0,0,-1)
    {
    Dis = "0"
    }
   -Wire-([432,198],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([432,234],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([432,270],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([270,198],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   -Wire-([342,234],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([414,270],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([414,306],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([414,360],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([306,360],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   .loadAB848([306,306],0,0,10)
    {
    }
   .loadBC848([378,306],0,0,20)
    {
    }
   .loadCA848([342,360],0,0,30)
    {
    }
   -Wire-([216,234],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   }
  }
 Module("Main")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-12,-12,12,11)
   }


  Page(D/A1,Landscape,16,[835,483],5)
   {
   0.source3R([252,1134],0,0,130)
    {
    Name = "Source1"
    MVA = "12.0 [MVA]"
    Vm = "24.9 [kV]"
    F = "60.0 [Hz]"
    Tc = "0.05 [sec]"
    Ideal = "1"
    ZSeq = "0"
    Imp = "0"
    View = "1"
    details = "1"
    Z1 = "1.0 [ohm]"
    Phi1 = "80.0 []"
    R1p = "0.16038 [ohm]"
    X1p = "0.64151 [ohm]"
    Z0 = "1.0 [ohm]"
    Phi0 = "80.0 []"
    R0p = "0.16977 [ohm]"
    X0p = "0.50932 [ohm]"
    P = "Psrc"
    Q = "Qsrc"
    Ia = "Ia_src"
    Ib = "Ib_src"
    Ic = "Ic_src"
    }
   0.const([270,1062],7,0,110)
    {
    Name = ""
    Value = "0.0"
    }
   0.mult([216,1062],1,0,100)
    {
    }
   0.const([90,1062],0,0,80)
    {
    Name = ""
    Value = "1.05"
    }
   0.const([180,1026],0,0,70)
    {
    Name = ""
    Value = "24.9"
    }
   -Wire-([2376,1386],0,0,-1)
    {
    Vertex="0,0;0,-126"
    }
   -Sticky-([72,72],0)
    {
    Name = ""
    Font = 2
    Bounds = 72,72,468,144
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
IEEE 34 BUS DISTRIBUTION TEST MODEL
WITH WIND GENERATORS"
    }
   .unbalanced_shortline([522,1134],0,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.488636"
    Type = "0"
    View = "1"
    Mac = ".5015 [ohm]"
    Mbc = ".4591 [ohm]"
    Mab = ".5779 [ohm]"
    Rac = "0.2130 [ohm]"
    Rbc = "0.2066 [ohm]"
    Rab = "0.2101 [ohm]"
    Lc = "1.3471 [ohm]"
    Lb = "1.3569 [ohm]"
    La = "1.3343 [ohm]"
    Rc = "1.3294 [ohm]"
    Rb = "1.3238 [ohm]"
    Ra = "1.3368 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9943 [uF]"
    Cac = "-0.6212 [uF]"
    Cab = "-1.5313 [uF]"
    Ccc = "4.888 [uF]"
    Cbb = "5.0979 [uF]"
    Caa = "5.335 [uF]"
    }
   0.annotation([522,1134],0,0,-1)
    {
    AL1 = "300"
    AL2 = ""
    }
   0.annotation([738,1134],0,0,-1)
    {
    AL1 = "300"
    AL2 = ""
    }
   .unbalanced_shortline([738,1134],0,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.081913"
    Type = "0"
    View = "1"
    Mac = ".5015 [ohm]"
    Mbc = ".4591 [ohm]"
    Mab = ".5779 [ohm]"
    Rac = "0.2130 [ohm]"
    Rbc = "0.2066 [ohm]"
    Rab = "0.2101 [ohm]"
    Lc = "1.3471 [ohm]"
    Lb = "1.3569 [ohm]"
    La = "1.3343 [ohm]"
    Rc = "1.3294 [ohm]"
    Rb = "1.3238 [ohm]"
    Ra = "1.3368 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9943 [uF]"
    Cac = "-0.6212 [uF]"
    Cab = "-1.5313 [uF]"
    Ccc = "4.888 [uF]"
    Cbb = "5.0979 [uF]"
    Caa = "5.335 [uF]"
    }
   .unbalanced_shortline([1098,1134],0,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "6.104167"
    Type = "0"
    View = "1"
    Mac = ".5015 [ohm]"
    Mbc = ".4591 [ohm]"
    Mab = ".5779 [ohm]"
    Rac = "0.2130 [ohm]"
    Rbc = "0.2066 [ohm]"
    Rab = "0.2101 [ohm]"
    Lc = "1.3471 [ohm]"
    Lb = "1.3569 [ohm]"
    La = "1.3343 [ohm]"
    Rc = "1.3294 [ohm]"
    Rb = "1.3238 [ohm]"
    Ra = "1.3368 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9943 [uF]"
    Cac = "-0.6212 [uF]"
    Cab = "-1.5313 [uF]"
    Ccc = "4.888 [uF]"
    Cbb = "5.0979 [uF]"
    Caa = "5.335 [uF]"
    }
   0.annotation([1098,1134],0,0,-1)
    {
    AL1 = "300"
    AL2 = ""
    }
   0.annotation([1116,1476],0,0,-1)
    {
    AL1 = "303"
    AL2 = ""
    }
   .unbalanced_shortline([1314,1134],0,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "7.102273"
    Type = "0"
    View = "1"
    Mac = ".5015 [ohm]"
    Mbc = ".4591 [ohm]"
    Mab = ".5779 [ohm]"
    Rac = "0.2130 [ohm]"
    Rbc = "0.2066 [ohm]"
    Rab = "0.2101 [ohm]"
    Lc = "1.3471 [ohm]"
    Lb = "1.3569 [ohm]"
    La = "1.3343 [ohm]"
    Rc = "1.3294 [ohm]"
    Rb = "1.3238 [ohm]"
    Ra = "1.3368 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9943 [uF]"
    Cac = "-0.6212 [uF]"
    Cab = "-1.5313 [uF]"
    Ccc = "4.888 [uF]"
    Cbb = "5.0979 [uF]"
    Caa = "5.335 [uF]"
    }
   0.annotation([1314,1134],0,0,-1)
    {
    AL1 = "300"
    AL2 = ""
    }
   .unbalanced_shortline([1530,1134],0,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "5.630682"
    Type = "0"
    View = "1"
    Mac = ".5015 [ohm]"
    Mbc = ".4591 [ohm]"
    Mab = ".5779 [ohm]"
    Rac = "0.2130 [ohm]"
    Rbc = "0.2066 [ohm]"
    Rab = "0.2101 [ohm]"
    Lc = "1.3471 [ohm]"
    Lb = "1.3569 [ohm]"
    La = "1.3343 [ohm]"
    Rc = "1.3294 [ohm]"
    Rb = "1.3238 [ohm]"
    Ra = "1.3368 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9943 [uF]"
    Cac = "-0.6212 [uF]"
    Cab = "-1.5313 [uF]"
    Ccc = "4.888 [uF]"
    Cbb = "5.0979 [uF]"
    Caa = "5.335 [uF]"
    }
   0.annotation([1530,1134],0,0,-1)
    {
    AL1 = "300"
    AL2 = ""
    }
   .unbalanced_shortline([1818,1134],0,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.001894"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   0.annotation([1818,1134],0,0,-1)
    {
    AL1 = "301"
    AL2 = ""
    }
   .unbalanced_shortline([1998,1134],0,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.058712"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   0.annotation([1998,1134],0,0,-1)
    {
    AL1 = "301"
    AL2 = ""
    }
   0.annotation([2088,882],6,0,-1)
    {
    AL1 = "302"
    AL2 = ""
    }
   .unbalanced_shortline([2322,1134],0,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "1.450284"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   0.annotation([2250,1134],0,0,-1)
    {
    AL1 = "301"
    AL2 = ""
    }
   -Wire-([2358,1134],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([2484,1998],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.annotation([2592,1134],0,0,-1)
    {
    AL1 = "303"
    AL2 = ""
    }
   -Wire-([2628,1134],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   .unbalanced_shortline([2376,1530],3,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.119318"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   0.annotation([2376,1530],1,0,-1)
    {
    AL1 = "301"
    AL2 = ""
    }
   -Wire-([2376,1566],0,0,-1)
    {
    Vertex="0,0;0,450"
    }
   .unbalanced_shortline([2592,1998],0,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.967803"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   0.annotation([2592,1998],0,0,-1)
    {
    AL1 = "301"
    AL2 = ""
    }
   -Wire-([2700,1998],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   .unbalanced_shortline([2898,1998],0,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.098485"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   0.annotation([2898,1998],0,0,-1)
    {
    AL1 = "301"
    AL2 = ""
    }
   0.annotation([3204,1998],0,0,-1)
    {
    AL1 = "303"
    AL2 = ""
    }
   -Wire-([3294,1998],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([2934,1962],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   .unbalanced_shortline([2952,1782],7,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "6.975379"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   0.annotation([2952,1782],5,0,-1)
    {
    AL1 = "301"
    AL2 = ""
    }
   .unbalanced_shortline([2952,1494],3,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.001894"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   0.annotation([2952,1494],1,0,-1)
    {
    AL1 = "301"
    AL2 = ""
    }
   .unbalanced_shortline([2952,1314],3,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.232008"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   0.annotation([2952,1278],1,0,-1)
    {
    AL1 = "301"
    AL2 = ""
    }
   .unbalanced_shortline([3204,1134],0,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.828125"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   0.annotation([3132,1134],0,0,-1)
    {
    AL1 = "301"
    AL2 = ""
    }
   -Wire-([3240,1134],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   .unbalanced_shortline([3456,1134],0,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.095644"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   0.annotation([3456,1134],0,0,-1)
    {
    AL1 = "301"
    AL2 = ""
    }
   -Wire-([3564,1134],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   .unbalanced_shortline([3276,918],7,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.05303"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   0.annotation([3276,900],5,0,-1)
    {
    AL1 = "301"
    AL2 = ""
    }
   -Wire-([3276,1062],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([3258,1116],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([3276,486],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   .unbalanced_shortline([3276,612],7,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.19176"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   0.annotation([3276,702],5,0,-1)
    {
    AL1 = "301"
    AL2 = ""
    }
   -Wire-([3834,522],0,0,-1)
    {
    Vertex="0,0;-216,0"
    }
   .unbalanced_shortline([3600,522],4,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.517045"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   0.annotation([3636,522],6,0,-1)
    {
    AL1 = "301"
    AL2 = ""
    }
   -Wire-([4032,522],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   .unbalanced_shortline([3870,522],4,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.025095"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   0.annotation([3906,522],6,0,-1)
    {
    AL1 = "301"
    AL2 = ""
    }
   .unbalanced_shortline([3798,1134],0,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.126894"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   0.annotation([3798,1134],0,0,-1)
    {
    AL1 = "301"
    AL2 = ""
    }
   -Wire-([3906,1134],0,0,-1)
    {
    Vertex="0,0;324,0"
    }
   .unbalanced_shortline([4266,1134],0,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.04072"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   0.annotation([4266,1134],0,0,-1)
    {
    AL1 = "301"
    AL2 = ""
    }
   -Wire-([4374,1134],0,0,-1)
    {
    Vertex="0,0;198,0"
    }
   .unbalanced_shortline([4032,1332],3,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.05303"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   0.annotation([4032,1332],1,0,-1)
    {
    AL1 = "301"
    AL2 = ""
    }
   -Wire-([3168,1458],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   0.annotation([4050,1674],0,0,-1)
    {
    AL1 = "304"
    AL2 = ""
    }
   -Wire-([4032,1710],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   0.xfmr-3p2w([3222,1458],0,0,-1)
    {
    Name = "T32"
    Tmva = "500 [kVA]"
    f = "60.0 [Hz]"
    YD1 = "1"
    YD2 = "0"
    Lead = "2"
    Xl = "0.0408 [p.u.]"
    Ideal = "1"
    NLL = "0.0 [pu]"
    CuL = "0.019 [p.u.]"
    Tap = "0"
    View = "1"
    Dtls = "1"
    V1 = "24.9 [kV]"
    V2 = "4.16 [kV]"
    Enab = "0"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [sec]"
    Xknee = "1.25 [pu]"
    Txk = "0.1 [sec]"
    Im1 = "0.4 [%]"
    ILA1 = ""
    ILB1 = ""
    ILC1 = ""
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = ""
    ILB2 = ""
    ILC2 = ""
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   -Wire-([3258,1458],0,0,-1)
    {
    Vertex="0,0;216,0"
    }
   .unbalanced_shortline([3582,1458],0,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "2"
    Type = "0"
    View = "1"
    Mac = ".5015 [ohm]"
    Mbc = ".4591 [ohm]"
    Mab = ".5779 [ohm]"
    Rac = "0.2130 [ohm]"
    Rbc = "0.2066 [ohm]"
    Rab = "0.2101 [ohm]"
    Lc = "1.3471 [ohm]"
    Lb = "1.3569 [ohm]"
    La = "1.3343 [ohm]"
    Rc = "1.3294 [ohm]"
    Rb = "1.3238 [ohm]"
    Ra = "1.3368 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9943 "
    Cac = "-0.6212 "
    Cab = "-1.5313 "
    Ccc = "4.888 "
    Cbb = "5.0979 "
    Caa = "5.335 "
    }
   0.annotation([3582,1458],0,0,-1)
    {
    AL1 = "300"
    AL2 = ""
    }
   -Wire-([3762,1458],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.ground([3222,1494],1,0,-1)
    {
    }
   0.fixed_load([3636,1206],0,0,-1)
    {
    PO = "20 [kW]"
    QO = "16 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.fixed_load([4572,1098],6,0,-1)
    {
    PO = "0.009 [MW]"
    QO = "0.007 [MVAR]"
    VBO = "14.38 [kV]"
    NP = "1"
    NQ = "1"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.fixed_load([3114,540],0,0,-1)
    {
    PO = "0.135 [MW]"
    QO = "0.105 [MVAR]"
    VBO = "14.38 [kV]"
    NP = "2"
    NQ = "2"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.fixed_load([828,1314],0,0,-1)
    {
    PO = "20 [kW]"
    QO = "10 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.breakout([828,1152],7,0,-1)
    {
    Dis = "0"
    }
   0.fixed_load([864,1224],0,0,-1)
    {
    PO = "16.7 [kW]"
    QO = "9.3 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.fixed_load([918,1314],0,0,-1)
    {
    PO = "10 [kW]"
    QO = "5 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.breakout([918,1152],7,0,-1)
    {
    Dis = "0"
    }
   0.fixed_load([954,1224],0,0,-1)
    {
    PO = "8.3 [kW]"
    QO = "4.7 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.fixed_load([1296,1530],3,0,-1)
    {
    PO = "10.6667 [kW]"
    QO = "5.3333 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "1"
    NQ = "1"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.breakout([1134,1170],7,0,-1)
    {
    Dis = "0"
    }
   0.breakout([2070,1098],5,0,-1)
    {
    Dis = "0"
    }
   0.fixed_load([2196,540],3,0,-1)
    {
    PO = "22.6667 [kW]"
    QO = "11.3333 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "2"
    NQ = "2"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.fixed_load([1458,360],4,0,-1)
    {
    PO = "45 [kW]"
    QO = "23.3333 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.fixed_load([2700,1224],0,0,-1)
    {
    PO = "26.6667 [kW]"
    QO = "13.3333 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "1"
    NQ = "1"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.breakout([2466,1134],6,0,-1)
    {
    Dis = "0"
    }
   0.fixed_load([2322,1494],1,0,-1)
    {
    PO = "2.6667 [kW]"
    QO = "1.3333 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.breakout([2376,1458],4,0,-1)
    {
    Dis = "0"
    }
   0.fixed_load([2322,1620],1,0,-1)
    {
    PO = "1.3333 [kW]"
    QO = "0.6667 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.breakout([2376,1584],4,0,-1)
    {
    Dis = "0"
    }
   0.fixed_load([2592,1926],2,0,-1)
    {
    PO = "4.6667 [kW]"
    QO = "2 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.breakout([2628,1980],3,0,-1)
    {
    Dis = "0"
    }
   0.breakout([2718,1980],3,0,-1)
    {
    Dis = "0"
    }
   0.fixed_load([2682,1926],2,0,-1)
    {
    PO = "2.3333 [kW]"
    QO = "1 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.fixed_load([3330,2106],0,0,-1)
    {
    PO = "2.6667 [kW]"
    QO = "1.3333 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.breakout([2988,1998],6,0,-1)
    {
    Dis = "0"
    }
   0.breakout([2952,1080],3,0,-1)
    {
    Dis = "0"
    }
   0.breakout([4032,1530],7,0,-1)
    {
    Dis = "0"
    }
   0.fixed_load([3330,702],3,0,-1)
    {
    PO = "6 [kW]"
    QO = "3.33 [kVAR]"
    VBO = " 14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.breakout([3276,666],6,0,-1)
    {
    Dis = "0"
    }
   0.fixed_load([3330,612],7,0,-1)
    {
    PO = "3 [kW]"
    QO = "1.6667 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.breakout([3276,576],6,0,-1)
    {
    Dis = "0"
    }
   0.fixed_load([3582,576],0,0,-1)
    {
    PO = "13.333 [kW]"
    QO = "7.3333 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.breakout([3546,522],7,0,-1)
    {
    Dis = "0"
    }
   0.breakout([3672,522],7,0,-1)
    {
    Dis = "0"
    }
   -Wire-([3564,522],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.fixed_load([3546,648],0,0,-1)
    {
    PO = "16.6667 [kW]"
    QO = "8 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.fixed_load([3672,666],0,0,-1)
    {
    PO = "8.3333 [kW]"
    QO = "4 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.fixed_load([3708,576],0,0,-1)
    {
    PO = "6.667 [kW]"
    QO = "3.6667 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.breakout([3924,522],7,0,-1)
    {
    Dis = "0"
    }
   0.breakout([4014,522],7,0,-1)
    {
    Dis = "0"
    }
   0.fixed_load([4014,576],4,0,-1)
    {
    PO = "7.6667 [kW]"
    QO = "3.6667 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.fixed_load([3924,666],0,0,-1)
    {
    PO = "15.3333 [kW]"
    QO = "7.3333 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.capacitive_load([3204,522],0,0,-1)
    {
    S = "100 [kVAR]"
    V = "14.38 [kV]"
    F = "60.0 [Hz]"
    SD = "0"
    }
   0.capacitive_load([4194,486],6,0,-1)
    {
    S = "150 [kVAR]"
    V = "14.38 [kV]"
    F = "60.0 [Hz]"
    SD = "0"
    }
   .DPQload848([4194,576],1,0,60)
    {
    }
   .DIload890([3780,1530],1,0,530)
    {
    }
   .DZload830([2718,2070],1,0,580)
    {
    }
   0.breakout([2286,1134],3,0,-1)
    {
    Dis = "0"
    }
   .loadBC816([2322,1080],4,0,240)
    {
    }
   -Wire-([2322,1098],0,0,-1)
    {
    Vertex="0,0;36,0;36,-18"
    }
   .loadBC824([2340,1008],2,0,180)
    {
    }
   0.breakout([2376,1062],5,0,-1)
    {
    Dis = "0"
    }
   -Wire-([2340,1026],0,0,-1)
    {
    Vertex="0,0;-36,0;-36,-18"
    }
   -Wire-([2376,1008],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   .DZload832([2898,1260],4,0,410)
    {
    }
   .DZload858([2898,1152],4,0,340)
    {
    }
   .DPQload858([3168,1188],1,0,370)
    {
    }
   .DPQload834([3240,1188],1,0,380)
    {
    }
   .DPQload860([3834,1188],1,0,420)
    {
    }
   .DPQload836([3906,1188],1,0,430)
    {
    }
   .DZload834([3492,1188],1,0,390)
    {
    }
   .DZload860([3564,1188],1,0,400)
    {
    }
   .DIload836([4302,1188],1,0,450)
    {
    }
   .DIload840([4374,1188],1,0,460)
    {
    }
   0.resistor([1134,1350],3,0,-1)
    {
    R = "0.769332 [ohm]"
    }
   0.inductor([1134,1440],3,0,-1)
    {
    L = "1.083 [mH]"
    }
   -Wire-([1134,1440],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   -Wire-([1134,1494],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.capacitor([1224,1494],0,0,-1)
    {
    C = "3.08 [nF]"
    }
   0.ground([1260,1494],0,0,-1)
    {
    }
   0.resistor([2106,882],7,0,-1)
    {
    R = "0.9067 [ohm]"
    }
   0.inductor([2106,810],7,0,-1)
    {
    L = "1.3 [mH]"
    }
   -Wire-([2106,810],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   -Wire-([2106,792],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.capacitor([2070,792],2,0,-1)
    {
    C = "3.6 [nF]"
    }
   0.ground([2034,792],2,0,-1)
    {
    }
   0.annotation([2088,630],6,0,-1)
    {
    AL1 = "302"
    AL2 = ""
    }
   0.resistor([2106,666],7,0,-1)
    {
    R = "6.382383 [ohm]"
    }
   0.inductor([2106,576],7,0,-1)
    {
    L = "8.983 [mH]"
    }
   -Wire-([2106,558],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.capacitor([2070,558],2,0,-1)
    {
    C = "25.55 [nF]"
    }
   0.ground([2034,558],2,0,-1)
    {
    }
   -Wire-([2106,576],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.annotation([1638,252],4,0,-1)
    {
    AL1 = "302"
    AL2 = ""
    }
   0.resistor([1674,252],6,0,-1)
    {
    R = "5.463797 [ohm]"
    }
   0.inductor([1566,252],6,0,-1)
    {
    L = "7.69 [mH]"
    }
   0.capacitor([1512,306],1,0,-1)
    {
    C = "21.873 [nF]"
    }
   0.ground([1512,342],1,0,-1)
    {
    }
   -Wire-([1602,252],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1422,252],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.resistor([2520,1134],6,0,-1)
    {
    R = "0.401633 [ohm]"
    }
   0.inductor([2592,1134],6,0,-1)
    {
    L = "565 [uH]"
    }
   -Wire-([2646,1134],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.capacitor([2646,1170],1,0,-1)
    {
    C = "1.608 [nF]"
    }
   0.ground([2646,1206],1,0,-1)
    {
    }
   0.resistor([3114,1998],6,0,-1)
    {
    R = "3.09244 [ohm]"
    }
   0.inductor([3204,1998],6,0,-1)
    {
    L = "4.353 [mH]"
    }
   0.capacitor([3294,2034],1,0,-1)
    {
    C = "12.38 [nF]"
    }
   0.ground([3294,2070],1,0,-1)
    {
    }
   0.resistor([4032,1620],5,0,-1)
    {
    R = "1.442209 [ohm]"
    }
   0.inductor([4032,1710],5,0,-1)
    {
    L = "867 [uH]"
    }
   -Wire-([4032,1728],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.capacitor([4068,1728],0,0,-1)
    {
    C = "2.664 [nF]"
    }
   0.ground([4104,1728],0,0,-1)
    {
    }
   0.annotation([2898,846],6,0,-1)
    {
    AL1 = "302"
    AL2 = ""
    }
   0.resistor([2916,936],7,0,-1)
    {
    R = "0.214734 [ohm]"
    }
   0.inductor([2916,864],7,0,-1)
    {
    L = "302 [uH]"
    }
   -Wire-([2916,792],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.capacitor([2880,792],2,0,-1)
    {
    C = "0.86 [nF]"
    }
   0.ground([2844,792],2,0,-1)
    {
    }
   -Wire-([2916,738],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   -Wire-([3744,504],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.annotation([3744,468],0,0,-1)
    {
    AL1 = "BUS846"
    AL2 = ""
    }
   -Wire-([2358,2016],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.annotation([2340,1998],0,0,-1)
    {
    AL1 = "BUS828"
    AL2 = ""
    }
   -Wire-([2376,1062],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   0.annotation([2340,1152],0,0,-1)
    {
    AL1 = "BUS824"
    AL2 = ""
    }
   -Wire-([2070,1098],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.annotation([2070,1152],0,0,-1)
    {
    AL1 = "BUS816"
    AL2 = ""
    }
   -Wire-([1854,1116],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.annotation([1854,1098],0,0,-1)
    {
    AL1 = "BUS850"
    AL2 = ""
    }
   -Wire-([2088,774],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.annotation([2142,756],0,0,-1)
    {
    AL1 = "BUS818"
    AL2 = ""
    }
   -Wire-([2178,540],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([1350,234],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.annotation([1314,234],0,0,-1)
    {
    AL1 = "BUS822"
    AL2 = ""
    }
   -Wire-([324,1152],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([612,1116],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([918,1116],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([1134,1116],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([1350,1116],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.annotation([324,1098],0,0,-1)
    {
    AL1 = "BUS800"
    AL2 = ""
    }
   0.annotation([612,1098],0,0,-1)
    {
    AL1 = "BUS802"
    AL2 = ""
    }
   0.annotation([918,1098],0,0,-1)
    {
    AL1 = "BUS806"
    AL2 = ""
    }
   0.annotation([1134,1098],0,0,-1)
    {
    AL1 = "BUS808"
    AL2 = ""
    }
   0.annotation([1350,1098],0,0,-1)
    {
    AL1 = "BUS812"
    AL2 = ""
    }
   -Wire-([1566,1116],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.annotation([1566,1098],0,0,-1)
    {
    AL1 = "BUS814"
    AL2 = ""
    }
   -Wire-([1134,1530],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   -Wire-([2718,1980],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([2934,1944],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([3330,1998],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.annotation([2682,1998],0,0,-1)
    {
    AL1 = "BUS830"
    AL2 = ""
    }
   0.annotation([2934,2016],0,0,-1)
    {
    AL1 = "BUS854"
    AL2 = ""
    }
   -Wire-([2934,1746],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.annotation([2988,1728],0,0,-1)
    {
    AL1 = "BUS852"
    AL2 = ""
    }
   -Wire-([2952,1080],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.annotation([2916,1116],0,0,-1)
    {
    AL1 = "BUS858"
    AL2 = ""
    }
   -Wire-([3474,1458],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.annotation([2916,1440],0,0,-1)
    {
    AL1 = "BUS832"
    AL2 = ""
    }
   -Wire-([3114,522],0,0,-1)
    {
    Vertex="0,0;324,0"
    }
   0.annotation([3186,486],0,0,-1)
    {
    AL1 = "BUS844"
    AL2 = ""
    }
   -Wire-([3258,882],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.annotation([3240,864],0,0,-1)
    {
    AL1 = "BUS842"
    AL2 = ""
    }
   -Wire-([4194,486],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.annotation([4230,504],0,0,-1)
    {
    AL1 = "BUS848"
    AL2 = ""
    }
   -Wire-([3258,1098],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.annotation([3276,1152],0,0,-1)
    {
    AL1 = "BUS834"
    AL2 = ""
    }
   -Wire-([3618,1116],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.annotation([3618,1098],0,0,-1)
    {
    AL1 = "BUS860"
    AL2 = ""
    }
   -Wire-([4032,1116],0,0,-1)
    {
    Vertex="0,0;0,180"
    }
   -Wire-([4572,1116],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([4014,1530],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.annotation([4032,1098],0,0,-1)
    {
    AL1 = "BUS836"
    AL2 = ""
    }
   0.annotation([4590,1152],0,0,-1)
    {
    AL1 = "BUS840"
    AL2 = ""
    }
   0.annotation([4068,1512],0,0,-1)
    {
    AL1 = "BUS862"
    AL2 = ""
    }
   -Wire-([4032,1800],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([3330,1440],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([3780,1440],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.annotation([3330,1476],0,0,-1)
    {
    AL1 = "BUS888"
    AL2 = ""
    }
   0.annotation([3780,1422],0,0,-1)
    {
    AL1 = "BUS890"
    AL2 = ""
    }
   -Wire-([2700,1134],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.annotation([2736,792],0,0,-1)
    {
    AL1 = "BUS826"
    AL2 = ""
    }
   -Wire-([2916,774],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pin([612,1134],0,0,-1)
    {
    }
   0.pin([918,1134],0,0,-1)
    {
    }
   0.pin([1134,1134],0,0,-1)
    {
    }
   0.pin([2376,1134],0,0,-1)
    {
    }
   0.pin([2718,1998],0,0,-1)
    {
    }
   0.pin([3780,1458],0,0,-1)
    {
    }
   0.pin([3618,1134],0,0,-1)
    {
    }
   0.pin([4032,1134],0,0,-1)
    {
    }
   0.pin([4572,1134],0,0,-1)
    {
    }
   0.pin([4032,1530],0,0,-1)
    {
    }
   0.pin([4194,522],0,0,-1)
    {
    }
   0.pin([3672,522],1,0,-1)
    {
    }
   0.pin([3276,522],0,0,-1)
    {
    }
   0.pin([3276,882],0,0,-1)
    {
    }
   0.pin([2106,774],0,0,-1)
    {
    }
   0.pin([2700,1134],0,0,-1)
    {
    }
   0.datalabel([432,1206],0,0,-1)
    {
    Name = "Is"
    }
   0.pgb([432,1206],0,48603496,190)
    {
    Name = "Is"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-25.0"
    Max = "25.0"
    }
   0.datalabel([432,1242],0,0,-1)
    {
    Name = "Vs"
    }
   0.pgb([432,1242],0,48605904,210)
    {
    Name = "Vs"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-25.0"
    Max = "25.0"
    }
   0.datalabel([432,1278],0,0,-1)
    {
    Name = "Ps"
    }
   0.pgb([432,1278],0,48608352,260)
    {
    Name = "Ps"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.2"
    Max = "1.8"
    }
   0.datalabel([432,1314],0,0,-1)
    {
    Name = "Qs"
    }
   0.pgb([432,1314],0,48610800,280)
    {
    Name = "Qs"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.2"
    Max = "1.8"
    }
   0.datalabel([432,1350],0,0,-1)
    {
    Name = "angs"
    }
   0.pgb([432,1350],0,48613384,320)
    {
    Name = "angs"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "0.0014"
    }
   .regulator1([1746,1134],0,0,230)
    {
    }
   .regulator2([2952,1566],3,0,520)
    {
    }
   .unbalanced_shortline([882,1134],0,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.245739"
    Type = "0"
    View = "1"
    Mac = ".5015 [ohm]"
    Mbc = ".4591 [ohm]"
    Mab = ".5779 [ohm]"
    Rac = "0.2130 [ohm]"
    Rbc = "0.2066 [ohm]"
    Rab = "0.2101 [ohm]"
    Lc = "1.3471 [ohm]"
    Lb = "1.3569 [ohm]"
    La = "1.3343 [ohm]"
    Rc = "1.3294 [ohm]"
    Rb = "1.3238 [ohm]"
    Ra = "1.3368 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9943 [uF]"
    Cac = "-0.6212 [uF]"
    Cab = "-1.5313 [uF]"
    Ccc = "4.888 [uF]"
    Cbb = "5.0979 [uF]"
    Caa = "5.335 [uF]"
    }
   -Wire-([774,1134],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pin([828,1134],0,0,-1)
    {
    }
   -Wire-([828,1152],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.fixed_load([1278,1764],3,0,-1)
    {
    PO = "5.3333 [kW]"
    QO = "2.6667 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "1"
    NQ = "1"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.resistor([1134,1602],3,0,-1)
    {
    R = "2.307997 [ohm]"
    }
   0.inductor([1134,1692],3,0,-1)
    {
    L = "3.249 [mH]"
    }
   -Wire-([1134,1692],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([1134,1710],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.capacitor([1206,1710],0,0,-1)
    {
    C = "9.24 [nF]"
    }
   0.ground([1242,1710],0,0,-1)
    {
    }
   0.annotation([1152,1854],0,0,-1)
    {
    AL1 = "BUS810"
    AL2 = ""
    }
   0.pin([1134,1530],0,0,-1)
    {
    }
   0.fixed_load([2178,252],3,0,-1)
    {
    PO = "11.3333 [kW]"
    QO = "5.6667 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "2"
    NQ = "2"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.resistor([2106,468],7,0,-1)
    {
    R = "19.14715 [ohm]"
    }
   0.inductor([2106,378],7,0,-1)
    {
    L = "26.95 [mH]"
    }
   -Wire-([2106,342],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.capacitor([2070,342],2,0,-1)
    {
    C = "76.65 [nF]"
    }
   0.ground([2034,342],2,0,-1)
    {
    }
   -Wire-([2106,378],0,0,-1)
    {
    Vertex="0,0;0,-126"
    }
   -Wire-([2070,252],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.annotation([2106,216],0,0,-1)
    {
    AL1 = "BUS820"
    AL2 = ""
    }
   0.resistor([1944,252],6,0,-1)
    {
    R = "1.821266 [ohm]"
    }
   0.inductor([1836,252],6,0,-1)
    {
    L = "2.563 [mH]"
    }
   0.capacitor([1782,306],1,0,-1)
    {
    C = "7.291 [nF]"
    }
   0.ground([1782,342],1,0,-1)
    {
    }
   -Wire-([1872,252],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1710,252],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([1728,252],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pin([2106,252],0,0,-1)
    {
    }
   0.pin([2106,504],0,0,-1)
    {
    }
   0.pin([1710,252],0,0,-1)
    {
    }
   0.fixed_load([1728,360],4,0,-1)
    {
    PO = "90 [kW]"
    QO = "46.6667 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.pin([1350,252],0,0,-1)
    {
    }
   .unbalanced_shortline([2250,1134],0,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.483428"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   -Wire-([2700,1080],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.resistor([2700,1044],7,0,-1)
    {
    R = "1.204898 [ohm]"
    }
   0.inductor([2700,972],7,0,-1)
    {
    L = "1.696 [mH]"
    }
   -Wire-([2700,936],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.capacitor([2664,936],2,0,-1)
    {
    C = "4.824 [nF]"
    }
   0.ground([2628,936],2,0,-1)
    {
    }
   -Wire-([2700,882],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.fixed_load([2736,918],7,0,-1)
    {
    PO = "13.3333 [kW]"
    QO = "6.6667[kVAR]"
    VBO = "14.38 [kV]"
    NP = "1"
    NQ = "1"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   -Wire-([2682,828],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   .unbalanced_shortline([2376,1422],3,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.039773"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   .unbalanced_shortline([2664,1998],0,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "2.903409"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   -Wire-([2628,1980],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([3600,1998],0,0,-1)
    {
    Vertex="0,0;-108,0"
    }
   0.fixed_load([3564,2106],0,0,-1)
    {
    PO = "1.3333 [kW]"
    QO = "0.6667 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.resistor([3366,1998],6,0,-1)
    {
    R = "9.27732 [ohm]"
    }
   0.inductor([3456,1998],6,0,-1)
    {
    L = "13.058 [mH]"
    }
   0.capacitor([3528,2034],1,0,-1)
    {
    C = "37.14 [nF]"
    }
   0.ground([3528,2070],1,0,-1)
    {
    }
   -Wire-([3294,1998],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([3564,1998],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.annotation([3690,1998],0,0,-1)
    {
    AL1 = "BUS856"
    AL2 = ""
    }
   0.pin([3564,1998],0,0,-1)
    {
    }
   .unbalanced_shortline([2952,1188],3,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.696023"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   -Wire-([2952,1134],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.fixed_load([2988,576],3,0,-1)
    {
    PO = "0.6667 [kW]"
    QO = "0.3333 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.resistor([2916,702],7,0,-1)
    {
    R = "0.644203 [ohm]"
    }
   0.inductor([2916,630],7,0,-1)
    {
    L = "907 [uH]"
    }
   -Wire-([2916,594],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.capacitor([2880,594],2,0,-1)
    {
    C = "2.579 [nF]"
    }
   0.ground([2844,594],2,0,-1)
    {
    }
   -Wire-([2916,540],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   -Wire-([2916,576],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.annotation([2916,468],0,0,-1)
    {
    AL1 = "BUS864"
    AL2 = ""
    }
   0.fixed_load([2988,774],3,0,-1)
    {
    PO = "1.3333 [kW]"
    QO = "0.66667 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.pin([2916,774],0,0,-1)
    {
    }
   .unbalanced_shortline([3132,1134],0,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.276042"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   .unbalanced_shortline([3528,1134],0,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.286932"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   .unbalanced_shortline([3870,1134],0,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.380682"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   .unbalanced_shortline([4338,1134],0,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.122159"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   -Wire-([4032,1962],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.fixed_load([4122,2052],3,0,-1)
    {
    PO = "9.3333 [kW]"
    QO = "4.6667 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   0.resistor([4032,1872],5,0,-1)
    {
    R = "1.326628 [ohm]"
    }
   0.inductor([4032,1962],5,0,-1)
    {
    L = "2.602 [mH]"
    }
   -Wire-([4032,1980],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.capacitor([4068,1980],0,0,-1)
    {
    C = "0.007991 [uF]"
    }
   0.ground([4104,1980],0,0,-1)
    {
    }
   -Wire-([4032,2052],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.annotation([3996,2142],0,0,-1)
    {
    AL1 = "BUS838"
    AL2 = ""
    }
   0.fixed_load([4122,1800],3,0,-1)
    {
    PO = "18.6667 [kW]"
    QO = "9.3333 [kVAR]"
    VBO = "14.38 [kV]"
    NP = "0"
    NQ = "0"
    KPF = "0"
    KQF = "0"
    FR = "60 [Hz]"
    Dtls = "1"
    R1 = ""
    L1 = ""
    C1 = ""
    }
   .unbalanced_shortline([3276,702],7,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.06392"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   -Wire-([3276,648],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   .unbalanced_shortline([3474,522],4,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.172348"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   .unbalanced_shortline([3960,522],4,0,-1)
    {
    f = "60.0 [Hz]"
    NCap = "1"
    length = "0.075284"
    Type = "0"
    View = "1"
    Mac = ".5691 [ohm]"
    Mbc = ".5238 [ohm]"
    Mab = ".6442 [ohm]"
    Rac = "0.2359 [ohm]"
    Rbc = "0.2288 [ohm]"
    Rab = "0.2327 [ohm]"
    Lc = "1.4209 [ohm]"
    Lb = "1.4281 [ohm]"
    La = "1.4115 [ohm]"
    Rc = "1.9219 [ohm]"
    Rb = "1.9157 [ohm]"
    Ra = "1.93 [ohm]"
    Lz = "0.028 [H]"
    Rz = "0.01 [ohm]"
    Lp = "0.001 [H]"
    Rp = "0.01 [ohm]"
    Cod = "-0.5 [uF]"
    Cd = "2.5 [uF]"
    Cbc = "-0.9402 [uF]"
    Cac = "-0.5951 [uF]"
    Cab = "-1.4364 [uF]"
    Ccc = "4.7154 [uF]"
    Cbb = "4.9055 [uF]"
    Caa = "5.1207 [uF]"
    }
   -Wire-([3906,522],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.pin([1566,1134],0,0,-1)
    {
    }
   -Wire-([1656,1134],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1566,1134],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1134,1134],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1026,1134],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([558,1134],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pin([2070,1134],0,0,-1)
    {
    }
   -Wire-([2178,1134],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2034,1134],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([2376,1134],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2286,1080],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.multimeter([1134,1260],1,0,300)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376[kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = "Ib08_10"
    VolI = "Vb08_10"
    P = "Pb08_10"
    Q = "Qb08_10"
    Vrms = "Vbrms08_10"
    Ph = "Ab08_10"
    hide1 = "1"
    hide2 = "1"
    Pd = "0.02045"
    Qd = "0.009282"
    Vd = "1.014"
    }
   0.multimeter([2106,990],3,0,160)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = "Ia16_18"
    VolI = "Va16_18"
    P = "Pa16_18"
    Q = "Qa16_18"
    Vrms = "Varms16_18"
    Ph = "Aa16_18"
    hide1 = "1"
    hide2 = "1"
    Pd = "0.06004"
    Qd = "0.02807"
    Vd = "0.5032"
    }
   0.multimeter([2106,738],3,0,40)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = "Ia18_20"
    VolI = "Va18_20"
    P = "Pa18_20"
    Q = "Qa18_20"
    Vrms = "Varms18_20"
    Ph = "Aa18_20"
    hide1 = "1"
    hide2 = "1"
    Pd = "0.05997"
    Qd = "0.02805"
    Vd = "0.5026"
    }
   0.multimeter([2052,252],4,0,20)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = "Ia20_22"
    VolI = "Va20_22"
    P = "Pa20_22"
    Q = "Qa20_22"
    Vrms = "Varms20_22"
    Ph = "Aa20_22"
    hide1 = "1"
    hide2 = "1"
    Pd = "0.04977"
    Qd = "0.02472"
    Vd = "0.4854"
    }
   -Wire-([1134,1350],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.multimeter([3060,1998],0,0,570)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = "Ib54_56"
    VolI = "Vb54_56"
    P = "Pb54_56"
    Q = "Qb54_56"
    Vrms = "Vbrms54_56"
    Ph = "Ab54_56"
    hide1 = "1"
    hide2 = "1"
    Pd = "0.006128"
    Qd = "-0.0007156"
    Vd = "0.9915"
    }
   -Wire-([3150,1998],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.multimeter([2916,1026],3,0,250)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = "Ia58_64"
    VolI = "Va58_64"
    P = "Pa58_64"
    Q = "Qa58_64"
    Vrms = "Varms58_64"
    Ph = "Aa58_64"
    hide1 = "1"
    hide2 = "1"
    Pd = "4.686e-006"
    Qd = "6.746e-005"
    Vd = "0.03261"
    }
   -Wire-([3042,1134],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2952,1134],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([3366,1134],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([3618,1134],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.pin([3258,1134],0,0,-1)
    {
    }
   0.multimeter([1134,1818],7,0,540)
    {
    MeasI = "0"
    MeasV = "0"
    MeasP = "0"
    MeasQ = "0"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376[kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = "Ib10"
    VolI = "Vb10"
    P = "Pb10"
    Q = "Qb10"
    Vrms = "Vbrms10"
    Ph = "Ab10"
    hide1 = "1"
    hide2 = "1"
    Pd = "-1.144e-017"
    Qd = "-2.485e-016"
    Vd = "1.014"
    }
   0.multimeter([1404,252],4,0,10)
    {
    MeasI = "0"
    MeasV = "0"
    MeasP = "0"
    MeasQ = "0"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376[kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = "Ia22"
    VolI = "Va22"
    P = "Pa22"
    Q = "Qa22"
    Vrms = "Varms22"
    Ph = "Aa22"
    hide1 = "1"
    hide2 = "1"
    Pd = "-8.918e-018"
    Qd = "-1.191e-016"
    Vd = "0.4832"
    }
   0.multimeter([2700,864],3,0,120)
    {
    MeasI = "0"
    MeasV = "0"
    MeasP = "0"
    MeasQ = "0"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376[kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = "Ib26"
    VolI = "Vb26"
    P = "Pb26"
    Q = "Qb26"
    Vrms = "Vbrms26"
    Ph = "Ab26"
    hide1 = "1"
    hide2 = "1"
    Pd = "-4.403e-017"
    Qd = "-4.447e-016"
    Vd = "1.016"
    }
   0.multimeter([2916,522],3,0,30)
    {
    MeasI = "0"
    MeasV = "0"
    MeasP = "0"
    MeasQ = "0"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376[kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = "Ia64"
    VolI = "Va64"
    P = "Pa64"
    Q = "Qa64"
    Vrms = "Varms64"
    Ph = "Aa64"
    hide1 = "1"
    hide2 = "1"
    Pd = "8.304e-017"
    Qd = "-8.627e-016"
    Vd = "0.03261"
    }
   -Wire-([4032,522],0,0,-1)
    {
    Vertex="0,0;198,0"
    }
   0.multimeter([4032,2106],1,0,600)
    {
    MeasI = "0"
    MeasV = "0"
    MeasP = "0"
    MeasQ = "0"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376[kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = "Ib38"
    VolI = "Vb38"
    P = "Pb8"
    Q = "Qb8"
    Vrms = "Vbrms38"
    Ph = "Ab8"
    hide1 = "1"
    hide2 = "1"
    Pd = "-3.659e-017"
    Qd = "-2.812e-016"
    Vd = "1.026"
    }
   -Wire-([4032,1512],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.multimeter([3618,1998],0,0,590)
    {
    MeasI = "0"
    MeasV = "0"
    MeasP = "0"
    MeasQ = "0"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "14.376 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = "Ib56"
    VolI = "Vb56"
    P = "Pb56"
    Q = "Qb56"
    Vrms = "Vbrms56"
    Ph = "Ab56"
    hide1 = "1"
    hide2 = "1"
    Pd = "-1.133e-018"
    Qd = "-8.395e-017"
    Vd = "0.9913"
    }
   -Wire-([3654,1980],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.pin([3654,1998],0,0,-1)
    {
    }
   -Wire-([2898,486],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pin([2916,486],0,0,-1)
    {
    }
   -Wire-([1134,1854],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1134,1854],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.pin([1134,1854],0,0,-1)
    {
    }
   -Wire-([1458,252],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pin([2700,828],0,0,-1)
    {
    }
   -Wire-([4014,2142],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pin([4032,2142],0,0,-1)
    {
    }
   -Wire-([2718,1998],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   -Wire-([2952,1962],0,0,-1)
    {
    Vertex="0,0;0,-144"
    }
   -Wire-([3276,882],0,0,-1)
    {
    Vertex="0,0;0,-144"
    }
   -Wire-([1350,1134],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   -Wire-([1854,1134],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([612,1134],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   .Meters800([360,1134],0,0,140)
    {
    }
   -Wire-([288,1134],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([450,1134],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   .Meters806([1008,1134],0,0,170)
    {
    }
   0.multimeter([432,1134],0,0,150)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "2"
    S = "1.0 [MVA]"
    BaseV = "24.9 [kV]"
    TS = "0.2 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = "Is"
    VolI = "Vs"
    P = "Ps"
    Q = "Qs"
    Vrms = ""
    Ph = "angs"
    hide1 = "1"
    hide2 = "1"
    Pd = "5.339"
    Qd = "5.16"
    Vd = "1.05"
    }
   -Wire-([414,1134],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([918,1134],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   .Meters808([1224,1134],0,0,200)
    {
    }
   -Wire-([1242,1134],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   .Meters814([1638,1134],0,0,220)
    {
    }
   .Meters816([2160,1134],0,0,270)
    {
    }
   -Wire-([2106,882],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([2106,972],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   -Wire-([2106,612],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([2106,702],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([2106,414],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([2034,252],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([1782,252],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([1512,306],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   -Wire-([1350,252],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,1062],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   -Wire-([828,1188],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([864,1188],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([918,1188],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([954,1206],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([1134,1206],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([1134,1278],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([1134,1656],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   -Wire-([1134,1764],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([1134,1836],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   .Meters824([2430,1134],0,0,310)
    {
    }
   -Wire-([2700,1008],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([2700,846],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([2718,918],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2520,1134],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2556,1134],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2466,1134],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   .Meters824_828([2376,1242],1,0,360)
    {
    }
   -Wire-([2376,1458],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   .Meters828_830([2466,1998],0,0,560)
    {
    }
   -Wire-([2394,2016],0,0,-1)
    {
    Vertex="0,0;0,-18;54,-18"
    }
   -Wire-([3024,1998],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([3078,1998],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([3294,1998],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([3402,1998],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([3528,2034],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([3636,1998],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([2934,1998],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   .Meters852_832([2952,1692],3,0,550)
    {
    }
   -Wire-([2952,1710],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([2952,1674],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   .Meters832_888([3078,1458],0,0,480)
    {
    }
   -Wire-([3060,1458],0,0,-1)
    {
    Vertex="0,0;-108,0"
    }
   -Wire-([2952,1458],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   .Meters832_858([2952,1404],3,0,470)
    {
    }
   -Wire-([2952,1224],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([2952,1350],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   .Meters858_834([3024,1134],0,0,330)
    {
    }
   .Meters834_860([3348,1134],0,0,350)
    {
    }
   .Meters834_842([3276,1044],3,0,290)
    {
    }
   -Wire-([3276,954],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([3618,1152],0,0,-1)
    {
    Vertex="0,0;18,0;18,36"
    }
   -Wire-([3330,1458],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([3744,522],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([3546,558],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([3672,558],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([3924,558],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   .Meters888_890([3672,1458],0,0,490)
    {
    }
   -Wire-([3618,1458],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([3690,1458],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   .Meters836_862([4032,1440],3,0,500)
    {
    }
   -Wire-([4032,1368],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([4032,1458],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([4032,1566],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([4032,1620],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([4032,1872],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([4032,2124],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([4032,2052],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([2916,972],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([2916,900],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([2916,666],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([2916,504],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Sticky-([72,144],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,144,414,234
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Developed June 2006
by Jen Z. Zhou, Dharshana Muthumuni, and Paul Wilson.
This version of the model is complete with wind generators.  This model can only run in the Professional version of PSCAD.

IEEE Description papers and discussion available."
    }
   0.pin([324,1134],0,0,-1)
    {
    }
   0.var([144,1062],0,48739680,90)
    {
    Name = "Vs"
    Group = ""
    Display = "1"
    Max = "1.20"
    Min = "0.0"
    Value = "1.05"
    Units = ""
    Collect = "1"
    }
   -ControlPanel-([54,1098],0)
    {
    Name = "$(GROUP) : Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,0,0
    Slider(48739680)
    }
   -Wire-([4230,522],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([3258,1152],0,0,-1)
    {
    Vertex="0,0;54,0;54,72"
    }
   -Wire-([3294,1260],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.tfaultn([3240,1260],4,0,440)
    {
    TF = "4.1"
    DF = "1111"
    }
   0.tpflt([3330,1224],4,0,610)
    {
    Ctype = "0"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "0.0001 [ohm]"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "1"
    }
   -Plot-([180,1188],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,576,486]
    Posn = [180,1188]
    Icon = [378,1044]
    Extents = 0,0,576,486
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,576,141],"y")
     {
     Options = 128
     Units = ""
     Curve(48603496,"Is",0,,,)
     Curve(48605904,"Vs",0,,,)
     }
    Graph([0,141],[0,0,576,141],"y")
     {
     Options = 128
     Units = ""
     Curve(48613384,"angs",0,,,)
     }
    Graph([0,282],[0,0,576,141],"y")
     {
     Options = 0
     Units = ""
     Curve(48608352,"Ps",0,,,)
     Curve(48610800,"Qs",0,,,)
     }
    }
   .WG1([4392,522],0,0,50)
    {
    }
   .WG1_1([3906,1458],0,0,510)
    {
    }
   -Plot-([3942,864],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,774,540]
    Posn = [3942,864]
    Icon = [3564,1278]
    Extents = 0,0,774,540
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,774,159],"y")
     {
     Options = 128
     Units = ""
     Curve(48769568,"w1",0,,,)
     Curve(48766608,"w2",0,,,)
     }
    Graph([0,159],[0,0,774,159],"y")
     {
     Options = 128
     Units = ""
     Curve(48789520,"IG11",0,,,)
     Curve(48798600,"IG21",0,,,)
     }
    Graph([0,318],[0,0,774,159],"y")
     {
     Options = 128
     Units = ""
     Curve(48787624,"IG12",0,,,)
     Curve(48796704,"IG22",0,,,)
     }
    }
   -Plot-([3150,864],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,774,468]
    Posn = [3150,864]
    Icon = [3438,738]
    Extents = 0,0,774,468
    XLabel = " "
    AutoPan = "true,75"
    Graph([0,0],[0,0,774,203],"y")
     {
     Options = 136
     Units = ""
     Curve(48852728,"IG1",0,,,)
     }
    Graph([0,203],[0,0,774,202],"y")
     {
     Options = 136
     Units = ""
     Curve(48854456,"IG2",0,,,)
     }
    }
   }
  }
 }

