PSCAD 4.2.1

Settings
 {
 Id = "981327640.1179179708"
 Author = "papic.peiw"
 Desc = "Base Model"
 Arch = "windows"
 Options = 32
 Build = 16
 Warn = 1
 Check = 7
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 10
  Step = 2e-005
  Plot = 0.0005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 1023
  Debug = 0
  StartFile = "C:\\CIGRE_Wind\\12bus_3G_damp_Wind_02.emt\\90s.snp"
  OFile = "dfig_feb07.out"
  SFile = "20s.snp"
  SnapTime = 20
  Mruns = 10
  Mrunfile = 0
  StartType = 1
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }

 }

Definitions
 {
 Component("REC2FILE")
  {
  Desc = ""
  FileDate = 0
  Parameters = 
   {
   Category("Main")
    {
    Choice("NVAR",2,2,154,12,2)
     {
     Style = 0
     Desc = "Number of Variables"
     Def = "1"
     Len = 15
     *1 = "1"
     *2 = "2"
     *3 = "3"
     *4 = "4"
     *5 = "5"
     *6 = "6"
     *7 = "7"
     *8 = "8"
     *9 = "9"
     *10 = "10"
     *11 = "11"
     *12 = "12"
     *13 = "13"
     *14 = "14"
     *15 = "15"
     *16 = "16"
     *17 = "17"
     *18 = "18"
     *19 = "19"
     *20 = "20"
     }
    Choice("RecType",4,26,152,42,2)
     {
     Style = 1
     Desc = "Record simulation data "
     Def = "0"
     Len = 15
     *0 = "at the end of each run (Multiple Run)"
     *1 = "throughout the run (Single Run)"
     }
    Text("RecFile",4,82,184,12,2)
     {
     Desc = "Output File Name (with extension)"
     Def = "RECOUT.TXT"
     Len = 15
     }
    }
   }

  Nodes = 
   {
   Input("IS1",-54,0)
    {
    Cond = "NVAR == 1"
    Type = Real
    }
   Input("IS2",-54,0)
    {
    Cond = "NVAR ==2"
    Type = Real
    Dim  = [2]
    }
   Input("IS3",-54,0)
    {
    Cond = "NVAR == 3"
    Type = Real
    Dim  = [3]
    }
   Input("IS4",-54,0)
    {
    Cond = "NVAR == 4"
    Type = Real
    Dim  = [4]
    }
   Input("IS5",-54,0)
    {
    Cond = "NVAR == 5"
    Type = Real
    Dim  = [5]
    }
   Input("IS6",-54,0)
    {
    Cond = "NVAR == 6"
    Type = Real
    Dim  = [6]
    }
   Input("IS7",-54,0)
    {
    Cond = "NVAR == 7"
    Type = Real
    Dim  = [7]
    }
   Input("IS8",-54,0)
    {
    Cond = "NVAR == 8"
    Type = Real
    Dim  = [8]
    }
   Input("IS9",-54,0)
    {
    Cond = "NVAR == 9"
    Type = Real
    Dim  = [9]
    }
   Input("IS10",-54,0)
    {
    Cond = "NVAR == 10"
    Type = Real
    Dim  = [10]
    }
   Input("IS11",-54,0)
    {
    Cond = "NVAR == 11"
    Type = Real
    Dim  = [11]
    }
   Input("IS12",-54,0)
    {
    Cond = "NVAR == 12"
    Type = Real
    Dim  = [12]
    }
   Input("IS13",-54,0)
    {
    Cond = "NVAR == 13"
    Type = Real
    Dim  = [13]
    }
   Input("IS14",-54,0)
    {
    Cond = "NVAR == 14"
    Type = Real
    Dim  = [14]
    }
   Input("IS15",-54,0)
    {
    Cond = "NVAR == 15"
    Type = Real
    Dim  = [15]
    }
   Input("IS16",-54,0)
    {
    Cond = "NVAR == 16"
    Type = Real
    Dim  = [16]
    }
   Input("IS17",-54,0)
    {
    Cond = "NVAR == 17"
    Type = Real
    Dim  = [17]
    }
   Input("IS18",-54,0)
    {
    Cond = "NVAR == 18"
    Type = Real
    Dim  = [18]
    }
   Input("IS19",-54,0)
    {
    Cond = "NVAR == 19"
    Type = Real
    Dim  = [19]
    }
   Input("IS20",-54,0)
    {
    Cond = "NVAR == 20"
    Type = Real
    Dim  = [20]
    }
   }

  Graphics = 
   {
   Rectangle(-29,-29,29,29)
   Pen(ByNode,ByNode,ByNode,IS16)
   Line(-54,0,-29,0)
   Pen(,Solid)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Pen(Black,,0.2)
   Arc(-24,-24,1,-10,0,90)
   Arc(-24,4,1,18,0,90)
   Line(-12,4,-12,-24)
   Line(12,4,12,-24)
   Line(0,9,0,-19)
   Arc(0,7,30,21,180,-90)
   Arc(-24,7,1,21,0,90)
   Line(-10,4,-12,7)
   Line(15,7,15,-22)
   Line(12,-19,15,-22)
   Arc(-18,-19,-1,-7,0,90)
   Arc(-18,-15,-1,-3,0,90)
   Arc(-18,-10,-1,1,0,90)
   Pen(ByNode,,ByNode)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Pen(,ByNode)
   Line(-54,0,-29,0)
   Line(-54,0,-29,0)
   Pen(,Solid)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Pen(,ByNode)
   Line(-54,0,-29,0)
   Pen(,Solid)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Pen(,ByNode)
   Line(-54,0,-29,0)
   Pen(,Solid)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Pen(,ByNode)
   Line(-54,0,-29,0)
   Pen(,Solid)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Pen(,ByNode)
   Line(-54,0,-29,0)
   Line(-54,0,-29,0)
   Line(-54,0,-29,0)
   Line(-54,0,-29,0)
   Line(-54,0,-29,0)
   Line(-54,0,-29,0)
   Line(-54,0,-29,0)
   Line(-54,0,-29,0)
   Line(-54,0,-29,0)
   Line(-54,0,-29,0)
   Line(-54,0,-29,0)
   Line(-54,0,-29,0)
   Line(-54,0,-29,0)
   Line(-54,0,-29,0)
   Text(0,25,"Recorder")
   Pen(Black,Solid,0.2)
   Arc(0,-24,24,-10,180,-90)
   Arc(0,4,25,18,180,-90)
   }

  Section(EMTDC)
   {
   Fortran = "\
	#LOCAL INTEGER II
	#FUNCTION INTEGER EMTDC_RUN
	#LOCAL INTEGER R_NUM


	IF ($RecType .EQ. 0) THEN ! Multiple Run Version
		R_NUM = EMTDC_RUN()

		IF (R_NUM .EQ. 1 .AND. (FIRSTSTEP .OR. TIMEZERO)) THEN
			OPEN(63,FILE=\"$RecFile\", RECL = 800)
		ENDIF

		IF (LASTSTEP) THEN
			#IF ($NVAR .EQ. 1)
				WRITE(63,784) R_NUM, $IS1
			#ELSEIF ($NVAR .EQ. 2) 
				WRITE(63,784) R_NUM, ($IS2(II),II=1,2)
			#ELSEIF ($NVAR .EQ. 3) 
				WRITE(63,784) R_NUM, ($IS3(II),II=1,3)
			#ELSEIF ($NVAR .EQ. 4) 
				WRITE(63,784) R_NUM, ($IS4(II),II=1,4)
			#ELSEIF ($NVAR .EQ. 5) 
				WRITE(63,784) R_NUM, ($IS5(II),II=1,5)
			#ELSEIF ($NVAR .EQ. 6) 
				WRITE(63,784) R_NUM, ($IS6(II),II=1,6)
			#ELSEIF ($NVAR .EQ. 7) 
				WRITE(63,784) R_NUM, ($IS7(II),II=1,7)
			#ELSEIF ($NVAR .EQ. 8) 
				WRITE(63,784) R_NUM, ($IS8(II),II=1,8)
			#ELSEIF ($NVAR .EQ. 9) 
				WRITE(63,784) R_NUM, ($IS9(II),II=1,9)
			#ELSEIF ($NVAR .EQ. 10) 
				WRITE(63,784) R_NUM, ($IS10(II),II=1,10)
			#ELSEIF ($NVAR .EQ. 11) 
				WRITE(63,784) R_NUM, ($IS11(II),II=1,11)
			#ELSEIF ($NVAR .EQ. 12) 
				WRITE(63,784) R_NUM, ($IS12(II),II=1,12)
			#ELSEIF ($NVAR .EQ. 13) 
				WRITE(63,784) R_NUM, ($IS13(II),II=1,13)
			#ELSEIF ($NVAR .EQ. 14) 
				WRITE(63,784) R_NUM, ($IS14(II),II=1,14)
			#ELSEIF ($NVAR .EQ. 15) 
				WRITE(63,784) R_NUM, ($IS15(II),II=1,15)
			#ELSEIF ($NVAR .EQ. 16)
				WRITE(63,784) R_NUM, ($IS16(II),II=1,16)
			#ELSEIF ($NVAR .EQ. 17) 
				WRITE(63,784) R_NUM, ($IS17(II),II=1,17)
			#ELSEIF ($NVAR .EQ. 18) 
				WRITE(63,784) R_NUM, ($IS18(II),II=1,18)
			#ELSEIF ($NVAR .EQ. 19) 
				WRITE(63,784) R_NUM, ($IS19(II),II=1,19)
			#ELSE   
				WRITE(63,784) R_NUM, ($IS20(II),II=1,20)
			#ENDIF
		ENDIF		
	ELSE	! Single-Run Version
		IF ( TIMEZERO .OR. FIRSTSTEP) THEN
			OPEN(68,FILE=\"$RecFile\", RECL = 400)
		ENDIF	
		#IF ($NVAR .EQ. 1) 
			WRITE(68,785) TIME, $IS1
		#ELSEIF ($NVAR .EQ. 2) 
			WRITE(68,785) TIME, ($IS2(II),II=1,2)
		#ELSEIF ($NVAR .EQ. 3) 
			WRITE(68,785) TIME, ($IS3(II),II=1,3)
		#ELSEIF ($NVAR .EQ. 4) 
			WRITE(68,785) TIME, ($IS4(II),II=1,4)
		#ELSEIF ($NVAR .EQ. 5) 
			WRITE(68,785) TIME, ($IS5(II),II=1,5)
		#ELSEIF ($NVAR .EQ. 6) 
			WRITE(68,785) TIME, ($IS6(II),II=1,6)
		#ELSEIF ($NVAR .EQ. 7) 
			WRITE(68,785) TIME, ($IS7(II),II=1,7)
		#ELSEIF ($NVAR .EQ. 8) 
			WRITE(68,785) TIME, ($IS8(II),II=1,8)
		#ELSEIF ($NVAR .EQ. 9) 
			WRITE(68,785) TIME, ($IS9(II),II=1,9)
		#ELSEIF ($NVAR .EQ. 10) 
			WRITE(68,785) TIME, ($IS10(II),II=1,10)
		#ELSEIF ($NVAR .EQ. 11) 
			WRITE(68,785) TIME, ($IS11(II),II=1,11)
		#ELSEIF ($NVAR .EQ. 12) 
			WRITE(68,785) TIME, ($IS12(II),II=1,12)
		#ELSEIF ($NVAR .EQ. 13) 
			WRITE(68,785) TIME, ($IS13(II),II=1,13)
		#ELSEIF ($NVAR .EQ. 14) 
			WRITE(68,785) TIME, ($IS14(II),II=1,14)
		#ELSEIF ($NVAR .EQ. 15)
			WRITE(68,785) TIME, ($IS15(II),II=1,15)
		#ELSEIF ($NVAR .EQ. 16) 
			WRITE(68,785) TIME, ($IS16(II),II=1,16)
		#ELSEIF ($NVAR .EQ. 17) 
			WRITE(68,785) TIME, ($IS17(II),II=1,17)
		#ELSEIF ($NVAR .EQ. 18)
			WRITE(68,785) TIME, ($IS18(II),II=1,18)
		#ELSEIF ($NVAR .EQ. 19)
			WRITE(68,785) TIME, ($IS19(II),II=1,19)
		#ELSE   
			WRITE(68,785) TIME, ($IS20(II),II=1,20)
		#ENDIF
	ENDIF

784	FORMAT( I4, 20(G10.3, 2X))
785	FORMAT( G10.5, 2X, 20(G15.9, 2X))"
   Branch = ""
   Computations = ""
   }
  }
 Module("exciter4")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   Input("VT4",-54,0)
    {
    Type = Real
    }
   Input("Ef04",54,0)
    {
    Type = Real
    }
   Input("If4",-18,54)
    {
    Type = Real
    }
   Output("Ef4",18,54)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-29,-29,29,29)
   Text(0,4,"exciter4")
   Pen(ByNode,ByNode,ByNode,VT4)
   Line(-54,0,-29,0)
   Pen(,Solid)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Pen(,ByNode,,Ef04)
   Line(54,0,29,0)
   Pen(,Solid)
   Line(29,0,35,6)
   Line(29,0,35,-6)
   Pen(,ByNode,,If4)
   Line(-18,54,-18,29)
   Pen(,Solid)
   Line(-18,29,-24,35)
   Line(-18,29,-11,35)
   Pen(,ByNode,,Ef4)
   Line(18,54,18,29)
   }


  Page(A/A4,Landscape,16,[796,556],100)
   {
   -Wire-([414,126],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([450,126],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.sumjct([450,216],0,0,120)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "1"
    E = "0"
    F = "0"
    G = "0"
    }
   0.mult([306,216],0,0,100)
    {
    }
   0.datalabel([306,252],0,0,-1)
    {
    Name = "sw1"
    }
   0.const([162,216],0,0,60)
    {
    Name = ""
    Value = "1.02"
    }
   0.sumjct([234,216],0,0,70)
    {
    DPath = "1"
    A = "0"
    B = "-1"
    C = "0"
    D = "1"
    E = "0"
    F = "0"
    G = "0"
    }
   0.import([162,90],0,0,10)
    {
    Name = "Ef04"
    }
   0.import([162,126],0,0,20)
    {
    Name = "If4"
    }
   0.import([198,180],0,0,40)
    {
    Name = "VT4"
    }
   0.pgb([234,180],0,24218160,50)
    {
    Name = "VT4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.export([522,216],2,0,130)
    {
    Name = "Ef4"
    }
   0.pgb([486,216],3,24220704,140)
    {
    Name = "Ef4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([234,360],2,0,-1)
    {
    Name = "sw1"
    }
   -Wire-([198,360],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.time-sig([90,360],0,0,80)
    {
    }
   0.compare([162,360],0,0,90)
    {
    X = "0.25"
    OL = "0.0"
    OH = "1.0"
    INTR = "0"
    }
   -Plot-([378,468],0)
    {
    Title = "Untitled"
    Draw = 1
    Area = [0,0,792,450]
    Posn = [378,468]
    Icon = [-1,-1]
    Extents = 0,0,792,450
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,792,387],"y")
     {
     Options = 137
     Units = ""
     Curve(24218160,"VT4",8388608,,,)
     Curve(24220704,"Ef4",32768,,,)
     }
    }
   0.realpole([378,216],0,0,110)
    {
    Limit = "1"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "20.0"
    T = "0.05 [sec]"
    Max = "2.0"
    Min = "-1.0"
    }
   0.const([378,126],0,0,30)
    {
    Name = ""
    Value = "1.665"
    }
   }
  }
 Module("controls")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   Output("Sa",-18,-108)
    {
    Type = Real
    }
   Output("Sb",-18,-72)
    {
    Type = Real
    }
   Output("Sc",-18,-36)
    {
    Type = Real
    }
   Output("Pa",-18,0)
    {
    Type = Real
    }
   Output("Pb",-18,36)
    {
    Type = Real
    }
   Output("Pc",-18,72)
    {
    Type = Real
    }
   Input("Udc",-126,54)
    {
    Type = Real
    }
   Input("Us",-126,-90)
    {
    Type = Real
    Dim  = [3]
    }
   Input("Ur",-126,-18)
    {
    Type = Real
    Dim  = [3]
    }
   Input("Is",-90,-144)
    {
    Type = Real
    Dim  = [3]
    }
   Input("Ip",-54,-144)
    {
    Type = Real
    Dim  = [3]
    }
   Input("Pfd",-90,108)
    {
    Type = Real
    }
   Input("om",-54,108)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Text(-73,-10,"UPFC")
   Pen(ByNode,ByNode,ByNode,Sb)
   Line(-90,-144,-90,-119)
   Pen(,Solid)
   Line(-90,-119,-96,-125)
   Line(-90,-119,-83,-125)
   Line(-54,-119,-60,-125)
   Line(-54,-119,-47,-125)
   Line(-101,-90,-107,-83)
   Line(-101,-90,-107,-96)
   Line(-101,-18,-107,-11)
   Line(-101,-18,-107,-24)
   Line(-101,54,-107,60)
   Line(-101,54,-107,47)
   Pen(,ByNode)
   Line(-18,-108,-43,-108)
   Line(-18,-72,-43,-72)
   Pen(Real,Real,0.2)
   Line(-18,-36,-43,-36)
   Line(-18,0,-43,0)
   Line(-54,108,-54,83)
   Pen(,Solid)
   Line(-54,83,-60,89)
   Pen(ByNode,ByNode,ByNode)
   Line(-126,-90,-101,-90)
   Line(-126,-18,-101,-18)
   Pen(Real,Real,0.2)
   Line(-18,72,-43,72)
   Pen(ByNode,ByNode,ByNode)
   Line(-126,54,-101,54)
   Pen(Real,Solid,0.2)
   Line(-54,83,-47,89)
   Pen(ByNode,ByNode,ByNode)
   Line(-54,-144,-54,-119)
   Pen(Real,Real,0.2)
   Line(-18,36,-43,36)
   Pen(Black,Solid)
   Rectangle(-101,-118,-42,83)
   Text(-73,1,"Control")
   Pen(Real,Real)
   Line(-90,108,-90,83)
   Pen(,Solid)
   Line(-90,83,-96,89)
   Line(-90,83,-83,89)
   }


  Page(B/A3,Landscape,16,[796,556],100)
   {
   0.gain([792,108],0,0,20)
    {
    G = "0.01745"
    COM = "Gain"
    Dim = "1"
    }
   -Wire-([720,108],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([180,108],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.gain([1386,108],0,0,30)
    {
    G = "0.01745"
    COM = "Gain"
    Dim = "1"
    }
   -Wire-([1314,108],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.gain([1962,108],0,0,50)
    {
    G = "0.01745"
    COM = "Gain"
    Dim = "1"
    }
   -Wire-([1890,108],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2142,126],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1404,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([1224,990],0,0,900)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "1"
    E = "0"
    F = "0"
    G = "0"
    }
   -Wire-([792,1026],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([774,1296],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1098,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([756,1242],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.sumjct([846,1296],0,0,300)
    {
    DPath = "1"
    A = "0"
    B = "-1"
    C = "0"
    D = "1"
    E = "0"
    F = "0"
    G = "0"
    }
   -Wire-([846,1260],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([882,1296],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   -Wire-([234,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.gain([1746,1134],0,0,970)
    {
    G = "1.0"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([1746,1170],0,0,960)
    {
    G = "-1.0"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([1746,1206],0,0,560)
    {
    G = "0.01745"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([1746,954],0,0,480)
    {
    G = "1.0"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([1746,990],0,0,490)
    {
    G = "-1.0"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([1746,1026],0,0,510)
    {
    G = "0.01745"
    COM = "Gain"
    Dim = "1"
    }
   -Wire-([1926,1206],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1926,1170],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1926,1134],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1926,954],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1926,990],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1926,1026],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.import([684,108],0,0,10)
    {
    Name = "om"
    }
   0.import([1854,108],0,0,-1)
    {
    Name = "om"
    }
   -Wire-([1638,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([1674,1206],0,0,550)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.import([1602,1206],0,0,-1)
    {
    Name = "om"
    }
   0.const([1602,1242],0,0,310)
    {
    Name = ""
    Value = "30.0"
    }
   0.import([1602,1026],0,0,-1)
    {
    Name = "om"
    }
   0.sumjct([1674,1026],0,0,500)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([1638,1062],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.const([1602,1062],0,0,230)
    {
    Name = ""
    Value = "30.0"
    }
   -Wire-([972,144],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([432,144],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([972,864],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([972,954],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.sumjct([1224,864],0,0,910)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([1224,936],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1170,954],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   -Wire-([1152,936],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([1152,954],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1044,900],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1044,954],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([792,1044],0,0,-1)
    {
    Name = "Ipq"
    }
   0.datalabel([1440,990],0,0,-1)
    {
    Name = "Upq"
    }
   0.datalabel([1440,864],0,0,-1)
    {
    Name = "Upd"
    }
   -Wire-([1404,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1620,1134],0,0,-1)
    {
    Name = "Upd"
    }
   0.datalabel([1620,954],0,0,-1)
    {
    Name = "Ud"
    }
   0.datalabel([1620,1170],0,0,-1)
    {
    Name = "Upq"
    }
   -Wire-([1620,1170],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([1620,1134],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.datalabel([1620,990],0,0,-1)
    {
    Name = "Uq"
    }
   -Wire-([1620,990],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([1620,954],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.dq0([1854,990],0,0,990)
    {
    Mode = "1"
    }
   0.export([2016,954],2,0,1070)
    {
    Name = "Sa"
    }
   0.export([2016,990],2,0,1060)
    {
    Name = "Sb"
    }
   0.export([2016,1026],2,0,1050)
    {
    Name = "Sc"
    }
   0.export([2016,1134],2,0,1040)
    {
    Name = "Pa"
    }
   0.export([2016,1170],2,0,1030)
    {
    Name = "Pb"
    }
   0.export([2016,1206],2,0,1020)
    {
    Name = "Pc"
    }
   0.datalabel([1062,900],4,0,-1)
    {
    Name = "Ipdc"
    }
   0.mult([864,864],0,0,860)
    {
    }
   0.gain([1116,900],0,0,890)
    {
    G = "377.0"
    COM = "Gain"
    Dim = "1"
    }
   0.realpole([1008,954],0,0,830)
    {
    Limit = "0"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "0.02653"
    T = "0.02653 [sec]"
    Max = "10.0"
    Min = "-10.0"
    }
   0.dq0([1998,180],0,0,610)
    {
    Mode = "0"
    }
   0.dq0([1422,180],0,0,590)
    {
    Mode = "0"
    }
   0.gain([1530,144],0,0,650)
    {
    G = "4.226"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([2106,144],0,0,670)
    {
    G = "4.226"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([396,144],0,0,630)
    {
    G = "0.00355"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([396,180],0,0,580)
    {
    G = "-0.00355"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([936,144],0,0,1010)
    {
    G = "0.00355"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([936,180],0,0,1170)
    {
    G = "-0.00355"
    COM = "Gain"
    Dim = "1"
    }
   -Wire-([198,162],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([216,144],3,0,340)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([216,180],3,0,350)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([216,216],3,0,370)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1332,162],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([1350,216],3,0,430)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1350,144],3,0,390)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1350,180],3,0,410)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1908,162],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([1926,216],3,0,450)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1926,144],3,0,420)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1926,180],3,0,440)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.import([1872,252],0,0,100)
    {
    Name = "Ip"
    }
   -Wire-([738,162],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([756,144],3,0,360)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([756,180],3,0,380)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([756,216],3,0,400)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1368,1026],4,0,-1)
    {
    Name = "Usq"
    }
   0.sumjct([1368,990],0,0,940)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "-1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.datalabel([1368,900],4,0,-1)
    {
    Name = "Usd"
    }
   0.sumjct([1368,864],0,0,950)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "-1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.mult([864,990],0,0,800)
    {
    }
   0.datalabel([864,1026],0,0,-1)
    {
    Name = "sw"
    }
   0.datalabel([864,900],4,0,-1)
    {
    Name = "sw"
    }
   0.datalabel([918,1278],4,0,-1)
    {
    Name = "sw"
    }
   0.dq0([828,180],0,0,1000)
    {
    Mode = "0"
    }
   0.import([1278,108],0,0,-1)
    {
    Name = "om"
    }
   0.import([1296,252],0,0,70)
    {
    Name = "Is"
    }
   0.import([702,252],0,0,60)
    {
    Name = "Ur"
    }
   0.gain([1530,180],0,0,600)
    {
    G = "-4.226"
    COM = "Gain"
    Dim = "1"
    }
   0.dq0([1854,1170],0,0,980)
    {
    Mode = "1"
    }
   0.pgb([1440,990],3,24324152,1080)
    {
    Name = "Upq"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([720,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([1440,864],3,24326200,1090)
    {
    Name = "Upd"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.dq0([288,180],0,0,570)
    {
    Mode = "0"
    }
   0.gain([252,108],0,0,330)
    {
    G = "0.01745"
    COM = "Gain"
    Dim = "1"
    }
   0.import([702,1242],0,0,260)
    {
    Name = "Udc"
    }
   0.realpole([1008,900],0,0,880)
    {
    Limit = "0"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "0.02653"
    T = "0.02653 [sec]"
    Max = "10.0"
    Min = "-10.0"
    }
   -Wire-([432,180],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([972,180],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.gain([1296,864],0,0,930)
    {
    G = "0.0002653"
    COM = "Gain"
    Dim = "1"
    }
   0.pi_ctlr([936,990],0,0,810)
    {
    GP = "100.0"
    TI = "0.0002653 [sec]"
    YHI = "10000.0"
    YLO = "-10000.0"
    YINIT = "0.0"
    Mthd = "0"
    INTR = "0"
    }
   0.import([162,252],0,0,40)
    {
    Name = "Us"
    }
   0.sumjct([792,990],0,0,790)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.mult([918,1242],0,0,520)
    {
    }
   0.datalabel([270,1224],2,0,-1)
    {
    Name = "sw"
    }
   0.gain([1296,990],0,0,920)
    {
    G = "0.0002653"
    COM = "Gain"
    Dim = "1"
    }
   -Wire-([1170,900],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1152,936],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([972,864],0,0,-1)
    {
    Vertex="0,0;216,0"
    }
   -Wire-([972,990],0,0,-1)
    {
    Vertex="0,0;216,0"
    }
   -Wire-([576,450],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([468,414],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.const([432,414],0,0,110)
    {
    Name = ""
    Value = "100.0"
    }
   0.var([954,1386],0,24338040,320)
    {
    Name = "Kdc"
    Group = ""
    Display = "0"
    Max = "1000.0"
    Min = "0.0"
    Value = "1.0"
    Units = ""
    Collect = "1"
    }
   0.datalabel([1152,1242],2,0,-1)
    {
    Name = "dUdc"
    }
   0.datalabel([990,1386],2,0,-1)
    {
    Name = "Kdc"
    }
   0.gain([1116,954],0,0,840)
    {
    G = "377.0"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([990,1242],0,0,530)
    {
    G = "Kdc"
    COM = "Gain"
    Dim = "1"
    }
   0.datalabel([828,450],0,0,-1)
    {
    Name = "Ud"
    }
   0.gain([792,1242],0,0,270)
    {
    G = "0.05"
    COM = "Gain"
    Dim = "1"
    }
   0.const([738,1296],0,0,290)
    {
    Name = "Udc_ref"
    Value = "1.0"
    }
   0.fft([1044,162],0,0,1180)
    {
    Type = "2"
    Size = "1"
    F = "60.0 [Hz]"
    AMod = "0"
    PMod = "0"
    PModCS = "0"
    Filt = "1"
    Track = "0"
    Enab = "1"
    Fout = ""
    }
   0.fft([1638,162],0,0,660)
    {
    Type = "2"
    Size = "1"
    F = "60.0 [Hz]"
    AMod = "0"
    PMod = "0"
    PModCS = "0"
    Filt = "1"
    Track = "0"
    Enab = "1"
    Fout = ""
    }
   0.datalabel([2250,234],0,0,-1)
    {
    Name = "Ipq"
    }
   0.mult([126,918],0,0,710)
    {
    }
   -Wire-([90,954],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([90,1026],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([90,954],0,0,-1)
    {
    Name = "Ud"
    }
   0.datalabel([90,1026],0,0,-1)
    {
    Name = "Uq"
    }
   0.datalabel([270,954],0,0,-1)
    {
    Name = "Ipd_ref"
    }
   0.pgb([270,954],3,24354056,1100)
    {
    Name = "Ipd_ref"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([234,990],0,0,-1)
    {
    Name = "Us_mag"
    }
   -Wire-([144,864],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([144,792],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.square([108,864],0,0,700)
    {
    Dim = "1"
    }
   0.sqrt([234,828],0,0,740)
    {
    Dim = "1"
    }
   0.datalabel([72,792],0,0,-1)
    {
    Name = "Usd"
    }
   0.datalabel([72,864],0,0,-1)
    {
    Name = "Usq"
    }
   0.datalabel([288,828],0,0,-1)
    {
    Name = "Us_mag"
    }
   -Wire-([288,828],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.square([108,792],0,0,690)
    {
    Dim = "1"
    }
   0.datalabel([90,918],0,0,-1)
    {
    Name = "Isd"
    }
   0.mult([126,990],0,0,720)
    {
    }
   0.datalabel([90,990],0,0,-1)
    {
    Name = "Isq"
    }
   0.sumjct([162,828],0,0,730)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "0"
    E = "0"
    F = "1"
    G = "0"
    }
   0.div([234,954],0,0,760)
    {
    }
   0.sumjct([162,954],0,0,750)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "0"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([792,828],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([720,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([684,828],2,0,-1)
    {
    Name = "dUdc"
    }
   0.datalabel([648,864],0,0,-1)
    {
    Name = "Ipd_ref"
    }
   0.datalabel([792,810],2,0,-1)
    {
    Name = "Ipdc"
    }
   0.sumjct([684,864],0,0,820)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "1"
    E = "0"
    F = "0"
    G = "0"
    }
   0.sumjct([792,864],0,0,850)
    {
    DPath = "1"
    A = "0"
    B = "-1"
    C = "0"
    D = "1"
    E = "0"
    F = "0"
    G = "0"
    }
   0.datalabel([612,1026],0,0,-1)
    {
    Name = "Us_mag"
    }
   0.gain([684,990],0,0,780)
    {
    G = "-1.0"
    COM = "Gain"
    Dim = "1"
    }
   0.div([612,990],0,0,770)
    {
    }
   0.var([540,990],0,24369232,220)
    {
    Name = "Qp_ref"
    Group = ""
    Display = "0"
    Max = "5.0"
    Min = "-5.0"
    Value = "0.0"
    Units = "p.u."
    Collect = "1"
    }
   -ControlPanel-([108,414],0)
    {
    Name = "CPanel"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,0,0
    Slider(24401712)
    Slider(24406120)
    Slider(24338040)
    }
   0.datalabel([810,576],0,0,-1)
    {
    Name = "Uq"
    }
   -Wire-([612,540],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.pgb([810,576],3,24391136,1110)
    {
    Name = "Uq"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.var([144,378],0,24392952,80)
    {
    Name = "Kd"
    Group = ""
    Display = "0"
    Max = "5.0"
    Min = "-5.0"
    Value = "0.0"
    Units = "p.u."
    Collect = "1"
    }
   0.datalabel([180,378],0,0,-1)
    {
    Name = "Kd"
    }
   0.datalabel([252,378],0,0,-1)
    {
    Name = "Kq"
    }
   0.import([432,486],0,0,140)
    {
    Name = "Pfd"
    }
   0.var([720,450],0,24401712,130)
    {
    Name = "Ud"
    Group = ""
    Display = "0"
    Max = "0.5"
    Min = "-0.5"
    Value = "0.0"
    Units = "p.u."
    Collect = "1"
    }
   0.pgb([828,450],3,24403680,1120)
    {
    Name = "Ud"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([684,540],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.var([702,576],0,24406120,190)
    {
    Name = "Uq"
    Group = ""
    Display = "0"
    Max = "0.5"
    Min = "-0.5"
    Value = "0.0"
    Units = "p.u."
    Collect = "1"
    }
   -Wire-([774,648],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.sumjct([774,576],0,0,470)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.pi_ctlr([936,864],0,0,870)
    {
    GP = "100.0"
    TI = "0.0002653 [sec]"
    YHI = "10000.0"
    YLO = "-10000.0"
    YINIT = "0.0"
    Mthd = "0"
    INTR = "0"
    }
   -Wire-([684,486],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([828,1242],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.pgb([846,1242],3,24410208,280)
    {
    Name = "Udc"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Plot-([954,972],0)
    {
    Title = "Untitled"
    Draw = 1
    Area = [0,0,324,234]
    Posn = [954,972]
    Icon = [-1,-1]
    Extents = 0,0,324,234
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,324,171],"y")
     {
     Options = 137
     Units = ""
     Curve(24478240,"Isd",8388608,,,)
     Curve(24248656,"Isq",32768,,,)
     Curve(24484528,"Ipd",128,,,)
     Curve(24481400,"Ipq",8421376,,,)
     }
    }
   0.div([576,486],6,0,160)
    {
    }
   0.var([216,378],0,24426064,90)
    {
    Name = "Kq"
    Group = ""
    Display = "0"
    Max = "5.0"
    Min = "-5.0"
    Value = "0.0"
    Units = "p.u."
    Collect = "1"
    }
   -ControlPanel-([108,558],0)
    {
    Name = "CPanel"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,0,0
    Slider(24369232)
    Slider(24392952)
    Slider(24426064)
    }
   0.sumjct([792,450],0,0,460)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.datalabel([1674,234],0,0,-1)
    {
    Name = "Isq"
    }
   -Wire-([1566,180],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.gain([2106,180],0,0,620)
    {
    G = "-4.226"
    COM = "Gain"
    Dim = "1"
    }
   -Wire-([2142,180],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.datalabel([1008,234],0,0,-1)
    {
    Name = "Urd"
    }
   0.datalabel([1080,234],0,0,-1)
    {
    Name = "Urq"
    }
   0.pgb([1674,234],0,24248656,1150)
    {
    Name = "Isq"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([1602,234],0,0,-1)
    {
    Name = "Isd"
    }
   0.pgb([1602,234],0,24478240,1160)
    {
    Name = "Isd"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([1566,126],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.datalabel([540,234],0,0,-1)
    {
    Name = "Usq"
    }
   0.datalabel([468,234],0,0,-1)
    {
    Name = "Usd"
    }
   0.pgb([2250,234],0,24481400,1130)
    {
    Name = "Ipq"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([2178,234],0,0,-1)
    {
    Name = "Ipd"
    }
   0.fft([2214,162],0,0,680)
    {
    Type = "2"
    Size = "1"
    F = "60.0 [Hz]"
    AMod = "0"
    PMod = "0"
    PModCS = "0"
    Filt = "1"
    Track = "0"
    Enab = "1"
    Fout = ""
    }
   0.pgb([2178,234],0,24484528,1140)
    {
    Name = "Ipd"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.time-sig([126,1224],0,0,240)
    {
    }
   0.compare([198,1224],0,0,250)
    {
    X = "0.1"
    OL = "0.0"
    OH = "1.0"
    INTR = "0"
    }
   0.sumjct([504,486],0,0,150)
    {
    DPath = "1"
    A = "0"
    B = "-1"
    C = "0"
    D = "1"
    E = "0"
    F = "0"
    G = "0"
    }
   -Plot-([180,576],0)
    {
    Title = "Untitled"
    Draw = 1
    Area = [0,0,360,234]
    Posn = [180,576]
    Icon = [-1,-1]
    Extents = 0,0,360,234
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,360,171],"y")
     {
     Options = 137
     Units = ""
     Curve(24410208,"Udc",8388608,,,)
     }
    }
   0.time-sig([666,648],0,0,200)
    {
    }
   0.gain([648,540],0,0,180)
    {
    G = "Kq"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([648,486],0,0,170)
    {
    G = "Kd"
    COM = "Gain"
    Dim = "1"
    }
   0.const([468,450],0,0,120)
    {
    Name = ""
    Value = "326.54"
    }
   0.pi_ctlr([1062,1242],0,0,540)
    {
    GP = "1.0"
    TI = "0.1 [sec]"
    YHI = "100000.0"
    YLO = "-10000.0"
    YINIT = "0.0"
    Mthd = "0"
    INTR = "0"
    }
   0.fft([504,162],0,0,640)
    {
    Type = "2"
    Size = "1"
    F = "60.0 [Hz]"
    AMod = "0"
    PMod = "0"
    PModCS = "0"
    Filt = "1"
    Track = "0"
    Enab = "1"
    Fout = ""
    }
   0.range([738,648],0,0,210)
    {
    XL = "100.0"
    XU = "100.1"
    OL = "0.0"
    OM = "0.01"
    OH = "0.0"
    COM = "Band_Compare"
    }
   0.import([144,108],0,0,-1)
    {
    Name = "om"
    }
   -Plot-([576,612],0)
    {
    Title = "Untitled"
    Draw = 1
    Area = [0,0,432,234]
    Posn = [576,612]
    Icon = [-1,-1]
    Extents = 0,0,432,234
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,432,171],"y")
     {
     Options = 137
     Units = ""
     Curve(24403680,"Ud",8388608,,,)
     Curve(24326200,"Upd",32768,,,)
     Curve(24324152,"Upq",128,,,)
     }
    }
   }
  }
 Module("exciter3")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   Input("VT3",-54,0)
    {
    Type = Real
    }
   Input("Ef03",54,0)
    {
    Type = Real
    }
   Output("Ef3",18,54)
    {
    Type = Real
    }
   Input("If3",-18,54)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-29,-29,29,29)
   Pen(ByNode,ByNode,ByNode)
   Line(-54,0,-29,0)
   Pen(,Solid)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Pen(,ByNode)
   Line(54,0,29,0)
   Pen(,Solid)
   Line(29,0,35,6)
   Line(29,0,35,-6)
   Pen(,ByNode)
   Line(-18,54,-18,29)
   Pen(,Solid)
   Line(-18,29,-24,35)
   Line(-18,29,-11,35)
   Pen(,ByNode)
   Line(18,54,18,29)
   Text(0,4,"exciter3")
   }


  Page(A/A4,Landscape,16,[796,556],100)
   {
   0.datalabel([252,360],2,0,-1)
    {
    Name = "sw1"
    }
   -Wire-([216,360],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([450,144],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([486,144],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.sumjct([486,234],0,0,120)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "1"
    E = "0"
    F = "0"
    G = "0"
    }
   0.time-sig([108,360],0,0,80)
    {
    }
   0.const([198,234],0,0,60)
    {
    Name = ""
    Value = "1.01"
    }
   0.import([198,144],0,0,20)
    {
    Name = "If3"
    }
   0.import([234,198],0,0,40)
    {
    Name = "VT3"
    }
   0.export([558,234],2,0,130)
    {
    Name = "Ef3"
    }
   0.import([198,108],0,0,10)
    {
    Name = "Ef03"
    }
   0.pgb([270,198],0,24456536,50)
    {
    Name = "VT3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([522,234],3,24458392,140)
    {
    Name = "Ef3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.sumjct([270,234],0,0,70)
    {
    DPath = "1"
    A = "0"
    B = "-1"
    C = "0"
    D = "1"
    E = "0"
    F = "0"
    G = "0"
    }
   0.mult([342,234],0,0,100)
    {
    }
   0.datalabel([342,270],0,0,-1)
    {
    Name = "sw1"
    }
   0.compare([180,360],0,0,90)
    {
    X = "0.25"
    OL = "0.0"
    OH = "1.0"
    INTR = "0"
    }
   -Plot-([360,432],0)
    {
    Title = "Untitled"
    Draw = 1
    Area = [0,0,720,450]
    Posn = [360,432]
    Icon = [-1,-1]
    Extents = 0,0,720,450
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,720,387],"y")
     {
     Options = 137
     Units = ""
     Curve(24456536,"VT3",8388608,,,)
     Curve(24458392,"Ef3",32768,,,)
     }
    }
   0.realpole([414,234],0,0,110)
    {
    Limit = "1"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "20.0"
    T = "0.05 [sec]"
    Max = "2.0"
    Min = "-1.0"
    }
   0.const([414,144],0,0,30)
    {
    Name = ""
    Value = "1.628"
    }
   }
  }
 Module("exciter2")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   Input("VT2",-54,0)
    {
    Type = Real
    }
   Input("Ef02",54,0)
    {
    Type = Real
    }
   Input("If2",-18,54)
    {
    Type = Real
    }
   Output("Ef2",18,54)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-29,-29,29,29)
   Pen(ByNode,ByNode,ByNode,VT2)
   Line(-54,0,-29,0)
   Pen(,Solid)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Pen(,ByNode,,Ef02)
   Line(54,0,29,0)
   Pen(,Solid)
   Line(29,0,35,6)
   Line(29,0,35,-6)
   Pen(,ByNode,,If2)
   Line(-18,54,-18,29)
   Pen(,Solid)
   Line(-18,29,-24,35)
   Line(-18,29,-11,35)
   Pen(,ByNode,,Ef2)
   Line(18,54,18,29)
   Text(0,4,"exciter2")
   }


  Page(A/A4,Landscape,16,[796,556],100)
   {
   -Wire-([432,126],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([468,126],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.sumjct([468,216],0,0,120)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "1"
    E = "0"
    F = "0"
    G = "0"
    }
   0.mult([324,216],0,0,100)
    {
    }
   0.datalabel([324,252],0,0,-1)
    {
    Name = "sw1"
    }
   0.import([180,90],0,0,10)
    {
    Name = "Ef02"
    }
   0.import([180,126],0,0,20)
    {
    Name = "If2"
    }
   0.import([216,180],0,0,40)
    {
    Name = "VT2"
    }
   0.const([180,216],0,0,60)
    {
    Name = ""
    Value = "1.02"
    }
   0.export([540,216],2,0,130)
    {
    Name = "Ef2"
    }
   0.sumjct([252,216],0,0,70)
    {
    DPath = "1"
    A = "0"
    B = "-1"
    C = "0"
    D = "1"
    E = "0"
    F = "0"
    G = "0"
    }
   0.pgb([504,216],3,24549960,140)
    {
    Name = "Ef2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([252,180],0,24551816,50)
    {
    Name = "VT2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([198,306],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.time-sig([90,306],0,0,80)
    {
    }
   0.compare([162,306],0,0,90)
    {
    X = "0.25"
    OL = "0.0"
    OH = "1.0"
    INTR = "0"
    }
   0.datalabel([234,306],2,0,-1)
    {
    Name = "sw1"
    }
   -Plot-([432,414],0)
    {
    Title = "Untitled"
    Draw = 1
    Area = [0,0,810,486]
    Posn = [432,414]
    Icon = [-1,-1]
    Extents = 0,0,810,486
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,810,423],"y")
     {
     Options = 137
     Units = ""
     Curve(24551816,"VT2",8388608,,,)
     Curve(24549960,"Ef2",32768,,,)
     }
    }
   0.realpole([396,216],0,0,110)
    {
    Limit = "1"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "20.0"
    T = "0.05 [sec]"
    Max = "2.0"
    Min = "-1.0"
    }
   0.const([396,126],0,0,30)
    {
    Name = ""
    Value = "1.735"
    }
   }
  }
 Module("Plots_controls")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Pen(Green,,0.8)
   Rectangle(-39,-39,39,39)
   Text(0,-13,"Controls")
   Text(0,6,"and")
   Text(0,25,"Plots")
   }


  Page(B/A3,Landscape,16,[796,556],5)
   {
   -Sticky-([1296,450],0)
    {
    Name = ""
    Font = 2
    Bounds = 1296,450,1728,522
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Ird - Controls the reactive power
Irq - Controls the real power"
    }
   -ControlPanel-([108,936],0)
    {
    Name = "CRPWM"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 108,936
    Extents = 0,0,126,126
    Slider(25361816)
    }
   -Sticky-([432,288],0)
    {
    Name = ""
    Font = 1
    Bounds = 432,288,792,612
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
1) To bypass rotor converter (i.e. set firing pule = 0), turn ON the Crowbar_SW.

When it is OFF, the crowbar control/protection will determine the bypass action.


2) To connect the capacitor, turn Cont_Cap to OFF position. The Capacitor breaker will remail closed.
If Cont_Cap = 1, then the breaker will remain Open in normal operation. It will get connected if the voltage sag at the terminal falls below a specified setting. (i.e. the capacitor will come in to support voltage during faults etc.)

3) If Cont_Gen_Trip is OFF, the machine will remain connected to the system.
If this setting is ON, the generator controls will trip the main breaker if the measured voltage sag is greater than a specified setting.

DM/Feb 2007"
    }
   -Plot-([810,540],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,432,432]
    Posn = [810,540]
    Icon = [-1,-1]
    Extents = 0,0,432,432
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,432,123],"y")
     {
     Options = 128
     Units = ""
     Curve(25545640,"Ecap",0,,,)
     Curve(25610896,"Ecapref",0,,,)
     }
    Graph([0,123],[0,0,432,123],"y")
     {
     Options = 128
     Units = ""
     Curve(25560616,"Vdref1",0,,,)
     }
    Graph([0,246],[0,0,432,123],"y")
     {
     Options = 128
     Units = ""
     Curve(25562600,"Vqref1",0,,,)
     }
    }
   -Plot-([1296,540],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,432,666]
    Posn = [1296,540]
    Icon = [-1,-1]
    Extents = 0,0,432,666
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,432,121],"y")
     {
     Options = 129
     Units = ""
     Curve(56096584,"Vgrms_pu",0,,,)
     }
    Graph([0,121],[0,0,432,121],"y")
     {
     Options = 129
     Units = ""
     Curve(25437520,"S1",0,,,)
     }
    Graph([0,242],[0,0,432,121],"y")
     {
     Options = 129
     Units = ""
     Curve(25630456,"Ir",0,,,)
     }
    Graph([0,363],[0,0,432,120],"y")
     {
     Options = 129
     Units = ""
     Curve(25470784,"Idc_Crow",0,,,)
     }
    Graph([0,483],[0,0,432,120],"y")
     {
     Options = 129
     Units = ""
     Curve(56076392,"BRK_cap",0,,,)
     }
    }
   -Sticky-([540,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 540,198,666,252
    Alignment = 0
    Style = 1
    Arrow = 6
    Color = 0,15792890
    Text = "\
Large Ir limit disables Crow Bar action.
Once the simulation is in steady state, lower this valuye to 60.

See below for more details.
DM/ Feb 2007.
"
    }
   -ControlPanel-([90,774],0)
    {
    Name = "Rotor side controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 90,774
    Extents = 0,0,0,0
    Slider(25371544)
    Slider(25374064)
    Slider(25376496)
    Slider(25378936)
    }
   -ControlPanel-([108,144],0)
    {
    Name = "DFIG Protection and control settings"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 108,144
    Extents = 0,0,270,126
    Switch(25435080)
    Switch(56073960)
    Switch(56079488)
    Slider(25696536)
    }
   -Plot-([1296,90],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,432,342]
    Posn = [1296,90]
    Icon = [-1,-1]
    Extents = 0,0,432,342
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,432,140],"y")
     {
     Options = 128
     Units = ""
     Curve(25243848,"Irq",0,,,)
     }
    Graph([0,140],[0,0,432,139],"y")
     {
     Options = 128
     Units = ""
     Curve(25233584,"Ird",0,,,)
     }
    }
   -ControlPanel-([90,612],0)
    {
    Name = "Grid side controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 90,612
    Extents = 0,0,324,126
    Slider(25551520)
    Slider(25553424)
    Slider(25557184)
    Slider(25555304)
    }
   -Plot-([792,72],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,432,432]
    Posn = [792,72]
    Icon = [-1,-1]
    Extents = 0,0,432,432
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,432,123],"y")
     {
     Options = 129
     Units = ""
     Curve(25136176,"Pg",0,1,,)
     Curve(24563312,"Pg",0,,,)
     }
    Graph([0,123],[0,0,432,123],"y")
     {
     Options = 129
     Units = ""
     Curve(25466248,"Qg_ref",0,,,)
     Curve(25138112,"Qg",0,,,)
     }
    Graph([0,246],[0,0,432,123],"y")
     {
     Options = 129
     Units = ""
     Curve(25644296,"Wpu",0,,,)
     Curve(25394176,"Wref_",0,,,)
     }
    }
   -ControlPanel-([108,288],0)
    {
    Name = "Rotor side controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 108,288
    Extents = 0,0,180,144
    Slider(25143576)
    Slider(25236824)
    Meter(56037352)
    }
   -ControlPanel-([90,450],0)
    {
    Name = "$(GROUP) : Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 90,450
    Extents = 0,0,270,126
    Slider(25548992)
    Slider(25522888)
    Meter(25545640)
    }
   }
  }
 Module("Windfarm")
  {
  Desc = ""
  FileDate = 1179177168
  Nodes = 
   {
   Output("Tm",-72,0)
    {
    Type = Real
    }
   Input("Cp",90,-18)
    {
    Type = Real
    }
   Input("Vw",90,18)
    {
    Type = Real
    }
   Input("Wm",18,54)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-57,-39,75,39)
   Pen(ByNode,ByNode,ByNode,Tm)
   Line(-72,0,-57,0)
   Pen(,,,Cp)
   Line(90,-18,75,-18)
   Pen(,Solid)
   Line(75,-18,80,-23)
   Line(75,-18,80,-13)
   Pen(,ByNode,,Vw)
   Line(90,18,75,18)
   Pen(Black,Solid,0.2)
   Line(-8,20,-13,-10)
   Line(-25,-15,-51,-28)
   Line(-25,-15,-21,-15)
   Line(-16,-13,-13,-10)
   Line(-15,-21,10,-36)
   Line(-15,-16,11,-35)
   Line(69,-33,68,-34)
   Line(-10,21,-8,20)
   Line(-18,-12,-10,21)
   Line(-51,-30,-20,-17)
   Line(-16,-17,-15,-21)
   Pen(Gray)
   Brush(Solid)
   Ellipse(-21,-18,-15,-12)
   Pen(Black)
   Line(-51,-30,-51,-28)
   Line(-20,-13,-20,24)
   Line(-16,-5,-16,24)
   Pen(ByNode,,ByNode,Cp)
   Line(75,18,80,13)
   Line(75,18,80,23)
   Pen(Black,,0.2)
   Line(50,22,45,-8)
   Line(33,-13,7,-26)
   Line(33,-13,37,-13)
   Line(42,-11,45,-8)
   Line(43,-19,68,-34)
   Line(43,-14,69,-33)
   Line(48,23,50,22)
   Line(40,-10,48,23)
   Line(7,-28,38,-15)
   Line(42,-15,43,-19)
   Pen(Gray)
   Ellipse(37,-16,43,-10)
   Pen(Black)
   Line(7,-28,7,-26)
   Line(38,-11,38,26)
   Line(42,-3,42,26)
   Line(10,-36,11,-35)
   Pen(ByNode,ByNode,ByNode,Vw)
   Line(18,39,18,54)
   Pen(,Solid,,Cp)
   Line(23,44,18,39)
   Line(13,44,18,39)
   Text(1,33,"Wind Park")
   Text(-64,-4,"Tm")
   Text(82,-22,"Cp")
   Text(82,14,"Vw")
   Text(8,50,"Wm")
   }


  Page(A/A4,Landscape,16,[796,556],5)
   {
   0.mult([234,270],6,0,80)
    {
    }
   0.mult([306,270],6,0,90)
    {
    }
   0.mult([270,360],0,0,160)
    {
    }
   -Wire-([378,306],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.const([270,432],5,0,150)
    {
    Name = ""
    Value = "3.0"
    }
   -Wire-([594,270],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([486,270],0,0,-1)
    {
    Name = "Pw"
    }
   -Wire-([738,270],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.div([558,270],0,0,200)
    {
    }
   -Wire-([126,360],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([774,270],3,25064664,250)
    {
    Name = "Tm"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.log([198,360],6,0,120)
    {
    Log = "0"
    COM = "Logarithm"
    Dim = "1"
    }
   -Wire-([486,270],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.mult([450,270],6,0,190)
    {
    }
   0.pgb([504,270],3,25068176,260)
    {
    Name = "Pw"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.const([558,342],3,0,130)
    {
    Name = ""
    Value = "2000000.0"
    }
   0.exp([342,360],0,0,170)
    {
    Base = "0"
    A = "1.0"
    B = "1.0"
    COM = ""
    Dim = "1"
    }
   0.import([90,360],0,0,100)
    {
    Name = "Vw"
    }
   0.import([702,342],3,0,140)
    {
    Name = "wm"
    }
   0.mult([306,198],1,0,40)
    {
    }
   0.square([270,162],0,0,20)
    {
    Dim = "1"
    }
   0.export([918,270],2,0,240)
    {
    Name = "Tm"
    }
   0.mult([378,270],0,0,180)
    {
    }
   0.annotation([90,378],0,0,-1)
    {
    AL1 = "Wind Speed"
    AL2 = ""
    }
   0.const([198,162],0,0,10)
    {
    Name = "Rotor Radius"
    Value = "40.0"
    }
   0.const([234,198],0,0,30)
    {
    Name = "PI"
    Value = "3.14159"
    }
   0.const([198,234],0,0,60)
    {
    Name = "Air Density"
    Value = "1.225"
    }
   0.const([162,270],0,0,70)
    {
    Name = "Constant"
    Value = "0.5"
    }
   0.annotation([702,378],0,0,-1)
    {
    AL1 = "Convert Power to Torque"
    AL2 = "(PU)"
    }
   0.annotation([504,378],0,0,-1)
    {
    AL1 = "Convert to Per-Unit"
    AL2 = ""
    }
   -Sticky-([252,54],0)
    {
    Name = ""
    Font = 2
    Bounds = 252,54,432,108
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
2 MW Wind Turbine 
(one unit in the park)"
    }
   0.div([702,270],0,0,210)
    {
    }
   0.gain([846,270],0,0,220)
    {
    G = "-1.0"
    COM = "Gain"
    Dim = "1"
    }
   -Sticky-([810,180],0)
    {
    Name = ""
    Font = 1
    Bounds = 810,180,1044,234
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Input mechanical torque to the machine is negative
(sign convention used in the model)"
    }
   -Sticky-([486,54],0)
    {
    Name = ""
    Font = 2
    Bounds = 486,54,1026,126
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This block converts wind speed to machine torque.
P = 0.5.Cp.Area.airdensity.Vw.Vw.Vw"
    }
   0.import([450,198],1,0,50)
    {
    Name = "Cp"
    }
   0.pgb([144,360],1,25086168,110)
    {
    Name = "Vw"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([702,306],0,25088152,230)
    {
    Name = "Wm"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Plot-([90,540],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,306,324]
    Posn = [90,540]
    Icon = [486,144]
    Extents = 0,0,306,324
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,306,131],"y")
     {
     Options = 129
     Units = ""
     Curve(25064664,"Tm",0,,,)
     }
    Graph([0,131],[0,0,306,130],"y")
     {
     Options = 128
     Units = ""
     Curve(25068176,"Pw",0,,,)
     }
    }
   }
  }
 Module("DGIF_Controls")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   Electrical("GABC",0,72)
    {
    Dim  = [3]
    }
   Input("Ctrl",0,-72)
    {
    Type = Real
    Dim  = [12]
    }
   Electrical("SABC",144,72)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Pen(,,0.8)
   Rectangle(-47,-47,47,47)
   Pen(,ByNode)
   Line(0,-72,0,-47)
   Pen(,Solid)
   Line(0,-47,-6,-53)
   Line(0,-47,6,-53)
   Line(0,72,0,47)
   Rectangle(97,-47,191,47)
   Pen(,ByNode,0.6)
   Line(96,36,47,36)
   Line(96,-36,47,-36)
   Pen(,Solid)
   Line(72,-3,72,-36)
   Line(72,36,72,3)
   Line(66,3,78,3)
   Line(66,-3,78,-3)
   Pen(,ByNode,0.8)
   Line(144,72,144,47)
   Text(1,21,"& Controls")
   Text(145,21,"& Controls")
   Text(145,-12,"GRID")
   Text(1,4,"Converter")
   Text(145,4,"Converter")
   Text(1,-12,"GENERATOR")
   Text(16,59,"GABC")
   Text(160,59,"SABC")
   }


  Page(E_JUMBO,Landscape,16,[796,556],5)
   {
   -Sticky-([1440,72],0)
    {
    Name = ""
    Font = 2
    Bounds = 1440,72,1998,126
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "Vector Control of rotor-fed induction motor/generator"
    }
   0.import([4158,2970],0,0,750)
    {
    Name = "CTRL"
    }
   0.datatap([4248,2988],0,0,780)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([4248,3024],4,0,-1)
    {
    Name = "Isa"
    }
   0.datatap([4284,2988],0,0,790)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([4320,2988],0,0,800)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([4356,2988],0,0,820)
    {
    Index = "4"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([4392,2988],0,0,830)
    {
    Index = "5"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([4428,2988],0,0,840)
    {
    Index = "6"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([4464,2988],0,0,850)
    {
    Index = "7"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([4536,2988],0,0,870)
    {
    Index = "9"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([4284,3024],4,0,-1)
    {
    Name = "Isb"
    }
   0.datalabel([4320,3024],4,0,-1)
    {
    Name = "Isc"
    }
   0.datalabel([4464,3024],0,0,-1)
    {
    Name = "Wpu"
    }
   0.datatap([4500,2988],0,0,860)
    {
    Index = "8"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.unity([4284,3024],1,0,920)
    {
    IType = "2"
    OType = "2"
    }
   0.unity([4320,3024],1,0,930)
    {
    IType = "2"
    OType = "2"
    }
   0.unity([4356,3024],1,0,940)
    {
    IType = "2"
    OType = "2"
    }
   0.unity([4392,3024],1,0,950)
    {
    IType = "2"
    OType = "2"
    }
   0.unity([4428,3024],1,0,960)
    {
    IType = "2"
    OType = "2"
    }
   0.unity([4464,3024],1,0,970)
    {
    IType = "2"
    OType = "2"
    }
   0.datalabel([4356,3024],0,0,-1)
    {
    Name = "Va"
    }
   0.datalabel([4392,3024],0,0,-1)
    {
    Name = "Vb"
    }
   0.datalabel([4428,3024],0,0,-1)
    {
    Name = "Vc"
    }
   -Wire-([3744,2952],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([3744,2988],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([3744,3024],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([3744,2952],0,0,-1)
    {
    Name = "Era"
    }
   0.datalabel([3744,2988],0,0,-1)
    {
    Name = "Erb"
    }
   0.datalabel([3744,3024],0,0,-1)
    {
    Name = "Erc"
    }
   0.pgb([3780,3024],0,25010136,770)
    {
    Name = "Erc"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([3780,2952],0,25012304,720)
    {
    Name = "Era"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "12.0"
    }
   0.pgb([3780,2988],0,25014200,740)
    {
    Name = "Erb"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([3852,2952],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([3852,2988],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([3852,2952],0,0,-1)
    {
    Name = "Isa"
    }
   0.datalabel([3852,3024],0,0,-1)
    {
    Name = "Isc"
    }
   0.pgb([3888,2952],0,25017856,2030)
    {
    Name = "Isa"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([3888,2988],0,25019752,2020)
    {
    Name = "Isb"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([3852,2988],0,0,-1)
    {
    Name = "Isb"
    }
   0.pgb([3888,3024],0,25170328,2010)
    {
    Name = "Isc"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([3852,3024],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([3960,2952],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([3960,2988],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([3960,3024],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([3960,2988],0,0,-1)
    {
    Name = "Irb"
    }
   0.pgb([3996,2952],0,25173752,730)
    {
    Name = "Ira"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([3960,2952],0,0,-1)
    {
    Name = "Ira"
    }
   0.pgb([3996,2988],0,25176184,760)
    {
    Name = "Irb"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([3996,3024],0,25178080,810)
    {
    Name = "Irc"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([3960,3024],0,0,-1)
    {
    Name = "Irc"
    }
   -Wire-([450,504],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([504,468],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.pgb([864,450],0,25181360,2630)
    {
    Name = "Iraa"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([864,486],0,25188224,2610)
    {
    Name = "Irbb"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([864,522],0,25190120,2600)
    {
    Name = "Ircc"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([828,450],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([828,486],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([828,522],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([846,450],4,0,-1)
    {
    Name = "Ira_ref"
    }
   0.datalabel([846,486],4,0,-1)
    {
    Name = "Irb_ref"
    }
   0.datalabel([846,522],4,0,-1)
    {
    Name = "Irc_ref"
    }
   0.datalabel([396,864],4,0,-1)
    {
    Name = "Vbeta"
    }
   -Wire-([396,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([738,828],4,0,-1)
    {
    Name = "Vsmag"
    }
   -Wire-([702,828],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([702,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([738,828],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([738,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([198,900],4,0,-1)
    {
    Name = "Vc"
    }
   0.datalabel([198,774],4,0,-1)
    {
    Name = "Va"
    }
   0.sumjct([234,900],6,0,1330)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "-1"
    D = "1"
    E = "0"
    F = "0"
    G = "0"
    }
   0.datalabel([198,846],4,0,-1)
    {
    Name = "Vb"
    }
   0.sumjct([234,846],6,0,1320)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "-1"
    D = "1"
    E = "0"
    F = "0"
    G = "0"
    }
   -Wire-([594,792],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.pgb([594,882],0,25200600,2390)
    {
    Name = "phisy"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([594,864],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.pgb([594,792],0,25202520,2510)
    {
    Name = "phisx"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([774,828],0,25204248,2440)
    {
    Name = "phsmag"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([576,864],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([576,828],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.diffpole([540,864],0,0,1520)
    {
    Limit = "0"
    COM = "Differential_Pole"
    Reset = "0"
    YO = "0.0"
    G = "1.0"
    T = "0.2 [sec]"
    Max = "10.0"
    Min = "-10.0"
    }
   -Wire-([270,774],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([270,900],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([396,828],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([666,432],2,0,-1)
    {
    Name = "slpang"
    }
   0.sumjct([252,1170],0,0,1560)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "1"
    D = "-1"
    E = "0"
    F = "0"
    G = "0"
    }
   0.datalabel([180,1134],6,0,-1)
    {
    Name = "phis"
    }
   -Wire-([432,1170],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Sticky-([108,198],0)
    {
    Name = ""
    Font = 2
    Bounds = 108,198,450,234
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "Generation of current references"
    }
   -Wire-([720,954],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.datalabel([810,954],4,0,-1)
    {
    Name = "phis"
    }
   -Wire-([720,864],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   -Sticky-([738,882],0)
    {
    Name = ""
    Font = 2
    Bounds = 738,882,918,936
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "Present location of rotating stator flux"
    }
   0.datalabel([414,1170],6,0,-1)
    {
    Name = "slpang"
    }
   0.datalabel([396,828],4,0,-1)
    {
    Name = "Valfa"
    }
   0.diffpole([540,828],0,0,1510)
    {
    Limit = "0"
    COM = "Differential_Pole"
    Reset = "0"
    YO = "0.0"
    G = "1.0"
    T = "0.2 [sec]"
    Max = "10.0"
    Min = "-10.0"
    }
   -Sticky-([504,1116],0)
    {
    Name = ""
    Font = 1
    Bounds = 504,1116,756,1206
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
determining the relative difference between stator flux and rotor position for resolving the rotor currents.
angle resolver cleans the angle signal so that jumps of 2 x pi don't show up."
    }
   0.integral([468,810],0,0,1500)
    {
    Extrn = "0"
    Reset = "0"
    Mthd = "0"
    noname5 = ""
    INTR = "0"
    INTCLR = "0"
    T = "1.0 [sec]"
    Yo = "0.0"
    YRst = "0.0"
    YHi = "100.0"
    YLo = "-100.0"
    }
   -Wire-([504,810],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([504,882],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([432,828],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([432,864],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.integral([468,882],0,0,1400)
    {
    Extrn = "0"
    Reset = "0"
    Mthd = "0"
    noname5 = ""
    INTR = "0"
    INTCLR = "0"
    T = "1.0 [sec]"
    Yo = "0.0"
    YRst = "0.0"
    YHi = "100.0"
    YLo = "-100.0"
    }
   0.pgb([774,864],0,25216832,2410)
    {
    Name = "phis"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.gain([162,810],0,0,1140)
    {
    G = "0.00257"
    COM = "Gain"
    Dim = "1"
    }
   0.datalabel([126,810],4,0,-1)
    {
    Name = "Isa"
    }
   0.unity([4248,3024],1,0,900)
    {
    IType = "2"
    OType = "2"
    }
   0.angle_resolver([324,1170],0,0,1570)
    {
    IPUnit = "0"
    OPUnit = "0"
    OPRange = "1"
    }
   -Sticky-([126,1026],0)
    {
    Name = ""
    Font = 2
    Bounds = 126,1026,576,1062
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Rotor position and the slip angle
"
    }
   -Sticky-([450,702],0)
    {
    Name = ""
    Font = 1
    Bounds = 450,702,828,774
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Identification of main stator flux by integrating stator voltage
after removal of resistive drop. The washout filter removes any 
dc component from the integrated flux without significantly 
ffecting the phase"
    }
   0.sumjct([234,774],6,0,1290)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "-1"
    D = "1"
    E = "0"
    F = "0"
    G = "0"
    }
   -Sticky-([2286,90],0)
    {
    Name = ""
    Font = 2
    Bounds = 2286,90,2862,198
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Rotor Vector Controller and Source-side PWM controller

Ani  Gole, Feb 2003"
    }
   -Sticky-([126,72],0)
    {
    Name = ""
    Font = 2
    Bounds = 126,72,504,108
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Induction Machine Vector Control Section"
    }
   -Wire-([108,1908],0,0,-1)
    {
    Vertex="0,0;954,0"
    }
   -Wire-([4194,2970],0,0,-1)
    {
    Vertex="0,0;450,0"
    }
   0.pi_ctlr([414,558],0,0,1120)
    {
    GP = "Kpq"
    TI = "Tiq"
    YHI = "2.75"
    YLO = "0.0"
    YINIT = "1.5125"
    Mthd = "0"
    INTR = "0"
    }
   0.sumjct([162,522],0,0,1100)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.datatap([4572,2988],0,0,880)
    {
    Index = "10"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([4608,2988],0,0,890)
    {
    Index = "11"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([4644,2988],0,0,910)
    {
    Index = "12"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([4644,2988],0,0,-1)
    {
    Name = "Qg"
    }
   -Wire-([504,468],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.pgb([594,468],3,25233584,2640)
    {
    Name = "Ird"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "5.0"
    Max = "40.0"
    }
   0.select([306,558],0,0,1110)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([198,522],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.const([234,558],0,0,160)
    {
    Name = ""
    Value = "0.0"
    }
   0.var([108,378],0,25236824,70)
    {
    Name = "Qref"
    Group = ""
    Display = "0"
    Max = "200.0"
    Min = "-100.0"
    Value = "25.0"
    Units = ""
    Collect = "1"
    }
   0.pi_ctlr([468,414],0,0,1270)
    {
    GP = "Kpd"
    TI = "Tid"
    YHI = "3.0"
    YLO = "0.0"
    YINIT = "2.0"
    Mthd = "0"
    INTR = "0"
    }
   0.sumjct([198,378],0,0,1040)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.datalabel([198,414],0,0,-1)
    {
    Name = "Qg"
    }
   0.select([360,414],0,0,1260)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([396,414],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.const([288,414],0,0,150)
    {
    Name = ""
    Value = "0.0"
    }
   0.datalabel([90,522],0,0,-1)
    {
    Name = "Wpu"
    }
   0.pgb([594,504],7,25243848,2620)
    {
    Name = "Irq"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "10.0"
    Max = "50.0"
    }
   -Wire-([90,522],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([3240,522],0,0,-1)
    {
    Vertex="0,0;0,2178"
    }
   -Wire-([3276,486],0,0,-1)
    {
    Vertex="0,0;0,2178"
    }
   -Wire-([3258,486],0,0,-1)
    {
    Vertex="0,0;0,2196"
    }
   -Wire-([234,378],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([378,558],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([450,504],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([1836,810],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.voltmetergnd([1854,792],7,0,240)
    {
    Name = "V1b"
    }
   0.voltmetergnd([1890,792],7,0,250)
    {
    Name = "V1c"
    }
   0.voltmetergnd([1818,792],7,0,230)
    {
    Name = "V1a"
    }
   -Wire-([1926,1026],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([1926,1098],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.nodeloop([1854,990],3,0,350)
    {
    View = "0"
    }
   -Wire-([1890,1026],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([1854,1026],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([1854,954],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([1818,1026],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.resistor([1890,1026],1,0,-1)
    {
    R = "0.001 [ohm]"
    }
   0.nodeloop([1854,1098],3,0,420)
    {
    View = "0"
    }
   0.resistor([1818,1026],1,0,-1)
    {
    R = "0.001 [ohm]"
    }
   -Wire-([1818,774],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([2088,558],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2088,522],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2070,504],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([2088,702],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2088,666],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2070,702],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([2016,558],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2016,522],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1998,504],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([2016,702],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2016,666],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1998,702],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([1944,558],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1944,522],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1926,504],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1944,702],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1944,666],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1926,702],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([2214,738],0,0,-1)
    {
    Vertex="0,0;-288,0"
    }
   -Wire-([2214,504],0,0,-1)
    {
    Vertex="0,0;-288,0"
    }
   -Wire-([1926,558],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.peswitch([1926,558],4,0,-1)
    {
    L = "D1"
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.0005 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([2016,522],6,0,2580)
    {
    L = "T1"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.0005 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([1998,558],4,0,-1)
    {
    L = "D1"
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.0005 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([2070,558],4,0,-1)
    {
    L = "D1"
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.0005 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([1944,666],6,0,2490)
    {
    L = "T1"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.0005 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([2016,666],6,0,2480)
    {
    L = "T1"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.0005 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([1998,702],4,0,-1)
    {
    L = "D1"
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.0005 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([2088,666],6,0,2470)
    {
    L = "T1"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.0005 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([2070,702],4,0,-1)
    {
    L = "D1"
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.0005 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([2214,504],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([1998,558],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.peswitch([2088,522],6,0,2570)
    {
    L = "T1"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.0005 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([2070,558],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([1854,774],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.ammeter([1854,774],3,0,210)
    {
    Name = "I1b"
    }
   -Wire-([1890,810],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.ammeter([1890,774],3,0,220)
    {
    Name = "I1c"
    }
   0.peswitch([1944,522],6,0,2590)
    {
    L = "T1"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.0005 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([1872,612],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   0.ground([1962,738],7,0,-1)
    {
    }
   -Wire-([2214,594],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   -Wire-([2214,738],0,0,-1)
    {
    Vertex="0,0;162,0"
    }
   -Wire-([2268,504],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   -Wire-([2268,630],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.voltmeter([2268,594],0,0,190)
    {
    Name = "Ecap"
    }
   0.capacitor([2214,594],3,0,-1)
    {
    C = "200020.0 [uF]"
    }
   0.datalabel([2376,648],4,0,-1)
    {
    Name = "Ecapref"
    }
   -Wire-([2214,504],0,0,-1)
    {
    Vertex="0,0;198,0"
    }
   0.breaker1([2412,576],3,0,180)
    {
    NAME = "BRK"
    OPCUR = "1"
    ENAB = "0"
    ViewB = "1"
    CLVL = "0.0001 [kA]"
    ROFF = "1e16"
    RON = "0.005 [ohm]"
    PRER = "0.1 [ohm]"
    TD = "0.0 [sec]"
    TDR = "0.05 [sec]"
    PostIns = "0"
    TDBO = "0.005 [s]"
    IBR = ""
    SBR = ""
    BOpen = "2"
    }
   -Wire-([2412,504],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.ground([1926,918],3,0,-1)
    {
    }
   0.ground([1962,846],0,0,-1)
    {
    }
   0.resistor([1926,846],0,0,-1)
    {
    R = "10000.0 [ohm]"
    }
   0.ammeter([2718,1062],1,0,450)
    {
    Name = "Irc"
    }
   0.ammeter([2682,1062],1,0,440)
    {
    Name = "Irb"
    }
   -Wire-([2610,558],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([2610,522],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([2628,504],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([2610,702],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([2610,666],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([2628,702],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.datalabel([2574,558],0,0,-1)
    {
    Name = "T1"
    }
   0.peswitch([2610,522],2,0,2550)
    {
    L = "T1"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([2682,558],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([2682,522],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([2700,504],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([2682,702],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([2682,666],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([2700,702],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.peswitch([2700,702],0,0,-1)
    {
    L = "D2"
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([2682,522],2,0,2540)
    {
    L = "T1"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([2682,666],2,0,2420)
    {
    L = "T2"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([2772,558],0,0,-1)
    {
    L = "D1"
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([2754,558],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([2754,522],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([2772,504],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([2754,702],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([2754,666],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([2772,702],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.datalabel([2718,702],0,0,-1)
    {
    Name = "T2"
    }
   0.peswitch([2772,702],0,0,-1)
    {
    L = "D2"
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([2754,522],2,0,2530)
    {
    L = "T1"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([2700,558],0,0,-1)
    {
    L = "D1"
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([2754,666],2,0,2400)
    {
    L = "T2"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([2808,882],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   0.datalabel([2574,702],0,0,-1)
    {
    Name = "T4"
    }
   0.datalabel([2718,558],0,0,-1)
    {
    Name = "T5"
    }
   0.datalabel([2646,702],0,0,-1)
    {
    Name = "T6"
    }
   0.datalabel([2646,558],0,0,-1)
    {
    Name = "T3"
    }
   0.voltmetergnd([2808,810],1,0,310)
    {
    Name = "Erc"
    }
   -Wire-([2718,1062],0,0,-1)
    {
    Vertex="0,0;0,-144"
    }
   0.ammeter([2646,1062],1,0,430)
    {
    Name = "Ira"
    }
   -Wire-([2808,828],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([2736,828],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.voltmetergnd([2736,810],1,0,290)
    {
    Name = "Erb"
    }
   -Wire-([2682,1062],0,0,-1)
    {
    Vertex="0,0;0,-234"
    }
   -Wire-([2556,882],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.voltmetergnd([2556,828],1,0,280)
    {
    Name = "Era"
    }
   -Wire-([2646,882],0,0,-1)
    {
    Vertex="0,0;0,180"
    }
   0.peswitch([2610,666],2,0,2430)
    {
    L = "T2"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([2628,558],0,0,-1)
    {
    L = "D1"
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([2628,702],0,0,-1)
    {
    L = "D2"
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([2376,738],0,0,-1)
    {
    Vertex="0,0;396,0"
    }
   -Wire-([2772,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2700,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2628,630],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([2628,558],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([2700,558],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([2772,558],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([2412,504],0,0,-1)
    {
    Vertex="0,0;360,0"
    }
   -Wire-([2556,630],0,0,-1)
    {
    Vertex="0,0;0,252"
    }
   -Wire-([2808,630],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   -Wire-([2736,630],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   0.xfmr-3p2w([1854,882],3,0,-1)
    {
    Name = ""
    Tmva = "100"
    f = "60.0 [Hz]"
    YD1 = "0"
    YD2 = "0"
    Lead = "1"
    Xl = "0.1 [pu]"
    Ideal = "0"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Tap = "0"
    View = "0"
    Dtls = "0"
    V1 = "13.8 [kV]"
    V2 = "1"
    Enab = "0"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0.1 [s]"
    Im1 = "0.1 [%]"
    ILA1 = ""
    ILB1 = ""
    ILC1 = ""
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = ""
    ILB2 = ""
    ILC2 = ""
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   -Wire-([1872,612],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1854,612],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   -Wire-([1890,648],0,0,-1)
    {
    Vertex="0,0;180,0"
    }
   -Wire-([1890,648],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   -Wire-([1818,594],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.resistor([1854,1026],1,0,-1)
    {
    R = "0.001 [ohm]"
    }
   0.pgb([1998,1026],3,25321680,2290)
    {
    Name = "Pso"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.power([1962,1026],0,0,1210)
    {
    DIR = "1"
    P = "1"
    Q = "1"
    TS = "0.1 [sec]"
    View = "0"
    }
   0.pgb([1998,1062],3,25324304,2280)
    {
    Name = "Qso"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([1818,1062],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   -Wire-([1890,1062],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([1980,558],4,0,-1)
    {
    Name = "T1s"
    }
   0.datalabel([2052,558],4,0,-1)
    {
    Name = "T3s"
    }
   0.datalabel([2124,558],4,0,-1)
    {
    Name = "T5s"
    }
   0.peswitch([1926,702],4,0,-1)
    {
    L = "D1"
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.0005 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.datalabel([1980,702],4,0,-1)
    {
    Name = "T4s"
    }
   0.datalabel([2052,702],4,0,-1)
    {
    Name = "T6s"
    }
   0.datalabel([2124,702],4,0,-1)
    {
    Name = "T2s"
    }
   -Wire-([2430,450],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2394,450],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2394,450],0,0,-1)
    {
    Name = "BRK"
    }
   0.ammeter([1818,774],3,0,200)
    {
    Name = "I1a"
    }
   -Wire-([1818,594],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   0.source_1([2412,648],1,0,2460)
    {
    Name = "Source1"
    Type = "1"
    Grnd = "1"
    Spec = "0"
    Cntrl = "1"
    AC = "0"
    Vm = "132.79 [kV]"
    Tc = "0.0 [s]"
    Ph = "0.0 [deg]"
    f = "60.0 [Hz]"
    P = "0.0 [MW]"
    Q = "0.0 [MVAR]"
    R = "0.01 [ohm]"
    Rs = "1.0 [ohm]"
    Rp = "1.0 [ohm]"
    Lp = "0.1 [H]"
    R' = "1.0 [ohm]"
    L = "0.1 [H]"
    C = "1.0 [uF]"
    L' = "0.1 [H]"
    C' = "1.0 [uF]"
    CUR = ""
    }
   0.tbreakn([2502,450],0,0,170)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "0.2"
    TO2 = "100000.0 [sec]"
    }
   -Sticky-([2574,414],0)
    {
    Name = ""
    Font = 1
    Bounds = 2574,414,2826,468
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "This breaker necessary if you want to pre-charge capacitor to 10kV  at start-up"
    }
   -Sticky-([2826,540],0)
    {
    Name = ""
    Font = 2
    Bounds = 2826,540,3060,612
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "CR-PWM based Rotor-side converter"
    }
   -Sticky-([1566,558],0)
    {
    Name = ""
    Font = 2
    Bounds = 1566,558,1764,630
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "SPWM based source-side converter"
    }
   -Wire-([1854,1062],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.breakout([1854,1188],3,0,-1)
    {
    Dis = "0"
    }
   0.breakout([2682,1170],3,0,-1)
    {
    Dis = "0"
    }
   -Wire-([2682,1098],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([2718,1134],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([2646,1134],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([2682,1170],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([1854,1188],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([180,1458],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([378,1764],0,0,-1)
    {
    Name = "hy"
    }
   -Wire-([342,1764],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([342,1800],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([324,1764],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([450,1800],0,0,-1)
    {
    Name = "nhy"
    }
   0.datalabel([324,1494],0,0,-1)
    {
    Name = "T1"
    }
   0.datalabel([324,1620],0,0,-1)
    {
    Name = "T4"
    }
   0.sumjct([108,1458],0,0,1710)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "-1"
    D = "0"
    E = "1"
    F = "0"
    G = "0"
    }
   -Wire-([540,1476],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1062,1458],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   0.inv([1062,1584],0,0,1830)
    {
    INTR = "0"
    }
   0.sumjct([972,1458],0,0,1680)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "-1"
    D = "0"
    E = "1"
    F = "0"
    G = "0"
    }
   0.sumjct([468,1476],0,0,1700)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "-1"
    D = "0"
    E = "1"
    F = "0"
    G = "0"
    }
   0.datalabel([720,1512],0,0,-1)
    {
    Name = "T3"
    }
   0.datalabel([720,1638],0,0,-1)
    {
    Name = "T6"
    }
   -Wire-([1044,1458],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1170,1494],0,0,-1)
    {
    Name = "T5"
    }
   0.datalabel([1170,1620],0,0,-1)
    {
    Name = "T2"
    }
   0.datalabel([432,1512],4,0,-1)
    {
    Name = "Irb_ref"
    }
   0.datalabel([900,1494],4,0,-1)
    {
    Name = "Irc_ref"
    }
   0.datalabel([558,1836],0,0,-1)
    {
    Name = "hy"
    }
   0.pgb([756,1800],0,25354648,2140)
    {
    Name = "Iref-hy"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([684,1764],2,0,-1)
    {
    Name = "ira_ref"
    }
   0.datalabel([558,1764],2,0,-1)
    {
    Name = "ira_ref"
    }
   0.datalabel([684,1836],0,0,-1)
    {
    Name = "hy"
    }
   0.pgb([630,1800],0,25358288,2150)
    {
    Name = "Iref+hy"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([324,1494],0,25359920,2240)
    {
    Name = "T1"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.var([288,1764],0,25361816,700)
    {
    Name = "Hys_band"
    Group = ""
    Display = "0"
    Max = "10.0"
    Min = "0.0"
    Value = "0.001"
    Units = ""
    Collect = "1"
    }
   0.sumjct([594,1800],0,0,1910)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "1"
    D = "0"
    E = "1"
    F = "0"
    G = "0"
    }
   0.sumjct([720,1800],0,0,1900)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "1"
    D = "0"
    E = "-1"
    F = "0"
    G = "0"
    }
   -Sticky-([126,1296],0)
    {
    Name = ""
    Font = 2
    Bounds = 126,1296,738,1332
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "Current-Reference PWM Controls. Hysteresis band can be adjusted"
    }
   0.datalabel([396,1386],2,0,-1)
    {
    Name = "Irb"
    }
   0.datalabel([882,1386],2,0,-1)
    {
    Name = "Irc"
    }
   0.gain([414,1800],0,0,710)
    {
    G = "-1.0"
    COM = "Gain"
    Dim = "1"
    }
   -Wire-([108,1890],0,0,-1)
    {
    Vertex="0,0;954,0"
    }
   -Wire-([108,1872],0,0,-1)
    {
    Vertex="0,0;954,0"
    }
   0.xnode([1854,1224],0,0,-1)
    {
    Name = "SABC"
    }
   0.xnode([2682,1206],0,0,-1)
    {
    Name = "GABC"
    }
   0.annotation([4374,2898],0,0,-1)
    {
    AL1 = "Signals from main Page"
    AL2 = ""
    }
   0.annotation([3942,2880],0,0,-1)
    {
    AL1 = "Channels for plotting"
    AL2 = ""
    }
   -Sticky-([108,702],0)
    {
    Name = ""
    Font = 2
    Bounds = 108,702,450,756
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "Present location of rotating stator flux"
    }
   0.annotation([180,324],0,0,-1)
    {
    AL1 = "Reactive Power Reference"
    AL2 = ""
    }
   0.annotation([126,576],0,0,-1)
    {
    AL1 = "Speed Reference"
    AL2 = ""
    }
   0.var([342,234],0,25371544,20)
    {
    Name = "Kpd"
    Group = ""
    Display = "0"
    Max = "10"
    Min = "0.0"
    Value = "0.1"
    Units = ""
    Collect = "1"
    }
   0.datalabel([522,234],0,0,-1)
    {
    Name = "Kpd"
    }
   0.var([558,234],0,25374064,30)
    {
    Name = "Tid"
    Group = ""
    Display = "0"
    Max = "25.0"
    Min = "0.0"
    Value = "0.2"
    Units = ""
    Collect = "1"
    }
   0.datalabel([738,234],0,0,-1)
    {
    Name = "Tid"
    }
   0.var([468,342],0,25376496,60)
    {
    Name = "Kpq"
    Group = ""
    Display = "0"
    Max = "1250.0"
    Min = "0.0"
    Value = "972.222222222"
    Units = ""
    Collect = "1"
    }
   0.datalabel([576,342],0,0,-1)
    {
    Name = "Kpq"
    }
   0.var([594,360],0,25378936,110)
    {
    Name = "Tiq"
    Group = ""
    Display = "0"
    Max = "5.0"
    Min = "0.0"
    Value = "8.0e-005"
    Units = ""
    Collect = "1"
    }
   0.datalabel([702,360],0,0,-1)
    {
    Name = "Tiq"
    }
   0.datalabel([126,882],4,0,-1)
    {
    Name = "Isb"
    }
   0.datalabel([126,936],4,0,-1)
    {
    Name = "Isc"
    }
   0.gain([162,882],0,0,1170)
    {
    G = "0.00257"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([162,936],0,0,1180)
    {
    G = "0.00257"
    COM = "Gain"
    Dim = "1"
    }
   0.radiolink([990,288],4,0,50)
    {
    Source = "MAIN"
    Name = "Wspd"
    dim = "1"
    Mode = "0"
    Type = "0"
    }
   -Wire-([1098,288],0,0,-1)
    {
    Vertex="0,0;-108,0"
    }
   0.datalabel([1044,288],4,0,-1)
    {
    Name = "Vw"
    }
   0.annotation([1044,252],4,0,-1)
    {
    AL1 = "Wind speed signal"
    AL2 = ""
    }
   0.realpole([1206,288],0,0,1070)
    {
    Limit = "0"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "1.0"
    T = "0.05 [sec]"
    Max = "10.0"
    Min = "-10.0"
    }
   0.datalabel([1278,288],0,0,-1)
    {
    Name = "Wref_"
    }
   -Wire-([1242,288],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.div([1134,288],0,0,1050)
    {
    }
   0.const([1098,324],0,0,140)
    {
    Name = ""
    Value = "10.909"
    }
   -Sticky-([1062,342],0)
    {
    Name = ""
    Font = 1
    Bounds = 1062,342,1350,450
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Assume constant tip speed ratio:
windspeed/Wpu = 12/1.1 = 10.909 = constant

Note:
Initial wind speed is 12 m/s and the initial speed of machine is 1.1 pu"
    }
   0.pgb([1278,288],0,25394176,2650)
    {
    Name = "Wref_"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "1.085"
    Max = "1.115"
    }
   0.datalabel([162,558],0,0,-1)
    {
    Name = "Wref_"
    }
   -Sticky-([648,108],0)
    {
    Name = ""
    Font = 1
    Bounds = 648,108,864,162
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Enable the controls after 0.5 s, when the machine is in torque control mode."
    }
   -Sticky-([360,306],0)
    {
    Name = ""
    Font = 1
    Bounds = 360,306,468,342
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Ird - Determines the reactive power"
    }
   -Sticky-([666,576],0)
    {
    Name = ""
    Font = 1
    Bounds = 666,576,774,648
    Alignment = 0
    Style = 1
    Arrow = 64
    Color = 0,15792890
    Text = "Irq - Determines the real power"
    }
   -Sticky-([1008,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 1008,198,1260,252
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Determine the reference speed to maintian the optimal tip speed ratio (Max. power tracking)"
    }
   -Sticky-([1008,144],0)
    {
    Name = ""
    Font = 2
    Bounds = 1008,144,1224,180
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "Optimal Power Tracking"
    }
   0.pgb([432,1170],0,25398496,2300)
    {
    Name = "slpang"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.realpole([504,504],0,0,1280)
    {
    Limit = "0"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "1.0"
    T = "1.0e-005 [sec]"
    Max = "10.0"
    Min = "-10.0"
    }
   -Wire-([540,504],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([360,450],0,0,-1)
    {
    Name = "S_TMODE"
    }
   0.datalabel([306,594],0,0,-1)
    {
    Name = "S_TMODE"
    }
   -Wire-([2808,1098],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([2808,936],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([2880,936],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([2952,1098],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([2952,936],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([3042,1044],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([2808,990],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([2808,900],0,0,-1)
    {
    Vertex="0,0;198,0"
    }
   -Wire-([2880,1098],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([3042,936],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([2808,1152],0,0,-1)
    {
    Vertex="0,0;234,0"
    }
   -Wire-([3042,990],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([3042,1062],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Sticky-([2880,810],0)
    {
    Name = ""
    Font = 2
    Bounds = 2880,810,3222,864
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Crowbar (roter over current  protection)
"
    }
   0.peswitch([2808,990],0,0,-1)
    {
    L = "DA"
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "200.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([2808,1098],0,0,-1)
    {
    L = "DD"
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "200.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([2880,990],0,0,-1)
    {
    L = "DB"
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "200.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([2880,1098],0,0,-1)
    {
    L = "DE"
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "200.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([2952,990],0,0,-1)
    {
    L = "DC"
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "200.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([2952,1098],0,0,-1)
    {
    L = "DF"
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "200.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([3042,1008],2,0,2270)
    {
    L = "V729"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.datalabel([3006,1044],0,0,-1)
    {
    Name = "S1"
    }
   -Wire-([2880,990],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([2952,990],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([2808,1044],0,0,-1)
    {
    Vertex="0,0;-162,0"
    }
   -Wire-([2952,1008],0,0,-1)
    {
    Vertex="0,0;-234,0"
    }
   0.ammeter([3006,936],0,0,380)
    {
    Name = "Idc"
    }
   -Wire-([3006,900],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.voltmeter([2970,954],4,0,410)
    {
    Name = "DEC"
    }
   0.voltmeter([2898,954],4,0,400)
    {
    Name = "DEB"
    }
   0.voltmeter([2826,954],4,0,390)
    {
    Name = "DEA"
    }
   0.voltmeter([2970,1062],4,0,490)
    {
    Name = "DEF"
    }
   0.voltmeter([2898,1062],4,0,480)
    {
    Name = "DEE"
    }
   0.voltmeter([2826,1062],4,0,470)
    {
    Name = "DED"
    }
   -Wire-([2970,954],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2970,990],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2898,954],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2898,990],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2826,954],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2826,990],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2826,1062],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2826,1098],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2898,1098],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2898,1062],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2970,1062],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2970,1098],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2880,1026],0,0,-1)
    {
    Vertex="0,0;-198,0"
    }
   -Wire-([3060,990],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([3060,1044],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([4248,0],0,0,-1)
    {
    Vertex="0,0;0,2178"
    }
   0.const([5346,540],0,0,270)
    {
    Name = ""
    Value = "75.0"
    }
   -Wire-([5508,540],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([5652,504],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([5526,504],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.datalabel([5526,468],1,0,-1)
    {
    Name = "Ir"
    }
   0.annotation([5544,414],0,0,-1)
    {
    AL1 = "VRCC Modulator &"
    AL2 = "Rotor Overcurrent Protection"
    }
   0.compar([5526,504],0,0,1790)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1.0"
    ONone = "0.0"
    ONeg = "1.0"
    OHi = "1.0"
    OLo = "0.0"
    }
   -Wire-([5652,504],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([5652,558],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([5526,468],0,25432712,2370)
    {
    Name = "Ir"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([5778,576],0,0,-1)
    {
    Name = "S1"
    }
   0.var_switch([5724,648],0,25435080,370)
    {
    Name = "crowbar_sw"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1.0"
    Min = "0.0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.datalabel([5796,648],0,0,-1)
    {
    Name = "block"
    }
   0.pgb([5778,576],0,25437520,2330)
    {
    Name = "S1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.ammeter([2718,882],1,0,340)
    {
    Name = "Irc_con"
    }
   0.peswitch([3060,1044],0,0,-1)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1000000.0 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "100000.0 [kV]"
    Erw = "100000.0 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.logic_mult([5742,576],0,0,1860)
    {
    Type = "1"
    Num_in = "2"
    Inv = "0"
    disnum = "0"
    INTR = "0"
    Inv1 = "0"
    Inv2 = "0"
    Inv3 = "0"
    Inv4 = "0"
    Inv5 = "0"
    Inv6 = "0"
    Inv7 = "0"
    Inv8 = "0"
    Inv9 = "0"
    }
   0.datalabel([5706,594],0,0,-1)
    {
    Name = "block"
    }
   -Wire-([4230,0],0,0,-1)
    {
    Vertex="0,0;0,2178"
    }
   -Wire-([900,1494],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([1170,1494],0,25443048,2210)
    {
    Name = "T5"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1170,1620],0,25444776,2170)
    {
    Name = "T2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.select([1134,1494],0,0,1950)
    {
    A = "0"
    DPath = "1"
    COM = "Selector"
    }
   0.datalabel([1134,1530],0,0,-1)
    {
    Name = "S1"
    }
   0.select([1134,1620],0,0,1920)
    {
    A = "0"
    DPath = "1"
    COM = "Selector"
    }
   0.const([1062,1494],0,0,650)
    {
    Name = ""
    Value = "0.0"
    }
   0.const([1062,1620],0,0,690)
    {
    Name = ""
    Value = "0.0"
    }
   0.datalabel([1134,1656],0,0,-1)
    {
    Name = "S1"
    }
   -Wire-([216,1458],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   0.inv([216,1584],0,0,1850)
    {
    INTR = "0"
    }
   -Wire-([216,1458],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([324,1620],0,25451608,2200)
    {
    Name = "T4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.select([288,1494],0,0,1970)
    {
    A = "0"
    DPath = "1"
    COM = "Selector"
    }
   0.datalabel([288,1530],0,0,-1)
    {
    Name = "S1"
    }
   0.select([288,1620],0,0,1940)
    {
    A = "0"
    DPath = "1"
    COM = "Selector"
    }
   0.const([216,1494],0,0,620)
    {
    Name = ""
    Value = "0.0"
    }
   0.const([216,1620],0,0,660)
    {
    Name = ""
    Value = "0.0"
    }
   0.datalabel([288,1656],0,0,-1)
    {
    Name = "S1"
    }
   -Wire-([612,1476],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   0.inv([612,1602],0,0,1840)
    {
    INTR = "0"
    }
   -Wire-([594,1476],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([720,1512],0,25458144,2220)
    {
    Name = "T3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([720,1638],0,25459872,2180)
    {
    Name = "T6"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.select([684,1512],0,0,1960)
    {
    A = "0"
    DPath = "1"
    COM = "Selector"
    }
   0.datalabel([684,1548],0,0,-1)
    {
    Name = "S1"
    }
   0.select([684,1638],0,0,1930)
    {
    A = "0"
    DPath = "1"
    COM = "Selector"
    }
   0.const([612,1512],0,0,640)
    {
    Name = ""
    Value = "0.0"
    }
   0.const([612,1638],0,0,680)
    {
    Name = ""
    Value = "0.0"
    }
   0.datalabel([684,1674],0,0,-1)
    {
    Name = "S1"
    }
   -Sticky-([792,1602],0)
    {
    Name = ""
    Font = 1
    Bounds = 792,1602,1008,1692
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Block the roter side invetre during the high enough roter current to trigger the crowbar potection circuit
S1 = 0  ==> Crowbar not active."
    }
   -Wire-([144,378],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.pgb([144,378],1,25466248,80)
    {
    Name = "Qg_ref"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-50.0"
    Max = "175.0"
    }
   -Wire-([2808,1116],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([2952,1116],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([2880,1116],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([2808,900],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([2880,900],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([2952,900],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.datalabel([3024,756],0,0,-1)
    {
    Name = "Idc"
    }
   -Wire-([3024,756],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([3096,756],0,25470784,2350)
    {
    Name = "Idc_Crow"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.polar_rec([666,846],0,0,1550)
    {
    Dir = "1"
    AngUnit = "0"
    }
   -Wire-([3852,468],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([3852,504],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([3888,468],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([3888,504],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([3762,504],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([3762,468],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([3636,414],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.pgb([3636,414],0,25480376,2560)
    {
    Name = "Ea"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([3924,504],0,25482104,2450)
    {
    Name = "phivs"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([3888,468],4,0,-1)
    {
    Name = "Ed"
    }
   0.pgb([3924,468],0,25484552,2500)
    {
    Name = "Vsmag"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Sticky-([3402,360],0)
    {
    Name = ""
    Font = 1
    Bounds = 3402,360,3546,396
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Detection of system voltage"
    }
   0.datalabel([3564,450],4,0,-1)
    {
    Name = "Va"
    }
   0.datalabel([3564,486],4,0,-1)
    {
    Name = "Vb"
    }
   0.datalabel([3564,522],4,0,-1)
    {
    Name = "Vc"
    }
   0.datalabel([3348,720],4,0,-1)
    {
    Name = "i1a"
    }
   0.datalabel([3348,792],4,0,-1)
    {
    Name = "i1c"
    }
   0.datalabel([3348,756],4,0,-1)
    {
    Name = "i1b"
    }
   -Wire-([3420,666],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.pgb([3420,666],0,25492704,2380)
    {
    Name = "i1a"
    Group = ""
    Display = "1"
    Scale = "5"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.diffpole([3582,774],0,0,1200)
    {
    Limit = "0"
    COM = "Differential_Pole"
    Reset = "0"
    YO = "0.0"
    G = "1.0"
    T = "0.2 [sec]"
    Max = "10.0"
    Min = "-10.0"
    }
   -Wire-([3618,774],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.pgb([3618,810],0,25495640,2320)
    {
    Name = "i1beta"
    Group = ""
    Display = "1"
    Scale = "5"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([3618,666],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.pgb([3618,666],0,25497912,2360)
    {
    Name = "i1alfa"
    Group = ""
    Display = "1"
    Scale = "5"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([3942,774],4,0,-1)
    {
    Name = "i1q"
    }
   0.const([3690,810],0,0,360)
    {
    Name = ""
    Value = "0.01326"
    }
   -Wire-([3690,738],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([3888,702],2,0,-1)
    {
    Name = "phi"
    }
   0.datalabel([3942,738],4,0,-1)
    {
    Name = "i1d"
    }
   0.pgb([4032,738],0,24320160,2340)
    {
    Name = "i1d"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([4032,774],0,25505072,2310)
    {
    Name = "i1q"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([3924,738],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.realpole([3996,774],0,0,1980)
    {
    Limit = "0"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "1.0"
    T = "0.001 [sec]"
    Max = "10.0"
    Min = "-10.0"
    }
   -Wire-([3942,738],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([3942,774],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.realpole([3996,738],0,0,1990)
    {
    Limit = "0"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "1.0"
    T = "0.001 [sec]"
    Max = "10.0"
    Min = "-10.0"
    }
   0.sumjct([3726,774],0,0,1360)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.diffpole([3582,738],0,0,1340)
    {
    Limit = "0"
    COM = "Differential_Pole"
    Reset = "0"
    YO = "0.0"
    G = "1.0"
    T = "0.2 [sec]"
    Max = "10.0"
    Min = "-10.0"
    }
   -Sticky-([3474,576],0)
    {
    Name = ""
    Font = 1
    Bounds = 3474,576,3780,630
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Detection of  d-q components of currents. The washout
filters remove dc components. Phase change of 0.01326 rad
corrects washout filter phase error"
    }
   0.datalabel([3762,468],4,0,-1)
    {
    Name = "Valfas"
    }
   0.datalabel([3762,504],4,0,-1)
    {
    Name = "Vbetas"
    }
   0.datalabel([3888,504],0,0,-1)
    {
    Name = "phi"
    }
   0.polar_rec([3654,756],0,0,1350)
    {
    Dir = "1"
    AngUnit = "0"
    }
   0.polar_rec([3816,486],0,0,1310)
    {
    Dir = "1"
    AngUnit = "0"
    }
   -Wire-([3798,1062],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([3798,1296],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([3870,1098],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([3870,1152],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([3924,1260],0,0,-1)
    {
    Vertex="0,0;0,-90"
    }
   -Wire-([3870,1260],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.sumjct([4014,1296],6,0,1490)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "-1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([3960,1260],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([3960,1098],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([3924,1170],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([3870,1188],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.pi_ctlr([3942,1296],0,0,1480)
    {
    GP = "Kpssc"
    TI = "Tissc"
    YHI = "15"
    YLO = "-15"
    YINIT = "0.0"
    Mthd = "0"
    INTR = "0"
    }
   0.datalabel([3870,1116],0,0,-1)
    {
    Name = "i1d"
    }
   0.gain([3960,1224],1,0,1460)
    {
    G = "0"
    COM = "Gain"
    Dim = "1"
    }
   0.datalabel([3924,1224],2,0,-1)
    {
    Name = "i1q"
    }
   0.sumjct([4014,1062],0,0,1530)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "-1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.const([3978,1026],0,0,530)
    {
    Name = ""
    Value = "3.266"
    }
   0.datalabel([4050,1062],0,0,-1)
    {
    Name = "Vdref1"
    }
   0.datalabel([4050,1296],0,0,-1)
    {
    Name = "Vqref1"
    }
   0.sumjct([3870,1062],0,0,1430)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.var([3384,1062],0,25522888,520)
    {
    Name = "Vref_Cap"
    Group = ""
    Display = "0"
    Max = "12"
    Min = "0"
    Value = "10.0"
    Units = ""
    Collect = "1"
    }
   -Wire-([3420,1062],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([3456,1062],4,0,-1)
    {
    Name = "Ecapref"
    }
   0.datalabel([3438,1098],4,0,-1)
    {
    Name = "Ecap"
    }
   -Wire-([3618,1062],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.pi_ctlr([3654,1062],0,0,1240)
    {
    GP = "Kpcvc"
    TI = "Ticvc"
    YHI = "2"
    YLO = "-2"
    YINIT = "0.0"
    Mthd = "0"
    INTR = "0"
    }
   -Wire-([3726,1134],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([3762,1062],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([3726,1098],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.sumjct([3726,1062],0,0,1370)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.diffpole([3654,1134],0,0,1250)
    {
    Limit = "0"
    COM = "Differential_Pole"
    Reset = "0"
    YO = "0.0"
    G = "0"
    T = "0.01 [sec]"
    Max = "10.0"
    Min = "-10.0"
    }
   0.gain([3960,1134],3,0,1450)
    {
    G = "0"
    COM = "Gain"
    Dim = "1"
    }
   0.datalabel([3708,972],2,0,-1)
    {
    Name = "Kpcvc"
    }
   -Wire-([3672,972],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([3708,1008],2,0,-1)
    {
    Name = "Ticvc"
    }
   -Wire-([3672,1008],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([3510,1494],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([3582,1494],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([3582,1458],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([3420,1458],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([3420,1458],0,0,-1)
    {
    Name = "Vdref1"
    }
   -Wire-([3420,1494],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([3420,1494],0,0,-1)
    {
    Name = "Vqref1"
    }
   0.datalabel([3708,1494],0,0,-1)
    {
    Name = "vqref"
    }
   0.datalabel([3708,1458],0,0,-1)
    {
    Name = "vdref"
    }
   0.hardlimit([3546,1458],0,0,1600)
    {
    UL = "2000"
    LL = "0"
    COM = "Hard_Limit"
    }
   -Sticky-([3330,1386],0)
    {
    Name = ""
    Font = 1
    Bounds = 3330,1386,3528,1422
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Generation of PWM Reference Voltages"
    }
   0.datalabel([3978,1440],0,0,-1)
    {
    Name = "Varef"
    }
   0.datalabel([3978,1512],0,0,-1)
    {
    Name = "Vcref"
    }
   0.datalabel([3978,1476],0,0,-1)
    {
    Name = "Vbref"
    }
   -Wire-([3672,1458],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([3672,1494],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Sticky-([3474,1566],0)
    {
    Name = ""
    Font = 1
    Bounds = 3474,1566,3564,1602
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Magnitude Limiter"
    }
   -Sticky-([3348,1638],0)
    {
    Name = ""
    Font = 1
    Bounds = 3348,1638,3546,1674
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "1.26 kHz SPWM Firing Pulse generator"
    }
   0.pi_ctlr([3942,1062],0,0,1440)
    {
    GP = "Kpssc"
    TI = "Tissc"
    YHI = "15"
    YLO = "-15"
    YINIT = "0.0"
    Mthd = "0"
    INTR = "0"
    }
   0.sumjct([3510,1062],0,0,1220)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.pgb([3510,1098],0,25545640,570)
    {
    Name = "Ecap"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "14.0"
    }
   0.realpole([3474,1098],0,0,560)
    {
    Limit = "0"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "1.0"
    T = "0.04 [sec]"
    Max = "10.0"
    Min = "-10.0"
    }
   0.datalabel([3798,1422],1,0,-1)
    {
    Name = "phi"
    }
   0.var([3762,1296],0,25548992,670)
    {
    Name = "Iqref_grid_side"
    Group = ""
    Display = "0"
    Max = "10"
    Min = "-10"
    Value = "0.0"
    Units = ""
    Collect = "1"
    }
   0.sumjct([3870,1296],6,0,1470)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.var([4140,1080],0,25551520,600)
    {
    Name = "Kpssc"
    Group = ""
    Display = "0"
    Max = "1000"
    Min = "0"
    Value = "10.0"
    Units = ""
    Collect = "1"
    }
   0.var([4140,1134],0,25553424,630)
    {
    Name = "Tissc"
    Group = ""
    Display = "0"
    Max = "1000"
    Min = "0.001"
    Value = "0.01"
    Units = ""
    Collect = "1"
    }
   0.var([3636,1008],0,25555304,500)
    {
    Name = "Ticvc"
    Group = ""
    Display = "0"
    Max = "1000"
    Min = "0.001"
    Value = "0.1"
    Units = ""
    Collect = "1"
    }
   0.var([3636,972],0,25557184,460)
    {
    Name = "Kpcvc"
    Group = ""
    Display = "0"
    Max = "1000"
    Min = "0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   -Sticky-([3780,936],0)
    {
    Name = ""
    Font = 1
    Bounds = 3780,936,4050,972
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Decoupled Id-Iq controller. Voltage error drives the Idref"
    }
   0.datalabel([3798,1062],2,0,-1)
    {
    Name = "idref"
    }
   0.polar_rec([3474,1476],0,0,1540)
    {
    Dir = "1"
    AngUnit = "0"
    }
   0.pgb([4050,1062],0,25560616,2250)
    {
    Name = "Vdref1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-12.5"
    Max = "7.5"
    }
   0.pgb([4050,1296],0,25562600,2190)
    {
    Name = "Vqref1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-10.0"
    Max = "12.5"
    }
   0.pgb([3978,1440],0,25564504,2160)
    {
    Name = "Varef"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([3888,1926],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([3888,1980],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([3888,2178],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([3600,1890],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.jumper([3600,2052],3,0,-1)
    {
    }
   -Wire-([3600,2088],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.compar([3672,2052],0,0,1810)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   -Wire-([3600,2214],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([3564,2178],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.jumper([3600,2178],3,0,-1)
    {
    }
   -Wire-([3564,1926],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.jumper([3600,1926],3,0,-1)
    {
    }
   -Wire-([3600,1962],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([3600,1818],0,25571112,2130)
    {
    Name = "triangular wave"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([3564,1818],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.compar([3672,1926],0,0,1820)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   0.compar([3672,2178],0,0,1800)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   -Wire-([3456,1926],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([3474,1926],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([3474,1926],0,0,-1)
    {
    Name = "Varef"
    }
   -Wire-([3564,2052],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.gain([3528,2052],0,0,1730)
    {
    G = "1"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([3528,2178],0,0,1720)
    {
    G = "1"
    COM = "Gain"
    Dim = "1"
    }
   -Wire-([3456,2052],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([3474,2052],0,0,-1)
    {
    Name = "Vbref"
    }
   -Wire-([3438,2178],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([3474,2178],0,0,-1)
    {
    Name = "Vcref"
    }
   0.datalabel([3924,1926],0,0,-1)
    {
    Name = "T1s"
    }
   0.datalabel([3924,2178],0,0,-1)
    {
    Name = "T5s"
    }
   -Wire-([3600,2016],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.delay([3852,1980],0,0,2100)
    {
    T = "1e-6 [sec]"
    INTR = "0"
    }
   0.datalabel([3924,1980],0,0,-1)
    {
    Name = "T4s"
    }
   0.inv([3762,1980],0,0,1890)
    {
    INTR = "0"
    }
   -Wire-([3762,1980],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.delay([3852,1926],0,0,2110)
    {
    T = "1e-6 [sec]"
    INTR = "0"
    }
   -Wire-([3888,2052],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([3924,2052],0,0,-1)
    {
    Name = "T3s"
    }
   0.inv([3762,2106],0,0,1880)
    {
    INTR = "0"
    }
   0.delay([3852,2106],0,0,2070)
    {
    T = "1e-6 [sec]"
    INTR = "0"
    }
   -Wire-([3888,2106],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([3924,2106],0,0,-1)
    {
    Name = "T6s"
    }
   -Wire-([3888,2232],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([3762,2232],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.inv([3762,2232],0,0,1870)
    {
    INTR = "0"
    }
   -Wire-([3762,2106],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.delay([3852,2232],0,0,2040)
    {
    T = "1e-6 [sec]"
    INTR = "0"
    }
   0.datalabel([3924,2232],0,0,-1)
    {
    Name = "T2s"
    }
   -Wire-([3744,1926],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([3798,1980],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([3744,2052],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([3798,2106],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([3744,2178],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([3798,2232],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.delay([3852,2052],0,0,2080)
    {
    T = "1e-6 [sec]"
    INTR = "0"
    }
   0.delay([3852,2178],0,0,2050)
    {
    T = "1e-6 [sec]"
    INTR = "0"
    }
   -Wire-([3600,2088],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.gain([3528,1926],0,0,1740)
    {
    G = "1"
    COM = "Gain"
    Dim = "1"
    }
   0.annotation2([3834,1818],0,0,-1)
    {
    AL1 = "PWM and"
    AL2 = "IGBT Firing"
    AL3 = "Control"
    A = "1"
    B = "0"
    C = "0"
    D = "0"
    E = "0"
    F = "1"
    G = "1"
    H = "1"
    }
   0.pgb([3438,2178],2,25597912,2060)
    {
    Name = "Vcmag"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([3456,1926],2,25599832,2120)
    {
    Name = "Vamag"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([3456,2052],2,25601728,2090)
    {
    Name = "Vbmag"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([3402,1818],0,0,-1)
    {
    Name = "phi"
    }
   0.datalabel([4176,1080],2,0,-1)
    {
    Name = "Kpssc"
    }
   0.datalabel([4176,1134],2,0,-1)
    {
    Name = "Tissc"
    }
   0.gain([3600,522],0,0,1160)
    {
    G = "0.05"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([3600,486],0,0,1150)
    {
    G = "0.05"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([3600,450],0,0,1130)
    {
    G = "0.05"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([3384,720],0,0,260)
    {
    G = "0.005"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([3384,756],0,0,320)
    {
    G = "0.005"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([3384,792],0,0,330)
    {
    G = "0.005"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([3582,1062],0,0,1230)
    {
    G = "0.1"
    COM = "Gain"
    Dim = "1"
    }
   -Wire-([5760,648],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([36,1386],2,0,-1)
    {
    Name = "Ira"
    }
   0.datalabel([72,1494],4,0,-1)
    {
    Name = "Ira_ref"
    }
   0.pgb([3456,1026],0,25610896,2260)
    {
    Name = "Ecapref"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "14.0"
    }
   -Wire-([3456,1026],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.buffer([144,1458],0,0,1780)
    {
    HI = "hy"
    LO = "nhy"
    Inv = "0"
    INTR = "0"
    }
   0.polar_rec([3798,756],0,0,1410)
    {
    Dir = "0"
    AngUnit = "0"
    }
   0.polar_rec([3636,1476],0,0,1610)
    {
    Dir = "0"
    AngUnit = "0"
    }
   0.inv([756,378],0,0,1080)
    {
    INTR = "0"
    }
   0.unity([828,378],0,0,1090)
    {
    IType = "2"
    OType = "1"
    }
   0.datalabel([864,378],0,0,-1)
    {
    Name = "S_TMODE"
    }
   -Wire-([828,378],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([756,378],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.datalabel([4500,3024],0,0,-1)
    {
    Name = "Theta"
    }
   0.datalabel([4536,3024],0,0,-1)
    {
    Name = "S2TMODE"
    }
   0.unity([4500,3024],1,0,980)
    {
    IType = "2"
    OType = "2"
    }
   0.unity([4536,3024],1,0,990)
    {
    IType = "2"
    OType = "2"
    }
   0.datalabel([702,378],0,0,-1)
    {
    Name = "S2TMODE"
    }
   0.datalabel([180,1170],0,0,-1)
    {
    Name = "Theta"
    }
   -Wire-([180,1134],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([180,1170],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([5238,990],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.square([5562,918],0,0,1620)
    {
    Dim = "1"
    }
   0.square([5562,954],0,0,1590)
    {
    Dim = "1"
    }
   -Wire-([5598,918],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([5634,954],6,0,1630)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([5670,954],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([5238,918],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([5238,954],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.sqrt([5724,954],0,0,1690)
    {
    Dim = "1"
    }
   -Wire-([5760,954],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([5922,954],3,25630456,2230)
    {
    Name = "Ir"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([5238,918],0,0,-1)
    {
    Name = "Ira"
    }
   0.datalabel([5238,954],0,0,-1)
    {
    Name = "Irb"
    }
   0.datalabel([5238,990],0,0,-1)
    {
    Name = "Irc"
    }
   0.datalabel([5940,954],1,0,-1)
    {
    Name = "Ir"
    }
   0.dq0([5400,954],0,0,1580)
    {
    Mode = "0"
    }
   -Wire-([5400,810],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.datalabel([5400,810],2,0,-1)
    {
    Name = "slpang"
    }
   -Wire-([5472,918],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([5472,954],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([5508,918],0,0,-1)
    {
    Name = "Idr"
    }
   0.datalabel([5508,954],0,0,-1)
    {
    Name = "Iqr"
    }
   0.realpole([5850,954],0,0,1760)
    {
    Limit = "0"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "1.0"
    T = "0.004 [sec]"
    Max = "10.0"
    Min = "-10.0"
    }
   -Wire-([5886,954],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([5238,990],1,25638640,610)
    {
    Name = "Irc"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([5238,918],3,25640504,550)
    {
    Name = "Ira"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([5238,954],2,25642400,590)
    {
    Name = "Irb"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([3780,3060],0,25644296,2000)
    {
    Name = "Wpu"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "1.085"
    Max = "1.115"
    }
   -Wire-([3744,3060],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([3744,3060],0,0,-1)
    {
    Name = "Wpu"
    }
   0.pgb([3564,450],4,25647024,2520)
    {
    Name = "<Untitled>"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Sticky-([3546,324],0)
    {
    Name = ""
    Font = 1
    Bounds = 3546,324,3654,360
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Per unitize Voltages"
    }
   -Sticky-([3312,612],0)
    {
    Name = ""
    Font = 1
    Bounds = 3312,612,3420,648
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Per unitize Currents"
    }
   -Sticky-([3996,1170],0)
    {
    Name = ""
    Font = 1
    Bounds = 3996,1170,4104,1206
    Alignment = 0
    Style = 1
    Arrow = 80
    Color = 0,15792890
    Text = "De coupling not active."
    }
   -Sticky-([4068,1404],0)
    {
    Name = ""
    Font = 1
    Bounds = 4068,1404,4320,1548
    Alignment = 0
    Style = 1
    Arrow = 20
    Color = 0,15792890
    Text = "\
Vdref1 is controlled by the capacitor voltage error.
Vqref1 is controlled by the stator side reactive power error (setting-actual).
Vdref1 and Vqref1 are used to generate the staor side reference voltages for firing the switches.
"
    }
   -Plot-([5508,1008],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,0,0]
    Posn = [5508,1008]
    Icon = [-1,-1]
    Extents = 0,0,576,288
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,576,225],"y")
     {
     Options = 128
     Units = ""
     Curve(25630456,"Ir",0,,,)
     }
    }
   0.var([5472,540],0,25696536,300)
    {
    Name = "Ir_limit"
    Group = ""
    Display = "0"
    Max = "250"
    Min = "20"
    Value = "250.0"
    Units = ""
    Collect = "1"
    }
   0.div([414,234],0,0,1000)
    {
    }
   0.mult([630,234],0,0,1020)
    {
    }
   0.gain([288,378],0,0,1060)
    {
    G = "Scale1"
    COM = "Gain"
    Dim = "1"
    }
   0.const([378,270],0,0,40)
    {
    Name = ""
    Value = "0.002"
    }
   0.datalabel([414,270],0,0,-1)
    {
    Name = "Scale1"
    }
   0.datalabel([630,270],0,0,-1)
    {
    Name = "Scale1"
    }
   0.gain([486,234],0,0,1010)
    {
    G = "Scale2"
    COM = "Gain"
    Dim = "1"
    }
   0.const([432,180],0,0,10)
    {
    Name = ""
    Value = "0.05"
    }
   0.datalabel([468,180],0,0,-1)
    {
    Name = "Scale2"
    }
   0.div([702,234],6,0,1030)
    {
    }
   0.datalabel([702,198],2,0,-1)
    {
    Name = "Scale2"
    }
   0.gain([540,342],0,0,90)
    {
    G = "Scale2"
    COM = "Gain"
    Dim = "1"
    }
   0.datalabel([666,324],2,0,-1)
    {
    Name = "Scale2"
    }
   0.div([666,360],6,0,120)
    {
    }
   0.gain([72,1386],0,0,510)
    {
    G = "Scale2"
    COM = "Gain"
    Dim = "1"
    }
   -Wire-([108,1386],0,0,-1)
    {
    Vertex="0,0;54,0;54,18;-36,18;-36,36"
    }
   -Wire-([468,1386],0,0,-1)
    {
    Vertex="0,0;36,0;36,36;-54,36;-54,54;-36,54"
    }
   -Wire-([954,1386],0,0,-1)
    {
    Vertex="0,0;0,-54;-90,-54;-90,-18;-162,-18;-162,18;-72,18;-72,54;-36,54;-36,36;-18,36"
    }
   0.gain([432,1386],0,0,540)
    {
    G = "Scale2"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([918,1386],0,0,580)
    {
    G = "Scale2"
    COM = "Gain"
    Dim = "1"
    }
   0.pgb([522,234],0,25672800,2670)
    {
    Name = "Kpd"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([738,234],0,25674456,2660)
    {
    Name = "Tid"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([702,360],0,25676352,130)
    {
    Name = "Tiq"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([576,342],0,25678248,100)
    {
    Name = "Kpq"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.buffer([504,1476],0,0,1770)
    {
    HI = "hy"
    LO = "nhy"
    Inv = "0"
    INTR = "0"
    }
   0.buffer([1008,1458],0,0,1750)
    {
    HI = "hy"
    LO = "nhy"
    Inv = "0"
    INTR = "0"
    }
   1.tri_sync([3492,1818],0,0,1380)
    {
    n = "9"
    low = "-1"
    hi = "1"
    cmnt = ""
    }
   1.three_two([3690,486],0,0,1300)
    {
    }
   1.three_two([3474,756],0,0,1190)
    {
    }
   1.three_two([324,846],0,0,1390)
    {
    }
   1.stator_rotor([3798,1494],0,0,1660)
    {
    }
   1.stator_rotor([666,504],0,0,1640)
    {
    }
   1.rotor_stator([3888,774],0,0,1420)
    {
    }
   1.two_three([3906,1476],0,0,1670)
    {
    }
   1.two_three([774,486],0,0,1650)
    {
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(B/A3,Landscape,16,[796,556],100)
   {
   -Wire-([288,612],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.ground([126,612],4,0,-1)
    {
    }
   -Wire-([198,612],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.pgb([576,1386],0,25136176,230)
    {
    Name = "Pg"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-100.0"
    Max = "350.0"
    }
   0.pgb([576,1404],0,25138112,240)
    {
    Name = "Qg"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-50.0"
    Max = "175.0"
    }
   0.source3([162,612],0,0,-1)
    {
    Name = "Source1"
    Type = "1"
    Ctrl = "0"
    MVA = "100.0 [MVA]"
    Vm = "13.8 [kV]"
    F = "60.0 [Hz]"
    Tc = "0.05 [sec]"
    ZSeq = "0"
    Imp = "1"
    Exph = "0"
    View = "1"
    Term = "0"
    R1s = "1.0 [ohm]"
    R1p = "1.0 [ohm]"
    L1p = "0.1 [H]"
    Z1 = "0.0001 [ohm]"
    Phi1 = "84.29 [deg]"
    RN = "2.0"
    R0p = "1.0 [ohm]"
    L0p = "0.1 [H]"
    Z0 = "1.0 [ohm]"
    Phi0 = "80.0 [deg]"
    Es = "13.8 [kV]"
    F0 = "60.0 [Hz]"
    Ph = "0.0 [deg]"
    Pinit = "0.0 [pu]"
    Qinit = "0.0 [pu]"
    VCtrl = "0"
    Vdes = "1.0 [p.u.]"
    Vbase = "230.0 [kV]"
    Tvm = "0.02 [sec]"
    Tvc = "0.05 [sec]"
    PCtrl = "0"
    Pdes = "1.0 [p.u.]"
    Tpm = "0.02 [sec]"
    Tpc = "0.05 [sec]"
    P = ""
    Q = ""
    V = ""
    Theta = ""
    Ia = ""
    Ib = ""
    Ic = ""
    }
   -Wire-([738,612],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1098,648],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([1026,612],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.ammeter([864,612],6,0,60)
    {
    Name = "Istator"
    }
   0.datalabel([954,360],6,0,-1)
    {
    Name = "CTRL"
    }
   0.var([1044,576],4,25143576,40)
    {
    Name = "wstart"
    Group = ""
    Display = "0"
    Max = "1.1"
    Min = "0.0"
    Value = "1.1"
    Units = ""
    Collect = "1"
    }
   0.wound_rotor([954,612],4,0,350)
    {
    Name = "WG"
    Pbase = "500.0 [MVA]"
    Vbase = "13.8 [kV]"
    OMEG = "376.99 [rad/s]"
    TRN = "2.637687"
    J = "0.7267 [s]"
    D = "0.001 [pu]"
    View = "1"
    ERC = "1"
    MM = "0"
    SNP = "1"
    Cage = "0"
    NCW = "1"
    Msat = "0"
    Lsat = "0"
    R1 = "0.0054 [pu]"
    R2 = "0.00607 [pu]"
    R3 = "0.298 [pu]"
    R4 = "0.018 [pu]"
    R5 = "0.018 [pu]"
    Xmd = "4.362 [pu]"
    Xa = "0.102 [pu]"
    Xkd1 = "0.11 [pu]"
    Xkd2 = "0.05 [pu]"
    Xkd3 = "0.05 [pu]"
    Xkd4 = "0.05 [pu]"
    Xkd12 = "0.02 [pu]"
    Xkd13 = "0.02 [pu]"
    Xkd14 = "0.02 [pu]"
    Xkd23 = "0.02 [pu]"
    Xkd24 = "0.02 [pu]"
    Xkd34 = "0.02 [pu]"
    I1M = "0.0 [pu]"
    V1M = "0.0 [pu]"
    I2M = "0.5 [pu]"
    V2M = "0.5 [pu]"
    I3M = "0.8 [pu]"
    V3M = "0.79 [pu]"
    I4M = "1.0 [pu]"
    V4M = "0.947 [pu]"
    I5M = "1.2 [pu]"
    V5M = "1.076 [pu]"
    I6M = "1.5 [pu]"
    V6M = "1.2 [pu]"
    I7M = "1.8 [pu]"
    V7M = "1.26 [pu]"
    I8M = "2.2 [pu]"
    V8M = "1.32 [pu]"
    I9M = "3.2 [pu]"
    V9M = "1.42 [pu]"
    I10M = "4.2 [pu]"
    V10M = "1.5 [pu]"
    I1 = "0.0 [pu]"
    V1 = "0.0 [pu]"
    I2 = "1.196 [pu]"
    V2 = "0.286 [pu]"
    I3 = "1.82 [pu]"
    V3 = "0.4 [pu]"
    I4 = "2.861 [pu]"
    V4 = "0.564 [pu]"
    I5 = "5.882 [pu]"
    V5 = "0.981 [pu]"
    I6 = "-1.0 [pu]"
    V6 = "-1.0 [pu]"
    I7 = "-1.0 [pu]"
    V7 = "-1.0 [pu]"
    I8 = "-1.0 [pu]"
    V8 = "-1.0 [pu]"
    I9 = "-1.0 [pu]"
    V9 = "-1.0 [pu]"
    I10 = "-1.0 [pu]"
    V10 = "-1.0 [pu]"
    MSF = ""
    LSF = ""
    Spd = "Wpu"
    Tel = "TE"
    TmOp = "TM"
    ThetaR = "Theta"
    }
   -Wire-([954,504],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.voltmetergnd([828,612],4,0,50)
    {
    Name = "V"
    }
   -Wire-([864,612],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   .DGIF_Controls([954,432],4,0,510)
    {
    }
   -Wire-([810,504],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([612,612],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   0.datalabel([1026,612],0,0,-1)
    {
    Name = "S2TMODE"
    }
   0.compare([1296,702],4,0,320)
    {
    X = "5.0"
    OL = "12"
    OH = "13.2"
    INTR = "0"
    }
   0.time-sig([1368,702],4,0,90)
    {
    }
   0.datalabel([1044,648],0,0,-1)
    {
    Name = "WindTRQ"
    }
   .Windfarm([1170,648],0,0,360)
    {
    }
   0.const([1296,630],4,0,80)
    {
    Name = ""
    Value = "0.28"
    }
   -Wire-([1260,666],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.datalabel([1188,702],0,0,-1)
    {
    Name = "Wpu"
    }
   0.radiolink([1332,666],0,0,450)
    {
    Source = ""
    Name = "Wspd"
    dim = "1"
    Mode = "1"
    Type = "0"
    }
   -Wire-([1260,666],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.time-sig([882,810],0,0,100)
    {
    }
   0.compare([954,810],0,0,110)
    {
    X = "0.5"
    OL = "1.0"
    OH = "0.0"
    INTR = "0"
    }
   0.datalabel([1026,810],0,0,-1)
    {
    Name = "S2TMODE"
    }
   -Wire-([468,1296],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([468,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([468,1260],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([468,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([468,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([468,1206],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([468,1332],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([468,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([576,1188],2,0,-1)
    {
    Name = "Istator"
    }
   0.datalabel([504,1314],0,0,-1)
    {
    Name = "Wpu"
    }
   0.datalabel([576,1296],0,0,-1)
    {
    Name = "V"
    }
   0.datamerge([450,1278],0,0,370)
    {
    N = "12"
    Type = "2"
    Disp = "1"
    }
   0.datalabel([450,1458],4,0,-1)
    {
    Name = "CTRL"
    }
   0.datalabel([504,1404],0,0,-1)
    {
    Name = "QG"
    }
   0.datalabel([504,1386],0,0,-1)
    {
    Name = "PG"
    }
   -Wire-([468,1350],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([468,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([468,1386],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([468,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.const([540,1368],2,0,220)
    {
    Name = ""
    Value = "1.0"
    }
   0.datatap([504,1206],4,0,120)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([504,1260],4,0,180)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([504,1224],4,0,140)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([504,1278],4,0,190)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([504,1296],4,0,200)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([504,1242],4,0,160)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([522,1242],0,0,-1)
    {
    Vertex="0,0;0,54;54,54"
    }
   -Wire-([522,1224],0,0,-1)
    {
    Vertex="0,0;0,-36;54,-36"
    }
   -Sticky-([54,54],0)
    {
    Name = ""
    Font = 2
    Bounds = 54,54,540,108
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "Vector Controlled doubly-fed Induction Generator "
    }
   -Sticky-([54,108],0)
    {
    Name = ""
    Font = 1
    Bounds = 54,108,522,198
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Notes:
-The case is set up to track for maximum wind power utilization.
-The 'power coefficiect', Cp is a function of wid speed/machine speed. As wind speed changes, machine speed is changed to operate at maximum Cp
-P and Q can be independently controled irrespective of the machine slip (speed).

"
    }
   -Sticky-([54,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 54,18,180,54
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "WIND FARM"
    }
   -Sticky-([1422,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 1422,36,1728,288
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Om Nayak,
Nayak Corporation (om@nayakcorp.com)

Ani  Gole,
University of Manitoba (gole@ee.umanitoba.ca)

Dharshana Muthumuni
HVDC Research Centre

 February 2003

Modifed to include the crow bar:
 Husam Al-hadidi
HVDC Research Centre"
    }
   -Sticky-([396,1116],0)
    {
    Name = ""
    Font = 1
    Bounds = 396,1116,630,1152
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "These signals are passed the the page module on the converter and controls"
    }
   -Sticky-([828,864],0)
    {
    Name = ""
    Font = 1
    Bounds = 828,864,1098,972
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Switch to torque control mode after 0.5 s
Untill this time, the machine  willrotate at a selected speed/s as specified at the input W.
This value is used as the initial speed. If a turbine start up is under investigation, then the initial value will have to be changed accordingly."
    }
   -Sticky-([1044,414],0)
    {
    Name = ""
    Font = 2
    Bounds = 1044,414,1206,468
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Converters and controls page"
    }
   -Wire-([1188,702],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.pgb([1188,774],0,56037352,440)
    {
    Name = "Wpu"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Sticky-([1350,558],0)
    {
    Name = ""
    Font = 1
    Bounds = 1350,558,1584,594
    Alignment = 0
    Style = 1
    Arrow = 64
    Color = 0,15792890
    Text = "A constant power coefficient is assumed"
    }
   -Sticky-([1422,648],0)
    {
    Name = ""
    Font = 1
    Bounds = 1422,648,1710,864
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
A step change in wind speed at the specified instant.

This would cause the speed controller to react and maintain the tip speed ration for maximum power.
The optimal tip speed ration should be known. This can be derived from the turbine torque equations. (see Mathcad files associated with the other wind examples)

Tip speed ration will determine the value of Cp. (assumed constant in this example for simplicity)"
    }
   -Sticky-([1116,540],0)
    {
    Name = ""
    Font = 1
    Bounds = 1116,540,1260,576
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Determine torque from the wind turbine."
    }
   -Wire-([504,1386],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([504,1404],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -SrcFile-([720,144],0)
    {
   Name = "Vector Controlled Doubly Fed Induction Generator for Wind Applications.doc"
    }
   -Sticky-([54,216],0)
    {
    Name = ""
    Font = 1
    Bounds = 54,216,522,252
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case requires some models in the library dq0_new_lib.psl.
This must be load before you load the case !"
    }
   0.pgb([468,1458],0,56042648,400)
    {
    Name = "CTRL"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1296,666],3,56044464,460)
    {
    Name = "Wsped"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1080,648],3,56046360,480)
    {
    Name = "windtorq"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.tpflt([270,702],4,0,310)
    {
    Ctype = "0"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "0.035 [ohm]"
    ROFF = "1000000.0 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "0"
    Ifla = "IF_a"
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tfaultn([180,738],4,0,70)
    {
    TF = "200.0 [sec]"
    DF = "0.15 [sec]"
    }
   -Wire-([324,576],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.voltmetergnd([558,612],4,0,30)
    {
    Name = "Vs"
    }
   0.datalabel([144,1278],0,0,-1)
    {
    Name = "Vs"
    }
   0.pgb([198,1278],0,56056240,170)
    {
    Name = "Vs"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([144,1314],0,0,-1)
    {
    Name = "IF_a"
    }
   0.pgb([198,1314],0,56058688,410)
    {
    Name = "IF_a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([144,1206],0,0,-1)
    {
    Name = "TE"
    }
   0.pgb([198,1206],0,56061136,430)
    {
    Name = "TE"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([144,1242],0,0,-1)
    {
    Name = "TM"
    }
   0.pgb([198,1242],0,56063584,420)
    {
    Name = "TM"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.resistive_load([360,702],0,0,-1)
    {
    P = "240.0 [MW]"
    V = "230.0 [kV]"
    SD = "0"
    }
   0.capacitive_load([720,738],0,0,-1)
    {
    S = "60.0 [MVAR]"
    V = "11.0 [kV]"
    F = "60.0 [Hz]"
    SD = "0"
    }
   0.breaker3([720,702],1,0,470)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "0"
    NAME = "BRK_cap"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1000000.0 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [sec]"
    TDB = "0.0 [sec]"
    TDC = "0.0 [sec]"
    TDRA = "0.05 [sec]"
    TDRB = "0.05 [sec]"
    TDRC = "0.05 [sec]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = ""
    IBRB = ""
    IBRC = ""
    IBR0 = ""
    SBRA = ""
    SBRB = ""
    SBRC = ""
    BP = ""
    BQ = ""
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "0.0 [MW]"
    Q = "0.0 [MVAR]"
    }
   0.const([864,1188],0,0,130)
    {
    Name = ""
    Value = "1.0"
    }
   0.sumjct([936,1188],0,0,150)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.datalabel([936,1224],0,0,-1)
    {
    Name = "Vrms_pu"
    }
   0.datalabel([972,1188],0,0,-1)
    {
    Name = "Vsag_pu"
    }
   0.compare([1638,1368],0,0,270)
    {
    X = "0.3"
    OL = "1.0"
    OH = "0.0"
    INTR = "0"
    }
   0.datalabel([1566,1368],0,0,-1)
    {
    Name = "Vsag_pu"
    }
   -Wire-([1566,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1674,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1782,1404],0,0,-1)
    {
    Name = "BRK_cap"
    }
   -Sticky-([1584,1170],0)
    {
    Name = ""
    Font = 1
    Bounds = 1584,1170,1836,1224
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "If sag more than 0.3 pu connect the capacitor for ractive compensation ti enhance the windfarm fualt  ride through capability"
    }
   0.select([1746,1404],0,0,340)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.var_switch([1710,1440],0,56073960,300)
    {
    Name = "Cont_Cap"
    Group = ""
    Display = "1"
    Value = "0"
    Max = "1.0"
    Min = "0.0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.const([1674,1404],0,0,290)
    {
    Name = ""
    Value = "0.0"
    }
   0.pgb([1782,1404],0,56076392,380)
    {
    Name = "BRK_cap"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Sticky-([1260,1170],0)
    {
    Name = ""
    Font = 1
    Bounds = 1260,1170,1494,1260
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "The deepest Voltage allowed on the generator terminal due to a fualt  side is 0.3 pu. If sag more than 0.75 pu disconnect the windfarm from the transmission power network"
    }
   0.datalabel([1170,1350],0,0,-1)
    {
    Name = "Vsag_pu"
    }
   0.var_switch([1314,1422],0,56079488,280)
    {
    Name = "Cont_Gen Trip"
    Group = ""
    Display = "1"
    Value = "0"
    Max = "1.0"
    Min = "0.0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.pgb([1458,1386],0,56081504,390)
    {
    Name = "BRK"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.compare([1242,1350],0,0,250)
    {
    X = "0.75"
    OL = "0.0"
    OH = "1.0"
    INTR = "0"
    }
   -Wire-([1170,1350],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,1350],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1458,1386],0,0,-1)
    {
    Name = "BRK"
    }
   0.select([1422,1386],0,0,330)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([1350,1386],0,0,260)
    {
    Name = ""
    Value = "0.0"
    }
   -Wire-([1314,1350],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1350,1422],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Sticky-([846,1278],0)
    {
    Name = ""
    Font = 1
    Bounds = 846,1278,1062,1332
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Enable the controls after 0.75 s, when the machine is in torque control mode."
    }
   0.breaker3([648,612],0,0,490)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "0"
    NAME = "BRK"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1000000.0 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [sec]"
    TDB = "0.0 [sec]"
    TDC = "0.0 [sec]"
    TDRA = "0.05 [sec]"
    TDRB = "0.05 [sec]"
    TDRC = "0.05 [sec]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = ""
    IBRB = ""
    IBRC = ""
    IBR0 = ""
    SBRA = ""
    SBRB = ""
    SBRC = ""
    BP = ""
    BQ = ""
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "0.0 [MW]"
    Q = "0.0 [MVAR]"
    }
   0.breaker3([252,612],0,0,500)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "0"
    NAME = "BRK"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1000000.0 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [sec]"
    TDB = "0.0 [sec]"
    TDC = "0.0 [sec]"
    TDRA = "0.05 [sec]"
    TDRB = "0.05 [sec]"
    TDRC = "0.05 [sec]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = ""
    IBRB = ""
    IBRC = ""
    IBR0 = ""
    SBRA = ""
    SBRB = ""
    SBRC = ""
    BP = ""
    BQ = ""
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "0.0 [MW]"
    Q = "0.0 [MVAR]"
    }
   -Wire-([324,612],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   -Wire-([504,612],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Sticky-([126,810],0)
    {
    Name = ""
    Font = 1
    Bounds = 126,810,306,882
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "The deepest Voltage allowed on the generator terminal due to a fualt  side is 0.3 pu."
    }
   -Wire-([990,810],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([468,1458],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([450,1458],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Sticky-([144,1116],0)
    {
    Name = ""
    Font = 1
    Bounds = 144,1116,252,1152
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Signal for plotting"
    }
   -Sticky-([846,1116],0)
    {
    Name = ""
    Font = 2
    Bounds = 846,1116,1188,1170
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 16711680,15792890
    Text = "Low voltage ride through options:"
    }
   -Sticky-([1026,1170],0)
    {
    Name = ""
    Font = 1
    Bounds = 1026,1170,1188,1206
    Alignment = 0
    Style = 1
    Arrow = 12
    Color = 0,15792890
    Text = "Voltage sag"
    }
   -Wire-([0,1044],0,0,-1)
    {
    Vertex="0,0;1836,0"
    }
   -Wire-([90,1062],0,0,-1)
    {
    Vertex="0,0;1836,0"
    }
   .Plots_controls([198,450],0,0,10)
    {
    }
   0.multimeter([486,612],4,0,20)
    {
    MeasI = "1"
    MeasV = "0"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "13.8"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "1"
    CurI = "Iabc"
    VolI = ""
    P = "PG"
    Q = "QG"
    Vrms = "Vrms_pu"
    Ph = ""
    hide1 = "1"
    hide2 = "1"
    Pd = "181.8"
    Qd = "25.22"
    Vd = "1.088"
    }
   0.datalabel([144,1350],0,0,-1)
    {
    Name = "Vrms_pu"
    }
   0.pgb([198,1350],0,56096584,210)
    {
    Name = "Vgrms_pu"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "1.2"
    }
   -Wire-([144,1350],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([144,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([144,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([144,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([144,1206],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([738,576],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([684,612],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([720,666],0,0,-1)
    {
    Vertex="0,0;0,-36;18,-36"
    }
   -Wire-([234,738],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([324,630],0,0,-1)
    {
    Vertex="0,0;36,0;36,72"
    }
   -Wire-([324,630],0,0,-1)
    {
    Vertex="0,0;-36,0;-36,72;-72,72"
    }
   0.datalabel([594,1332],0,0,-1)
    {
    Name = "Theta"
    }
   0.datalabel([594,1350],0,0,-1)
    {
    Name = "S2TMODE"
    }
   -Plot-([1728,414],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,468,486]
    Posn = [1728,414]
    Icon = [288,1062]
    Extents = 0,0,468,486
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,468,141],"y")
     {
     Options = 129
     Units = ""
     Curve(56063584,"TM",0,,,)
     Curve(56061136,"TE",0,,,)
     }
    Graph([0,141],[0,0,468,141],"y")
     {
     Options = 129
     Units = ""
     Curve(56037352,"Wpu",0,,,)
     }
    Graph([0,282],[0,0,468,141],"y")
     {
     Options = 128
     Units = ""
     Curve(56046360,"windtorq",0,,,)
     }
    }
   }
  }
 }

